/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.entity.Fort;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FortManager
implements InstanceListManager {
    private static final Logger LOG = LoggerFactory.getLogger(FortManager.class);
    private final List<Fort> _forts = new CopyOnWriteArrayList<Fort>();

    public int findNearestFortIndex(L2Object obj) {
        return this.findNearestFortIndex(obj, Long.MAX_VALUE);
    }

    public int findNearestFortIndex(L2Object obj, long maxDistance) {
        int index = this.getFortIndex(obj);
        if (index < 0) {
            for (int i = 0; i < this._forts.size(); ++i) {
                double distance;
                Fort fort = this._forts.get(i);
                if (fort == null || !((double)maxDistance > (distance = fort.getDistance(obj)))) continue;
                maxDistance = (long)distance;
                index = i;
            }
        }
        return index;
    }

    public Fort getFortById(int fortId) {
        for (Fort f : this._forts) {
            if (f.getResidenceId() != fortId) continue;
            return f;
        }
        return null;
    }

    public Fort getFortByOwner(L2Clan clan) {
        for (Fort f : this._forts) {
            if (f.getOwnerClan() != clan) continue;
            return f;
        }
        return null;
    }

    public Fort getFort(String name) {
        for (Fort f : this._forts) {
            if (!f.getName().equalsIgnoreCase(name.trim())) continue;
            return f;
        }
        return null;
    }

    public Fort getFort(int x, int y, int z) {
        for (Fort f : this._forts) {
            if (!f.checkIfInZone(x, y, z)) continue;
            return f;
        }
        return null;
    }

    public Fort getFort(L2Object activeObject) {
        return this.getFort(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public int getFortIndex(int fortId) {
        for (int i = 0; i < this._forts.size(); ++i) {
            Fort fort = this._forts.get(i);
            if (fort == null || fort.getResidenceId() != fortId) continue;
            return i;
        }
        return -1;
    }

    public int getFortIndex(L2Object activeObject) {
        return this.getFortIndex(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public int getFortIndex(int x, int y, int z) {
        for (int i = 0; i < this._forts.size(); ++i) {
            Fort fort = this._forts.get(i);
            if (fort == null || !fort.checkIfInZone(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public List<Fort> getForts() {
        return this._forts;
    }

    @Override
    public void loadInstances() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id FROM fort ORDER BY id");){
            while (rs.next()) {
                this._forts.add(new Fort(rs.getInt("id")));
            }
            LOG.info("Loaded {} fortress.", (Object)this._forts.size());
            for (Fort fort : this._forts) {
                fort.getSiege().getSiegeGuardManager().loadSiegeGuard();
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error loading fort instances!", ex);
        }
    }

    @Override
    public void updateReferences() {
    }

    @Override
    public void activateInstances() {
        for (Fort fort : this._forts) {
            fort.activateInstance();
        }
    }

    public static FortManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FortManager _instance = new FortManager();

        private SingletonHolder() {
        }
    }
}

