/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.variables.AbstractVariables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalVariablesManager
extends AbstractVariables {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalVariablesManager.class);
    private static final String SELECT_QUERY = "SELECT * FROM global_variables";
    private static final String DELETE_QUERY = "DELETE FROM global_variables";
    private static final String INSERT_QUERY = "INSERT INTO global_variables (var, value) VALUES (?, ?)";

    protected GlobalVariablesManager() {
        this.restoreMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(SELECT_QUERY);){
            while (rs.next()) {
                this.set(rs.getString("var"), rs.getString("value"));
            }
        }
        catch (Exception ex) {
            LOG.warn("Couldn't restore global variables!", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compareAndSetChanges(true, false);
        }
        LOG.info("Loaded {} variables.", (Object)this.getSet().size());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeMe() {
        if (!this.hasChanges()) {
            return false;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement del = con.createStatement();
             PreparedStatement st = con.prepareStatement(INSERT_QUERY);){
            del.execute(DELETE_QUERY);
            for (Map.Entry<String, Object> entry : this.getSet().entrySet()) {
                st.setString(1, entry.getKey());
                st.setString(2, String.valueOf(entry.getValue()));
                st.addBatch();
            }
            st.executeBatch();
        }
        catch (Exception ex) {
            LOG.warn("Couldn't save global variables to database!", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compareAndSetChanges(true, false);
        }
        LOG.info("Stored {} variables.", (Object)this.getSet().size());
        return true;
    }

    public static GlobalVariablesManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GlobalVariablesManager _instance = new GlobalVariablesManager();

        private SingletonHolder() {
        }
    }
}

