/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.instancemanager.tasks.GrandBossManagerStoreTask;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IStorable;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrandBossManager
implements IStorable {
    private static final Logger LOG = LoggerFactory.getLogger(GrandBossManager.class);
    private static final String DELETE_GRAND_BOSS_LIST = "DELETE FROM grandboss_list";
    private static final String INSERT_GRAND_BOSS_LIST = "INSERT INTO grandboss_list (player_id,zone) VALUES (?,?)";
    private static final String UPDATE_GRAND_BOSS_DATA = "UPDATE grandboss_data set loc_x = ?, loc_y = ?, loc_z = ?, heading = ?, respawn_time = ?, currentHP = ?, currentMP = ?, status = ? where boss_id = ?";
    private static final String UPDATE_GRAND_BOSS_DATA2 = "UPDATE grandboss_data set status = ? where boss_id = ?";
    protected static final Map<Integer, L2GrandBossInstance> BOSSES = new ConcurrentHashMap<Integer, L2GrandBossInstance>();
    protected static Map<Integer, StatsSet> _storedInfo = new HashMap<Integer, StatsSet>();
    private final Map<Integer, Integer> _bossStatus = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, L2BossZone> _zones = new ConcurrentHashMap<Integer, L2BossZone>();

    protected GrandBossManager() {
        this.init();
    }

    private void init() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT * from grandboss_data ORDER BY boss_id");){
            while (rs.next()) {
                StatsSet info = new StatsSet();
                int bossId = rs.getInt("boss_id");
                info.set("loc_x", rs.getInt("loc_x"));
                info.set("loc_y", rs.getInt("loc_y"));
                info.set("loc_z", rs.getInt("loc_z"));
                info.set("heading", rs.getInt("heading"));
                info.set("respawn_time", rs.getLong("respawn_time"));
                double HP = rs.getDouble("currentHP");
                int true_HP = (int)HP;
                info.set("currentHP", true_HP);
                double MP = rs.getDouble("currentMP");
                int true_MP = (int)MP;
                info.set("currentMP", true_MP);
                int status = rs.getInt("status");
                this._bossStatus.put(bossId, status);
                _storedInfo.put(bossId, info);
                LOG.info("{} ({}) status is {}.", NpcData.getInstance().getTemplate(bossId).getName(), bossId, status);
                if (status <= 0) continue;
                LOG.info("Next spawn date of {} is {}.", (Object)NpcData.getInstance().getTemplate(bossId).getName(), (Object)new Date(info.getLong("respawn_time")));
            }
            LOG.info("Loaded {} grand boss instances.", (Object)_storedInfo.size());
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while initializing GrandBossManager!", ex);
        }
        ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new GrandBossManagerStoreTask(), 300000L, 300000L);
    }

    public void initZones() {
        HashMap zones = new HashMap();
        for (Integer n : this._zones.keySet()) {
            zones.put(n, new ArrayList());
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * from grandboss_list ORDER BY player_id");){
            while (rs.next()) {
                int id = rs.getInt("player_id");
                int zoneId = rs.getInt("zone");
                ((List)zones.get(zoneId)).add(id);
            }
            LOG.info("Initialized {} grand boss zones.", (Object)this._zones.size());
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while initializing GrandBoss zones!", ex);
        }
        for (Map.Entry entry : this._zones.entrySet()) {
            ((L2BossZone)entry.getValue()).setAllowedPlayers((List)zones.get(entry.getKey()));
        }
        zones.clear();
    }

    public void addZone(L2BossZone zone) {
        this._zones.put(zone.getId(), zone);
    }

    public L2BossZone getZone(int zoneId) {
        return this._zones.get(zoneId);
    }

    public L2BossZone getZone(L2Character character) {
        return this._zones.values().stream().filter(z -> z.isCharacterInZone(character)).findFirst().orElse(null);
    }

    public L2BossZone getZone(Location loc) {
        return this.getZone(loc.getX(), loc.getY(), loc.getZ());
    }

    public L2BossZone getZone(int x, int y, int z) {
        return this._zones.values().stream().filter(zone -> zone.isInsideZone(x, y, z)).findFirst().orElse(null);
    }

    public boolean checkIfInZone(String zoneType, L2Object obj) {
        L2BossZone temp = this.getZone(obj.getX(), obj.getY(), obj.getZ());
        return temp != null && temp.getName().equalsIgnoreCase(zoneType);
    }

    public boolean checkIfInZone(L2PcInstance player) {
        return player != null && this.getZone(player.getX(), player.getY(), player.getZ()) != null;
    }

    public int getBossStatus(int bossId) {
        return this._bossStatus.get(bossId);
    }

    public void setBossStatus(int bossId, int status) {
        this._bossStatus.put(bossId, status);
        LOG.info("Updated {} ({}) status to {}.", NpcData.getInstance().getTemplate(bossId).getName(), bossId, status);
        this.updateDb(bossId, true);
    }

    public void addBoss(L2GrandBossInstance boss) {
        if (boss != null) {
            BOSSES.put(boss.getId(), boss);
        }
    }

    public L2GrandBossInstance getBoss(int bossId) {
        return BOSSES.get(bossId);
    }

    public StatsSet getStatsSet(int bossId) {
        return _storedInfo.get(bossId);
    }

    public void setStatsSet(int bossId, StatsSet info) {
        _storedInfo.put(bossId, info);
        this.updateDb(bossId, false);
    }

    @Override
    public boolean storeMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();){
            s.executeUpdate(DELETE_GRAND_BOSS_LIST);
            try (PreparedStatement insert = con.prepareStatement(INSERT_GRAND_BOSS_LIST);){
                for (Map.Entry<Integer, L2BossZone> e : this._zones.entrySet()) {
                    List<Integer> list = e.getValue().getAllowedPlayers();
                    if (list == null || list.isEmpty()) continue;
                    for (Integer player : list) {
                        insert.setInt(1, player);
                        insert.setInt(2, e.getKey());
                        insert.executeUpdate();
                        insert.clearParameters();
                    }
                }
            }
            for (Map.Entry<Integer, StatsSet> e : _storedInfo.entrySet()) {
                PreparedStatement update;
                L2GrandBossInstance boss = BOSSES.get(e.getKey());
                StatsSet info = e.getValue();
                if (boss == null || info == null) {
                    update = con.prepareStatement(UPDATE_GRAND_BOSS_DATA2);
                    try {
                        update.setInt(1, this._bossStatus.get(e.getKey()));
                        update.setInt(2, e.getKey());
                        update.executeUpdate();
                        update.clearParameters();
                        continue;
                    }
                    finally {
                        if (update != null) {
                            update.close();
                        }
                        continue;
                    }
                }
                update = con.prepareStatement(UPDATE_GRAND_BOSS_DATA);
                try {
                    update.setInt(1, boss.getX());
                    update.setInt(2, boss.getY());
                    update.setInt(3, boss.getZ());
                    update.setInt(4, boss.getHeading());
                    update.setLong(5, info.getLong("respawn_time"));
                    double hp = boss.getCurrentHp();
                    double mp = boss.getCurrentMp();
                    if (boss.isDead()) {
                        hp = boss.getMaxHp();
                        mp = boss.getMaxMp();
                    }
                    update.setDouble(6, hp);
                    update.setDouble(7, mp);
                    update.setInt(8, this._bossStatus.get(e.getKey()));
                    update.setInt(9, e.getKey());
                    update.executeUpdate();
                    update.clearParameters();
                }
                finally {
                    if (update == null) continue;
                    update.close();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not store grand bosses to database!", ex);
            return false;
        }
        return true;
    }

    private void updateDb(int bossId, boolean statusOnly) {
        block22: {
            try (Connection con = ConnectionFactory.getInstance().getConnection();){
                L2GrandBossInstance boss = BOSSES.get(bossId);
                StatsSet info = _storedInfo.get(bossId);
                if (statusOnly || boss == null || info == null) {
                    try (PreparedStatement ps = con.prepareStatement(UPDATE_GRAND_BOSS_DATA2);){
                        ps.setInt(1, this._bossStatus.get(bossId));
                        ps.setInt(2, bossId);
                        ps.executeUpdate();
                        break block22;
                    }
                }
                try (PreparedStatement ps = con.prepareStatement(UPDATE_GRAND_BOSS_DATA);){
                    ps.setInt(1, boss.getX());
                    ps.setInt(2, boss.getY());
                    ps.setInt(3, boss.getZ());
                    ps.setInt(4, boss.getHeading());
                    ps.setLong(5, info.getLong("respawn_time"));
                    double hp = boss.getCurrentHp();
                    double mp = boss.getCurrentMp();
                    if (boss.isDead()) {
                        hp = boss.getMaxHp();
                        mp = boss.getMaxMp();
                    }
                    ps.setDouble(6, hp);
                    ps.setDouble(7, mp);
                    ps.setInt(8, this._bossStatus.get(bossId));
                    ps.setInt(9, bossId);
                    ps.executeUpdate();
                }
            }
            catch (Exception ex) {
                LOG.warn("Could not update grand bosses to database!", ex);
            }
        }
    }

    public void cleanUp() {
        this.storeMe();
        BOSSES.clear();
        _storedInfo.clear();
        this._bossStatus.clear();
        this._zones.clear();
    }

    public Map<Integer, L2BossZone> getZones() {
        return this._zones;
    }

    public static GrandBossManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GrandBossManager _instance = new GrandBossManager();

        private SingletonHolder() {
        }
    }
}

