/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.util.Util;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.scripting.ScriptEngineManager;
import com.l2jserver.gameserver.scripting.ScriptManager;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuestManager
extends ScriptManager<Quest> {
    private static final Logger LOG = LoggerFactory.getLogger(QuestManager.class);
    private final Map<String, Quest> _quests = new ConcurrentHashMap<String, Quest>();
    private final Map<String, Quest> _scripts = new ConcurrentHashMap<String, Quest>();

    protected QuestManager() {
    }

    @Override
    public boolean reload(String questFolder) {
        Quest q = this.getQuest(questFolder);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    @Override
    public boolean reload(int questId) {
        Quest q = this.getQuest(questId);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    public void reloadAllScripts() {
        LOG.info("Reloading all server scripts.");
        for (Quest quest : this._quests.values()) {
            if (quest == null) continue;
            quest.unload(false);
        }
        this._quests.clear();
        for (Quest script : this._scripts.values()) {
            if (script == null) continue;
            script.unload(false);
        }
        this._scripts.clear();
        try {
            ScriptEngineManager.getInstance().executeScriptList(new File(Configuration.server().getDatapackRoot(), "data/scripts.cfg"));
        }
        catch (Exception ex) {
            LOG.warn("Failed loading scripts.cfg, no script going to be loaded!", ex);
        }
        LOG.info("Loaded {} quests.", (Object)this._quests.size());
        LOG.info("Loaded {} scripts.", (Object)this._scripts.size());
    }

    public void save() {
        for (Quest quest : this._quests.values()) {
            quest.saveGlobalData();
        }
        for (Quest script : this._scripts.values()) {
            script.saveGlobalData();
        }
    }

    public Quest getQuest(String name) {
        if (this._quests.containsKey(name)) {
            return this._quests.get(name);
        }
        return this._scripts.get(name);
    }

    public Quest getQuest(int questId) {
        for (Quest q : this._quests.values()) {
            if (q.getId() != questId) continue;
            return q;
        }
        return null;
    }

    public void addQuest(Quest quest) {
        if (quest == null) {
            throw new IllegalArgumentException("Quest argument cannot be null");
        }
        Quest old = this._quests.put(quest.getName(), quest);
        if (old != null) {
            old.unload();
            LOG.info("Replaced quest {} with a new version.", (Object)old);
        }
        if (Configuration.general().showQuestsLoadInLogs()) {
            String questName = quest.getName().contains("_") ? quest.getName().substring(quest.getName().indexOf(95) + 1) : quest.getName();
            LOG.info("Loaded quest {}.", (Object)Util.splitWords((String)questName));
        }
    }

    public boolean removeScript(Quest script) {
        if (this._quests.containsKey(script.getName())) {
            this._quests.remove(script.getName());
            return true;
        }
        if (this._scripts.containsKey(script.getName())) {
            this._scripts.remove(script.getName());
            return true;
        }
        return false;
    }

    public Map<String, Quest> getQuests() {
        return this._quests;
    }

    @Override
    public boolean unload(Quest ms) {
        ms.saveGlobalData();
        return this.removeScript(ms);
    }

    @Override
    public String getScriptManagerName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Map<String, Quest> getScripts() {
        return this._scripts;
    }

    public void addScript(Quest script) {
        Quest old = this._scripts.put(script.getClass().getSimpleName(), script);
        if (old != null) {
            old.unload();
            LOG.info("Replaced script {} with a new version.", (Object)old);
        }
        if (Configuration.general().showQuestsLoadInLogs()) {
            LOG.info("Loaded script {}.", (Object)Util.splitWords((String)script.getClass().getSimpleName()));
        }
    }

    public static QuestManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final QuestManager INSTANCE = new QuestManager();

        private SingletonHolder() {
        }
    }
}

