/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.TowerSpawn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.skills.Skill;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SiegeManager {
    private static final Logger LOG = LoggerFactory.getLogger(SiegeManager.class);
    private final Map<Integer, List<TowerSpawn>> _controlTowers = new HashMap<Integer, List<TowerSpawn>>();
    private final Map<Integer, List<TowerSpawn>> _flameTowers = new HashMap<Integer, List<TowerSpawn>>();

    protected SiegeManager() {
        this.load();
    }

    public void addSiegeSkills(L2PcInstance character) {
        for (Skill sk : SkillData.getInstance().getSiegeSkills(character.isNoble(), character.getClan().getCastleId() > 0)) {
            character.addSkill(sk, false);
        }
    }

    public boolean checkIsRegistered(L2Clan clan, int castleId) {
        if (clan == null) {
            return false;
        }
        if (clan.getCastleId() > 0) {
            return true;
        }
        boolean register = false;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT clan_id FROM siege_clans where clan_id=? and castle_id=?");){
            ps.setInt(1, clan.getId());
            ps.setInt(2, castleId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    register = true;
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error verifying if the clan is registered to the siege!", ex);
        }
        return register;
    }

    public void removeSiegeSkills(L2PcInstance character) {
        for (Skill sk : SkillData.getInstance().getSiegeSkills(character.isNoble(), character.getClan().getCastleId() > 0)) {
            character.removeSkill(sk);
        }
    }

    private void load() {
        this._controlTowers.put(1, List.of(Configuration.siege().getGludioControlTower1(), Configuration.siege().getGludioControlTower2(), Configuration.siege().getGludioControlTower3()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[0] = Configuration.siege().getGludioMaxMercenaries();
        this._flameTowers.put(1, List.of(Configuration.siege().getGludioFlameTower1(), Configuration.siege().getGludioFlameTower1()));
        this._controlTowers.put(2, List.of(Configuration.siege().getDionControlTower1(), Configuration.siege().getDionControlTower2(), Configuration.siege().getDionControlTower3()));
        this._flameTowers.put(2, List.of(Configuration.siege().getDionFlameTower1(), Configuration.siege().getDionFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[1] = Configuration.siege().getDionMaxMercenaries();
        this._controlTowers.put(3, List.of(Configuration.siege().getGiranControlTower1(), Configuration.siege().getGiranControlTower2(), Configuration.siege().getGiranControlTower3()));
        this._flameTowers.put(3, List.of(Configuration.siege().getGiranFlameTower1(), Configuration.siege().getGiranFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[2] = Configuration.siege().getGiranMaxMercenaries();
        this._controlTowers.put(4, List.of(Configuration.siege().getOrenControlTower1(), Configuration.siege().getOrenControlTower2(), Configuration.siege().getOrenControlTower3()));
        this._flameTowers.put(4, List.of(Configuration.siege().getOrenFlameTower1(), Configuration.siege().getOrenFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[3] = Configuration.siege().getOrenMaxMercenaries();
        this._controlTowers.put(5, List.of(Configuration.siege().getAdenControlTower1(), Configuration.siege().getAdenControlTower2(), Configuration.siege().getAdenControlTower3()));
        this._flameTowers.put(5, List.of(Configuration.siege().getAdenFlameTower1(), Configuration.siege().getAdenFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[4] = Configuration.siege().getAdenMaxMercenaries();
        this._controlTowers.put(6, List.of(Configuration.siege().getInnadrilControlTower1(), Configuration.siege().getInnadrilControlTower2(), Configuration.siege().getInnadrilControlTower3()));
        this._flameTowers.put(6, List.of(Configuration.siege().getInnadrilFlameTower1(), Configuration.siege().getInnadrilFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[5] = Configuration.siege().getInnadrilMaxMercenaries();
        this._controlTowers.put(7, List.of(Configuration.siege().getGoddardControlTower1(), Configuration.siege().getGoddardControlTower2(), Configuration.siege().getGoddardControlTower3()));
        this._flameTowers.put(7, List.of(Configuration.siege().getGoddardFlameTower1(), Configuration.siege().getGoddardFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[6] = Configuration.siege().getGoddardMaxMercenaries();
        this._controlTowers.put(8, List.of(Configuration.siege().getRuneControlTower1(), Configuration.siege().getRuneControlTower2(), Configuration.siege().getRuneControlTower3()));
        this._flameTowers.put(8, List.of(Configuration.siege().getRuneFlameTower1(), Configuration.siege().getRuneFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[7] = Configuration.siege().getRuneMaxMercenaries();
        this._controlTowers.put(9, List.of(Configuration.siege().getSchuttgartControlTower1(), Configuration.siege().getSchuttgartControlTower2(), Configuration.siege().getSchuttgartControlTower3()));
        this._flameTowers.put(9, List.of(Configuration.siege().getSchuttgartFlameTower1(), Configuration.siege().getSchuttgartFlameTower1()));
        MercTicketManager.MERCS_MAX_PER_CASTLE[8] = Configuration.siege().getSchuttgartMaxMercenaries();
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            if (castle.getOwnerId() == 0) continue;
            this.loadTrapUpgrade(castle.getResidenceId());
        }
    }

    public List<TowerSpawn> getControlTowers(int castleId) {
        return this._controlTowers.get(castleId);
    }

    public List<TowerSpawn> getFlameTowers(int castleId) {
        return this._flameTowers.get(castleId);
    }

    public int getAttackerMaxClans() {
        return Configuration.siege().getAttackerMaxClans();
    }

    public int getAttackerRespawnDelay() {
        return Configuration.siege().getAttackerRespawn();
    }

    public int getDefenderMaxClans() {
        return Configuration.siege().getDefenderMaxClans();
    }

    public int getFlagMaxCount() {
        return Configuration.siege().getMaxFlags();
    }

    public Siege getSiege(ILocational loc) {
        return this.getSiege(loc.getX(), loc.getY(), loc.getZ());
    }

    public Siege getSiege(L2Object activeObject) {
        return this.getSiege(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public Siege getSiege(int x, int y, int z) {
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            if (!castle.getSiege().checkIfInZone(x, y, z)) continue;
            return castle.getSiege();
        }
        return null;
    }

    public int getSiegeClanMinLevel() {
        return Configuration.siege().getClanMinLevel();
    }

    public int getSiegeLength() {
        return Configuration.siege().getSiegeLength();
    }

    public int getBloodAllianceReward() {
        return Configuration.siege().getBloodAllianceReward();
    }

    public List<Siege> getSieges() {
        ArrayList<Siege> sieges = new ArrayList<Siege>();
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            sieges.add(castle.getSiege());
        }
        return sieges;
    }

    private void loadTrapUpgrade(int castleId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM castle_trapupgrade WHERE castleId=?");){
            ps.setInt(1, castleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._flameTowers.get(castleId).get(rs.getInt("towerIndex")).setUpgradeLevel(rs.getInt("level"));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error loading trap upgrade!", ex);
        }
    }

    public static SiegeManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SiegeManager _instance = new SiegeManager();

        private SingletonHolder() {
        }
    }
}

