/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TerritoryWard;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerritoryWarManager
implements Siegable {
    private static final Logger LOG = LoggerFactory.getLogger(TerritoryWarManager.class);
    private static final String DELETE = "DELETE FROM territory_registrations WHERE castleId = ? and registeredId = ?";
    private static final String INSERT = "INSERT INTO territory_registrations (castleId, registeredId) values (?, ?)";
    public static final Map<Integer, Integer> TERRITORY_ITEM_IDS = new HashMap<Integer, Integer>();
    private static final String qn = "TerritoryWarSuperClass";
    public static String GLOBAL_VARIABLE = "nextTWStartDate";
    private final Map<Integer, List<L2Clan>> _registeredClans = new ConcurrentHashMap<Integer, List<L2Clan>>();
    private final Map<Integer, List<Integer>> _registeredMercenaries = new ConcurrentHashMap<Integer, List<Integer>>();
    private final Map<Integer, Territory> _territoryList = new ConcurrentHashMap<Integer, Territory>();
    private final List<Integer> _disguisedPlayers = new CopyOnWriteArrayList<Integer>();
    private final List<TerritoryWard> _territoryWards = new CopyOnWriteArrayList<TerritoryWard>();
    private final Map<L2Clan, L2SiegeFlagInstance> _clanFlags = new ConcurrentHashMap<L2Clan, L2SiegeFlagInstance>();
    private final Map<Integer, Integer[]> _participantPoints = new ConcurrentHashMap<Integer, Integer[]>();
    private final Calendar _startTWDate = Calendar.getInstance();
    private boolean _isRegistrationOver = true;
    private boolean _isTWChannelOpen = false;
    private boolean _isTWInProgress = false;
    private ScheduledFuture<?> _scheduledStartTWTask = null;
    private ScheduledFuture<?> _scheduledEndTWTask = null;
    private ScheduledFuture<?> _scheduledRewardOnlineTask = null;

    private TerritoryWarManager() {
        this.load();
    }

    public int getRegisteredTerritoryId(L2PcInstance player) {
        if (player == null || !this._isTWChannelOpen || player.getLevel() < Configuration.territoryWar().getPlayerMinLevel()) {
            return 0;
        }
        if (player.getClan() != null) {
            if (player.getClan().getCastleId() > 0) {
                return player.getClan().getCastleId() + 80;
            }
            for (int cId : this._registeredClans.keySet()) {
                if (!this._registeredClans.get(cId).contains(player.getClan())) continue;
                return cId + 80;
            }
        }
        for (int cId : this._registeredMercenaries.keySet()) {
            if (!this._registeredMercenaries.get(cId).contains(player.getObjectId())) continue;
            return cId + 80;
        }
        return 0;
    }

    public boolean isAllyField(L2PcInstance player, int fieldId) {
        if (player == null || player.getSiegeSide() == 0) {
            return false;
        }
        if (player.getSiegeSide() - 80 == fieldId) {
            return true;
        }
        return fieldId > 100 && this._territoryList.containsKey(player.getSiegeSide() - 80) && this._territoryList.get(player.getSiegeSide() - 80).getFortId() == fieldId;
    }

    public boolean checkIsRegistered(int castleId, L2Clan clan) {
        if (clan == null) {
            return false;
        }
        if (clan.getCastleId() > 0) {
            return castleId == -1 || clan.getCastleId() == castleId;
        }
        if (castleId == -1) {
            for (int cId : this._registeredClans.keySet()) {
                if (!this._registeredClans.get(cId).contains(clan)) continue;
                return true;
            }
            return false;
        }
        return this._registeredClans.get(castleId).contains(clan);
    }

    public boolean checkIsRegistered(int castleId, int objId) {
        if (castleId == -1) {
            for (int cId : this._registeredMercenaries.keySet()) {
                if (!this._registeredMercenaries.get(cId).contains(objId)) continue;
                return true;
            }
            return false;
        }
        return this._registeredMercenaries.get(castleId).contains(objId);
    }

    public Territory getTerritory(int castleId) {
        return this._territoryList.get(castleId);
    }

    public List<Territory> getAllTerritories() {
        LinkedList<Territory> ret = new LinkedList<Territory>();
        for (Territory t : this._territoryList.values()) {
            if (t.getOwnerClan() == null) continue;
            ret.add(t);
        }
        return ret;
    }

    public List<L2Clan> getRegisteredClans(int castleId) {
        return this._registeredClans.get(castleId);
    }

    public void addDisguisedPlayer(int playerObjId) {
        this._disguisedPlayers.add(playerObjId);
    }

    public boolean isDisguised(int playerObjId) {
        return this._disguisedPlayers.contains(playerObjId);
    }

    public List<Integer> getRegisteredMercenaries(int castleId) {
        return this._registeredMercenaries.get(castleId);
    }

    public long getTWStartTimeInMillis() {
        return this._startTWDate.getTimeInMillis();
    }

    public Calendar getTWStart() {
        return this._startTWDate;
    }

    public void setTWStartTimeInMillis(long time) {
        this._startTWDate.setTimeInMillis(time);
        if (this._isTWInProgress) {
            if (this._scheduledEndTWTask != null) {
                this._scheduledEndTWTask.cancel(false);
            }
            this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), 1000L);
        } else {
            if (this._scheduledStartTWTask != null) {
                this._scheduledStartTWTask.cancel(false);
            }
            this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), 1000L);
        }
    }

    public boolean isTWChannelOpen() {
        return this._isTWChannelOpen;
    }

    public void registerClan(int castleId, L2Clan clan) {
        if (clan == null || this._registeredClans.get(castleId) != null && this._registeredClans.get(castleId).contains(clan)) {
            return;
        }
        this._registeredClans.putIfAbsent(castleId, new CopyOnWriteArrayList());
        this._registeredClans.get(castleId).add(clan);
        this.changeRegistration(castleId, clan.getId(), false);
    }

    public void registerMerc(int castleId, L2PcInstance player) {
        if (player == null || player.getLevel() < Configuration.territoryWar().getPlayerMinLevel() || this._registeredMercenaries.get(castleId) != null && this._registeredMercenaries.get(castleId).contains(player.getObjectId())) {
            return;
        }
        this._registeredMercenaries.putIfAbsent(castleId, new CopyOnWriteArrayList());
        this._registeredMercenaries.get(castleId).add(player.getObjectId());
        this.changeRegistration(castleId, player.getObjectId(), false);
    }

    public void removeClan(int castleId, L2Clan clan) {
        if (clan == null) {
            return;
        }
        if (this._registeredClans.get(castleId) != null && this._registeredClans.get(castleId).contains(clan)) {
            this._registeredClans.get(castleId).remove(clan);
            this.changeRegistration(castleId, clan.getId(), true);
        }
    }

    public void removeMerc(int castleId, L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (this._registeredMercenaries.get(castleId) != null && this._registeredMercenaries.get(castleId).contains(player.getObjectId())) {
            this._registeredMercenaries.get(castleId).remove((Object)player.getObjectId());
            this.changeRegistration(castleId, player.getObjectId(), true);
        }
    }

    public boolean getIsRegistrationOver() {
        return this._isRegistrationOver;
    }

    public boolean isTWInProgress() {
        return this._isTWInProgress;
    }

    public void territoryCatapultDestroyed(int castleId) {
        if (this._territoryList.get(castleId) != null) {
            this._territoryList.get(castleId).changeNPCsSpawn(2, false);
        }
        for (L2DoorInstance door : CastleManager.getInstance().getCastleById(castleId).getDoors()) {
            door.openMe();
        }
    }

    public L2Npc addTerritoryWard(int territoryId, int newOwnerId, int oldOwnerId, boolean broadcastMessage) {
        L2Npc ret = null;
        Territory terNew = this._territoryList.get(newOwnerId);
        if (terNew != null) {
            TerritoryNPCSpawn ward = terNew.getFreeWardSpawnPlace();
            if (ward != null) {
                ward._npcId = territoryId;
                ret = this.spawnNPC(36491 + territoryId, ward.getLocation());
                ward.setNPC(ret);
                if (!this.isTWInProgress() && !Configuration.territoryWar().spawnWardsWhenTWIsNotInProgress()) {
                    ret.decayMe();
                }
                if (terNew.getOwnerClan() != null && terNew.getOwnedWardIds().contains(newOwnerId + 80)) {
                    for (int wardId : terNew.getOwnedWardIds()) {
                        List<L2SkillLearn> residentialSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                        for (L2SkillLearn s : residentialSkills) {
                            Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                            if (sk == null) continue;
                            for (L2PcInstance member : terNew.getOwnerClan().getOnlineMembers(0)) {
                                if (member.isInOlympiadMode()) continue;
                                member.addSkill(sk, false);
                            }
                        }
                    }
                }
            }
            if (this._territoryList.containsKey(oldOwnerId)) {
                Territory terOld = this._territoryList.get(oldOwnerId);
                terOld.removeWard(territoryId);
                this.updateTerritoryData(terOld);
                this.updateTerritoryData(terNew);
                if (broadcastMessage) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_HAS_SUCCEDED_IN_CAPTURING_S2_TERRITORY_WARD);
                    sm.addString(terNew.getOwnerClan().getName());
                    sm.addCastleId(territoryId);
                    this.announceToParticipants(sm, 135000, 13500);
                }
                if (terOld.getOwnerClan() != null) {
                    List<L2SkillLearn> territorySkills = SkillTreesData.getInstance().getAvailableResidentialSkills(territoryId);
                    for (L2SkillLearn s : territorySkills) {
                        Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                        if (sk == null) continue;
                        for (L2PcInstance member : terOld.getOwnerClan().getOnlineMembers(0)) {
                            member.removeSkill(sk, false);
                        }
                    }
                    if (!terOld.getOwnedWardIds().isEmpty() && !terOld.getOwnedWardIds().contains(oldOwnerId + 80)) {
                        Iterator<Object> iterator = terOld.getOwnedWardIds().iterator();
                        while (iterator.hasNext()) {
                            int wardId = (Integer)iterator.next();
                            List<L2SkillLearn> wardSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                            for (L2SkillLearn s : wardSkills) {
                                Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                                if (sk == null) continue;
                                for (L2PcInstance member : terOld.getOwnerClan().getOnlineMembers(0)) {
                                    member.removeSkill(sk, false);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            LOG.warn("Missing territory for new Ward owner: {}; {}", (Object)newOwnerId, (Object)territoryId);
        }
        return ret;
    }

    public L2SiegeFlagInstance getHQForClan(L2Clan clan) {
        if (clan.getCastleId() > 0) {
            return this._territoryList.get(clan.getCastleId()).getHQ();
        }
        return null;
    }

    public L2SiegeFlagInstance getHQForTerritory(int territoryId) {
        return this._territoryList.get(territoryId - 80).getHQ();
    }

    public void setHQForClan(L2Clan clan, L2SiegeFlagInstance hq) {
        if (clan.getCastleId() > 0) {
            this._territoryList.get(clan.getCastleId()).setHQ(hq);
        }
    }

    public void addClanFlag(L2Clan clan, L2SiegeFlagInstance flag) {
        this._clanFlags.put(clan, flag);
    }

    public boolean isClanHasFlag(L2Clan clan) {
        return this._clanFlags.containsKey(clan);
    }

    public L2SiegeFlagInstance getFlagForClan(L2Clan clan) {
        return this._clanFlags.get(clan);
    }

    public void removeClanFlag(L2Clan clan) {
        this._clanFlags.remove(clan);
    }

    public List<TerritoryWard> getAllTerritoryWards() {
        return this._territoryWards;
    }

    public TerritoryWard getTerritoryWardForOwner(int castleId) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.getTerritoryId() != castleId) continue;
            return twWard;
        }
        return null;
    }

    public TerritoryWard getTerritoryWard(int territoryId) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.getTerritoryId() != territoryId) continue;
            return twWard;
        }
        return null;
    }

    public TerritoryWard getTerritoryWard(L2PcInstance player) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.playerId != player.getObjectId()) continue;
            return twWard;
        }
        return null;
    }

    public void dropCombatFlag(L2PcInstance player, boolean isKilled, boolean isSpawnBack) {
        for (TerritoryWard twWard : this._territoryWards) {
            if (twWard.playerId != player.getObjectId()) continue;
            twWard.dropIt();
            if (this.isTWInProgress()) {
                if (isKilled) {
                    twWard.spawnMe();
                } else if (isSpawnBack) {
                    twWard.spawnBack();
                } else {
                    for (TerritoryNPCSpawn wardSpawn : this._territoryList.get(twWard.getOwnerCastleId()).getOwnedWard()) {
                        if (wardSpawn.getId() != twWard.getTerritoryId()) continue;
                        wardSpawn.setNPC(wardSpawn.getNpc().getSpawn().doSpawn());
                        twWard.unSpawnMe();
                        twWard.setNpc(wardSpawn.getNpc());
                    }
                }
            }
            if (!isKilled) continue;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_CHAR_THAT_ACQUIRED_S1_WARD_HAS_BEEN_KILLED);
            sm.addString(twWard.getNpc().getName().replace(" Ward", ""));
            this.announceToParticipants(sm, 0, 0);
        }
    }

    public void giveTWQuestPoint(L2PcInstance player) {
        this._participantPoints.putIfAbsent(player.getObjectId(), new Integer[]{player.getSiegeSide(), 0, 0, 0, 0, 0, 0});
        Integer[] integerArray = this._participantPoints.get(player.getObjectId());
        Integer n = integerArray[2];
        integerArray[2] = integerArray[2] + 1;
    }

    public void giveTWPoint(L2PcInstance killer, int victimSide, int type) {
        if (victimSide == 0) {
            return;
        }
        if (killer.getParty() != null && type < 5) {
            for (L2PcInstance pl : killer.getParty().getMembers()) {
                if (pl.getSiegeSide() == victimSide || pl.getSiegeSide() == 0 || !Util.checkIfInRange(2000, killer, pl, false)) continue;
                this._participantPoints.putIfAbsent(pl.getObjectId(), new Integer[]{pl.getSiegeSide(), 0, 0, 0, 0, 0, 0});
                Integer[] integerArray = this._participantPoints.get(pl.getObjectId());
                int n = type;
                Integer n2 = integerArray[n];
                integerArray[n] = integerArray[n] + 1;
            }
        } else {
            if (killer.getSiegeSide() == victimSide || killer.getSiegeSide() == 0) {
                return;
            }
            this._participantPoints.putIfAbsent(killer.getObjectId(), new Integer[]{killer.getSiegeSide(), 0, 0, 0, 0, 0, 0});
            Integer[] integerArray = this._participantPoints.get(killer.getObjectId());
            int n = type;
            Integer n3 = integerArray[n];
            integerArray[n] = integerArray[n] + 1;
        }
    }

    public int[] calcReward(L2PcInstance player) {
        if (this._participantPoints.containsKey(player.getObjectId())) {
            int[] reward = new int[2];
            Integer[] temp = this._participantPoints.get(player.getObjectId());
            reward[0] = temp[0];
            if (temp[6] < 10) {
                return reward;
            }
            reward[1] = reward[1] + (temp[6] > 70 ? 7 : (int)((double)temp[6].intValue() * 0.1));
            reward[1] = reward[1] + temp[2] * 7;
            reward[1] = temp[1] < 50 ? (int)((double)reward[1] + (double)temp[1].intValue() * 0.1) : (temp[1] < 120 ? reward[1] + (5 + (temp[1] - 50) / 14) : reward[1] + 10);
            reward[1] = reward[1] + temp[3];
            reward[1] = reward[1] + temp[4] * 2;
            reward[1] = reward[1] + (temp[5] > 0 ? 5 : 0);
            reward[1] = reward[1] + Math.min(this._territoryList.get(temp[0] - 80).getQuestDone()[0], 10);
            reward[1] = reward[1] + this._territoryList.get(temp[0] - 80).getQuestDone()[1];
            reward[1] = reward[1] + this._territoryList.get(temp[0] - 80).getOwnedWardIds().size();
            return reward;
        }
        return new int[]{0, 0};
    }

    public void debugReward(L2PcInstance player) {
        player.sendMessage("Registered TerrId: " + player.getSiegeSide());
        if (this._participantPoints.containsKey(player.getObjectId())) {
            Integer[] temp = this._participantPoints.get(player.getObjectId());
            player.sendMessage("TerrId: " + temp[0]);
            player.sendMessage("PcKill: " + temp[1]);
            player.sendMessage("PcQuests: " + temp[2]);
            player.sendMessage("npcKill: " + temp[3]);
            player.sendMessage("CatatKill: " + temp[4]);
            player.sendMessage("WardKill: " + temp[5]);
            player.sendMessage("onlineTime: " + temp[6]);
        } else {
            player.sendMessage("No points for you!");
        }
        if (this._territoryList.containsKey(player.getSiegeSide() - 80)) {
            player.sendMessage("Your Territory's jobs:");
            player.sendMessage("npcKill: " + this._territoryList.get(player.getSiegeSide() - 80).getQuestDone()[0]);
            player.sendMessage("WardCaptured: " + this._territoryList.get(player.getSiegeSide() - 80).getQuestDone()[1]);
        }
    }

    public void resetReward(L2PcInstance player) {
        if (this._participantPoints.containsKey(player.getObjectId())) {
            this._participantPoints.get((Object)Integer.valueOf((int)player.getObjectId()))[6] = 0;
        }
    }

    public L2Npc spawnNPC(int npcId, Location loc) {
        try {
            L2Spawn spawnDat = new L2Spawn(npcId);
            spawnDat.setAmount(1);
            spawnDat.setX(loc.getX());
            spawnDat.setY(loc.getY());
            spawnDat.setZ(loc.getZ());
            spawnDat.setHeading(loc.getHeading());
            spawnDat.stopRespawn();
            return spawnDat.spawnOne(false);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return null;
        }
    }

    private void changeRegistration(int castleId, int objId, boolean delete) {
        String query = delete ? DELETE : INSERT;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, castleId);
            ps.setInt(2, objId);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: Territory War registration: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void updateTerritoryData(Territory ter) {
        StringBuilder wardList = new StringBuilder();
        for (int i : ter.getOwnedWardIds()) {
            wardList.append(i).append(";");
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE territories SET ownedWardIds=? WHERE territoryId=?");){
            ps.setString(1, wardList.toString());
            ps.setInt(2, ter.getTerritoryId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: Territory Data update: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() {
        int castleId;
        ResultSet rs;
        Statement s;
        Connection con;
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                s = con.createStatement();
                try {
                    rs = s.executeQuery("SELECT * FROM territory_spawnlist");
                    try {
                        block55: while (rs.next()) {
                            castleId = rs.getInt("castleId");
                            int npcId = rs.getInt("npcId");
                            Location loc = new Location(rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getInt("heading"));
                            int spawnType = rs.getInt("spawnType");
                            if (!this._territoryList.containsKey(castleId)) {
                                this._territoryList.put(castleId, new Territory(castleId));
                            }
                            switch (spawnType) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    this._territoryList.get(castleId).getSpawnList().add(new TerritoryNPCSpawn(castleId, loc, npcId, spawnType, null));
                                    continue block55;
                                }
                                case 3: {
                                    this._territoryList.get(castleId).addWardSpawnPlace(loc);
                                    continue block55;
                                }
                            }
                            LOG.warn("Unknown npc type for {}", (Object)rs.getInt("id"));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("SpawnList error: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                s = con.createStatement();
                try {
                    rs = s.executeQuery("SELECT * FROM territories");
                    try {
                        while (rs.next()) {
                            castleId = rs.getInt("castleId");
                            int fortId = rs.getInt("fortId");
                            String ownedWardIds = rs.getString("OwnedWardIds");
                            Territory t = this._territoryList.get(castleId);
                            if (t == null) continue;
                            t._fortId = fortId;
                            if (CastleManager.getInstance().getCastleById(castleId).getOwnerId() > 0) {
                                t.setOwnerClan(ClanTable.getInstance().getClan(CastleManager.getInstance().getCastleById(castleId).getOwnerId()));
                                t.changeNPCsSpawn(0, true);
                            }
                            if (ownedWardIds.isEmpty()) continue;
                            for (String wardId : ownedWardIds.split(";")) {
                                if (Integer.parseInt(wardId) <= 0) continue;
                                this.addTerritoryWard(Integer.parseInt(wardId), castleId, 0, false);
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Territory list error(): {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                s = con.createStatement();
                try {
                    rs = s.executeQuery("SELECT * FROM territory_registrations");
                    try {
                        while (rs.next()) {
                            castleId = rs.getInt("castleId");
                            int registeredId = rs.getInt("registeredId");
                            if (ClanTable.getInstance().getClan(registeredId) != null) {
                                if (this._registeredClans.get(castleId) == null) {
                                    this._registeredClans.putIfAbsent(castleId, new CopyOnWriteArrayList());
                                }
                                this._registeredClans.get(castleId).add(ClanTable.getInstance().getClan(registeredId));
                                continue;
                            }
                            this._registeredMercenaries.computeIfAbsent(castleId, key -> new CopyOnWriteArrayList());
                            this._registeredMercenaries.get(castleId).add(registeredId);
                        }
                        return;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Registration list error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void startTerritoryWar() {
        Castle castle;
        LinkedList<Territory> activeTerritoryList = new LinkedList<Territory>();
        for (Territory t : this._territoryList.values()) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            if (castle != null) {
                if (castle.getOwnerId() <= 0) continue;
                activeTerritoryList.add(t);
                continue;
            }
            LOG.warn("Castle missing! CastleId: {}", (Object)t.getCastleId());
        }
        if (activeTerritoryList.size() < 2) {
            return;
        }
        this._isTWInProgress = true;
        if (!this.updatePlayerTWStateFlags(false)) {
            return;
        }
        for (Territory t : activeTerritoryList) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            Fort fort = FortManager.getInstance().getFortById(t.getFortId());
            if (castle != null) {
                t.changeNPCsSpawn(2, true);
                castle.spawnDoor();
                castle.getZone().setSiegeInstance(this);
                castle.getZone().setIsActive(true);
                castle.getZone().updateZoneStatusForCharactersInside();
            } else {
                LOG.warn("Castle missing! CastleId: {}", (Object)t.getCastleId());
            }
            if (fort != null) {
                t.changeNPCsSpawn(1, true);
                fort.resetDoors();
                fort.getZone().setSiegeInstance(this);
                fort.getZone().setIsActive(true);
                fort.getZone().updateZoneStatusForCharactersInside();
            } else {
                LOG.warn("Fort missing! FortId: {}", (Object)t.getFortId());
            }
            for (TerritoryNPCSpawn ward : t.getOwnedWard()) {
                if (ward.getNpc() == null || t.getOwnerClan() == null) continue;
                if (!ward.getNpc().isVisible()) {
                    ward.setNPC(ward.getNpc().getSpawn().doSpawn());
                }
                this._territoryWards.add(new TerritoryWard(ward.getId(), ward.getLocation().getX(), ward.getLocation().getY(), ward.getLocation().getZ(), 0, ward.getId() + 13479, t.getCastleId(), ward.getNpc()));
            }
            t.getQuestDone()[0] = 0;
            t.getQuestDone()[1] = 0;
        }
        this._participantPoints.clear();
        if (Configuration.territoryWar().returnWardsWhenTWStarts()) {
            for (TerritoryWard ward : this._territoryWards) {
                if (ward.getOwnerCastleId() == ward.getTerritoryId() - 80) continue;
                ward.unSpawnMe();
                ward.setNpc(this.addTerritoryWard(ward.getTerritoryId(), ward.getTerritoryId() - 80, ward.getOwnerCastleId(), false));
                ward.setOwnerCastleId(ward.getTerritoryId() - 80);
            }
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_HAS_BEGUN);
        Broadcast.toAllOnlinePlayers(sm);
    }

    public void endTerritoryWar() {
        Castle castle;
        this._isTWInProgress = false;
        LinkedList<Territory> activeTerritoryList = new LinkedList<Territory>();
        for (Territory t : this._territoryList.values()) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            if (castle != null) {
                if (castle.getOwnerId() <= 0) continue;
                activeTerritoryList.add(t);
                continue;
            }
            LOG.warn("Castle missing! CastleId: {}", (Object)t.getCastleId());
        }
        if (activeTerritoryList.size() < 2) {
            return;
        }
        if (!this.updatePlayerTWStateFlags(true)) {
            return;
        }
        for (TerritoryWard twWard : this._territoryWards) {
            twWard.unSpawnMe();
        }
        this._territoryWards.clear();
        for (Territory t : activeTerritoryList) {
            castle = CastleManager.getInstance().getCastleById(t.getCastleId());
            Fort fort = FortManager.getInstance().getFortById(t.getFortId());
            if (castle != null) {
                castle.spawnDoor();
                t.changeNPCsSpawn(2, false);
                castle.getZone().setIsActive(false);
                castle.getZone().updateZoneStatusForCharactersInside();
                castle.getZone().setSiegeInstance(null);
            } else {
                LOG.warn("Castle missing! CastleId: {}", (Object)t.getCastleId());
            }
            if (fort != null) {
                t.changeNPCsSpawn(1, false);
                fort.getZone().setIsActive(false);
                fort.getZone().updateZoneStatusForCharactersInside();
                fort.getZone().setSiegeInstance(null);
            } else {
                LOG.warn("Fort missing! FortId: {}", (Object)t.getFortId());
            }
            if (t.getHQ() != null) {
                t.getHQ().deleteMe();
            }
            for (TerritoryNPCSpawn ward : t.getOwnedWard()) {
                if (ward.getNpc() == null) continue;
                if (!ward.getNpc().isVisible() && Configuration.territoryWar().spawnWardsWhenTWIsNotInProgress()) {
                    ward.setNPC(ward.getNpc().getSpawn().doSpawn());
                    continue;
                }
                if (!ward.getNpc().isVisible() || Configuration.territoryWar().spawnWardsWhenTWIsNotInProgress()) continue;
                ward.getNpc().decayMe();
            }
        }
        for (L2SiegeFlagInstance flag : this._clanFlags.values()) {
            flag.deleteMe();
        }
        this._clanFlags.clear();
        for (Integer castleId : this._registeredClans.keySet()) {
            for (L2Clan clan : this._registeredClans.get(castleId)) {
                this.changeRegistration(castleId, clan.getId(), true);
            }
        }
        for (Integer castleId : this._registeredMercenaries.keySet()) {
            for (Integer pl_objId : this._registeredMercenaries.get(castleId)) {
                this.changeRegistration(castleId, pl_objId, true);
            }
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_HAS_ENDED);
        Broadcast.toAllOnlinePlayers(sm);
    }

    public boolean updatePlayerTWStateFlags(boolean clear) {
        int castleId;
        Quest twQuest = QuestManager.getInstance().getQuest(qn);
        if (twQuest == null) {
            LOG.warn("Missing main Quest!");
            return false;
        }
        Iterator<Object> iterator = this._registeredClans.keySet().iterator();
        while (iterator.hasNext()) {
            castleId = iterator.next();
            for (L2Clan clan : this._registeredClans.get(castleId)) {
                for (L2PcInstance player : clan.getOnlineMembers(0)) {
                    if (clear) {
                        player.setSiegeState((byte)0);
                        if (!this._isTWChannelOpen) {
                            player.setSiegeSide(0);
                        }
                    } else {
                        if (player.getLevel() < Configuration.territoryWar().getPlayerMinLevel() || player.getClassId().level() < 2) continue;
                        if (this._isTWInProgress) {
                            player.setSiegeState((byte)1);
                        }
                        player.setSiegeSide(80 + castleId);
                    }
                    player.broadcastUserInfo();
                }
            }
        }
        iterator = this._registeredMercenaries.keySet().iterator();
        while (iterator.hasNext()) {
            castleId = iterator.next();
            Iterator<Object> iterator2 = this._registeredMercenaries.get(castleId).iterator();
            while (iterator2.hasNext()) {
                int objId = (Integer)iterator2.next();
                L2PcInstance player = L2World.getInstance().getPlayer(objId);
                if (player == null) continue;
                if (clear) {
                    player.setSiegeState((byte)0);
                    if (!this._isTWChannelOpen) {
                        player.setSiegeSide(0);
                    }
                } else {
                    if (this._isTWInProgress) {
                        player.setSiegeState((byte)1);
                    }
                    player.setSiegeSide(80 + castleId);
                }
                player.broadcastUserInfo();
            }
        }
        for (Territory terr : this._territoryList.values()) {
            if (terr.getOwnerClan() == null) continue;
            for (L2PcInstance player : terr.getOwnerClan().getOnlineMembers(0)) {
                if (player == null) continue;
                if (clear) {
                    player.setSiegeState((byte)0);
                    if (!this._isTWChannelOpen) {
                        player.setSiegeSide(0);
                    }
                } else {
                    if (player.getLevel() < Configuration.territoryWar().getPlayerMinLevel() || player.getClassId().level() < 2) continue;
                    if (this._isTWInProgress) {
                        player.setSiegeState((byte)1);
                    }
                    player.setSiegeSide(80 + terr.getCastleId());
                }
                player.broadcastUserInfo();
            }
        }
        twQuest.setOnEnterWorld(this._isTWInProgress);
        return true;
    }

    public void announceToParticipants(L2GameServerPacket sm, int exp, int sp) {
        for (Territory territory : this._territoryList.values()) {
            if (territory.getOwnerClan() == null) continue;
            for (L2PcInstance member : territory.getOwnerClan().getOnlineMembers(0)) {
                member.sendPacket(sm);
                if (exp <= 0 && sp <= 0) continue;
                member.addExpAndSp(exp, sp);
            }
        }
        for (List list : this._registeredClans.values()) {
            for (L2Clan c : list) {
                for (L2PcInstance member : c.getOnlineMembers(0)) {
                    member.sendPacket(sm);
                    if (exp <= 0 && sp <= 0) continue;
                    member.addExpAndSp(exp, sp);
                }
            }
        }
        for (List list : this._registeredMercenaries.values()) {
            Iterator<L2PcInstance> iterator = list.iterator();
            while (iterator.hasNext()) {
                int objId = (Integer)((Object)iterator.next());
                L2PcInstance player = L2World.getInstance().getPlayer(objId);
                if (player == null || player.getClan() != null && this.checkIsRegistered(-1, player.getClan())) continue;
                player.sendPacket(sm);
                if (exp <= 0 && sp <= 0) continue;
                player.addExpAndSp(exp, sp);
            }
        }
    }

    @Override
    public void startSiege() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endSiege() {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getAttackerClan(int clanId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getAttackerClan(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2SiegeClan> getAttackerClans() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getDefenderClan(int clanId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public L2SiegeClan getDefenderClan(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2SiegeClan> getDefenderClans() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Calendar getSiegeDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean giveFame() {
        return true;
    }

    @Override
    public int getFameFrequency() {
        return (int)Configuration.character().getCastleZoneFameTaskFrequency();
    }

    @Override
    public int getFameAmount() {
        return Configuration.character().getCastleZoneFameAcquirePoints();
    }

    @Override
    public void updateSiege() {
    }

    public void declareLord(int territoryId, L2PcInstance player) {
    }

    public static TerritoryWarManager getInstance() {
        return SingletonHolder._instance;
    }

    static {
        TERRITORY_ITEM_IDS.put(81, 13757);
        TERRITORY_ITEM_IDS.put(82, 13758);
        TERRITORY_ITEM_IDS.put(83, 13759);
        TERRITORY_ITEM_IDS.put(84, 13760);
        TERRITORY_ITEM_IDS.put(85, 13761);
        TERRITORY_ITEM_IDS.put(86, 13762);
        TERRITORY_ITEM_IDS.put(87, 13763);
        TERRITORY_ITEM_IDS.put(88, 13764);
        TERRITORY_ITEM_IDS.put(89, 13765);
    }

    public class Territory {
        private static final Logger LOG = LoggerFactory.getLogger(Territory.class);
        private final int _territoryId;
        private final int _castleId;
        protected int _fortId;
        private L2Clan _ownerClan;
        private final List<TerritoryNPCSpawn> _spawnList = new LinkedList<TerritoryNPCSpawn>();
        private final TerritoryNPCSpawn[] _territoryWardSpawnPlaces;
        private boolean _isInProgress = false;
        private L2SiegeFlagInstance _territoryHQ = null;
        private final int[] _questDone;

        public Territory(int castleId) {
            this._castleId = castleId;
            this._territoryId = castleId + 80;
            this._territoryWardSpawnPlaces = new TerritoryNPCSpawn[9];
            this._questDone = new int[2];
        }

        protected void addWardSpawnPlace(Location loc) {
            for (int i = 0; i < this._territoryWardSpawnPlaces.length; ++i) {
                if (this._territoryWardSpawnPlaces[i] != null) continue;
                this._territoryWardSpawnPlaces[i] = new TerritoryNPCSpawn(this._castleId, loc, 0, 4, null);
                return;
            }
        }

        protected TerritoryNPCSpawn getFreeWardSpawnPlace() {
            for (TerritoryNPCSpawn _territoryWardSpawnPlace : this._territoryWardSpawnPlaces) {
                if (_territoryWardSpawnPlace == null || _territoryWardSpawnPlace.getNpc() != null) continue;
                return _territoryWardSpawnPlace;
            }
            LOG.warn("No free Ward spawn found for territory: {}", (Object)this._territoryId);
            for (int i = 0; i < this._territoryWardSpawnPlaces.length; ++i) {
                if (this._territoryWardSpawnPlaces[i] == null) {
                    LOG.warn("Territory ward spawn place {} is null!", (Object)i);
                    continue;
                }
                if (this._territoryWardSpawnPlaces[i].getNpc() != null) {
                    LOG.warn("Territory ward spawn place {} has npc name: {}", (Object)i, (Object)this._territoryWardSpawnPlaces[i].getNpc().getName());
                    continue;
                }
                LOG.warn("Territory ward spawn place {} is empty!", (Object)i);
            }
            return null;
        }

        public List<TerritoryNPCSpawn> getSpawnList() {
            return this._spawnList;
        }

        protected void changeNPCsSpawn(int type, boolean isSpawn) {
            if (type < 0 || type > 3) {
                LOG.warn("Wrong type({}) for NPCs spawn change!", (Object)type);
                return;
            }
            for (TerritoryNPCSpawn twSpawn : this._spawnList) {
                if (twSpawn.getType() != type) continue;
                if (isSpawn) {
                    twSpawn.setNPC(TerritoryWarManager.this.spawnNPC(twSpawn.getId(), twSpawn.getLocation()));
                    continue;
                }
                L2Npc npc = twSpawn.getNpc();
                if (npc != null && !npc.isDead()) {
                    npc.deleteMe();
                }
                twSpawn.setNPC(null);
            }
        }

        protected void removeWard(int wardId) {
            for (TerritoryNPCSpawn wardSpawn : this._territoryWardSpawnPlaces) {
                if (wardSpawn.getId() != wardId) continue;
                wardSpawn.getNpc().deleteMe();
                wardSpawn.setNPC(null);
                wardSpawn._npcId = 0;
                return;
            }
            LOG.warn("Can't delete wardId: {} for territory: {}", (Object)wardId, (Object)this._territoryId);
        }

        public int getTerritoryId() {
            return this._territoryId;
        }

        public int getCastleId() {
            return this._castleId;
        }

        public int getFortId() {
            return this._fortId;
        }

        public L2Clan getOwnerClan() {
            return this._ownerClan;
        }

        public void setOwnerClan(L2Clan newOwner) {
            this._ownerClan = newOwner;
        }

        public void setHQ(L2SiegeFlagInstance hq) {
            this._territoryHQ = hq;
        }

        public L2SiegeFlagInstance getHQ() {
            return this._territoryHQ;
        }

        public TerritoryNPCSpawn[] getOwnedWard() {
            return this._territoryWardSpawnPlaces;
        }

        public int[] getQuestDone() {
            return this._questDone;
        }

        public List<Integer> getOwnedWardIds() {
            LinkedList<Integer> ret = new LinkedList<Integer>();
            for (TerritoryNPCSpawn wardSpawn : this._territoryWardSpawnPlaces) {
                if (wardSpawn.getId() <= 0) continue;
                ret.add(wardSpawn.getId());
            }
            return ret;
        }

        public boolean isInProgress() {
            return this._isInProgress;
        }

        public void setIsInProgress(boolean val) {
            this._isInProgress = val;
        }
    }

    private class ScheduleEndTWTask
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(ScheduleEndTWTask.class);

        protected ScheduleEndTWTask() {
        }

        @Override
        public void run() {
            try {
                TerritoryWarManager.this._scheduledEndTWTask.cancel(false);
                long timeRemaining = TerritoryWarManager.this._startTWDate.getTimeInMillis() + TimeUnit.MINUTES.toMillis(Configuration.territoryWar().getWarLength()) - Calendar.getInstance().getTimeInMillis();
                if (timeRemaining > 3600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_HOURS);
                    sm.addInt(2);
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 3600000L);
                } else if (timeRemaining > 600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES);
                    sm.addInt((int)(timeRemaining / 60000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 600000L);
                } else if (timeRemaining > 300000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES);
                    sm.addInt((int)(timeRemaining / 60000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 300000L);
                } else if (timeRemaining > 10000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES);
                    sm.addInt((int)(timeRemaining / 60000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining - 10000L);
                } else if (timeRemaining > 0L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_TO_THE_END_OF_TERRITORY_WAR);
                    sm.addInt((int)(timeRemaining / 1000L));
                    TerritoryWarManager.this.announceToParticipants(sm, 0, 0);
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), timeRemaining);
                } else {
                    TerritoryWarManager.this.endTerritoryWar();
                    ThreadPoolManager.getInstance().scheduleGeneral(new closeTerritoryChannelTask(), 600000L);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    protected class ScheduleStartTWTask
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(ScheduleStartTWTask.class);

        protected ScheduleStartTWTask() {
        }

        @Override
        public void run() {
            TerritoryWarManager.this._scheduledStartTWTask.cancel(false);
            try {
                long timeRemaining = TerritoryWarManager.this._startTWDate.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
                if (timeRemaining > 0x6DDD00L) {
                    TerritoryWarManager.this._isRegistrationOver = false;
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 0x6DDD00L);
                } else if (timeRemaining > 1200000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_TERRITORY_WAR_REGISTERING_PERIOD_ENDED);
                    Broadcast.toAllOnlinePlayers(sm);
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 1200000L);
                } else if (timeRemaining > 600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_20_MINUTES);
                    Broadcast.toAllOnlinePlayers(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 600000L);
                } else if (timeRemaining > 300000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_10_MINUTES);
                    Broadcast.toAllOnlinePlayers(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 300000L);
                } else if (timeRemaining > 60000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_5_MINUTES);
                    Broadcast.toAllOnlinePlayers(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining - 60000L);
                } else if (timeRemaining > 0L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.TERRITORY_WAR_BEGINS_IN_1_MINUTE);
                    Broadcast.toAllOnlinePlayers(sm);
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.updatePlayerTWStateFlags(false);
                    TerritoryWarManager.this._scheduledStartTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartTWTask(), timeRemaining);
                } else if (timeRemaining + TimeUnit.MINUTES.toMillis(Configuration.territoryWar().getWarLength()) > 0L) {
                    TerritoryWarManager.this._isTWChannelOpen = true;
                    TerritoryWarManager.this._isRegistrationOver = true;
                    TerritoryWarManager.this.startTerritoryWar();
                    TerritoryWarManager.this._scheduledEndTWTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndTWTask(), 1000L);
                    TerritoryWarManager.this._scheduledRewardOnlineTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RewardOnlineParticipants(), 60000L, 60000L);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    public static class TerritoryNPCSpawn
    implements IIdentifiable {
        private final Location _location;
        protected int _npcId;
        private final int _castleId;
        private final int _type;
        private L2Npc _npc;

        public TerritoryNPCSpawn(int castle_id, Location loc, int npc_id, int type, L2Npc npc) {
            this._castleId = castle_id;
            this._location = loc;
            this._npcId = npc_id;
            this._type = type;
            this._npc = npc;
        }

        public int getCastleId() {
            return this._castleId;
        }

        @Override
        public int getId() {
            return this._npcId;
        }

        public int getType() {
            return this._type;
        }

        public void setNPC(L2Npc npc) {
            if (this._npc != null) {
                this._npc.deleteMe();
            }
            this._npc = npc;
        }

        public L2Npc getNpc() {
            return this._npc;
        }

        public Location getLocation() {
            return this._location;
        }
    }

    private static class SingletonHolder {
        protected static final TerritoryWarManager _instance = new TerritoryWarManager();

        private SingletonHolder() {
        }
    }

    private class closeTerritoryChannelTask
    implements Runnable {
        @Override
        public void run() {
            TerritoryWarManager.this._isTWChannelOpen = false;
            TerritoryWarManager.this._disguisedPlayers.clear();
            TerritoryWarManager.this.updatePlayerTWStateFlags(true);
        }
    }

    protected class RewardOnlineParticipants
    implements Runnable {
        protected RewardOnlineParticipants() {
        }

        @Override
        public void run() {
            if (TerritoryWarManager.this.isTWInProgress()) {
                for (L2PcInstance player : L2World.getInstance().getPlayers()) {
                    if (player == null || player.getSiegeSide() <= 0) continue;
                    TerritoryWarManager.this.giveTWPoint(player, 1000, 6);
                }
            } else {
                TerritoryWarManager.this._scheduledRewardOnlineTask.cancel(false);
            }
        }
    }
}

