/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.games;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lottery {
    protected static final Logger LOG = LoggerFactory.getLogger(Lottery.class);
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    private static final String INSERT_LOTTERY = "INSERT INTO games(id, idnr, enddate, prize, newprize) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_PRICE = "UPDATE games SET prize=?, newprize=? WHERE id = 1 AND idnr = ?";
    private static final String UPDATE_LOTTERY = "UPDATE games SET finished=1, prize=?, newprize=?, number1=?, number2=?, prize1=?, prize2=?, prize3=? WHERE id=1 AND idnr=?";
    private static final String SELECT_LAST_LOTTERY = "SELECT idnr, prize, newprize, enddate, finished FROM games WHERE id = 1 ORDER BY idnr DESC LIMIT 1";
    private static final String SELECT_LOTTERY_ITEM = "SELECT enchant_level, custom_type2 FROM items WHERE item_id = 4442 AND custom_type1 = ?";
    private static final String SELECT_LOTTERY_TICKET = "SELECT number1, number2, prize1, prize2, prize3 FROM games WHERE id = 1 and idnr = ?";
    private int _number = 1;
    private long _prize = Configuration.general().getLotteryPrize();
    private boolean _isSellingTickets = false;
    private boolean _isStarted = false;
    private long _enddate = System.currentTimeMillis();

    protected Lottery() {
        if (Configuration.general().allowLottery()) {
            new StartLottery().run();
        }
    }

    public static Lottery getInstance() {
        return SingletonHolder._instance;
    }

    public int getId() {
        return this._number;
    }

    public long getPrize() {
        return this._prize;
    }

    public long getEndDate() {
        return this._enddate;
    }

    public void increasePrize(long count) {
        this._prize += count;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_PRICE);){
            ps.setLong(1, this.getPrize());
            ps.setLong(2, this.getPrize());
            ps.setInt(3, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not increase current lottery prize: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean isSellableTickets() {
        return this._isSellingTickets;
    }

    public boolean isStarted() {
        return this._isStarted;
    }

    public int[] decodeNumbers(int enchant, int type2) {
        int val;
        int[] res = new int[5];
        int id = 0;
        int nr = 1;
        while (enchant > 0) {
            val = enchant / 2;
            if ((long)val != Math.round((double)enchant / 2.0)) {
                res[id++] = nr;
            }
            enchant /= 2;
            ++nr;
        }
        nr = 17;
        while (type2 > 0) {
            val = type2 / 2;
            if ((double)val != (double)type2 / 2.0) {
                res[id++] = nr;
            }
            type2 /= 2;
            ++nr;
        }
        return res;
    }

    public long[] checkTicket(L2ItemInstance item) {
        return this.checkTicket(item.getCustomType1(), item.getEnchantLevel(), item.getCustomType2());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] checkTicket(int id, int enchant, int type2) {
        long[] res = new long[]{0L, 0L};
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_LOTTERY_TICKET);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return res;
                int curenchant = rs.getInt("number1") & enchant;
                int curtype2 = rs.getInt("number2") & type2;
                if (curenchant == 0 && curtype2 == 0) {
                    long[] lArray = res;
                    return lArray;
                }
                int count = 0;
                for (int i = 1; i <= 16; ++i) {
                    int val2;
                    int val = curenchant / 2;
                    if ((long)val != Math.round((double)curenchant / 2.0)) {
                        ++count;
                    }
                    if ((double)(val2 = curtype2 / 2) != (double)curtype2 / 2.0) {
                        ++count;
                    }
                    curenchant = val;
                    curtype2 = val2;
                }
                switch (count) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        res[0] = 1L;
                        res[1] = rs.getLong("prize1");
                        break;
                    }
                    case 4: {
                        res[0] = 2L;
                        res[1] = rs.getLong("prize2");
                        break;
                    }
                    case 3: {
                        res[0] = 3L;
                        res[1] = rs.getLong("prize3");
                        break;
                    }
                    default: {
                        res[0] = 4L;
                        res[1] = Configuration.general().getLottery2and1NumberPrize();
                    }
                }
                if (!Configuration.general().debug()) return res;
                LOG.warn("count: {}, id: {}, enchant: {}, type2: {}", count, id, enchant, type2);
                return res;
            }
        }
        catch (Exception e) {
            LOG.warn("Could not check lottery ticket #{}: {}", id, e.getMessage(), e);
        }
        return res;
    }

    private class StartLottery
    implements Runnable {
        protected StartLottery() {
        }

        @Override
        public void run() {
            block44: {
                try (Connection con = ConnectionFactory.getInstance().getConnection();){
                    ResultSet rs;
                    Statement s;
                    block45: {
                        s = con.createStatement();
                        rs = s.executeQuery(Lottery.SELECT_LAST_LOTTERY);
                        if (!rs.next()) break block44;
                        Lottery.this._number = rs.getInt("idnr");
                        if (rs.getInt("finished") == 1) {
                            ++Lottery.this._number;
                            Lottery.this._prize = rs.getLong("newprize");
                            break block44;
                        }
                        Lottery.this._prize = rs.getLong("prize");
                        Lottery.this._enddate = rs.getLong("enddate");
                        if (Lottery.this._enddate <= System.currentTimeMillis() + 120000L) {
                            new FinishLottery().run();
                            return;
                        }
                        if (Lottery.this._enddate <= System.currentTimeMillis()) break block44;
                        Lottery.this._isStarted = true;
                        ThreadPoolManager.getInstance().scheduleGeneral(new FinishLottery(), Lottery.this._enddate - System.currentTimeMillis());
                        if (Lottery.this._enddate <= System.currentTimeMillis() + 720000L) break block45;
                        Lottery.this._isSellingTickets = true;
                        ThreadPoolManager.getInstance().scheduleGeneral(new StopSellingTickets(), Lottery.this._enddate - System.currentTimeMillis() - 600000L);
                    }
                    return;
                    {
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Could not restore lottery data: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (Configuration.general().debug()) {
                LOG.info("Starting ticket sell for lottery #{}.", (Object)Lottery.this.getId());
            }
            Lottery.this._isSellingTickets = true;
            Lottery.this._isStarted = true;
            Broadcast.toAllOnlinePlayers("Lottery tickets are now available for Lucky Lottery #" + Lottery.this.getId() + ".");
            Calendar finishtime = Calendar.getInstance();
            finishtime.setTimeInMillis(Lottery.this._enddate);
            finishtime.set(12, 0);
            finishtime.set(13, 0);
            if (finishtime.get(7) == 1) {
                finishtime.set(11, 19);
                Lottery.this._enddate = finishtime.getTimeInMillis();
                Lottery.this._enddate += 604800000L;
            } else {
                finishtime.set(7, 1);
                finishtime.set(11, 19);
                Lottery.this._enddate = finishtime.getTimeInMillis();
            }
            ThreadPoolManager.getInstance().scheduleGeneral(new StopSellingTickets(), Lottery.this._enddate - System.currentTimeMillis() - 600000L);
            ThreadPoolManager.getInstance().scheduleGeneral(new FinishLottery(), Lottery.this._enddate - System.currentTimeMillis());
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(Lottery.INSERT_LOTTERY);){
                ps.setInt(1, 1);
                ps.setInt(2, Lottery.this.getId());
                ps.setLong(3, Lottery.this.getEndDate());
                ps.setLong(4, Lottery.this.getPrize());
                ps.setLong(5, Lottery.this.getPrize());
                ps.execute();
            }
            catch (Exception e) {
                LOG.warn("Could not store new lottery data: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class SingletonHolder {
        protected static final Lottery _instance = new Lottery();

        private SingletonHolder() {
        }
    }

    private class FinishLottery
    implements Runnable {
        protected FinishLottery() {
        }

        @Override
        public void run() {
            if (Configuration.general().debug()) {
                LOG.info("Ending lottery #{}.", (Object)Lottery.this.getId());
            }
            int[] luckynums = new int[5];
            int luckynum = 0;
            for (int i = 0; i < 5; ++i) {
                boolean found = true;
                block30: while (found) {
                    luckynum = Rnd.get((int)20) + 1;
                    found = false;
                    for (int j = 0; j < i; ++j) {
                        if (luckynums[j] != luckynum) continue;
                        found = true;
                        continue block30;
                    }
                }
                luckynums[i] = luckynum;
            }
            if (Configuration.general().debug()) {
                LOG.info("The lucky numbers are {}, {}, {}, {}, {}.", luckynums[0], luckynums[1], luckynums[2], luckynums[3], luckynums[4]);
            }
            int enchant = 0;
            int type2 = 0;
            for (int i = 0; i < 5; ++i) {
                if (luckynums[i] < 17) {
                    enchant += (int)Math.pow(2.0, luckynums[i] - 1);
                    continue;
                }
                type2 += (int)Math.pow(2.0, luckynums[i] - 17);
            }
            if (Configuration.general().debug()) {
                LOG.info("Encoded lucky numbers are {}, {}", (Object)enchant, (Object)type2);
            }
            int count1 = 0;
            int count2 = 0;
            int count3 = 0;
            int count4 = 0;
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(Lottery.SELECT_LOTTERY_ITEM);){
                ps.setInt(1, Lottery.this.getId());
                try (ResultSet rset = ps.executeQuery();){
                    while (rset.next()) {
                        int curenchant = rset.getInt("enchant_level") & enchant;
                        int curtype2 = rset.getInt("custom_type2") & type2;
                        if (curenchant == 0 && curtype2 == 0) continue;
                        int count = 0;
                        for (int i = 1; i <= 16; ++i) {
                            int val2;
                            int val = curenchant / 2;
                            if ((long)val != Math.round((double)curenchant / 2.0)) {
                                ++count;
                            }
                            if ((double)(val2 = curtype2 / 2) != (double)curtype2 / 2.0) {
                                ++count;
                            }
                            curenchant = val;
                            curtype2 = val2;
                        }
                        if (count == 5) {
                            ++count1;
                            continue;
                        }
                        if (count == 4) {
                            ++count2;
                            continue;
                        }
                        if (count == 3) {
                            ++count3;
                            continue;
                        }
                        if (count <= 0) continue;
                        ++count4;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Could not restore lottery data: {}", (Object)e.getMessage(), (Object)e);
            }
            long prize4 = (long)count4 * Configuration.general().getLottery2and1NumberPrize();
            long prize1 = 0L;
            long prize2 = 0L;
            long prize3 = 0L;
            if (count1 > 0) {
                prize1 = (long)((float)(Lottery.this.getPrize() - prize4) * Configuration.general().getLottery5NumberRate() / (float)count1);
            }
            if (count2 > 0) {
                prize2 = (long)((float)(Lottery.this.getPrize() - prize4) * Configuration.general().getLottery4NumberRate() / (float)count2);
            }
            if (count3 > 0) {
                prize3 = (long)((float)(Lottery.this.getPrize() - prize4) * Configuration.general().getLottery3NumberRate() / (float)count3);
            }
            if (Configuration.general().debug()) {
                LOG.info("{} players with all FIVE numbers each win {}.", (Object)count1, (Object)prize1);
                LOG.info("{} players with FOUR numbers each win {}.", (Object)count2, (Object)prize2);
                LOG.info("{} players with THREE numbers each win {}.", (Object)count3, (Object)prize3);
                LOG.info("{} players with ONE or TWO numbers each win {}.", (Object)count4, (Object)prize4);
            }
            long newprize = Lottery.this.getPrize() - (prize1 + prize2 + prize3 + prize4);
            if (Configuration.general().debug()) {
                LOG.info("Jackpot for next lottery is {}.", (Object)newprize);
            }
            if (count1 > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AMOUNT_FOR_WINNER_S1_IS_S2_ADENA_WE_HAVE_S3_PRIZE_WINNER);
                sm.addInt(Lottery.this.getId());
                sm.addLong(Lottery.this.getPrize());
                sm.addLong(count1);
                Broadcast.toAllOnlinePlayers(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AMOUNT_FOR_LOTTERY_S1_IS_S2_ADENA_NO_WINNER);
                sm.addInt(Lottery.this.getId());
                sm.addLong(Lottery.this.getPrize());
                Broadcast.toAllOnlinePlayers(sm);
            }
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(Lottery.UPDATE_LOTTERY);){
                ps.setLong(1, Lottery.this.getPrize());
                ps.setLong(2, newprize);
                ps.setInt(3, enchant);
                ps.setInt(4, type2);
                ps.setLong(5, prize1);
                ps.setLong(6, prize2);
                ps.setLong(7, prize3);
                ps.setInt(8, Lottery.this.getId());
                ps.execute();
            }
            catch (Exception e) {
                LOG.warn("Could not store finished lottery data: {}", (Object)e.getMessage(), (Object)e);
            }
            ThreadPoolManager.getInstance().scheduleGeneral(new StartLottery(), 60000L);
            ++Lottery.this._number;
            Lottery.this._isStarted = false;
        }
    }

    private class StopSellingTickets
    implements Runnable {
        protected StopSellingTickets() {
        }

        @Override
        public void run() {
            if (Configuration.general().debug()) {
                LOG.info("Stopping ticket sell for lottery #{}.", (Object)Lottery.this.getId());
            }
            Lottery.this._isSellingTickets = false;
            Broadcast.toAllOnlinePlayers(SystemMessage.getSystemMessage(SystemMessageId.LOTTERY_TICKET_SALES_TEMP_SUSPENDED));
        }
    }
}

