/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSpawnHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AutoSpawnHandler.class);
    private static final int DEFAULT_INITIAL_SPAWN = 30000;
    private static final int DEFAULT_RESPAWN = 3600000;
    private static final int DEFAULT_DESPAWN = 3600000;
    protected Map<Integer, AutoSpawnInstance> _registeredSpawns = new ConcurrentHashMap<Integer, AutoSpawnInstance>();
    protected Map<Integer, ScheduledFuture<?>> _runningSpawns = new ConcurrentHashMap();
    protected boolean _activeState = true;

    protected AutoSpawnHandler() {
        this.restoreSpawnData();
    }

    public void reload() {
        for (ScheduledFuture<?> sf : this._runningSpawns.values()) {
            if (sf == null) continue;
            sf.cancel(true);
        }
        for (AutoSpawnInstance asi : this._registeredSpawns.values()) {
            if (asi == null) continue;
            this.removeSpawn(asi);
        }
        this._registeredSpawns.clear();
        this._runningSpawns.clear();
        this.restoreSpawnData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreSpawnData() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM random_spawn ORDER BY groupId");
             PreparedStatement ps = con.prepareStatement("SELECT * FROM random_spawn_loc WHERE groupId=?");){
            while (rs.next()) {
                AutoSpawnInstance spawnInst = this.registerSpawn(rs.getInt("npcId"), rs.getInt("initialDelay"), rs.getInt("respawnDelay"), rs.getInt("despawnDelay"));
                spawnInst.setSpawnCount(rs.getInt("count"));
                spawnInst.setBroadcast(rs.getBoolean("broadcastSpawn"));
                spawnInst.setRandomSpawn(rs.getBoolean("randomSpawn"));
                ps.setInt(1, rs.getInt("groupId"));
                ResultSet rs2 = ps.executeQuery();
                try {
                    ps.clearParameters();
                    while (rs2.next()) {
                        spawnInst.addSpawnLocation(rs2.getInt("x"), rs2.getInt("y"), rs2.getInt("z"), rs2.getInt("heading"));
                    }
                }
                finally {
                    if (rs2 == null) continue;
                    rs2.close();
                }
            }
            LOG.info("Loaded {} handlers.", (Object)this._registeredSpawns.size());
            return;
        }
        catch (Exception ex) {
            LOG.warn("Could not restore spawn data!", ex);
        }
    }

    public AutoSpawnInstance registerSpawn(int npcId, int[][] spawnPoints, int initialDelay, int respawnDelay, int despawnDelay) {
        int objectId;
        if (initialDelay < 0) {
            initialDelay = 30000;
        }
        if (respawnDelay < 0) {
            respawnDelay = 3600000;
        }
        if (despawnDelay < 0) {
            despawnDelay = 3600000;
        }
        AutoSpawnInstance newSpawn = new AutoSpawnInstance(npcId, initialDelay, respawnDelay, despawnDelay);
        if (spawnPoints != null) {
            for (int[] spawnPoint : spawnPoints) {
                newSpawn.addSpawnLocation(spawnPoint);
            }
        }
        newSpawn._objectId = objectId = IdFactory.getInstance().getNextId();
        this._registeredSpawns.put(objectId, newSpawn);
        this.setSpawnActive(newSpawn, true);
        return newSpawn;
    }

    public AutoSpawnInstance registerSpawn(int npcId, int initialDelay, int respawnDelay, int despawnDelay) {
        return this.registerSpawn(npcId, null, initialDelay, respawnDelay, despawnDelay);
    }

    public boolean removeSpawn(AutoSpawnInstance spawnInst) {
        if (!this.isSpawnRegistered(spawnInst)) {
            return false;
        }
        try {
            this._registeredSpawns.remove(spawnInst.getId());
            ScheduledFuture<?> respawnTask = this._runningSpawns.remove(spawnInst._objectId);
            respawnTask.cancel(false);
        }
        catch (Exception ex) {
            LOG.warn("Could not auto spawn for NPC Id {} (Object Id={})!", spawnInst._npcId, spawnInst._objectId, ex);
            return false;
        }
        return true;
    }

    public void removeSpawn(int objectId) {
        this.removeSpawn(this._registeredSpawns.get(objectId));
    }

    public void setSpawnActive(AutoSpawnInstance spawnInst, boolean isActive) {
        if (spawnInst == null) {
            return;
        }
        int objectId = spawnInst._objectId;
        if (this.isSpawnRegistered(objectId)) {
            if (isActive) {
                AutoSpawner rs = new AutoSpawner(objectId);
                ScheduledFuture<?> spawnTask = spawnInst._desDelay > 0 ? ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(rs, spawnInst._initDelay, spawnInst._resDelay) : ThreadPoolManager.getInstance().scheduleEffect(rs, spawnInst._initDelay);
                this._runningSpawns.put(objectId, spawnTask);
            } else {
                AutoDespawner rd = new AutoDespawner(objectId);
                ScheduledFuture<?> spawnTask = this._runningSpawns.remove(objectId);
                if (spawnTask != null) {
                    spawnTask.cancel(false);
                }
                ThreadPoolManager.getInstance().scheduleEffect(rd, 0L);
            }
            spawnInst.setSpawnActive(isActive);
        }
    }

    public void setAllActive(boolean isActive) {
        if (this._activeState == isActive) {
            return;
        }
        for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
            this.setSpawnActive(spawnInst, isActive);
        }
        this._activeState = isActive;
    }

    public final long getTimeToNextSpawn(AutoSpawnInstance spawnInst) {
        int objectId = spawnInst.getObjectId();
        if (!this.isSpawnRegistered(objectId)) {
            return -1L;
        }
        return this._runningSpawns.containsKey(objectId) ? this._runningSpawns.get(objectId).getDelay(TimeUnit.MILLISECONDS) : 0L;
    }

    public final AutoSpawnInstance getAutoSpawnInstance(int id, boolean isObjectId) {
        if (isObjectId) {
            if (this.isSpawnRegistered(id)) {
                return this._registeredSpawns.get(id);
            }
        } else {
            for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
                if (spawnInst.getId() != id) continue;
                return spawnInst;
            }
        }
        return null;
    }

    public List<AutoSpawnInstance> getAutoSpawnInstances(int npcId) {
        LinkedList<AutoSpawnInstance> result = new LinkedList<AutoSpawnInstance>();
        for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
            if (spawnInst.getId() != npcId) continue;
            result.add(spawnInst);
        }
        return result;
    }

    public final boolean isSpawnRegistered(int objectId) {
        return this._registeredSpawns.containsKey(objectId);
    }

    public final boolean isSpawnRegistered(AutoSpawnInstance spawnInst) {
        return this._registeredSpawns.containsValue(spawnInst);
    }

    public static AutoSpawnHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static class AutoSpawnInstance
    implements IIdentifiable {
        protected int _objectId;
        protected int _spawnIndex;
        protected int _npcId;
        protected int _initDelay;
        protected int _resDelay;
        protected int _desDelay;
        protected int _spawnCount = 1;
        protected int _lastLocIndex = -1;
        private final Queue<L2Npc> _npcList = new ConcurrentLinkedQueue<L2Npc>();
        private final List<Location> _locList = new CopyOnWriteArrayList<Location>();
        private boolean _spawnActive;
        private boolean _randomSpawn = false;
        private boolean _broadcastAnnouncement = false;

        protected AutoSpawnInstance(int npcId, int initDelay, int respawnDelay, int despawnDelay) {
            this._npcId = npcId;
            this._initDelay = initDelay;
            this._resDelay = respawnDelay;
            this._desDelay = despawnDelay;
        }

        protected void setSpawnActive(boolean activeValue) {
            this._spawnActive = activeValue;
        }

        protected boolean addNpcInstance(L2Npc npcInst) {
            return this._npcList.add(npcInst);
        }

        protected boolean removeNpcInstance(L2Npc npcInst) {
            return this._npcList.remove(npcInst);
        }

        public int getObjectId() {
            return this._objectId;
        }

        public int getInitialDelay() {
            return this._initDelay;
        }

        public int getRespawnDelay() {
            return this._resDelay;
        }

        public int getDespawnDelay() {
            return this._desDelay;
        }

        @Override
        public int getId() {
            return this._npcId;
        }

        public int getSpawnCount() {
            return this._spawnCount;
        }

        public Location[] getLocationList() {
            return this._locList.toArray(new Location[this._locList.size()]);
        }

        public Queue<L2Npc> getNPCInstanceList() {
            return this._npcList;
        }

        public List<L2Spawn> getSpawns() {
            ArrayList<L2Spawn> npcSpawns = new ArrayList<L2Spawn>();
            for (L2Npc npcInst : this._npcList) {
                npcSpawns.add(npcInst.getSpawn());
            }
            return npcSpawns;
        }

        public void setSpawnCount(int spawnCount) {
            this._spawnCount = spawnCount;
        }

        public void setRandomSpawn(boolean randValue) {
            this._randomSpawn = randValue;
        }

        public void setBroadcast(boolean broadcastValue) {
            this._broadcastAnnouncement = broadcastValue;
        }

        public boolean isSpawnActive() {
            return this._spawnActive;
        }

        public boolean isRandomSpawn() {
            return this._randomSpawn;
        }

        public boolean isBroadcasting() {
            return this._broadcastAnnouncement;
        }

        public boolean addSpawnLocation(int x, int y, int z, int heading) {
            return this._locList.add(new Location(x, y, z, heading));
        }

        public boolean addSpawnLocation(int[] spawnLoc) {
            if (spawnLoc.length != 3) {
                return false;
            }
            return this.addSpawnLocation(spawnLoc[0], spawnLoc[1], spawnLoc[2], -1);
        }

        public Location removeSpawnLocation(int locIndex) {
            try {
                return this._locList.remove(locIndex);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
    }

    private class AutoSpawner
    implements Runnable {
        private final int _objectId;

        protected AutoSpawner(int objectId) {
            this._objectId = objectId;
        }

        @Override
        public void run() {
            try {
                AutoSpawnInstance spawnInst = AutoSpawnHandler.this._registeredSpawns.get(this._objectId);
                if (!spawnInst.isSpawnActive()) {
                    return;
                }
                Location[] locationList = spawnInst.getLocationList();
                if (locationList.length == 0) {
                    LOG.warn("No location co-ords specified for spawn instance (Object Id={}).", (Object)this._objectId);
                    return;
                }
                int locationCount = locationList.length;
                int locationIndex = Rnd.nextInt((int)locationCount);
                if (!spawnInst.isRandomSpawn()) {
                    locationIndex = spawnInst._lastLocIndex + 1;
                    if (locationIndex == locationCount) {
                        locationIndex = 0;
                    }
                    spawnInst._lastLocIndex = locationIndex;
                }
                int x = locationList[locationIndex].getX();
                int y = locationList[locationIndex].getY();
                int z = locationList[locationIndex].getZ();
                int heading = locationList[locationIndex].getHeading();
                L2Spawn newSpawn = new L2Spawn(spawnInst.getId());
                newSpawn.setX(x);
                newSpawn.setY(y);
                newSpawn.setZ(z);
                if (heading != -1) {
                    newSpawn.setHeading(heading);
                }
                newSpawn.setAmount(spawnInst.getSpawnCount());
                if (spawnInst._desDelay == 0) {
                    newSpawn.setRespawnDelay(spawnInst._resDelay);
                }
                SpawnTable.getInstance().addNewSpawn(newSpawn, false);
                L2Npc npcInst = null;
                if (spawnInst._spawnCount == 1) {
                    npcInst = newSpawn.doSpawn();
                    npcInst.setXYZ(npcInst.getX(), npcInst.getY(), npcInst.getZ());
                    spawnInst.addNpcInstance(npcInst);
                } else {
                    for (int i = 0; i < spawnInst._spawnCount; ++i) {
                        npcInst = newSpawn.doSpawn();
                        npcInst.setXYZ(npcInst.getX() + Rnd.nextInt((int)50), npcInst.getY() + Rnd.nextInt((int)50), npcInst.getZ());
                        spawnInst.addNpcInstance(npcInst);
                    }
                }
                if (npcInst != null) {
                    String nearestTown = MapRegionManager.getInstance().getClosestTownName(npcInst);
                    if (spawnInst.isBroadcasting()) {
                        Broadcast.toAllOnlinePlayers("The " + npcInst.getName() + " has spawned near " + nearestTown + "!");
                    }
                }
                if (spawnInst.getDespawnDelay() > 0) {
                    AutoDespawner rd = new AutoDespawner(this._objectId);
                    ThreadPoolManager.getInstance().scheduleAi(rd, spawnInst.getDespawnDelay() - 1000);
                }
            }
            catch (Exception ex) {
                LOG.warn("An error occurred while initializing spawn instance (Object Id={})!", (Object)this._objectId, (Object)ex);
            }
        }
    }

    private class AutoDespawner
    implements Runnable {
        private final int _objectId;

        protected AutoDespawner(int objectId) {
            this._objectId = objectId;
        }

        @Override
        public void run() {
            try {
                AutoSpawnInstance spawnInst = AutoSpawnHandler.this._registeredSpawns.get(this._objectId);
                if (spawnInst == null) {
                    LOG.warn("No spawn registered for object Id={}!", (Object)this._objectId);
                    return;
                }
                for (L2Npc npcInst : spawnInst.getNPCInstanceList()) {
                    npcInst.deleteMe();
                    SpawnTable.getInstance().deleteSpawn(npcInst.getSpawn(), false);
                    spawnInst.removeNpcInstance(npcInst);
                }
            }
            catch (Exception ex) {
                LOG.warn("An error occurred while despawning spawn (Object Id={})!", (Object)this._objectId, (Object)ex);
            }
        }
    }

    private static class SingletonHolder {
        protected static final AutoSpawnHandler INSTANCE = new AutoSpawnHandler();

        private SingletonHolder() {
        }
    }
}

