/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.AbnormalStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadSpelledInfo;
import com.l2jserver.gameserver.network.serverpackets.PartySpelled;
import com.l2jserver.gameserver.network.serverpackets.ShortBuffStatusUpdate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CharEffectList {
    private static final Logger LOG = LoggerFactory.getLogger(CharEffectList.class);
    private volatile Queue<BuffInfo> _buffs;
    private volatile Queue<BuffInfo> _triggered;
    private volatile Queue<BuffInfo> _dances;
    private volatile Queue<BuffInfo> _toggles;
    private volatile Queue<BuffInfo> _debuffs;
    private volatile Queue<BuffInfo> _passives;
    private volatile Map<AbnormalType, BuffInfo> _stackedEffects;
    private volatile Set<AbnormalType> _blockedBuffSlots = null;
    private BuffInfo _shortBuff = null;
    private volatile boolean _hasBuffsRemovedOnAnyAction = false;
    private volatile boolean _hasBuffsRemovedOnDamage = false;
    private volatile boolean _hasDebuffsRemovedOnDamage = false;
    private int _effectFlags;
    private boolean _partyOnly = false;
    private final L2Character _owner;
    private final AtomicInteger _hiddenBuffs = new AtomicInteger();

    public CharEffectList(L2Character owner) {
        this._owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<BuffInfo> getBuffs() {
        if (this._buffs == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._buffs == null) {
                    this._buffs = new ConcurrentLinkedQueue<BuffInfo>();
                }
            }
        }
        return this._buffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<BuffInfo> getTriggered() {
        if (this._triggered == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._triggered == null) {
                    this._triggered = new ConcurrentLinkedQueue<BuffInfo>();
                }
            }
        }
        return this._triggered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<BuffInfo> getDances() {
        if (this._dances == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._dances == null) {
                    this._dances = new ConcurrentLinkedQueue<BuffInfo>();
                }
            }
        }
        return this._dances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<BuffInfo> getToggles() {
        if (this._toggles == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._toggles == null) {
                    this._toggles = new ConcurrentLinkedQueue<BuffInfo>();
                }
            }
        }
        return this._toggles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<BuffInfo> getDebuffs() {
        if (this._debuffs == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._debuffs == null) {
                    this._debuffs = new ConcurrentLinkedQueue<BuffInfo>();
                }
            }
        }
        return this._debuffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<BuffInfo> getPassives() {
        if (this._passives == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._passives == null) {
                    this._passives = new ConcurrentLinkedQueue<BuffInfo>();
                }
            }
        }
        return this._passives;
    }

    public List<BuffInfo> getEffects() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BuffInfo> buffs = new ArrayList<BuffInfo>();
        if (this.hasBuffs()) {
            buffs.addAll(this.getBuffs());
        }
        if (this.hasTriggered()) {
            buffs.addAll(this.getTriggered());
        }
        if (this.hasDances()) {
            buffs.addAll(this.getDances());
        }
        if (this.hasToggles()) {
            buffs.addAll(this.getToggles());
        }
        if (this.hasDebuffs()) {
            buffs.addAll(this.getDebuffs());
        }
        return buffs;
    }

    private Queue<BuffInfo> getEffectList(Skill skill) {
        if (skill == null) {
            return null;
        }
        Queue<BuffInfo> effects = skill.isPassive() ? this.getPassives() : (skill.isDebuff() ? this.getDebuffs() : (skill.isTrigger() ? this.getTriggered() : (skill.isDance() ? this.getDances() : (skill.isToggle() ? this.getToggles() : this.getBuffs()))));
        return effects;
    }

    public BuffInfo getFirstEffect(L2EffectType type) {
        if (this.hasBuffs()) {
            for (BuffInfo info : this.getBuffs()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this.getTriggered()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this.getDances()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this.getToggles()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this.getDebuffs()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public boolean isAffectedBySkill(int skillId) {
        return this.getBuffInfoBySkillId(skillId) != null;
    }

    public BuffInfo getBuffInfoBySkillId(int skillId) {
        BuffInfo info = null;
        if (this.hasBuffs()) {
            info = this.getBuffs().stream().filter(b -> b.getSkill().getId() == skillId).findFirst().orElse(null);
        }
        if (this.hasTriggered() && info == null) {
            info = this.getTriggered().stream().filter(b -> b.getSkill().getId() == skillId).findFirst().orElse(null);
        }
        if (this.hasDances() && info == null) {
            info = this.getDances().stream().filter(b -> b.getSkill().getId() == skillId).findFirst().orElse(null);
        }
        if (this.hasToggles() && info == null) {
            info = this.getToggles().stream().filter(b -> b.getSkill().getId() == skillId).findFirst().orElse(null);
        }
        if (this.hasDebuffs() && info == null) {
            info = this.getDebuffs().stream().filter(b -> b.getSkill().getId() == skillId).findFirst().orElse(null);
        }
        if (this.hasPassives() && info == null) {
            info = this.getPassives().stream().filter(b -> b.getSkill().getId() == skillId).findFirst().orElse(null);
        }
        return info;
    }

    public BuffInfo getBuffInfoByAbnormalType(AbnormalType type) {
        return this._stackedEffects != null ? this._stackedEffects.get((Object)type) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockedBuffSlots(Set<AbnormalType> blockedBuffSlots) {
        if (this._blockedBuffSlots == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._blockedBuffSlots == null) {
                    this._blockedBuffSlots = ConcurrentHashMap.newKeySet(blockedBuffSlots.size());
                }
            }
        }
        this._blockedBuffSlots.addAll(blockedBuffSlots);
    }

    public boolean removeBlockedBuffSlots(Set<AbnormalType> blockedBuffSlots) {
        if (this._blockedBuffSlots != null) {
            return this._blockedBuffSlots.removeAll(blockedBuffSlots);
        }
        return false;
    }

    public Set<AbnormalType> getAllBlockedBuffSlots() {
        return this._blockedBuffSlots;
    }

    public BuffInfo getShortBuff() {
        return this._shortBuff;
    }

    public void shortBuffStatusUpdate(BuffInfo info) {
        if (this._owner.isPlayer()) {
            this._shortBuff = info;
            if (info == null) {
                this._owner.sendPacket(ShortBuffStatusUpdate.RESET_SHORT_BUFF);
            } else {
                this._owner.sendPacket(new ShortBuffStatusUpdate(info.getSkill().getId(), info.getSkill().getLevel(), info.getTime()));
            }
        }
    }

    private boolean doesStack(Skill skill) {
        AbnormalType type = skill.getAbnormalType();
        if (type.isNone() || this.isEmpty()) {
            return false;
        }
        Queue<BuffInfo> effects = this.getEffectList(skill);
        for (BuffInfo info : effects) {
            if (info == null || info.getSkill().getAbnormalType() != type) continue;
            return true;
        }
        return false;
    }

    public int getBuffCount() {
        return this.hasBuffs() ? this.getBuffs().size() - this._hiddenBuffs.get() - (this.getShortBuff() != null ? 1 : 0) : 0;
    }

    public int getDanceCount() {
        return this.hasDances() ? this.getDances().size() : 0;
    }

    public int getTriggeredBuffCount() {
        return this.hasTriggered() ? this.getTriggered().size() : 0;
    }

    public int getHiddenBuffsCount() {
        return this._hiddenBuffs.get();
    }

    protected void stopAndRemove(BuffInfo info) {
        this.stopAndRemove(true, info, this.getEffectList(info.getSkill()));
    }

    protected void stopAndRemove(BuffInfo info, Queue<BuffInfo> effects) {
        this.stopAndRemove(true, info, effects);
    }

    private void stopAndRemove(boolean removed, BuffInfo info, Queue<BuffInfo> buffs) {
        if (info == null) {
            return;
        }
        buffs.remove(info);
        info.stopAllEffects(removed);
        if (!info.isInUse()) {
            this._hiddenBuffs.decrementAndGet();
        } else if (this._stackedEffects != null) {
            this._stackedEffects.remove((Object)info.getSkill().getAbnormalType());
        }
        if (info.getSkill().isAbnormalInstant() && this.hasBuffs()) {
            for (BuffInfo buff : this.getBuffs()) {
                if (buff == null || buff.getSkill().getAbnormalType() != info.getSkill().getAbnormalType() || buff.isInUse()) continue;
                buff.setInUse(true);
                buff.addStats();
                if (this._stackedEffects != null) {
                    this._stackedEffects.put(buff.getSkill().getAbnormalType(), buff);
                }
                this._hiddenBuffs.decrementAndGet();
                break;
            }
        }
        if (!removed) {
            info.getSkill().applyEffectScope(EffectScope.END, info, true, false);
        }
    }

    public void stopAllEffects() {
        this.stopAllBuffs(false, true);
        this.stopAllDances(false);
        this.stopAllToggles(false);
        this.stopAllDebuffs(false);
        if (this._stackedEffects != null) {
            this._stackedEffects.clear();
        }
        this.updateEffectList(true);
    }

    public void stopAllEffectsExceptThoseThatLastThroughDeath() {
        boolean update = false;
        if (this.hasBuffs()) {
            this.getBuffs().stream().filter(info -> !info.getSkill().isStayAfterDeath()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getBuffs()));
            update = true;
        }
        if (this.hasTriggered()) {
            this.getTriggered().stream().filter(info -> !info.getSkill().isStayAfterDeath()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getTriggered()));
            update = true;
        }
        if (this.hasDebuffs()) {
            this.getDebuffs().stream().filter(info -> !info.getSkill().isStayAfterDeath()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDebuffs()));
            update = true;
        }
        if (this.hasDances()) {
            this.getDances().stream().filter(info -> !info.getSkill().isStayAfterDeath()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDances()));
            update = true;
        }
        if (this.hasToggles()) {
            this.getToggles().stream().filter(info -> !info.getSkill().isStayAfterDeath()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getToggles()));
            update = true;
        }
        this.updateEffectList(update);
    }

    public void stopAllEffectsNotStayOnSubclassChange() {
        boolean update = false;
        if (this.hasBuffs()) {
            this.getBuffs().stream().filter(info -> !info.getSkill().isStayOnSubclassChange()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getBuffs()));
            update = true;
        }
        if (this.hasTriggered()) {
            this.getTriggered().stream().filter(info -> !info.getSkill().isStayOnSubclassChange()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getTriggered()));
            update = true;
        }
        if (this.hasDebuffs()) {
            this.getDebuffs().stream().filter(info -> !info.getSkill().isStayOnSubclassChange()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDebuffs()));
            update = true;
        }
        if (this.hasDances()) {
            this.getDances().stream().filter(info -> !info.getSkill().isStayOnSubclassChange()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDances()));
            update = true;
        }
        if (this.hasToggles()) {
            this.getToggles().stream().filter(info -> !info.getSkill().isStayOnSubclassChange()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getToggles()));
            update = true;
        }
        this.updateEffectList(update);
    }

    public void stopAllBuffs(boolean update, boolean triggered) {
        if (this.hasBuffs()) {
            this.getBuffs().forEach(b -> this.stopAndRemove((BuffInfo)b, this.getBuffs()));
        }
        if (triggered && this.hasTriggered()) {
            this.getTriggered().forEach(b -> this.stopAndRemove((BuffInfo)b, this.getTriggered()));
        }
        this.updateEffectList(update);
    }

    public void stopAllToggles() {
        this.stopAllToggles(true);
    }

    public void stopAllToggles(boolean update) {
        if (this.hasToggles()) {
            this.getToggles().forEach(b -> this.stopAndRemove((BuffInfo)b, this.getToggles()));
            this.updateEffectList(update);
        }
    }

    public void stopAllDances(boolean update) {
        if (this.hasDances()) {
            this.getDances().forEach(b -> this.stopAndRemove((BuffInfo)b, this.getDances()));
            this.updateEffectList(update);
        }
    }

    public void stopAllDebuffs(boolean update) {
        if (this.hasDebuffs()) {
            this.getDebuffs().forEach(b -> this.stopAndRemove((BuffInfo)b, this.getDebuffs()));
            this.updateEffectList(update);
        }
    }

    public void stopEffects(L2EffectType type) {
        boolean update = false;
        Consumer<BuffInfo> action = info -> {
            if (info.getEffects().stream().anyMatch(effect -> effect != null && effect.getEffectType() == type)) {
                this.stopAndRemove((BuffInfo)info);
            }
        };
        if (this.hasBuffs()) {
            this.getBuffs().stream().filter(Objects::nonNull).forEach(action);
            update = true;
        }
        if (this.hasTriggered()) {
            this.getTriggered().stream().filter(Objects::nonNull).forEach(action);
            update = true;
        }
        if (this.hasDances()) {
            this.getDances().stream().filter(Objects::nonNull).forEach(action);
            update = true;
        }
        if (this.hasToggles()) {
            this.getToggles().stream().filter(Objects::nonNull).forEach(action);
            update = true;
        }
        if (this.hasDebuffs()) {
            this.getDebuffs().stream().filter(Objects::nonNull).forEach(action);
            update = true;
        }
        this.updateEffectList(update);
    }

    public void stopSkillEffects(boolean removed, int skillId) {
        BuffInfo info = this.getBuffInfoBySkillId(skillId);
        if (info != null) {
            this.remove(removed, info);
        }
    }

    public void stopSkillEffects(boolean removed, Skill skill) {
        if (skill != null) {
            this.stopSkillEffects(removed, skill.getId());
        }
    }

    public boolean stopSkillEffects(boolean removed, AbnormalType type) {
        BuffInfo old;
        if (this._stackedEffects != null && (old = this._stackedEffects.remove((Object)type)) != null) {
            this.stopSkillEffects(removed, old.getSkill());
            return true;
        }
        return false;
    }

    public void stopEffectsOnAction() {
        if (this._hasBuffsRemovedOnAnyAction) {
            boolean update = false;
            if (this.hasBuffs()) {
                this.getBuffs().stream().filter(info -> info.getSkill().isRemovedOnAnyActionExceptMove()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getBuffs()));
                update = true;
            }
            if (this.hasTriggered()) {
                this.getTriggered().stream().filter(info -> info.getSkill().isRemovedOnAnyActionExceptMove()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getTriggered()));
                update = true;
            }
            if (this.hasDebuffs()) {
                this.getDebuffs().stream().filter(info -> info.getSkill().isRemovedOnAnyActionExceptMove()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDebuffs()));
                update = true;
            }
            if (this.hasDances()) {
                this.getDances().stream().filter(info -> info.getSkill().isRemovedOnAnyActionExceptMove()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDances()));
                update = true;
            }
            if (this.hasToggles()) {
                this.getToggles().stream().filter(info -> info.getSkill().isRemovedOnAnyActionExceptMove()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getToggles()));
                update = true;
            }
            this.updateEffectList(update);
        }
    }

    public void stopEffectsOnDamage(boolean awake) {
        if (awake) {
            boolean update = false;
            if (this._hasBuffsRemovedOnDamage) {
                if (this.hasBuffs()) {
                    this.getBuffs().stream().filter(Objects::nonNull).filter(info -> info.getSkill().isRemovedOnDamage()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getBuffs()));
                    update = true;
                }
                if (this.hasTriggered()) {
                    this.getTriggered().stream().filter(Objects::nonNull).filter(info -> info.getSkill().isRemovedOnDamage()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getTriggered()));
                    update = true;
                }
                if (this.hasDances()) {
                    this.getDances().stream().filter(Objects::nonNull).filter(info -> info.getSkill().isRemovedOnDamage()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDances()));
                    update = true;
                }
                if (this.hasToggles()) {
                    this.getToggles().stream().filter(Objects::nonNull).filter(info -> info.getSkill().isRemovedOnDamage()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getToggles()));
                    update = true;
                }
            }
            if (this._hasDebuffsRemovedOnDamage && this.hasDebuffs()) {
                this.getDebuffs().stream().filter(Objects::nonNull).filter(info -> info.getSkill().isRemovedOnDamage()).forEach(info -> this.stopAndRemove((BuffInfo)info, this.getDebuffs()));
                update = true;
            }
            this.updateEffectList(update);
        }
    }

    public void updateEffectIcons(boolean partyOnly) {
        if (partyOnly) {
            this._partyOnly = true;
        }
        this.updateEffectList(true);
    }

    public boolean isEmpty() {
        return !this.hasBuffs() && !this.hasTriggered() && !this.hasDances() && !this.hasDebuffs() && !this.hasToggles();
    }

    public boolean hasBuffs() {
        return this._buffs != null && !this._buffs.isEmpty();
    }

    public boolean hasTriggered() {
        return this._triggered != null && !this._triggered.isEmpty();
    }

    public boolean hasDances() {
        return this._dances != null && !this._dances.isEmpty();
    }

    public boolean hasToggles() {
        return this._toggles != null && !this._toggles.isEmpty();
    }

    public boolean hasDebuffs() {
        return this._debuffs != null && !this._debuffs.isEmpty();
    }

    public boolean hasPassives() {
        return this._passives != null && !this._passives.isEmpty();
    }

    public void forEach(Function<BuffInfo, Boolean> function, boolean dances) {
        boolean update = false;
        if (this.hasBuffs()) {
            for (BuffInfo info : this.getBuffs()) {
                update |= function.apply(info).booleanValue();
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this.getTriggered()) {
                update |= function.apply(info).booleanValue();
            }
        }
        if (dances && this.hasDances()) {
            for (BuffInfo info : this.getDances()) {
                update |= function.apply(info).booleanValue();
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this.getToggles()) {
                update |= function.apply(info).booleanValue();
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this.getDebuffs()) {
                update |= function.apply(info).booleanValue();
            }
        }
        this.updateEffectList(update);
    }

    public void remove(boolean removed, BuffInfo info) {
        if (info == null) {
            return;
        }
        this.stopAndRemove(removed, info, this.getEffectList(info.getSkill()));
        this.updateEffectList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BuffInfo info) {
        if (info == null) {
            return;
        }
        Skill skill = info.getSkill();
        if (this._blockedBuffSlots != null && this._blockedBuffSlots.contains((Object)skill.getAbnormalType())) {
            return;
        }
        if (skill.isPassive()) {
            if (!skill.getAbnormalType().isNone()) {
                LOG.warn("Passive {} with abnormal type: {}!", (Object)skill, (Object)skill.getAbnormalType());
            }
            if (!skill.checkCondition(info.getEffector(), info.getEffected(), false)) {
                return;
            }
            this.getPassives().stream().filter(b -> b.getSkill().getId() == skill.getId()).forEach(b -> {
                b.setInUse(false);
                b.removeStats();
                this.getPassives().remove(b);
            });
            this.getPassives().add(info);
            info.initializeEffects();
            return;
        }
        if (info.getEffected().isDead() && info.getEffector() != info.getEffector()) {
            return;
        }
        if (skill.getAbnormalType().isNone()) {
            this.stopSkillEffects(true, skill);
        } else {
            if (this._stackedEffects == null) {
                CharEffectList charEffectList = this;
                synchronized (charEffectList) {
                    if (this._stackedEffects == null) {
                        this._stackedEffects = new ConcurrentHashMap<AbnormalType, BuffInfo>();
                    }
                }
            }
            if (this._stackedEffects.containsKey((Object)skill.getAbnormalType())) {
                BuffInfo stackedInfo = this._stackedEffects.get((Object)skill.getAbnormalType());
                if (stackedInfo != null && skill.getAbnormalLvl() >= stackedInfo.getSkill().getAbnormalLvl()) {
                    if (skill.isAbnormalInstant()) {
                        if (stackedInfo.getSkill().isAbnormalInstant()) {
                            this.stopSkillEffects(true, skill.getAbnormalType());
                            stackedInfo = this._stackedEffects.get((Object)skill.getAbnormalType());
                        }
                        if (stackedInfo != null) {
                            stackedInfo.setInUse(false);
                            stackedInfo.removeStats();
                            this._hiddenBuffs.incrementAndGet();
                        }
                    } else {
                        if (stackedInfo.getSkill().isAbnormalInstant()) {
                            this.stopSkillEffects(true, skill.getAbnormalType());
                        }
                        this.stopSkillEffects(true, skill.getAbnormalType());
                    }
                } else {
                    return;
                }
            }
            this._stackedEffects.put(skill.getAbnormalType(), info);
        }
        Queue<BuffInfo> effects = this.getEffectList(skill);
        if (!(skill.isDebuff() || skill.isToggle() || skill.is7Signs() || this.doesStack(skill))) {
            int buffsToRemove = -1;
            if (skill.isDance()) {
                buffsToRemove = this.getDanceCount() - Configuration.character().getMaxDanceAmount();
            } else if (skill.isTrigger()) {
                buffsToRemove = this.getTriggeredBuffCount() - Configuration.character().getMaxTriggeredBuffAmount();
            } else if (!skill.isHealingPotionSkill()) {
                buffsToRemove = this.getBuffCount() - this._owner.getStat().getMaxBuffCount();
            }
            for (BuffInfo bi : effects) {
                if (buffsToRemove < 0) break;
                if (!bi.isInUse() || bi.getSkill().getAbnormalType() == AbnormalType.SUMMON_CONDITION) continue;
                this.stopAndRemove(bi, effects);
                --buffsToRemove;
            }
        }
        effects.add(info);
        info.initializeEffects();
        this.updateEffectList(true);
    }

    private void updateEffectIcons() {
        OlympiadGameTask game;
        if (this._owner == null) {
            return;
        }
        this.updateEffectFlags();
        if (!this._owner.isPlayable()) {
            return;
        }
        AbnormalStatusUpdate asu = null;
        PartySpelled ps = null;
        PartySpelled psSummon = null;
        ExOlympiadSpelledInfo os = null;
        boolean isSummon = false;
        if (this._owner.isPlayer()) {
            if (this._partyOnly) {
                this._partyOnly = false;
            } else {
                asu = new AbnormalStatusUpdate();
            }
            if (this._owner.isInParty()) {
                ps = new PartySpelled(this._owner);
            }
            if (this._owner.getActingPlayer().isInOlympiadMode() && this._owner.getActingPlayer().isOlympiadStart()) {
                os = new ExOlympiadSpelledInfo(this._owner.getActingPlayer());
            }
        } else if (this._owner.isSummon()) {
            isSummon = true;
            ps = new PartySpelled(this._owner);
            psSummon = new PartySpelled(this._owner);
        }
        if (this.hasBuffs()) {
            for (BuffInfo info : this.getBuffs()) {
                if (info.getSkill().isHealingPotionSkill()) {
                    this.shortBuffStatusUpdate(info);
                    continue;
                }
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this.getTriggered()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this.getDances()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this.getToggles()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this.getDebuffs()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (asu != null) {
            this._owner.sendPacket(asu);
        }
        if (ps != null) {
            if (this._owner.isSummon()) {
                L2PcInstance summonOwner = ((L2Summon)this._owner).getOwner();
                if (summonOwner != null) {
                    if (summonOwner.isInParty()) {
                        summonOwner.getParty().broadcastToPartyMembers(summonOwner, psSummon);
                    }
                    summonOwner.sendPacket(ps);
                }
            } else if (this._owner.isPlayer() && this._owner.isInParty()) {
                this._owner.getParty().broadcastPacket(ps);
            }
        }
        if (os != null && (game = OlympiadGameManager.getInstance().getOlympiadTask(this._owner.getActingPlayer().getOlympiadGameId())) != null && game.isBattleStarted()) {
            game.getZone().broadcastPacketToObservers(os);
        }
    }

    private void addIcon(BuffInfo info, AbnormalStatusUpdate asu, PartySpelled ps, PartySpelled psSummon, ExOlympiadSpelledInfo os, boolean isSummon) {
        if (info == null || !info.isInUse()) {
            return;
        }
        Skill skill = info.getSkill();
        if (asu != null) {
            asu.addSkill(info);
        }
        if (ps != null && (isSummon || !skill.isToggle())) {
            ps.addSkill(info);
        }
        if (psSummon != null && !skill.isToggle()) {
            psSummon.addSkill(info);
        }
        if (os != null) {
            os.addSkill(info);
        }
    }

    private void updateEffectList(boolean update) {
        if (update) {
            this.updateEffectIcons();
            this.computeEffectFlags();
        }
    }

    private void updateEffectFlags() {
        if (this.hasBuffs()) {
            for (BuffInfo info : this.getBuffs()) {
                if (info == null) continue;
                if (info.getSkill().isRemovedOnAnyActionExceptMove()) {
                    this._hasBuffsRemovedOnAnyAction = true;
                }
                if (!info.getSkill().isRemovedOnDamage()) continue;
                this._hasBuffsRemovedOnDamage = true;
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this.getTriggered()) {
                if (info == null) continue;
                if (info.getSkill().isRemovedOnAnyActionExceptMove()) {
                    this._hasBuffsRemovedOnAnyAction = true;
                }
                if (!info.getSkill().isRemovedOnDamage()) continue;
                this._hasBuffsRemovedOnDamage = true;
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this.getToggles()) {
                if (info == null) continue;
                if (info.getSkill().isRemovedOnAnyActionExceptMove()) {
                    this._hasBuffsRemovedOnAnyAction = true;
                }
                if (!info.getSkill().isRemovedOnDamage()) continue;
                this._hasBuffsRemovedOnDamage = true;
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this.getDebuffs()) {
                if (info == null || !info.getSkill().isRemovedOnDamage()) continue;
                this._hasDebuffsRemovedOnDamage = true;
            }
        }
    }

    private void computeEffectFlags() {
        int flags = 0;
        if (this.hasBuffs()) {
            for (BuffInfo info : this.getBuffs()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this.getTriggered()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this.getDebuffs()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this.getDances()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this.getToggles()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        this._effectFlags = flags;
    }

    public boolean isAffected(EffectFlag flag) {
        return (this._effectFlags & flag.getMask()) != 0;
    }
}

