/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.TransformData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.gameserver.network.serverpackets.ExRedSky;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursedWeapon
implements INamable {
    private static final Logger LOG = LoggerFactory.getLogger(CursedWeapon.class);
    private final String _name;
    private final int _itemId;
    private final int _skillId;
    private final int _skillMaxLevel;
    private int _dropRate;
    private int _duration;
    private int _durationLost;
    private int _disappearChance;
    private int _stageKills;
    private boolean _isDropped = false;
    private boolean _isActivated = false;
    private ScheduledFuture<?> _removeTask;
    private int _nbKills = 0;
    private long _endTime = 0L;
    private int _playerId = 0;
    protected L2PcInstance _player = null;
    private L2ItemInstance _item = null;
    private int _playerKarma = 0;
    private int _playerPkKills = 0;
    private int transformationId = 0;

    public CursedWeapon(int itemId, int skillId, String name) {
        this._name = name;
        this._itemId = itemId;
        this._skillId = skillId;
        this._skillMaxLevel = SkillData.getInstance().getMaxLevel(this._skillId);
    }

    public void endOfLife() {
        if (this._isActivated) {
            if (this._player != null && this._player.isOnline()) {
                LOG.info("{} being removed online.", (Object)this._name);
                this._player.abortAttack();
                this._player.setKarma(this._playerKarma);
                this._player.setPkKills(this._playerPkKills);
                this._player.setCursedWeaponEquippedId(0);
                this.removeSkill();
                this._player.getInventory().unEquipItemInBodySlot(16384);
                this._player.storeMe();
                removedItem = this._player.getInventory().destroyItemByItemId("", this._itemId, 1L, this._player, null);
                if (!Configuration.general().forceInventoryUpdate()) {
                    InventoryUpdate iu = new InventoryUpdate();
                    if (removedItem.getCount() == 0L) {
                        iu.addRemovedItem(removedItem);
                    } else {
                        iu.addModifiedItem(removedItem);
                    }
                    this._player.sendPacket(iu);
                } else {
                    this._player.sendPacket(new ItemList(this._player, true));
                }
                this._player.broadcastUserInfo();
            } else {
                LOG.info("{} being removed offline.", (Object)this._name);
                try (Connection con = ConnectionFactory.getInstance().getConnection();
                     PreparedStatement del = con.prepareStatement("DELETE FROM items WHERE owner_id=? AND item_id=?");
                     PreparedStatement ps = con.prepareStatement("UPDATE characters SET karma=?, pkkills=? WHERE charId=?");){
                    del.setInt(1, this._playerId);
                    del.setInt(2, this._itemId);
                    if (del.executeUpdate() != 1) {
                        LOG.warn("Error while deleting itemId {} from userId {}", (Object)this._itemId, (Object)this._playerId);
                    }
                    ps.setInt(1, this._playerKarma);
                    ps.setInt(2, this._playerPkKills);
                    ps.setInt(3, this._playerId);
                    if (ps.executeUpdate() != 1) {
                        LOG.warn("Error while updating karma & pkkills for userId {}", (Object)this._playerId);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Could not delete : {}", (Object)e.getMessage(), (Object)e);
                }
            }
        } else if (this._player != null && this._player.getInventory().getItemByItemId(this._itemId) != null) {
            removedItem = this._player.getInventory().destroyItemByItemId("", this._itemId, 1L, this._player, null);
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate iu = new InventoryUpdate();
                if (removedItem.getCount() == 0L) {
                    iu.addRemovedItem(removedItem);
                } else {
                    iu.addModifiedItem(removedItem);
                }
                this._player.sendPacket(iu);
            } else {
                this._player.sendPacket(new ItemList(this._player, true));
            }
            this._player.broadcastUserInfo();
        } else if (this._item != null) {
            this._item.decayMe();
            L2World.getInstance().removeObject(this._item);
            LOG.info("{} item has been removed from World.", (Object)this._name);
        }
        CursedWeaponsManager.removeFromDb(this._itemId);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_DISAPPEARED);
        sm.addItemName(this._itemId);
        CursedWeaponsManager.announce(sm);
        this.cancelTask();
        this._isActivated = false;
        this._isDropped = false;
        this._endTime = 0L;
        this._player = null;
        this._playerId = 0;
        this._playerKarma = 0;
        this._playerPkKills = 0;
        this._item = null;
        this._nbKills = 0;
    }

    private void cancelTask() {
        if (this._removeTask != null) {
            this._removeTask.cancel(true);
            this._removeTask = null;
        }
    }

    private void dropIt(L2Attackable attackable, L2PcInstance player) {
        this.dropIt(attackable, player, null, true);
    }

    private void dropIt(L2Attackable attackable, L2PcInstance player, L2Character killer, boolean fromMonster) {
        this._isActivated = false;
        if (fromMonster) {
            this._item = attackable.dropItem(player, this._itemId, 1L);
            this._item.setDropTime(0L);
            ExRedSky packet = new ExRedSky(10);
            Earthquake eq = new Earthquake(player.getX(), player.getY(), player.getZ(), 14, 3);
            Broadcast.toAllOnlinePlayers(packet);
            Broadcast.toAllOnlinePlayers(eq);
        } else {
            this._item = this._player.getInventory().getItemByItemId(this._itemId);
            this._player.dropItem("DieDrop", this._item, killer, true);
            this._player.setKarma(this._playerKarma);
            this._player.setPkKills(this._playerPkKills);
            this._player.setCursedWeaponEquippedId(0);
            this.removeSkill();
            this._player.abortAttack();
        }
        this._isDropped = true;
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_WAS_DROPPED_IN_THE_S1_REGION);
        if (player != null) {
            sm.addZoneName(player.getX(), player.getY(), player.getZ());
        } else if (this._player != null) {
            sm.addZoneName(this._player.getX(), this._player.getY(), this._player.getZ());
        } else {
            sm.addZoneName(killer.getX(), killer.getY(), killer.getZ());
        }
        sm.addItemName(this._itemId);
        CursedWeaponsManager.announce(sm);
    }

    public void cursedOnLogin() {
        this.doTransform();
        this.giveSkill();
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S2_OWNER_HAS_LOGGED_INTO_THE_S1_REGION);
        msg.addZoneName(this._player.getX(), this._player.getY(), this._player.getZ());
        msg.addItemName(this._player.getCursedWeaponEquippedId());
        CursedWeaponsManager.announce(msg);
        CursedWeapon cw = CursedWeaponsManager.getInstance().getCursedWeapon(this._player.getCursedWeaponEquippedId());
        SystemMessage msg2 = SystemMessage.getSystemMessage(SystemMessageId.S2_MINUTE_OF_USAGE_TIME_ARE_LEFT_FOR_S1);
        int timeLeft = (int)(cw.getTimeLeft() / 60000L);
        msg2.addItemName(this._player.getCursedWeaponEquippedId());
        msg2.addInt(timeLeft);
        this._player.sendPacket(msg2);
    }

    public void giveSkill() {
        int level = 1 + this._nbKills / this._stageKills;
        if (level > this._skillMaxLevel) {
            level = this._skillMaxLevel;
        }
        Skill skill = SkillData.getInstance().getSkill(this._skillId, level);
        this._player.addSkill(skill, false);
        this._player.addSkill(CommonSkill.VOID_BURST.getSkill(), false);
        this._player.addTransformSkill(CommonSkill.VOID_BURST.getSkill());
        this._player.addSkill(CommonSkill.VOID_FLOW.getSkill(), false);
        this._player.addTransformSkill(CommonSkill.VOID_FLOW.getSkill());
        this._player.sendSkillList();
    }

    public void doTransform() {
        if (this._itemId == 8689) {
            this.transformationId = 302;
        } else if (this._itemId == 8190) {
            this.transformationId = 301;
        }
        if (this._player.isTransformed() || this._player.isInStance()) {
            this._player.stopTransformation(true);
            ThreadPoolManager.getInstance().scheduleGeneral(() -> TransformData.getInstance().transformPlayer(this.transformationId, this._player), 500L);
        } else {
            TransformData.getInstance().transformPlayer(this.transformationId, this._player);
        }
    }

    public void removeSkill() {
        this._player.removeSkill(this._skillId);
        this._player.removeSkill(CommonSkill.VOID_BURST.getSkill().getId());
        this._player.removeSkill(CommonSkill.VOID_FLOW.getSkill().getId());
        this._player.untransform();
        this._player.sendSkillList();
    }

    public void reActivate() {
        this._isActivated = true;
        if (this._endTime - System.currentTimeMillis() <= 0L) {
            this.endOfLife();
        } else {
            this._removeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RemoveTask(), (long)this._durationLost * 12000L, (long)this._durationLost * 12000L);
        }
    }

    public boolean checkDrop(L2Attackable attackable, L2PcInstance player) {
        if (Rnd.get((int)100000) < this._dropRate) {
            this.dropIt(attackable, player);
            this._endTime = System.currentTimeMillis() + (long)this._duration * 60000L;
            this._removeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RemoveTask(), (long)this._durationLost * 12000L, (long)this._durationLost * 12000L);
            return true;
        }
        return false;
    }

    public void activate(L2PcInstance player, L2ItemInstance item) {
        if (player.isMounted() && !player.dismount()) {
            player.sendPacket(SystemMessageId.FAILED_TO_PICKUP_S1);
            player.dropItem("InvDrop", item, null, true);
            return;
        }
        this._isActivated = true;
        this._player = player;
        this._playerId = this._player.getObjectId();
        this._playerKarma = this._player.getKarma();
        this._playerPkKills = this._player.getPkKills();
        this.saveData();
        this._player.setCursedWeaponEquippedId(this._itemId);
        this._player.setKarma(9999999);
        this._player.setPkKills(0);
        if (this._player.isInParty()) {
            this._player.getParty().removePartyMember(this._player, L2Party.messageType.Expelled);
        }
        this.doTransform();
        this.giveSkill();
        this._item = item;
        this._player.getInventory().equipItem(this._item);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_EQUIPPED);
        sm.addItemName(this._item);
        this._player.sendPacket(sm);
        this._player.setCurrentHpMp(this._player.getMaxHp(), this._player.getMaxMp());
        this._player.setCurrentCp(this._player.getMaxCp());
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItem(this._item);
            this._player.sendPacket(iu);
        } else {
            this._player.sendPacket(new ItemList(this._player, false));
        }
        this._player.broadcastUserInfo();
        SocialAction atk = new SocialAction(this._player.getObjectId(), 17);
        this._player.broadcastPacket(atk);
        sm = SystemMessage.getSystemMessage(SystemMessageId.THE_OWNER_OF_S2_HAS_APPEARED_IN_THE_S1_REGION);
        sm.addZoneName(this._player.getX(), this._player.getY(), this._player.getZ());
        sm.addItemName(this._item);
        CursedWeaponsManager.announce(sm);
    }

    public void saveData() {
        if (Configuration.general().debug()) {
            LOG.info("CursedWeapon: Saving data to disk.");
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement del = con.prepareStatement("DELETE FROM cursed_weapons WHERE itemId = ?");
             PreparedStatement ps = con.prepareStatement("INSERT INTO cursed_weapons (itemId, charId, playerKarma, playerPkKills, nbKills, endTime) VALUES (?, ?, ?, ?, ?, ?)");){
            del.setInt(1, this._itemId);
            del.executeUpdate();
            if (this._isActivated) {
                ps.setInt(1, this._itemId);
                ps.setInt(2, this._playerId);
                ps.setInt(3, this._playerKarma);
                ps.setInt(4, this._playerPkKills);
                ps.setInt(5, this._nbKills);
                ps.setLong(6, this._endTime);
                ps.executeUpdate();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to save data.", e);
        }
    }

    public void dropIt(L2Character killer) {
        if (Rnd.get((int)100) <= this._disappearChance) {
            this.endOfLife();
        } else {
            this.dropIt(null, null, killer, false);
            this._player.setKarma(this._playerKarma);
            this._player.setPkKills(this._playerPkKills);
            this._player.setCursedWeaponEquippedId(0);
            this.removeSkill();
            this._player.abortAttack();
            this._player.broadcastUserInfo();
        }
    }

    public void increaseKills() {
        ++this._nbKills;
        if (this._player != null && this._player.isOnline()) {
            this._player.setPkKills(this._nbKills);
            this._player.sendPacket(new UserInfo(this._player));
            if (this._nbKills % this._stageKills == 0 && this._nbKills <= this._stageKills * (this._skillMaxLevel - 1)) {
                this.giveSkill();
            }
        }
        this._endTime -= (long)this._durationLost * 60000L;
        this.saveData();
    }

    public void setDisappearChance(int disappearChance) {
        this._disappearChance = disappearChance;
    }

    public void setDropRate(int dropRate) {
        this._dropRate = dropRate;
    }

    public void setDuration(int duration) {
        this._duration = duration;
    }

    public void setDurationLost(int durationLost) {
        this._durationLost = durationLost;
    }

    public void setStageKills(int stageKills) {
        this._stageKills = stageKills;
    }

    public void setNbKills(int nbKills) {
        this._nbKills = nbKills;
    }

    public void setPlayerId(int playerId) {
        this._playerId = playerId;
    }

    public void setPlayerKarma(int playerKarma) {
        this._playerKarma = playerKarma;
    }

    public void setPlayerPkKills(int playerPkKills) {
        this._playerPkKills = playerPkKills;
    }

    public void setActivated(boolean isActivated) {
        this._isActivated = isActivated;
    }

    public void setDropped(boolean isDropped) {
        this._isDropped = isDropped;
    }

    public void setEndTime(long endTime) {
        this._endTime = endTime;
    }

    public void setPlayer(L2PcInstance player) {
        this._player = player;
    }

    public void setItem(L2ItemInstance item) {
        this._item = item;
    }

    public boolean isActivated() {
        return this._isActivated;
    }

    public boolean isDropped() {
        return this._isDropped;
    }

    public long getEndTime() {
        return this._endTime;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public int getItemId() {
        return this._itemId;
    }

    public int getSkillId() {
        return this._skillId;
    }

    public int getPlayerId() {
        return this._playerId;
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public int getPlayerKarma() {
        return this._playerKarma;
    }

    public int getPlayerPkKills() {
        return this._playerPkKills;
    }

    public int getNbKills() {
        return this._nbKills;
    }

    public int getStageKills() {
        return this._stageKills;
    }

    public boolean isActive() {
        return this._isActivated || this._isDropped;
    }

    public int getLevel() {
        if (this._nbKills > this._stageKills * this._skillMaxLevel) {
            return this._skillMaxLevel;
        }
        return this._nbKills / this._stageKills;
    }

    public long getTimeLeft() {
        return this._endTime - System.currentTimeMillis();
    }

    public void goTo(L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (this._isActivated && this._player != null) {
            player.teleToLocation((ILocational)this._player.getLocation(), true);
        } else if (this._isDropped && this._item != null) {
            player.teleToLocation((ILocational)this._item.getLocation(), true);
        } else {
            player.sendMessage(this._name + " isn't in the World.");
        }
    }

    public Location getWorldPosition() {
        if (this._isActivated && this._player != null) {
            return this._player.getLocation();
        }
        if (this._isDropped && this._item != null) {
            return this._item.getLocation();
        }
        return null;
    }

    public long getDuration() {
        return this._duration;
    }

    private class RemoveTask
    implements Runnable {
        protected RemoveTask() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() >= CursedWeapon.this.getEndTime()) {
                CursedWeapon.this.endOfLife();
            }
        }
    }
}

