/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public final class DimensionalRiftRoom {
    private final byte _type;
    private final byte _room;
    private final int _xMin;
    private final int _xMax;
    private final int _yMin;
    private final int _yMax;
    private final int _zMin;
    private final int _zMax;
    private final Location _teleportCoords;
    private final Shape _s;
    private final boolean _isBossRoom;
    private final List<L2Spawn> _roomSpawns = new ArrayList<L2Spawn>();
    private L2Party _party = null;

    public DimensionalRiftRoom(byte type, byte room, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, int xT, int yT, int zT, boolean isBossRoom) {
        this._type = type;
        this._room = room;
        this._xMin = xMin + 128;
        this._xMax = xMax - 128;
        this._yMin = yMin + 128;
        this._yMax = yMax - 128;
        this._zMin = zMin;
        this._zMax = zMax;
        this._teleportCoords = new Location(xT, yT, zT);
        this._isBossRoom = isBossRoom;
        this._s = new Polygon(new int[]{xMin, xMax, xMax, xMin}, new int[]{yMin, yMin, yMax, yMax}, 4);
    }

    public byte getType() {
        return this._type;
    }

    public byte getRoom() {
        return this._room;
    }

    public int getRandomX() {
        return Rnd.get((int)this._xMin, (int)this._xMax);
    }

    public int getRandomY() {
        return Rnd.get((int)this._yMin, (int)this._yMax);
    }

    public Location getTeleportCoordinates() {
        return this._teleportCoords;
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this._s.contains(x, y) && z >= this._zMin && z <= this._zMax;
    }

    public boolean isBossRoom() {
        return this._isBossRoom;
    }

    public List<L2Spawn> getSpawns() {
        return this._roomSpawns;
    }

    public void spawn() {
        for (L2Spawn spawn : this._roomSpawns) {
            spawn.doSpawn();
            spawn.startRespawn();
        }
    }

    public DimensionalRiftRoom unspawn() {
        for (L2Spawn spawn : this._roomSpawns) {
            spawn.stopRespawn();
            if (spawn.getLastSpawn() == null) continue;
            spawn.getLastSpawn().deleteMe();
        }
        return this;
    }

    public void setParty(L2Party party) {
        this._party = party;
    }

    public L2Party getParty() {
        return this._party;
    }
}

