/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class L2PetData {
    private final Map<Integer, L2PetLevelData> _levelStats = new HashMap<Integer, L2PetLevelData>();
    private final List<L2PetSkillLearn> _skills = new ArrayList<L2PetSkillLearn>();
    private final int _npcId;
    private final int _itemId;
    private int _hungryLimit = 1;
    private int _minLvl = 127;
    private boolean _syncLevel = false;
    private final List<Integer> _food = new ArrayList<Integer>();

    public L2PetData(int npcId, int itemId) {
        this._npcId = npcId;
        this._itemId = itemId;
    }

    public int getNpcId() {
        return this._npcId;
    }

    public int getItemId() {
        return this._itemId;
    }

    public void addNewStat(int level, L2PetLevelData data) {
        if (this._minLvl > level) {
            this._minLvl = level;
        }
        this._levelStats.put(level, data);
    }

    public L2PetLevelData getPetLevelData(int petLevel) {
        return this._levelStats.get(petLevel);
    }

    public int getHungryLimit() {
        return this._hungryLimit;
    }

    public boolean isSyncLevel() {
        return this._syncLevel;
    }

    public int getMinLevel() {
        return this._minLvl;
    }

    public List<Integer> getFood() {
        return this._food;
    }

    public void addFood(Integer foodId) {
        this._food.add(foodId);
    }

    public void setHungryLimit(int limit) {
        this._hungryLimit = limit;
    }

    public void setSyncLevel(boolean val) {
        this._syncLevel = val;
    }

    public void addNewSkill(int skillId, int skillLvl, int petLvl) {
        this._skills.add(new L2PetSkillLearn(skillId, skillLvl, petLvl));
    }

    public int getAvailableLevel(L2Summon pet, int skillId) {
        StatsSet parameters = pet.getTemplate().getParameters();
        int currentStep = (int)Math.floor((double)pet.getLevel() / 5.0 - 11.0);
        return IntStream.rangeClosed(0, currentStep).map(i -> currentStep - i).mapToObj(step -> IntStream.iterate(1, i -> i + 1).mapToObj(skillNum -> parameters.getObject("step" + step + "_skill0" + skillNum, SkillHolder.class)).takeWhile(Objects::nonNull).filter(skill -> skill.getSkillId() == skillId).findFirst()).filter(Optional::isPresent).map(Optional::get).mapToInt(SkillHolder::getSkillLvl).findFirst().orElse(0);
    }

    public List<L2PetSkillLearn> getAvailableSkills() {
        return this._skills;
    }

    public static final class L2PetSkillLearn
    extends SkillHolder {
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            super(id, lvl);
            this._minLevel = minLvl;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }
}

