/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.L2Item;

public final class L2Seed {
    private final int _seedId;
    private final int _cropId;
    private final int _level;
    private final int _matureId;
    private final int _reward1;
    private final int _reward2;
    private final int _castleId;
    private final boolean _isAlternative;
    private final int _limitSeeds;
    private final int _limitCrops;
    private final int _seedReferencePrice;
    private final int _cropReferencePrice;

    public L2Seed(StatsSet set) {
        this._cropId = set.getInt("id");
        this._seedId = set.getInt("seedId");
        this._level = set.getInt("level");
        this._matureId = set.getInt("mature_Id");
        this._reward1 = set.getInt("reward1");
        this._reward2 = set.getInt("reward2");
        this._castleId = set.getInt("castleId");
        this._isAlternative = set.getBoolean("alternative");
        this._limitCrops = set.getInt("limit_crops");
        this._limitSeeds = set.getInt("limit_seed");
        L2Item item = ItemTable.getInstance().getTemplate(this._cropId);
        this._cropReferencePrice = item != null ? item.getReferencePrice() : 1;
        item = ItemTable.getInstance().getTemplate(this._seedId);
        this._seedReferencePrice = item != null ? item.getReferencePrice() : 1;
    }

    public int getCastleId() {
        return this._castleId;
    }

    public int getSeedId() {
        return this._seedId;
    }

    public int getCropId() {
        return this._cropId;
    }

    public int getMatureId() {
        return this._matureId;
    }

    public int getReward(int type) {
        return type == 1 ? this._reward1 : this._reward2;
    }

    public int getLevel() {
        return this._level;
    }

    public boolean isAlternative() {
        return this._isAlternative;
    }

    public int getSeedLimit() {
        return this._limitSeeds * Configuration.rates().getRateDropManor();
    }

    public int getCropLimit() {
        return this._limitCrops * Configuration.rates().getRateDropManor();
    }

    public int getSeedReferencePrice() {
        return this._seedReferencePrice;
    }

    public int getSeedMaxPrice() {
        return this._seedReferencePrice * 10;
    }

    public int getSeedMinPrice() {
        return (int)((double)this._seedReferencePrice * 0.6);
    }

    public int getCropReferencePrice() {
        return this._cropReferencePrice;
    }

    public int getCropMaxPrice() {
        return this._cropReferencePrice * 10;
    }

    public int getCropMinPrice() {
        return (int)((double)this._cropReferencePrice * 0.6);
    }

    public String toString() {
        return "SeedData [_id=" + this._seedId + ", _level=" + this._level + ", _crop=" + this._cropId + ", _mature=" + this._matureId + ", _type1=" + this._reward1 + ", _type2=" + this._reward2 + ", _manorId=" + this._castleId + ", _isAlternative=" + this._isAlternative + ", _limitSeeds=" + this._limitSeeds + ", _limitCrops=" + this._limitCrops + "]";
    }
}

