/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.enums.MacroType;
import com.l2jserver.gameserver.enums.ShortcutType;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroCmd;
import com.l2jserver.gameserver.model.Shortcut;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IRestorable;
import com.l2jserver.gameserver.network.serverpackets.SendMacroList;
import com.l2jserver.gameserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroList
implements IRestorable {
    private static final Logger LOG = LoggerFactory.getLogger(MacroList.class);
    private final L2PcInstance _owner;
    private int _revision;
    private int _macroId;
    private final Map<Integer, Macro> _macros = Collections.synchronizedMap(new LinkedHashMap());

    public MacroList(L2PcInstance owner) {
        this._owner = owner;
        this._revision = 1;
        this._macroId = 1000;
    }

    public int getRevision() {
        return this._revision;
    }

    public Map<Integer, Macro> getAllMacros() {
        return this._macros;
    }

    public void registerMacro(Macro macro) {
        if (macro.getId() == 0) {
            do {
                macro.setId(this._macroId++);
            } while (this._macros.containsKey(macro.getId()));
            this._macros.put(macro.getId(), macro);
            this.registerMacroInDb(macro);
        } else {
            Macro old = this._macros.put(macro.getId(), macro);
            if (old != null) {
                this.deleteMacroFromDb(old);
            }
            this.registerMacroInDb(macro);
        }
        this.sendUpdate();
    }

    public void deleteMacro(int id) {
        Shortcut[] allShortCuts;
        Macro removed = this._macros.remove(id);
        if (removed != null) {
            this.deleteMacroFromDb(removed);
        }
        for (Shortcut sc : allShortCuts = this._owner.getAllShortCuts()) {
            if (sc.getId() != id || sc.getType() != ShortcutType.MACRO) continue;
            this._owner.deleteShortCut(sc.getSlot(), sc.getPage());
        }
        this.sendUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdate() {
        ++this._revision;
        Collection<Macro> allMacros = this._macros.values();
        Map<Integer, Macro> map = this._macros;
        synchronized (map) {
            if (allMacros.isEmpty()) {
                this._owner.sendPacket(new SendMacroList(this._revision, 0, null));
            } else {
                for (Macro m : allMacros) {
                    this._owner.sendPacket(new SendMacroList(this._revision, allMacros.size(), m));
                }
            }
        }
    }

    private void registerMacroInDb(Macro macro) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO character_macroses (charId,id,icon,name,descr,acronym,commands) values(?,?,?,?,?,?,?)");){
            ps.setInt(1, this._owner.getObjectId());
            ps.setInt(2, macro.getId());
            ps.setInt(3, macro.getIcon());
            ps.setString(4, macro.getName());
            ps.setString(5, macro.getDescr());
            ps.setString(6, macro.getAcronym());
            StringBuilder sb = new StringBuilder(300);
            for (MacroCmd cmd : macro.getCommands()) {
                StringUtil.append(sb, String.valueOf(cmd.getType().ordinal()), ",", String.valueOf(cmd.getD1()), ",", String.valueOf(cmd.getD2()));
                if (cmd.getCmd() != null && !cmd.getCmd().isEmpty()) {
                    StringUtil.append(sb, ",", cmd.getCmd());
                }
                sb.append(';');
            }
            if (sb.length() > 255) {
                sb.setLength(255);
            }
            ps.setString(7, sb.toString());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not store macro:", e);
        }
    }

    private void deleteMacroFromDb(Macro macro) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_macroses WHERE charId=? AND id=?");){
            ps.setInt(1, this._owner.getObjectId());
            ps.setInt(2, macro.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not delete macro:", e);
        }
    }

    @Override
    public boolean restoreMe() {
        this._macros.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT charId, id, icon, name, descr, acronym, commands FROM character_macroses WHERE charId=?");){
            ps.setInt(1, this._owner.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("id");
                    int icon = rs.getInt("icon");
                    String name = rs.getString("name");
                    String descr = rs.getString("descr");
                    String acronym = rs.getString("acronym");
                    ArrayList<MacroCmd> commands = new ArrayList<MacroCmd>();
                    StringTokenizer st1 = new StringTokenizer(rs.getString("commands"), ";");
                    while (st1.hasMoreTokens()) {
                        StringTokenizer st = new StringTokenizer(st1.nextToken(), ",");
                        if (st.countTokens() < 3) continue;
                        MacroType type = MacroType.values()[Integer.parseInt(st.nextToken())];
                        int d1 = Integer.parseInt(st.nextToken());
                        int d2 = Integer.parseInt(st.nextToken());
                        String cmd = "";
                        if (st.hasMoreTokens()) {
                            cmd = st.nextToken();
                        }
                        commands.add(new MacroCmd(commands.size(), type, d1, d2, cmd));
                    }
                    this._macros.put(id, new Macro(id, icon, name, descr, acronym, commands));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not store shortcuts:", e);
            return false;
        }
        return true;
    }
}

