/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.enums.PetitionState;
import com.l2jserver.gameserver.enums.PetitionType;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PetitionVotePacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Petition {
    private final long _submitTime = System.currentTimeMillis();
    private final int _id;
    private final PetitionType _type;
    private PetitionState _state = PetitionState.PENDING;
    private final String _content;
    private final List<CreatureSay> _messageLog = new CopyOnWriteArrayList<CreatureSay>();
    private final L2PcInstance _petitioner;
    private L2PcInstance _responder;

    public Petition(L2PcInstance petitioner, String petitionText, int petitionType) {
        this._id = IdFactory.getInstance().getNextId();
        this._type = PetitionType.values()[--petitionType];
        this._content = petitionText;
        this._petitioner = petitioner;
    }

    public boolean addLogMessage(CreatureSay cs) {
        return this._messageLog.add(cs);
    }

    public List<CreatureSay> getLogMessages() {
        return this._messageLog;
    }

    public boolean endPetitionConsultation(PetitionState endState) {
        this.setState(endState);
        if (this.getResponder() != null && this.getResponder().isOnline()) {
            if (endState == PetitionState.RESPONDER_REJECT) {
                this.getPetitioner().sendMessage("Your petition was rejected. Please try again later.");
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PETITION_ENDED_WITH_C1);
                sm.addString(this.getPetitioner().getName());
                this.getResponder().sendPacket(sm);
                if (endState == PetitionState.PETITIONER_CANCEL) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RECENT_NO_S1_CANCELED);
                    sm.addInt(this.getId());
                    this.getResponder().sendPacket(sm);
                }
            }
        }
        if (this.getPetitioner() != null && this.getPetitioner().isOnline()) {
            this.getPetitioner().sendPacket(SystemMessageId.THIS_END_THE_PETITION_PLEASE_PROVIDE_FEEDBACK);
            this.getPetitioner().sendPacket(PetitionVotePacket.STATIC_PACKET);
        }
        PetitionManager.getInstance().getCompletedPetitions().put(this.getId(), this);
        return PetitionManager.getInstance().getPendingPetitions().remove(this.getId()) != null;
    }

    public String getContent() {
        return this._content;
    }

    public int getId() {
        return this._id;
    }

    public L2PcInstance getPetitioner() {
        return this._petitioner;
    }

    public L2PcInstance getResponder() {
        return this._responder;
    }

    public long getSubmitTime() {
        return this._submitTime;
    }

    public PetitionState getState() {
        return this._state;
    }

    public String getTypeAsString() {
        return this._type.toString().replace("_", " ");
    }

    public void sendPetitionerPacket(L2GameServerPacket responsePacket) {
        if (this.getPetitioner() == null || !this.getPetitioner().isOnline()) {
            return;
        }
        this.getPetitioner().sendPacket(responsePacket);
    }

    public void sendResponderPacket(L2GameServerPacket responsePacket) {
        if (this.getResponder() == null || !this.getResponder().isOnline()) {
            this.endPetitionConsultation(PetitionState.RESPONDER_MISSING);
            return;
        }
        this.getResponder().sendPacket(responsePacket);
    }

    public void setState(PetitionState state) {
        this._state = state;
    }

    public void setResponder(L2PcInstance respondingAdmin) {
        if (this.getResponder() != null) {
            return;
        }
        this._responder = respondingAdmin;
    }
}

