/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2FortSiegeGuardAI;
import com.l2jserver.gameserver.ai.L2SiegeGuardAI;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.AbsorberInfo;
import com.l2jserver.gameserver.model.AggroInfo;
import com.l2jserver.gameserver.model.DamageDoneInfo;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;
import com.l2jserver.gameserver.model.actor.status.AttackableStatus;
import com.l2jserver.gameserver.model.actor.tasks.attackable.CommandChannelTimer;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableAggroRangeEnter;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableAttack;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableKill;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Attackable
extends L2Npc {
    private static final Logger LOG = LoggerFactory.getLogger(L2Attackable.class);
    private boolean _isRaid = false;
    private boolean _isRaidMinion = false;
    private boolean _champion = false;
    private final Map<L2Character, AggroInfo> _aggroList = new ConcurrentHashMap<L2Character, AggroInfo>();
    private boolean _isReturningToSpawnPoint = false;
    private boolean _canReturnToSpawnPoint = true;
    private boolean _seeThroughSilentMove = false;
    private boolean _seeded = false;
    private L2Seed _seed = null;
    private int _seederObjId = 0;
    private final AtomicReference<ItemHolder> _harvestItem = new AtomicReference();
    private int _spoilerObjectId;
    private final AtomicReference<Collection<ItemHolder>> _sweepItems = new AtomicReference();
    private boolean _overhit;
    private double _overhitDamage;
    private L2Character _overhitAttacker;
    private volatile L2CommandChannel _firstCommandChannelAttacked = null;
    private CommandChannelTimer _commandChannelTimer = null;
    private long _commandChannelLastAttack = 0L;
    private boolean _absorbed;
    private final Map<Integer, AbsorberInfo> _absorbersList = new ConcurrentHashMap<Integer, AbsorberInfo>();
    private boolean _mustGiveExpSp;
    protected int _onKillDelay = 5000;

    public L2Attackable(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Attackable);
        this.setIsInvul(false);
        this._mustGiveExpSp = true;
    }

    @Override
    public AttackableKnownList getKnownList() {
        return (AttackableKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new AttackableKnownList(this));
    }

    @Override
    public AttackableStatus getStatus() {
        return (AttackableStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new AttackableStatus(this));
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2AttackableAI(this);
    }

    public final Map<L2Character, AggroInfo> getAggroList() {
        return this._aggroList;
    }

    public final boolean isReturningToSpawnPoint() {
        return this._isReturningToSpawnPoint;
    }

    public final void setisReturningToSpawnPoint(boolean value) {
        this._isReturningToSpawnPoint = value;
    }

    public final boolean canReturnToSpawnPoint() {
        return this._canReturnToSpawnPoint;
    }

    public final void setCanReturnToSpawnPoint(boolean value) {
        this._canReturnToSpawnPoint = value;
    }

    public boolean canSeeThroughSilentMove() {
        return this._seeThroughSilentMove;
    }

    public void setSeeThroughSilentMove(boolean val) {
        this._seeThroughSilentMove = val;
    }

    public void useMagic(Skill skill) {
        if (skill == null || this.isAlikeDead() || skill.isPassive() || this.isCastingNow() || this.isSkillDisabled(skill)) {
            return;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume1(skill) + this.getStat().getMpConsume2(skill)) || this.getCurrentHp() <= (double)skill.getHpConsume()) {
            return;
        }
        if (!skill.isStatic() && (skill.isMagic() ? this.isMuted() : this.isPhysicalMuted())) {
            return;
        }
        List<L2Object> targets = skill.getTargets(this);
        if (!targets.isEmpty()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, targets.get(0));
        }
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, Skill skill) {
        this.reduceCurrentHp(damage, attacker, true, false, skill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, Skill skill) {
        L2Attackable l2Attackable;
        if (this.isRaid() && !this.isMinion() && attacker != null && attacker.getParty() != null && attacker.getParty().isInCommandChannel() && attacker.getParty().getCommandChannel().meetRaidWarCondition(this)) {
            if (this._firstCommandChannelAttacked == null) {
                L2Attackable l2Attackable2 = this;
                synchronized (l2Attackable2) {
                    if (this._firstCommandChannelAttacked == null) {
                        this._firstCommandChannelAttacked = attacker.getParty().getCommandChannel();
                        if (this._firstCommandChannelAttacked != null) {
                            this._commandChannelTimer = new CommandChannelTimer(this);
                            this._commandChannelLastAttack = System.currentTimeMillis();
                            ThreadPoolManager.getInstance().scheduleGeneral(this._commandChannelTimer, 10000L);
                            this._firstCommandChannelAttacked.broadcastPacket(new CreatureSay(0, 16, "", "You have looting rights!"));
                        }
                    }
                }
            } else if (attacker.getParty().getCommandChannel().equals(this._firstCommandChannelAttacked)) {
                this._commandChannelLastAttack = System.currentTimeMillis();
            }
        }
        if (this.isEventMob()) {
            return;
        }
        if (attacker != null) {
            this.addDamage(attacker, (int)damage, skill);
        }
        if ((l2Attackable = this) instanceof L2MonsterInstance) {
            L2MonsterInstance master = (L2MonsterInstance)l2Attackable;
            if (master.hasMinions()) {
                master.getMinionList().onAssist(this, attacker);
            }
            if ((master = master.getLeader()) != null && master.hasMinions()) {
                master.getMinionList().onAssist(this, attacker);
            }
        }
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    public synchronized void setMustRewardExpSp(boolean value) {
        this._mustGiveExpSp = value;
    }

    public synchronized boolean getMustRewardExpSP() {
        return this._mustGiveExpSp;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (killer != null && killer.isPlayable()) {
            EventDispatcher.getInstance().notifyEventAsyncDelayed(new AttackableKill(killer.getActingPlayer(), this, killer.isSummon()), this, this._onKillDelay);
        }
        if (this.isMonster()) {
            L2MonsterInstance mob = (L2MonsterInstance)this;
            if (mob.getLeader() != null && mob.getLeader().hasMinions()) {
                Integer respawnTime = Configuration.npc().getCustomMinionsRespawnTime().get(this.getId());
                respawnTime = respawnTime != null ? respawnTime * 1000 : -1;
                mob.getLeader().getMinionList().onMinionDie(mob, respawnTime);
            }
            if (mob.hasMinions()) {
                mob.getMinionList().onMasterDie(false);
            }
        }
        return true;
    }

    @Override
    protected void calculateRewards(L2Character lastAttacker) {
        try {
            int damage;
            L2PcInstance attacker;
            if (this._aggroList.isEmpty()) {
                return;
            }
            ConcurrentHashMap<L2PcInstance, DamageDoneInfo> rewards = new ConcurrentHashMap<L2PcInstance, DamageDoneInfo>();
            L2PcInstance maxDealer = null;
            int maxDamage = 0;
            long totalDamage = 0L;
            for (AggroInfo info : this._aggroList.values()) {
                if (info == null || (attacker = info.getAttacker().getActingPlayer()) == null || (damage = info.getDamage()) <= 1 || !Util.checkIfInRange(Configuration.character().getPartyRange(), this, attacker, true)) continue;
                totalDamage += (long)damage;
                DamageDoneInfo reward = rewards.computeIfAbsent(attacker, DamageDoneInfo::new);
                reward.addDamage(damage);
                if (reward.getDamage() <= maxDamage) continue;
                maxDealer = attacker;
                maxDamage = reward.getDamage();
            }
            this.doItemDrop(maxDealer != null && maxDealer.isOnline() ? maxDealer : lastAttacker);
            this.doEventDrop(lastAttacker);
            if (!this.getMustRewardExpSP()) {
                return;
            }
            if (!rewards.isEmpty()) {
                for (DamageDoneInfo reward : rewards.values()) {
                    float penalty;
                    if (reward == null) continue;
                    attacker = reward.getAttacker();
                    damage = reward.getDamage();
                    L2Party attackerParty = attacker.getParty();
                    float f = penalty = attacker.hasServitor() ? ((L2ServitorInstance)attacker.getSummon()).getExpMultiplier() : 1.0f;
                    if (attackerParty == null) {
                        if (!attacker.getKnownList().knowsObject(this)) continue;
                        int levelDiff = attacker.getLevel() - this.getLevel();
                        int[] expSp = this.calculateExpAndSp(levelDiff, damage, totalDamage);
                        long exp = expSp[0];
                        int sp = expSp[1];
                        if (Configuration.customs().championEnable() && this.isChampion()) {
                            exp = (long)((double)exp * Configuration.customs().getChampionRewardsExpSp());
                            sp = (int)((double)sp * Configuration.customs().getChampionRewardsExpSp());
                        }
                        exp = (long)((float)exp * penalty);
                        L2Character overhitAttacker = this.getOverhitAttacker();
                        if (this.isOverhit() && overhitAttacker != null && overhitAttacker.getActingPlayer() != null && attacker == overhitAttacker.getActingPlayer()) {
                            attacker.sendPacket(SystemMessageId.OVER_HIT);
                            exp += this.calculateOverhitExp(exp);
                        }
                        if (attacker.isDead()) continue;
                        attacker.addExpAndSp(exp, sp, this.useVitalityRate());
                        if (exp <= 0L) continue;
                        attacker.updateVitalityPoints(this.getVitalityPoints(damage), true, false);
                        if (attacker.isInsideZone(ZoneId.PEACE) || attacker.getLevel() - this.getLevel() > 9) continue;
                        if (Configuration.hunting().getNevitEnable()) {
                            attacker.getHuntingSystem().startHuntingSystemTask();
                            if (attacker.getHuntingSystem().getHuntingBonusTime() < Configuration.hunting().getHuntingBonusMaxTime() || !Configuration.hunting().getHuntingBonusLimit()) {
                                attacker.getHuntingSystem().addPoints(Configuration.hunting().getNevitNormalPoints());
                            }
                        }
                        attacker.getRecSystem().startBonusTask(true);
                        continue;
                    }
                    int partyDmg = 0;
                    float partyMul = 1.0f;
                    int partyLvl = 0;
                    ArrayList<L2PcInstance> rewardedMembers = new ArrayList<L2PcInstance>();
                    List<L2PcInstance> groupMembers = attackerParty.isInCommandChannel() ? attackerParty.getCommandChannel().getMembers() : attackerParty.getMembers();
                    for (L2PcInstance partyPlayer : groupMembers) {
                        if (partyPlayer == null || partyPlayer.isDead()) continue;
                        DamageDoneInfo reward2 = (DamageDoneInfo)rewards.get(partyPlayer);
                        if (reward2 != null) {
                            if (Util.checkIfInRange(Configuration.character().getPartyRange(), this, partyPlayer, true)) {
                                partyDmg += reward2.getDamage();
                                rewardedMembers.add(partyPlayer);
                                if (partyPlayer.getLevel() > partyLvl) {
                                    partyLvl = attackerParty.isInCommandChannel() ? attackerParty.getCommandChannel().getLevel() : partyPlayer.getLevel();
                                }
                            }
                            rewards.remove(partyPlayer);
                            continue;
                        }
                        if (!Util.checkIfInRange(Configuration.character().getPartyRange(), this, partyPlayer, true)) continue;
                        rewardedMembers.add(partyPlayer);
                        if (partyPlayer.getLevel() <= partyLvl) continue;
                        if (attackerParty.isInCommandChannel()) {
                            partyLvl = attackerParty.getCommandChannel().getLevel();
                            continue;
                        }
                        partyLvl = partyPlayer.getLevel();
                    }
                    if ((long)partyDmg < totalDamage) {
                        partyMul = (float)partyDmg / (float)totalDamage;
                    }
                    int levelDiff = partyLvl - this.getLevel();
                    int[] expSp = this.calculateExpAndSp(levelDiff, partyDmg, totalDamage);
                    long exp = expSp[0];
                    int sp = expSp[1];
                    if (Configuration.customs().championEnable() && this.isChampion()) {
                        exp = (long)((double)exp * Configuration.customs().getChampionRewardsExpSp());
                        sp = (int)((double)sp * Configuration.customs().getChampionRewardsExpSp());
                    }
                    exp = (long)((float)exp * partyMul);
                    sp = (int)((float)sp * partyMul);
                    L2Character overhitAttacker = this.getOverhitAttacker();
                    if (this.isOverhit() && overhitAttacker != null && overhitAttacker.getActingPlayer() != null && attacker == overhitAttacker.getActingPlayer()) {
                        attacker.sendPacket(SystemMessageId.OVER_HIT);
                        exp += this.calculateOverhitExp(exp);
                    }
                    if (partyDmg <= 0) continue;
                    attackerParty.distributeXpAndSp(exp, sp, rewardedMembers, partyLvl, partyDmg, this);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error calculating rewards!", ex);
        }
    }

    @Override
    public void addAttackerToAttackByList(L2Character player) {
        if (player == null || player == this || this.getAttackByList().contains(player)) {
            return;
        }
        this.getAttackByList().add(player);
    }

    public void addDamage(L2Character attacker, int damage, Skill skill) {
        if (attacker == null) {
            return;
        }
        if (!this.isDead()) {
            try {
                if (this.isWalker() && !this.isCoreAIDisabled() && WalkingManager.getInstance().isOnWalk(this)) {
                    WalkingManager.getInstance().stopMoving(this, false, true);
                }
                this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, (Object)attacker);
                this.addDamageHate(attacker, damage, damage * 100 / (this.getLevel() + 7));
                L2PcInstance player = attacker.getActingPlayer();
                if (player != null) {
                    EventDispatcher.getInstance().notifyEventAsync(new AttackableAttack(player, this, damage, skill, attacker.isSummon()), this);
                }
            }
            catch (Exception ex) {
                LOG.error("Error adding damage!", ex);
            }
        }
    }

    public void addDamageHate(L2Character attacker, int damage, long aggro) {
        if (attacker == null || attacker == this) {
            return;
        }
        AggroInfo ai = this._aggroList.computeIfAbsent(attacker, AggroInfo::new);
        ai.addDamage(damage);
        L2PcInstance targetPlayer = attacker.getActingPlayer();
        if (targetPlayer == null || targetPlayer.getTrap() == null || !targetPlayer.getTrap().isTriggered()) {
            ai.addHate(aggro);
        }
        if (targetPlayer != null && aggro == 0L) {
            this.addDamageHate(attacker, 0, 1L);
            if (this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            EventDispatcher.getInstance().notifyEventAsync(new AttackableAggroRangeEnter(this, targetPlayer, attacker.isSummon()), this);
        } else if (targetPlayer == null && aggro == 0L) {
            aggro = 1L;
            ai.addHate(1L);
        }
        if (aggro != 0L && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public void reduceHate(L2Character target, long amount) {
        if (this.getAI() instanceof L2SiegeGuardAI || this.getAI() instanceof L2FortSiegeGuardAI) {
            this.stopHating(target);
            this.setTarget(null);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            return;
        }
        if (target == null) {
            L2Character mostHated = this.getMostHated();
            if (mostHated == null) {
                ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
                return;
            }
            for (AggroInfo ai : this._aggroList.values()) {
                ai.addHate(amount);
            }
            amount = this.getHating(mostHated);
            if (amount >= 0L) {
                ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
                this.clearAggroList();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.setWalking();
            }
            return;
        }
        AggroInfo ai = this._aggroList.get(target);
        if (ai == null) {
            LOG.info("Target {} not present in aggro list of {}.", (Object)target, (Object)this);
            return;
        }
        ai.addHate(amount);
        if (ai.getHate() >= 0L && this.getMostHated() == null) {
            ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
            this.clearAggroList();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.setWalking();
        }
    }

    public void stopHating(L2Character target) {
        if (target == null) {
            return;
        }
        AggroInfo ai = this._aggroList.get(target);
        if (ai != null) {
            ai.stopHate();
        }
    }

    public L2Character getMostHated() {
        if (this._aggroList.isEmpty() || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        long maxHate = 0L;
        for (AggroInfo ai : this._aggroList.values()) {
            if (ai == null || ai.checkHate(this) <= maxHate) continue;
            mostHated = ai.getAttacker();
            maxHate = ai.getHate();
        }
        return mostHated;
    }

    public List<L2Character> get2MostHated() {
        if (this._aggroList.isEmpty() || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        L2Character secondMostHated = null;
        long maxHate = 0L;
        ArrayList<L2Character> result = new ArrayList<L2Character>();
        for (AggroInfo ai : this._aggroList.values()) {
            if (ai == null || ai.checkHate(this) <= maxHate) continue;
            secondMostHated = mostHated;
            mostHated = ai.getAttacker();
            maxHate = ai.getHate();
        }
        result.add(mostHated);
        if (this.getAttackByList().contains(secondMostHated)) {
            result.add(secondMostHated);
        } else {
            result.add(null);
        }
        return result;
    }

    public List<L2Character> getHateList() {
        if (this._aggroList.isEmpty() || this.isAlikeDead()) {
            return null;
        }
        ArrayList<L2Character> result = new ArrayList<L2Character>();
        for (AggroInfo ai : this._aggroList.values()) {
            if (ai == null) continue;
            ai.checkHate(this);
            result.add(ai.getAttacker());
        }
        return result;
    }

    public long getHating(L2Character target) {
        L2PcInstance act;
        if (this._aggroList.isEmpty() || target == null) {
            return 0L;
        }
        AggroInfo ai = this._aggroList.get(target);
        if (ai == null) {
            return 0L;
        }
        L2Character l2Character = ai.getAttacker();
        if (l2Character instanceof L2PcInstance && ((act = (L2PcInstance)l2Character).isInvisible() || ai.getAttacker().isInvul() || act.isSpawnProtected())) {
            this._aggroList.remove(target);
            return 0L;
        }
        if (!ai.getAttacker().isVisible() || ai.getAttacker().isInvisible()) {
            this._aggroList.remove(target);
            return 0L;
        }
        if (ai.getAttacker().isAlikeDead()) {
            ai.stopHate();
            return 0L;
        }
        return ai.getHate();
    }

    public void doItemDrop(L2Character mainDamageDealer) {
        this.doItemDrop(this.getTemplate(), mainDamageDealer);
    }

    public void doItemDrop(L2NpcTemplate npcTemplate, L2Character mainDamageDealer) {
        Collection<ItemHolder> deathItems;
        if (mainDamageDealer == null) {
            return;
        }
        L2PcInstance player = mainDamageDealer.getActingPlayer();
        if (player == null) {
            return;
        }
        CursedWeaponsManager.getInstance().checkDrop(this, player);
        if (this.isSpoiled()) {
            this._sweepItems.set(npcTemplate.calculateDrops(DropListScope.CORPSE, this, player));
        }
        if ((deathItems = npcTemplate.calculateDrops(DropListScope.DEATH, this, player)) != null) {
            for (ItemHolder drop : deathItems) {
                L2Item item = ItemTable.getInstance().getTemplate(drop.getId());
                if (!item.hasExImmediateEffect() && (!this.isRaid() && Configuration.character().autoLoot() || this.isRaid() && Configuration.character().autoLootRaids()) || item.hasExImmediateEffect() && Configuration.character().autoLootHerbs()) {
                    player.doAutoLoot(this, drop);
                } else if (!item.hasExImmediateEffect() && !this.isRaid() && (player.isAutoLoot() && !player.isAutoLootItem() || player.isAutoLootItem() && Configuration.customs().getAutoLootItemsList().contains(item.getId())) || item.hasExImmediateEffect() && player.isAutoLootHerb() && Configuration.customs().getAutoLootHerbsList().contains(item.getId())) {
                    player.doAutoLoot(this, drop);
                } else {
                    this.dropItem(player, drop);
                }
                if (!this.isRaid() || this.isRaidMinion() || drop.getCount() <= 0L) continue;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DIED_DROPPED_S3_S2);
                sm.addCharName(this);
                sm.addItemName(item);
                sm.addLong(drop.getCount());
                this.broadcastPacket(sm);
            }
        }
        if (Configuration.customs().championEnable() && this.isChampion() && (Configuration.customs().getChampionRewardLowerLvlItemChance() > 0 || Configuration.customs().getChampionRewardHigherLvlItemChance() > 0)) {
            int champqty = Rnd.get((int)Configuration.customs().getChampionRewardItemQty());
            ItemHolder item = new ItemHolder(Configuration.customs().getChampionRewardItemID(), ++champqty);
            if (player.getLevel() <= this.getLevel() && Rnd.get((int)100) < Configuration.customs().getChampionRewardLowerLvlItemChance()) {
                if (Configuration.character().autoLoot()) {
                    player.addItem("ChampionLoot", item.getId(), item.getCount(), this, true);
                } else if (player.isAutoLoot() && !player.isAutoLootItem() || player.isAutoLootItem() && Configuration.customs().getAutoLootItemsList().contains(item.getId())) {
                    player.addItem("ChampionLoot", item.getId(), item.getCount(), this, true);
                } else {
                    this.dropItem(player, item);
                }
            } else if (player.getLevel() > this.getLevel() && Rnd.get((int)100) < Configuration.customs().getChampionRewardHigherLvlItemChance()) {
                if (Configuration.character().autoLoot()) {
                    player.addItem("ChampionLoot", item.getId(), item.getCount(), this, true);
                } else if (player.isAutoLoot() && !player.isAutoLootItem() || player.isAutoLootItem() && Configuration.customs().getAutoLootItemsList().contains(item.getId())) {
                    player.addItem("ChampionLoot", item.getId(), item.getCount(), this, true);
                } else {
                    this.dropItem(player, item);
                }
            }
        }
    }

    public void doEventDrop(L2Character lastAttacker) {
        if (lastAttacker == null) {
            return;
        }
        L2PcInstance player = lastAttacker.getActingPlayer();
        if (player == null) {
            return;
        }
        if (player.getLevel() - this.getLevel() > 9) {
            return;
        }
        for (EventDroplist.DateDrop drop : EventDroplist.getInstance().getAllDrops()) {
            if (Rnd.get((int)1000000) >= drop.getEventDrop().getDropChance()) continue;
            int itemId = drop.getEventDrop().getItemIdList()[Rnd.get((int)drop.getEventDrop().getItemIdList().length)];
            long itemCount = Rnd.get((long)drop.getEventDrop().getMinCount(), (long)drop.getEventDrop().getMaxCount());
            if (Configuration.character().autoLoot()) {
                player.doAutoLoot(this, itemId, itemCount);
                continue;
            }
            if (player.isAutoLoot() && !player.isAutoLootItem() || player.isAutoLootItem() && Configuration.customs().getAutoLootItemsList().contains(itemId)) {
                player.doAutoLoot(this, itemId, itemCount);
                continue;
            }
            this.dropItem(player, itemId, itemCount);
        }
    }

    public L2ItemInstance getActiveWeapon() {
        return null;
    }

    public boolean isInAggroList(L2Character creature) {
        return this._aggroList.containsKey(creature);
    }

    public void clearAggroList() {
        this._aggroList.clear();
        this._overhit = false;
        this._overhitDamage = 0.0;
        this._overhitAttacker = null;
    }

    @Override
    public boolean isSweepActive() {
        return this._sweepItems.get() != null;
    }

    public List<L2Item> getSpoilLootItems() {
        Collection<ItemHolder> sweepItems = this._sweepItems.get();
        LinkedList<L2Item> lootItems = new LinkedList<L2Item>();
        if (sweepItems != null) {
            for (ItemHolder item : sweepItems) {
                lootItems.add(ItemTable.getInstance().getTemplate(item.getId()));
            }
        }
        return lootItems;
    }

    public Collection<ItemHolder> takeSweep() {
        return this._sweepItems.getAndSet(null);
    }

    public ItemHolder takeHarvest() {
        return this._harvestItem.getAndSet(null);
    }

    public boolean isOldCorpse(L2PcInstance attacker, int remainingTime, boolean sendMessage) {
        if (this.isDead() && DecayTaskManager.getInstance().getRemainingTime(this) < (long)remainingTime) {
            if (sendMessage && attacker != null) {
                attacker.sendPacket(SystemMessageId.CORPSE_TOO_OLD_SKILL_NOT_USED);
            }
            return true;
        }
        return false;
    }

    public boolean checkSpoilOwner(L2PcInstance sweeper, boolean sendMessage) {
        if (sweeper.getObjectId() != this.getSpoilerObjectId() && !sweeper.isInLooterParty(this.getSpoilerObjectId())) {
            if (sendMessage) {
                sweeper.sendPacket(SystemMessageId.SWEEP_NOT_ALLOWED);
            }
            return false;
        }
        return true;
    }

    public void overhitEnabled(boolean status) {
        this._overhit = status;
    }

    public void setOverhitValues(L2Character attacker, double damage) {
        double overhitDmg = -(this.getCurrentHp() - damage);
        if (overhitDmg < 0.0) {
            this.overhitEnabled(false);
            this._overhitDamage = 0.0;
            this._overhitAttacker = null;
            return;
        }
        this.overhitEnabled(true);
        this._overhitDamage = overhitDmg;
        this._overhitAttacker = attacker;
    }

    public L2Character getOverhitAttacker() {
        return this._overhitAttacker;
    }

    public double getOverhitDamage() {
        return this._overhitDamage;
    }

    public boolean isOverhit() {
        return this._overhit;
    }

    public void absorbSoul() {
        this._absorbed = true;
    }

    public boolean isAbsorbed() {
        return this._absorbed;
    }

    public void addAbsorber(L2PcInstance attacker) {
        AbsorberInfo ai = this._absorbersList.get(attacker.getObjectId());
        if (ai == null) {
            this._absorbersList.put(attacker.getObjectId(), new AbsorberInfo(attacker.getObjectId(), this.getCurrentHp()));
        } else {
            ai.setAbsorbedHp(this.getCurrentHp());
        }
        this.absorbSoul();
    }

    public void resetAbsorbList() {
        this._absorbed = false;
        this._absorbersList.clear();
    }

    public Map<Integer, AbsorberInfo> getAbsorbersList() {
        return this._absorbersList;
    }

    private int[] calculateExpAndSp(int diff, int damage, long totalDamage) {
        if (diff < -5) {
            diff = -5;
        }
        double xp = (double)this.getExpReward() * (double)damage / (double)totalDamage;
        if (Configuration.character().getExponentXp() != 0) {
            xp *= Math.pow(2.0, -diff / Configuration.character().getExponentXp());
        }
        double sp = (double)this.getSpReward() * (double)damage / (double)totalDamage;
        if (Configuration.character().getExponentSp() != 0) {
            sp *= Math.pow(2.0, -diff / Configuration.character().getExponentSp());
        }
        if (Configuration.character().getExponentXp() == 0 && Configuration.character().getExponentSp() == 0) {
            if (diff > 5) {
                double pow = Math.pow(0.8333333333333334, diff - 5);
                xp *= pow;
                sp *= pow;
            }
            if (xp <= 0.0) {
                xp = 0.0;
                sp = 0.0;
            } else if (sp <= 0.0) {
                sp = 0.0;
            }
        }
        return new int[]{(int)xp, (int)sp};
    }

    public long calculateOverhitExp(long normalExp) {
        double overhitPercentage = this.getOverhitDamage() * 100.0 / (double)this.getMaxHp();
        if (overhitPercentage > 25.0) {
            overhitPercentage = 25.0;
        }
        double overhitExp = overhitPercentage / 100.0 * (double)normalExp;
        return Math.round(overhitExp);
    }

    @Override
    public boolean canBeAttacked() {
        return true;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.setSpoilerObjectId(0);
        this.clearAggroList();
        this._harvestItem.set(null);
        this._seeded = false;
        this._seed = null;
        this._seederObjId = 0;
        this.overhitEnabled(false);
        this._sweepItems.set(null);
        this.resetAbsorbList();
        this.setWalking();
        if (!this.isInActiveRegion() && this.hasAI()) {
            this.getAI().stopAITask();
        }
    }

    public final boolean isSpoiled() {
        return this._spoilerObjectId != 0;
    }

    public final int getSpoilerObjectId() {
        return this._spoilerObjectId;
    }

    public final void setSpoilerObjectId(int spoilerObjectId) {
        this._spoilerObjectId = spoilerObjectId;
    }

    public final void setSeeded(L2PcInstance seeder) {
        if (this._seed != null && this._seederObjId == seeder.getObjectId()) {
            this._seeded = true;
            int count = 1;
            for (int skillId : this.getTemplate().getSkills().keySet()) {
                switch (skillId) {
                    case 4303: {
                        count *= 2;
                        break;
                    }
                    case 4304: {
                        count *= 3;
                        break;
                    }
                    case 4305: {
                        count *= 4;
                        break;
                    }
                    case 4306: {
                        count *= 5;
                        break;
                    }
                    case 4307: {
                        count *= 6;
                        break;
                    }
                    case 4308: {
                        count *= 7;
                        break;
                    }
                    case 4309: {
                        count *= 8;
                        break;
                    }
                    case 4310: {
                        count *= 9;
                    }
                }
            }
            int diff = this.getLevel() - this._seed.getLevel() - 5;
            if (diff > 0) {
                count += diff;
            }
            this._harvestItem.set(new ItemHolder(this._seed.getCropId(), count * Configuration.rates().getRateDropManor()));
        }
    }

    public final void setSeeded(L2Seed seed, L2PcInstance seeder) {
        if (!this._seeded) {
            this._seed = seed;
            this._seederObjId = seeder.getObjectId();
        }
    }

    public final int getSeederId() {
        return this._seederObjId;
    }

    public final L2Seed getSeed() {
        return this._seed;
    }

    public final boolean isSeeded() {
        return this._seeded;
    }

    public final void setOnKillDelay(int delay) {
        this._onKillDelay = delay;
    }

    public final int getOnKillDelay() {
        return this._onKillDelay;
    }

    @Override
    public boolean hasRandomAnimation() {
        return Configuration.general().getMaxMonsterAnimation() > 0 && this.isRandomAnimationEnabled() && !(this instanceof L2GrandBossInstance);
    }

    @Override
    public boolean isMob() {
        return true;
    }

    public void setCommandChannelTimer(CommandChannelTimer commandChannelTimer) {
        this._commandChannelTimer = commandChannelTimer;
    }

    public CommandChannelTimer getCommandChannelTimer() {
        return this._commandChannelTimer;
    }

    public L2CommandChannel getFirstCommandChannelAttacked() {
        return this._firstCommandChannelAttacked;
    }

    public void setFirstCommandChannelAttacked(L2CommandChannel firstCommandChannelAttacked) {
        this._firstCommandChannelAttacked = firstCommandChannelAttacked;
    }

    public long getCommandChannelLastAttack() {
        return this._commandChannelLastAttack;
    }

    public void setCommandChannelLastAttack(long channelLastAttack) {
        this._commandChannelLastAttack = channelLastAttack;
    }

    public void returnHome() {
        this.clearAggroList();
        if (this.hasAI() && this.getSpawn() != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this.getSpawn().getLocation(this));
        }
    }

    public float getVitalityPoints(int damage) {
        float divider;
        if (damage <= 0) {
            return 0.0f;
        }
        float f = divider = this.getLevel() > 0 && this.getExpReward() > 0L ? this.getTemplate().getBaseHpMax() * 9.0f * (float)this.getLevel() * (float)this.getLevel() / (float)(100L * this.getExpReward()) : 0.0f;
        if (divider == 0.0f) {
            return 0.0f;
        }
        return (float)(-Math.min(damage, this.getMaxHp())) / divider;
    }

    public boolean useVitalityRate() {
        return !this.isChampion() || Configuration.customs().championEnableVitality();
    }

    @Override
    public boolean isRaid() {
        return this._isRaid;
    }

    public void setIsRaid(boolean isRaid) {
        this._isRaid = isRaid;
    }

    public void setIsRaidMinion(boolean val) {
        this._isRaid = val;
        this._isRaidMinion = val;
    }

    @Override
    public boolean isRaidMinion() {
        return this._isRaidMinion;
    }

    @Override
    public boolean isMinion() {
        return this.getLeader() != null;
    }

    public L2Attackable getLeader() {
        return null;
    }

    public void setChampion(boolean champ) {
        this._champion = champ;
    }

    @Override
    public boolean isChampion() {
        return this._champion;
    }

    @Override
    public boolean isAttackable() {
        return true;
    }
}

