/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.VehiclePathPoint;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.VehicleKnownList;
import com.l2jserver.gameserver.model.actor.stat.VehicleStat;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L2Vehicle
extends L2Character {
    private static final Logger LOG = LoggerFactory.getLogger(L2Vehicle.class);
    protected int _dockId = 0;
    protected final List<L2PcInstance> _passengers = new CopyOnWriteArrayList<L2PcInstance>();
    protected Location _oustLoc = null;
    private Runnable _engine = null;
    protected VehiclePathPoint[] _currentPath = null;
    protected int _runState = 0;

    public L2Vehicle(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Vehicle);
        this.setIsFlying(true);
    }

    public boolean isBoat() {
        return false;
    }

    public boolean isAirShip() {
        return false;
    }

    public boolean canBeControlled() {
        return this._engine == null;
    }

    public void registerEngine(Runnable r) {
        this._engine = r;
    }

    public void runEngine(int delay) {
        if (this._engine != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(this._engine, delay);
        }
    }

    public void executePath(VehiclePathPoint[] path) {
        this._runState = 0;
        this._currentPath = path;
        if (this._currentPath != null && this._currentPath.length > 0) {
            VehiclePathPoint point = this._currentPath[0];
            if (point.getMoveSpeed() > 0) {
                this.getStat().setMoveSpeed(point.getMoveSpeed());
            }
            if (point.getRotationSpeed() > 0) {
                this.getStat().setRotationSpeed(point.getRotationSpeed());
            }
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, point);
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean moveToNextRoutePoint() {
        this._move = null;
        if (this._currentPath != null) {
            ++this._runState;
            if (this._runState < this._currentPath.length) {
                VehiclePathPoint point = this._currentPath[this._runState];
                if (!this.isMovementDisabled()) {
                    if (point.getMoveSpeed() == 0) {
                        point.setHeading(point.getRotationSpeed());
                        this.teleToLocation((ILocational)point, false);
                        this._currentPath = null;
                    } else {
                        if (point.getMoveSpeed() > 0) {
                            this.getStat().setMoveSpeed(point.getMoveSpeed());
                        }
                        if (point.getRotationSpeed() > 0) {
                            this.getStat().setRotationSpeed(point.getRotationSpeed());
                        }
                        L2Character.MoveData m = new L2Character.MoveData();
                        m.disregardingGeodata = false;
                        m.onGeodataPathIndex = -1;
                        m._xDestination = point.getX();
                        m._yDestination = point.getY();
                        m._zDestination = point.getZ();
                        m._heading = 0;
                        double distance = Math.hypot(point.getX() - this.getX(), point.getY() - this.getY());
                        if (distance > 1.0) {
                            this.setHeading(Util.calculateHeadingFrom(this.getX(), this.getY(), point.getX(), point.getY()));
                        }
                        m._moveStartTime = GameTimeController.getInstance().getGameTicks();
                        this._move = m;
                        GameTimeController.getInstance().registerMovingObject(this);
                        return true;
                    }
                }
            } else {
                this._currentPath = null;
            }
        }
        this.runEngine(10);
        return false;
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new VehicleKnownList(this));
    }

    @Override
    public VehicleStat getStat() {
        return (VehicleStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new VehicleStat(this));
    }

    public boolean isInDock() {
        return this._dockId > 0;
    }

    public int getDockId() {
        return this._dockId;
    }

    public void setInDock(int d) {
        this._dockId = d;
    }

    public void setOustLoc(Location loc) {
        this._oustLoc = loc;
    }

    public Location getOustLoc() {
        return this._oustLoc != null ? this._oustLoc : MapRegionManager.getInstance().getTeleToLocation(this, TeleportWhereType.TOWN);
    }

    public void oustPlayers() {
        this._passengers.forEach(this::oustPlayer);
        this._passengers.clear();
    }

    public void oustPlayer(L2PcInstance player) {
        player.setVehicle(null);
        player.setInVehiclePosition(null);
        this.removePassenger(player);
    }

    public boolean addPassenger(L2PcInstance player) {
        if (player == null || this._passengers.contains(player)) {
            return false;
        }
        if (player.getVehicle() != null && player.getVehicle() != this) {
            return false;
        }
        this._passengers.add(player);
        return true;
    }

    public void removePassenger(L2PcInstance player) {
        try {
            this._passengers.remove(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this._passengers.isEmpty();
    }

    public List<L2PcInstance> getPassengers() {
        return this._passengers;
    }

    public void broadcastToPassengers(L2GameServerPacket sm) {
        for (L2PcInstance player : this._passengers) {
            if (player == null) continue;
            player.sendPacket(sm);
        }
    }

    public void payForRide(int itemId, int count, int oustX, int oustY, int oustZ) {
        List<L2PcInstance> passengers = this.getKnownList().getKnownPlayersInRadius(1000L);
        if (!passengers.isEmpty()) {
            for (L2PcInstance player : passengers) {
                if (player == null || !player.isInBoat() || player.getBoat() != this) continue;
                if (itemId > 0) {
                    L2ItemInstance ticket = player.getInventory().getItemByItemId(itemId);
                    if (ticket == null || player.getInventory().destroyItem("Boat", ticket, (long)count, player, (Object)this) == null) {
                        player.sendPacket(SystemMessageId.NOT_CORRECT_BOAT_TICKET);
                        player.teleToLocation((ILocational)new Location(oustX, oustY, oustZ), true);
                        continue;
                    }
                    InventoryUpdate iu = new InventoryUpdate();
                    iu.addModifiedItem(ticket);
                    player.sendPacket(iu);
                }
                this.addPassenger(player);
            }
        }
    }

    @Override
    public boolean updatePosition() {
        boolean result = super.updatePosition();
        for (L2PcInstance player : this._passengers) {
            if (player == null || player.getVehicle() != this) continue;
            player.setXYZ(this.getX(), this.getY(), this.getZ());
            player.revalidateZone(false);
        }
        return result;
    }

    @Override
    public void teleToLocation(ILocational loc, boolean allowRandomOffset) {
        if (this.isMoving()) {
            this.stopMove(null, false);
        }
        this.setIsTeleporting(true);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        for (L2PcInstance player : this._passengers) {
            if (player == null) continue;
            player.teleToLocation(loc, false);
        }
        this.decayMe();
        this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
        if (loc.getHeading() != 0) {
            this.setHeading(loc.getHeading());
        }
        this.onTeleported();
        this.revalidateZone(true);
    }

    @Override
    public void stopMove(Location loc, boolean updateKnownObjects) {
        this._move = null;
        if (loc != null) {
            this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
            this.setHeading(loc.getHeading());
            this.revalidateZone(true);
        }
        if (Configuration.general().moveBasedKnownList() && updateKnownObjects) {
            this.getKnownList().findObjects();
        }
    }

    @Override
    public boolean deleteMe() {
        this._engine = null;
        try {
            if (this.isMoving()) {
                this.stopMove(null);
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed stopMove().", ex);
        }
        try {
            this.oustPlayers();
        }
        catch (Exception ex) {
            LOG.warn("Failed oustPlayers().", ex);
        }
        L2WorldRegion oldRegion = this.getWorldRegion();
        try {
            this.decayMe();
        }
        catch (Exception ex) {
            LOG.warn("Failed decayMe().", ex);
        }
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception ex) {
            LOG.warn("Failed cleaning knownlist.", ex);
        }
        L2World.getInstance().removeObject(this);
        return super.deleteMe();
    }

    @Override
    public void updateAbnormalEffect() {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void detachAI() {
    }

    @Override
    public boolean isVehicle() {
        return true;
    }
}

