/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2AuctioneerInstance
extends L2Npc {
    private static final Logger LOG = LoggerFactory.getLogger(L2AuctioneerInstance.class);
    private static final int COND_ALL_FALSE = 0;
    private static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    private static final int COND_REGULAR = 3;
    private int _currentPage = 1;
    private final Map<Integer, Auction> _pendingAuctions = new ConcurrentHashMap<Integer, Auction>();

    public L2AuctioneerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2AuctioneerInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            player.sendMessage("Wrong conditions.");
            return;
        }
        if (condition == 1) {
            String filename = "data/html/auction/auction-busy.htm";
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), filename);
            html.replace("%objectId%", String.valueOf(this.getObjectId()));
            player.sendPacket(html);
            return;
        }
        if (condition == 3) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.hasMoreTokens()) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("auction")) {
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int days = Integer.parseInt(val);
                    try {
                        Auction a;
                        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                        long bid = 0L;
                        if (st.hasMoreTokens()) {
                            bid = Math.min(Long.parseLong(st.nextToken()), Configuration.character().getMaxAdena());
                        }
                        if (this._pendingAuctions.get((a = new Auction(player.getClan().getHideoutId(), player.getClan(), TimeUnit.DAYS.toMillis(days), bid, ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getName())).getId()) != null) {
                            this._pendingAuctions.remove(a.getId());
                        }
                        this._pendingAuctions.put(a.getId(), a);
                        String filename = "data/html/auction/AgitSale3.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace("%x%", val);
                        html.replace("%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace("%AGIT_AUCTION_MINBID%", String.valueOf(a.getStartingBid()));
                        html.replace("%AGIT_AUCTION_MIN%", String.valueOf(a.getStartingBid()));
                        html.replace("%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getDesc());
                        html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_sale2");
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                        player.sendPacket(html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid bid!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction duration!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("confirmAuction")) {
                try {
                    Auction a = this._pendingAuctions.get(player.getClan().getHideoutId());
                    a.confirmAuction();
                    this._pendingAuctions.remove(player.getClan().getHideoutId());
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bidding")) {
                if (val.isEmpty()) {
                    return;
                }
                if (Configuration.general().debug()) {
                    LOG.debug("bidding show successful");
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    int auctionId = Integer.parseInt(val);
                    if (Configuration.general().debug()) {
                        LOG.debug("auction test started");
                    }
                    String filename = "data/html/auction/AgitAuctionInfo.htm";
                    Auction a = AuctionManager.getInstance().getAuction(auctionId);
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    if (a != null) {
                        html.replace("%AGIT_NAME%", a.getItemName());
                        html.replace("%OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace("%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace("%AGIT_SIZE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getGrade() * 10));
                        html.replace("%AGIT_LEASE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLease()));
                        html.replace("%AGIT_LOCATION%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLocation());
                        html.replace("%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace("%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + " hours " + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + " minutes");
                        html.replace("%AGIT_AUCTION_MINBID%", String.valueOf(a.getStartingBid()));
                        html.replace("%AGIT_AUCTION_COUNT%", String.valueOf(a.getBidders().size()));
                        html.replace("%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getDesc());
                        html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_list");
                        html.replace("%AGIT_LINK_BIDLIST%", "bypass -h npc_" + this.getObjectId() + "_bidlist " + a.getId());
                        html.replace("%AGIT_LINK_RE%", "bypass -h npc_" + this.getObjectId() + "_bid1 " + a.getId());
                    } else {
                        LOG.debug("Auctioneer Auction null for AuctionId : {}", (Object)auctionId);
                    }
                    player.sendPacket(html);
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bid")) {
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int auctionId = Integer.parseInt(val);
                    try {
                        long bid = 0L;
                        if (st.hasMoreTokens()) {
                            bid = Math.min(Long.parseLong(st.nextToken()), Configuration.character().getMaxAdena());
                        }
                        AuctionManager.getInstance().getAuction(auctionId).setBid(player, bid);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid bid!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bid1")) {
                if (player.getClan() == null || player.getClan().getLevel() < 2) {
                    player.sendPacket(SystemMessageId.AUCTION_ONLY_CLAN_LEVEL_2_HIGHER);
                    return;
                }
                if (val.isEmpty()) {
                    return;
                }
                if (player.getClan().getAuctionBidAt() > 0 && player.getClan().getAuctionBidAt() != Integer.parseInt(val) || player.getClan().getHideoutId() > 0) {
                    player.sendPacket(SystemMessageId.ALREADY_SUBMITTED_BID);
                    return;
                }
                try {
                    String filename = "data/html/auction/AgitBid1.htm";
                    long minimumBid = AuctionManager.getInstance().getAuction(Integer.parseInt(val)).getHighestBidderMaxBid();
                    if (minimumBid == 0L) {
                        minimumBid = AuctionManager.getInstance().getAuction(Integer.parseInt(val)).getStartingBid();
                    }
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_bidding " + val);
                    html.replace("%PLEDGE_ADENA%", String.valueOf(player.getClan().getWarehouse().getAdena()));
                    html.replace("%AGIT_AUCTION_MINBID%", String.valueOf(minimumBid));
                    html.replace("npc_%objectId%_bid", "npc_" + this.getObjectId() + "_bid " + val);
                    player.sendPacket(html);
                    return;
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                    return;
                }
            }
            if (actualCommand.equalsIgnoreCase("list")) {
                int start;
                List<Auction> auctions = AuctionManager.getInstance().getAuctions();
                SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd");
                int limit = 10;
                int i = 1;
                if (val.isEmpty()) {
                    start = 1;
                    this._currentPage = 1;
                } else {
                    start = limit * (Integer.parseInt(val) - 1) + 1;
                    limit *= Integer.parseInt(val);
                    this._currentPage = Integer.parseInt(val);
                }
                if (Configuration.general().debug()) {
                    LOG.debug("cmd list: auction test started");
                }
                StringBuilder items = new StringBuilder();
                items.append("<table width=280 border=0>");
                for (Auction a : auctions) {
                    if (a == null) continue;
                    if (i > limit) break;
                    if (i < start) {
                        ++i;
                        continue;
                    }
                    ++i;
                    items.append("<tr>");
                    items.append("<td width=70 align=left><font color=\"99B3FF\">");
                    items.append(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLocation());
                    items.append("</font></td>");
                    items.append("<td width=70 align=left><font color=\"FFFF99\"><a action=\"bypass -h npc_");
                    items.append(this.getObjectId());
                    items.append("_bidding ");
                    items.append(a.getId());
                    items.append("\">");
                    items.append(a.getItemName());
                    items.append("[");
                    items.append(AuctionManager.getInstance().getAuction(a.getId()).getBidders().size());
                    items.append("]</a></font></td>");
                    items.append("<td width=70 align=left>");
                    items.append(format.format(a.getEndDate()));
                    items.append("</td>");
                    items.append("<td width=70 align=left><font color=\"99FFFF\">");
                    items.append(a.getStartingBid());
                    items.append("</font></td>");
                    items.append("</tr>");
                    items.append("<tr><td height=5></td></tr>");
                }
                items.append("</table>");
                items.append("<table width=280 border=0>");
                items.append("<tr>");
                if (this._currentPage > 1) {
                    items.append("<td width=80 align=left>");
                    items.append("<button action=\"bypass -h npc_");
                    items.append(this.getObjectId());
                    items.append("_list ");
                    items.append(this._currentPage - 1);
                    items.append("\"");
                    items.append(" value=\"Previous\" width=80 height=27 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_CT1.Button_DF\">");
                    items.append("</td>");
                }
                items.append("<td width=80 align=left>");
                items.append("<button action=\"bypass -h npc_");
                items.append(this.getObjectId());
                items.append("_list ");
                items.append(this._currentPage + 1);
                items.append("\"");
                items.append(" value=\"Next\" width=80 height=27 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_CT1.Button_DF\">");
                items.append("</td>");
                items.append("<td width=120></td>");
                items.append("</tr>");
                items.append("</table>");
                String filename = "data/html/auction/AgitAuctionList.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                html.replace("%itemsField%", items.toString());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("bidlist")) {
                int auctionId;
                if (val.isEmpty()) {
                    if (player.getClan().getAuctionBidAt() <= 0) {
                        return;
                    }
                    auctionId = player.getClan().getAuctionBidAt();
                } else {
                    auctionId = Integer.parseInt(val);
                }
                if (Configuration.general().debug()) {
                    LOG.debug("cmd bidlist: auction test started");
                }
                StringBuilder bidders = new StringBuilder();
                for (Auction.Bidder b : AuctionManager.getInstance().getAuction(auctionId).getBidders().values()) {
                    bidders.append("<tr><td>").append(b.getClanName()).append("</td><td>").append(b.getName()).append("</td><td>").append(b.getTimeBid().get(1)).append("/").append(b.getTimeBid().get(2) + 1).append("/").append(b.getTimeBid().get(5)).append("</td><td>").append(b.getBid()).append("</td>").append("</tr>");
                }
                String fileName = "data/html/auction/AgitBidderList.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/auction/AgitBidderList.htm");
                html.replace("%AGIT_LIST%", bidders.toString());
                html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_bidding " + auctionId);
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("selectedItems")) {
                if (player.getClan() != null && player.getClan().getHideoutId() == 0 && player.getClan().getAuctionBidAt() > 0) {
                    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    String filename = "data/html/auction/AgitBidInfo.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBidAt());
                    if (a != null) {
                        html.replace("%AGIT_NAME%", a.getItemName());
                        html.replace("%OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace("%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace("%AGIT_SIZE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getGrade() * 10));
                        html.replace("%AGIT_LEASE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLease()));
                        html.replace("%AGIT_LOCATION%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLocation());
                        html.replace("%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace("%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + " hours " + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + " minutes");
                        html.replace("%AGIT_AUCTION_MINBID%", String.valueOf(a.getStartingBid()));
                        html.replace("%AGIT_AUCTION_MYBID%", String.valueOf(a.getBidders().get(player.getClanId()).getBid()));
                        html.replace("%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getDesc());
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                        html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                    } else {
                        LOG.warn("Auctioneer Auction null for AuctionBiddedAt : {}", (Object)player.getClan().getAuctionBidAt());
                    }
                    player.sendPacket(html);
                    return;
                }
                if (player.getClan() != null && AuctionManager.getInstance().getAuction(player.getClan().getHideoutId()) != null) {
                    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    String filename = "data/html/auction/AgitSaleInfo.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getHideoutId());
                    if (a != null) {
                        html.replace("%AGIT_NAME%", a.getItemName());
                        html.replace("%AGIT_OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace("%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace("%AGIT_SIZE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getGrade() * 10));
                        html.replace("%AGIT_LEASE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLease()));
                        html.replace("%AGIT_LOCATION%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLocation());
                        html.replace("%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace("%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + " hours " + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + " minutes");
                        html.replace("%AGIT_AUCTION_MINBID%", String.valueOf(a.getStartingBid()));
                        html.replace("%AGIT_AUCTION_BIDCOUNT%", String.valueOf(a.getBidders().size()));
                        html.replace("%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getDesc());
                        html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        html.replace("%id%", String.valueOf(a.getId()));
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                    } else {
                        LOG.warn("Auctioneer Auction null for getHasHideout : {}", (Object)player.getClan().getHideoutId());
                    }
                    player.sendPacket(html);
                    return;
                }
                if (player.getClan() != null && player.getClan().getHideoutId() != 0) {
                    int ItemId = player.getClan().getHideoutId();
                    String filename = "data/html/auction/AgitInfo.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    if (ClanHallManager.getInstance().getAuctionableHallById(ItemId) != null) {
                        html.replace("%AGIT_NAME%", ClanHallManager.getInstance().getAuctionableHallById(ItemId).getName());
                        html.replace("%AGIT_OWNER_PLEDGE_NAME%", player.getClan().getName());
                        html.replace("%OWNER_PLEDGE_MASTER%", player.getClan().getLeaderName());
                        html.replace("%AGIT_SIZE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(ItemId).getGrade() * 10));
                        html.replace("%AGIT_LEASE%", String.valueOf(ClanHallManager.getInstance().getAuctionableHallById(ItemId).getLease()));
                        html.replace("%AGIT_LOCATION%", ClanHallManager.getInstance().getAuctionableHallById(ItemId).getLocation());
                        html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                    } else {
                        LOG.warn("Clan Hall ID NULL : {} Can be caused by concurrent write in ClanHallManager", (Object)ItemId);
                    }
                    player.sendPacket(html);
                    return;
                }
                if (player.getClan() != null && player.getClan().getHideoutId() == 0) {
                    player.sendPacket(SystemMessageId.NO_OFFERINGS_OWN_OR_MADE_BID_FOR);
                    return;
                }
                if (player.getClan() == null) {
                    player.sendPacket(SystemMessageId.CANNOT_PARTICIPATE_IN_AN_AUCTION);
                    return;
                }
            } else {
                if (actualCommand.equalsIgnoreCase("cancelBid")) {
                    long bid = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBidAt()).getBidders().get(player.getClanId()).getBid();
                    String filename = "data/html/auction/AgitBidCancel.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace("%AGIT_BID%", String.valueOf(bid));
                    html.replace("%AGIT_BID_REMAIN%", String.valueOf((long)((double)bid * 0.9)));
                    html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                    html.replace("%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("doCancelBid")) {
                    if (AuctionManager.getInstance().getAuction(player.getClan().getAuctionBidAt()) != null) {
                        AuctionManager.getInstance().getAuction(player.getClan().getAuctionBidAt()).cancelBid(player.getClanId());
                        player.sendPacket(SystemMessageId.CANCELED_BID);
                    }
                    return;
                }
                if (actualCommand.equalsIgnoreCase("cancelAuction")) {
                    if (!player.hasClanPrivilege(ClanPrivilege.CH_AUCTION)) {
                        String filename = "data/html/auction/not_authorized.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                        player.sendPacket(html);
                        return;
                    }
                    String filename = "data/html/auction/AgitSaleCancel.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace("%AGIT_DEPOSIT%", String.valueOf(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                    html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                    html.replace("%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("doCancelAuction")) {
                    if (AuctionManager.getInstance().getAuction(player.getClan().getHideoutId()) != null) {
                        AuctionManager.getInstance().getAuction(player.getClan().getHideoutId()).cancelAuction();
                        player.sendMessage("Your auction has been canceled");
                    }
                    return;
                }
                if (actualCommand.equalsIgnoreCase("sale2")) {
                    String filename = "data/html/auction/AgitSale2.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace("%AGIT_LAST_PRICE%", String.valueOf(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                    html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_sale");
                    html.replace("%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("sale")) {
                    if (!player.hasClanPrivilege(ClanPrivilege.CH_AUCTION)) {
                        String filename = "data/html/auction/not_authorized.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                        player.sendPacket(html);
                        return;
                    }
                    String filename = "data/html/auction/AgitSale1.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace("%AGIT_DEPOSIT%", String.valueOf(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                    html.replace("%AGIT_PLEDGE_ADENA%", String.valueOf(player.getClan().getWarehouse().getAdena()));
                    html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                    html.replace("%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("rebid")) {
                    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    if (!player.hasClanPrivilege(ClanPrivilege.CH_AUCTION)) {
                        String filename = "data/html/auction/not_authorized.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace("%objectId%", String.valueOf(this.getObjectId()));
                        player.sendPacket(html);
                        return;
                    }
                    try {
                        String filename = "data/html/auction/AgitBid2.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        Auction a = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBidAt());
                        if (a != null) {
                            html.replace("%AGIT_AUCTION_BID%", String.valueOf(a.getBidders().get(player.getClanId()).getBid()));
                            html.replace("%AGIT_AUCTION_MINBID%", String.valueOf(a.getStartingBid()));
                            html.replace("%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                            html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                            html.replace("npc_%objectId%_bid1", "npc_" + this.getObjectId() + "_bid1 " + a.getId());
                        } else {
                            LOG.warn("Auctioneer Auction null for AuctionBiddedAt : {}", (Object)player.getClan().getAuctionBidAt());
                        }
                        player.sendPacket(html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid auction!");
                    }
                    return;
                }
                if (actualCommand.equalsIgnoreCase("location")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/auction/location.htm");
                    html.replace("%location%", MapRegionManager.getInstance().getClosestTownName(player));
                    html.replace("%LOCATION%", this.getPictureName(player));
                    html.replace("%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("start")) {
                    this.showChatWindow(player);
                    return;
                }
            }
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        int condition = this.validateCondition(player);
        String filename = condition == 1 ? "data/html/auction/auction-busy.htm" : "data/html/auction/auction.htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcId%", String.valueOf(this.getId()));
        html.replace("%npcname%", this.getName());
        player.sendPacket(html);
    }

    private int validateCondition(L2PcInstance player) {
        if (this.getCastle() != null && this.getCastle().getResidenceId() > 0) {
            if (this.getCastle().getSiege().isInProgress()) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    private String getPictureName(L2PcInstance plyr) {
        int nearestTownId = MapRegionManager.getInstance().getMapRegionLocId(plyr);
        return switch (nearestTownId) {
            case 911 -> "GLUDIN";
            case 912 -> "GLUDIO";
            case 916 -> "DION";
            case 918 -> "GIRAN";
            case 1537 -> "RUNE";
            case 1538 -> "GODARD";
            case 1714 -> "SCHUTTGART";
            default -> "ADEN";
        };
    }
}

