/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.TeleportLocationTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AgitDecoInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2ClanHallManagerInstance
extends L2MerchantInstance {
    private static final Logger LOG = LoggerFactory.getLogger(L2ClanHallManagerInstance.class);
    protected static final int COND_OWNER_FALSE = 0;
    protected static final int COND_ALL_FALSE = 1;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 2;
    protected static final int COND_OWNER = 3;
    private int _clanHallId = -1;

    public L2ClanHallManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ClanHallManagerInstance);
    }

    @Override
    public boolean isWarehouse() {
        return true;
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.getClanHall().isSiegableHall() && ((SiegableHall)this.getClanHall()).isInSiege()) {
            return;
        }
        int condition = this.validateCondition(player);
        if (condition <= 1) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        if (condition == 3) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("banish_foreigner")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.hasClanPrivilege(ClanPrivilege.CH_DISMISS)) {
                    if (val.equalsIgnoreCase("list")) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/banish-list.htm");
                    } else if (val.equalsIgnoreCase("banish")) {
                        this.getClanHall().banishForeigners();
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/banish.htm");
                    }
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                }
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage_vault")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.hasClanPrivilege(ClanPrivilege.CL_VIEW_WAREHOUSE)) {
                    if (this.getClanHall().getLease() <= 0) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/vault-chs.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/vault.htm");
                        html.replace("%rent%", String.valueOf(this.getClanHall().getLease()));
                        html.replace("%date%", format.format(this.getClanHall().getPaidUntil()));
                    }
                    this.sendHtmlMessage(player, html);
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("door")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (player.hasClanPrivilege(ClanPrivilege.CH_OPEN_DOOR)) {
                    if (val.equalsIgnoreCase("open")) {
                        this.getClanHall().openCloseDoors(true);
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/door-open.htm");
                    } else if (val.equalsIgnoreCase("close")) {
                        this.getClanHall().openCloseDoors(false);
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/door-close.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/door.htm");
                    }
                    this.sendHtmlMessage(player, html);
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("functions")) {
                if (val.equalsIgnoreCase("tele")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    if (this.getClanHall().getFunction(1) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/tele" + this.getClanHall().getLocation() + this.getClanHall().getFunction(1).getLvl() + ".htm");
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("item_creation")) {
                    if (this.getClanHall().getFunction(2) == null) {
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-nac.htm");
                        this.sendHtmlMessage(player, html);
                        return;
                    }
                    if (st.countTokens() < 1) {
                        return;
                    }
                    int valbuy = Integer.parseInt(st.nextToken()) + this.getClanHall().getFunction(2).getLvl() * 100000;
                    this.showBuyWindow(player, valbuy);
                } else if (val.equalsIgnoreCase("support")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    if (this.getClanHall().getFunction(6) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/chamberlain-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support" + this.getClanHall().getFunction(6).getLvl() + ".htm");
                        html.replace("%mp%", String.valueOf((int)this.getCurrentMp()));
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("back")) {
                    this.showChatWindow(player);
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions.htm");
                    if (this.getClanHall().getFunction(5) != null) {
                        html.replace("%xp_regen%", String.valueOf(this.getClanHall().getFunction(5).getLvl()));
                    } else {
                        html.replace("%xp_regen%", "0");
                    }
                    if (this.getClanHall().getFunction(3) != null) {
                        html.replace("%hp_regen%", String.valueOf(this.getClanHall().getFunction(3).getLvl()));
                    } else {
                        html.replace("%hp_regen%", "0");
                    }
                    if (this.getClanHall().getFunction(4) != null) {
                        html.replace("%mp_regen%", String.valueOf(this.getClanHall().getFunction(4).getLvl()));
                    } else {
                        html.replace("%mp_regen%", "0");
                    }
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage")) {
                if (player.hasClanPrivilege(ClanPrivilege.CH_SET_FUNCTIONS)) {
                    if (val.equalsIgnoreCase("recovery")) {
                        int grade;
                        if (st.countTokens() >= 1) {
                            if (this.getClanHall().getOwnerId() == 0) {
                                player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("hp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "recovery hp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("mp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "recovery mp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("exp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "recovery exp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_hp")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Fireplace (HP Recovery Device)");
                                int percent = Integer.parseInt(val);
                                int cost = switch (percent) {
                                    case 20 -> Configuration.clanhall().getHpRegenerationFeeLvl1();
                                    case 40 -> Configuration.clanhall().getHpRegenerationFeeLvl2();
                                    case 80 -> Configuration.clanhall().getHpRegenerationFeeLvl3();
                                    case 100 -> Configuration.clanhall().getHpRegenerationFeeLvl4();
                                    case 120 -> Configuration.clanhall().getHpRegenerationFeeLvl5();
                                    case 140 -> Configuration.clanhall().getHpRegenerationFeeLvl6();
                                    case 160 -> Configuration.clanhall().getHpRegenerationFeeLvl7();
                                    case 180 -> Configuration.clanhall().getHpRegenerationFeeLvl8();
                                    case 200 -> Configuration.clanhall().getHpRegenerationFeeLvl9();
                                    case 220 -> Configuration.clanhall().getHpRegenerationFeeLvl10();
                                    case 240 -> Configuration.clanhall().getHpRegenerationFeeLvl11();
                                    case 260 -> Configuration.clanhall().getHpRegenerationFeeLvl12();
                                    default -> Configuration.clanhall().getHpRegenerationFeeLvl13();
                                };
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getHpRegenerationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Provides additional HP recovery for clan members in the clan hall.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace("%apply%", "recovery hp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_mp")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Carpet (MP Recovery)");
                                int percent = Integer.parseInt(val);
                                int cost = switch (percent) {
                                    case 5 -> Configuration.clanhall().getMpRegenerationFeeLvl1();
                                    case 10 -> Configuration.clanhall().getMpRegenerationFeeLvl2();
                                    case 15 -> Configuration.clanhall().getMpRegenerationFeeLvl3();
                                    case 30 -> Configuration.clanhall().getMpRegenerationFeeLvl4();
                                    default -> Configuration.clanhall().getMpRegenerationFeeLvl5();
                                };
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getMpRegenerationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Provides additional MP recovery for clan members in the clan hall.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace("%apply%", "recovery mp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_exp")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Chandelier (EXP Recovery Device)");
                                int percent = Integer.parseInt(val);
                                int cost = switch (percent) {
                                    case 5 -> Configuration.clanhall().getExpRegenerationFeeLvl1();
                                    case 10 -> Configuration.clanhall().getExpRegenerationFeeLvl2();
                                    case 15 -> Configuration.clanhall().getExpRegenerationFeeLvl3();
                                    case 25 -> Configuration.clanhall().getExpRegenerationFeeLvl4();
                                    case 35 -> Configuration.clanhall().getExpRegenerationFeeLvl5();
                                    case 40 -> Configuration.clanhall().getExpRegenerationFeeLvl6();
                                    default -> Configuration.clanhall().getExpRegenerationFeeLvl7();
                                };
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getExpRegenerationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Restores the Exp of any clan member who is resurrected in the clan hall.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace("%apply%", "recovery exp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("hp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(3) != null && this.getClanHall().getFunction(3).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 20: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl1();
                                            break;
                                        }
                                        case 40: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl2();
                                            break;
                                        }
                                        case 80: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl3();
                                            break;
                                        }
                                        case 100: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl4();
                                            break;
                                        }
                                        case 120: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl5();
                                            break;
                                        }
                                        case 140: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl6();
                                            break;
                                        }
                                        case 160: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl7();
                                            break;
                                        }
                                        case 180: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl8();
                                            break;
                                        }
                                        case 200: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl9();
                                            break;
                                        }
                                        case 220: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl10();
                                            break;
                                        }
                                        case 240: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl11();
                                            break;
                                        }
                                        case 260: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl12();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getHpRegenerationFeeLvl13();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 3, percent, fee, Configuration.clanhall().getHpRegenerationFunctionFeeRatio(), this.getClanHall().getFunction(3) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("mp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(4) != null && this.getClanHall().getFunction(4).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 5: {
                                            fee = Configuration.clanhall().getMpRegenerationFeeLvl1();
                                            break;
                                        }
                                        case 10: {
                                            fee = Configuration.clanhall().getMpRegenerationFeeLvl2();
                                            break;
                                        }
                                        case 15: {
                                            fee = Configuration.clanhall().getMpRegenerationFeeLvl3();
                                            break;
                                        }
                                        case 30: {
                                            fee = Configuration.clanhall().getMpRegenerationFeeLvl4();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getMpRegenerationFeeLvl5();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 4, percent, fee, Configuration.clanhall().getMpRegenerationFunctionFeeRatio(), this.getClanHall().getFunction(4) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("exp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Exp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(5) != null && this.getClanHall().getFunction(5).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 5: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl1();
                                            break;
                                        }
                                        case 10: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl2();
                                            break;
                                        }
                                        case 15: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl3();
                                            break;
                                        }
                                        case 25: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl4();
                                            break;
                                        }
                                        case 35: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl5();
                                            break;
                                        }
                                        case 40: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl6();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getExpRegenerationFeeLvl7();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 5, percent, fee, Configuration.clanhall().getExpRegenerationFunctionFeeRatio(), this.getClanHall().getFunction(5) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/edit_recovery.htm");
                        String hp_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 20\">20%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 40\">40%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 220\">220%</a>]";
                        String hp_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 40\">40%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 100\">100%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 160\">160%</a>]";
                        String hp_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 80\">80%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 140\">140%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 200\">200%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 260\">260%</a>]";
                        String hp_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 80\">80%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 120\">120%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 180\">180%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 240\">240%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 300\">300%</a>]";
                        String exp_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 10\">10%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>]";
                        String exp_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 30\">30%</a>]";
                        String exp_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 40\">40%</a>]";
                        String exp_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 25\">25%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 35\">35%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 50\">50%</a>]";
                        String mp_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 10\">10%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 25\">25%</a>]";
                        String mp_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 25\">25%</a>]";
                        String mp_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 30\">30%</a>]";
                        String mp_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 5\">5%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 15\">15%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 30\">30%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 40\">40%</a>]";
                        if (this.getClanHall().getFunction(3) != null) {
                            html.replace("%hp_recovery%", this.getClanHall().getFunction(3).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(3).getLease() + "</font>Adena /" + Configuration.clanhall().getHpRegenerationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%hp_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(3).getEndTime()));
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">Deactivate</a>]" + hp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">Deactivate</a>]" + hp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">Deactivate</a>]" + hp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">Deactivate</a>]" + hp_grade3);
                                }
                            }
                        } else {
                            html.replace("%hp_recovery%", "none");
                            html.replace("%hp_period%", "none");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_hp%", hp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_hp%", hp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_hp%", hp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_hp%", hp_grade3);
                                }
                            }
                        }
                        if (this.getClanHall().getFunction(5) != null) {
                            html.replace("%exp_recovery%", this.getClanHall().getFunction(5).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(5).getLease() + "</font>Adena /" + Configuration.clanhall().getExpRegenerationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%exp_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(5).getEndTime()));
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">Deactivate</a>]" + exp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">Deactivate</a>]" + exp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">Deactivate</a>]" + exp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">Deactivate</a>]" + exp_grade3);
                                }
                            }
                        } else {
                            html.replace("%exp_recovery%", "none");
                            html.replace("%exp_period%", "none");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_exp%", exp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_exp%", exp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_exp%", exp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_exp%", exp_grade3);
                                }
                            }
                        }
                        if (this.getClanHall().getFunction(4) != null) {
                            html.replace("%mp_recovery%", this.getClanHall().getFunction(4).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(4).getLease() + "</font>Adena /" + Configuration.clanhall().getMpRegenerationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%mp_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(4).getEndTime()));
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">Deactivate</a>]" + mp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">Deactivate</a>]" + mp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">Deactivate</a>]" + mp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">Deactivate</a>]" + mp_grade3);
                                }
                            }
                        } else {
                            html.replace("%mp_recovery%", "none");
                            html.replace("%mp_period%", "none");
                            grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_mp%", mp_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_mp%", mp_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_mp%", mp_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_mp%", mp_grade3);
                                }
                            }
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("other")) {
                        if (st.countTokens() >= 1) {
                            if (this.getClanHall().getOwnerId() == 0) {
                                player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("item_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "other item 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("tele_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "other tele 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("support_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "other support 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_item")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Magic Equipment (Item Production Facilities)");
                                int stage = Integer.parseInt(val);
                                int cost = switch (stage) {
                                    case 1 -> Configuration.clanhall().getItemCreationFunctionFeeLvl1();
                                    case 2 -> Configuration.clanhall().getItemCreationFunctionFeeLvl2();
                                    default -> Configuration.clanhall().getItemCreationFunctionFeeLvl3();
                                };
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getItemCreationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Allow the purchase of special items at fixed intervals.");
                                html.replace("%apply%", "other item " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_support")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Insignia (Supplementary Magic)");
                                int stage = Integer.parseInt(val);
                                int cost = switch (stage) {
                                    case 1 -> Configuration.clanhall().getSupportFeeLvl1();
                                    case 2 -> Configuration.clanhall().getSupportFeeLvl2();
                                    case 3 -> Configuration.clanhall().getSupportFeeLvl3();
                                    case 4 -> Configuration.clanhall().getSupportFeeLvl4();
                                    case 5 -> Configuration.clanhall().getSupportFeeLvl5();
                                    case 6 -> Configuration.clanhall().getSupportFeeLvl6();
                                    case 7 -> Configuration.clanhall().getSupportFeeLvl7();
                                    default -> Configuration.clanhall().getSupportFeeLvl8();
                                };
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getSupportFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Enables the use of supplementary magic.");
                                html.replace("%apply%", "other support " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_tele")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Mirror (Teleportation Device)");
                                int stage = Integer.parseInt(val);
                                int cost = stage == 1 ? Configuration.clanhall().getTeleportFunctionFeeLvl1() : Configuration.clanhall().getTeleportFunctionFeeLvl2();
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getTeleportFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Teleports clan members in a clan hall to the target <font color=\"00FFFF\">Stage " + stage + "</font> staging area");
                                html.replace("%apply%", "other tele " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("item")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (this.getClanHall().getOwnerId() == 0) {
                                        player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                        return;
                                    }
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Item editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(2) != null && this.getClanHall().getFunction(2).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Configuration.clanhall().getItemCreationFunctionFeeLvl1();
                                            break;
                                        }
                                        case 2: {
                                            fee = Configuration.clanhall().getItemCreationFunctionFeeLvl2();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getItemCreationFunctionFeeLvl3();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 2, lvl, fee, Configuration.clanhall().getItemCreationFunctionFeeRatio(), this.getClanHall().getFunction(2) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("tele")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Tele editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(1) != null && this.getClanHall().getFunction(1).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Configuration.clanhall().getTeleportFunctionFeeLvl1();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getTeleportFunctionFeeLvl2();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 1, lvl, fee, Configuration.clanhall().getTeleportFunctionFeeRatio(), this.getClanHall().getFunction(1) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("support")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Support editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(6) != null && this.getClanHall().getFunction(6).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Configuration.clanhall().getSupportFeeLvl1();
                                            break;
                                        }
                                        case 2: {
                                            fee = Configuration.clanhall().getSupportFeeLvl2();
                                            break;
                                        }
                                        case 3: {
                                            fee = Configuration.clanhall().getSupportFeeLvl3();
                                            break;
                                        }
                                        case 4: {
                                            fee = Configuration.clanhall().getSupportFeeLvl4();
                                            break;
                                        }
                                        case 5: {
                                            fee = Configuration.clanhall().getSupportFeeLvl5();
                                            break;
                                        }
                                        case 6: {
                                            fee = Configuration.clanhall().getSupportFeeLvl6();
                                            break;
                                        }
                                        case 7: {
                                            fee = Configuration.clanhall().getSupportFeeLvl7();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getSupportFeeLvl8();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 6, lvl, fee, Configuration.clanhall().getSupportFunctionFeeRatio(), this.getClanHall().getFunction(6) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/edit_other.htm");
                        String tele = "[<a action=\"bypass -h npc_%objectId%_manage other edit_tele 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_tele 2\">Level 2</a>]";
                        String support_grade0 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 2\">Level 2</a>]";
                        String support_grade1 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 2\">Level 2</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 4\">Level 4</a>]";
                        String support_grade2 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 3\">Level 3</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 4\">Level 4</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 5\">Level 5</a>]";
                        String support_grade3 = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 3\">Level 3</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 5\">Level 5</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 7\">Level 7</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 8\">Level 8</a>]";
                        String item = "[<a action=\"bypass -h npc_%objectId%_manage other edit_item 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_item 2\">Level 2</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_item 3\">Level 3</a>]";
                        if (this.getClanHall().getFunction(1) != null) {
                            html.replace("%tele%", "Stage " + this.getClanHall().getFunction(1).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(1).getLease() + "</font>Adena /" + Configuration.clanhall().getTeleportFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%tele_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(1).getEndTime()));
                            html.replace("%change_tele%", "[<a action=\"bypass -h npc_%objectId%_manage other tele_cancel\">Deactivate</a>]" + tele);
                        } else {
                            html.replace("%tele%", "none");
                            html.replace("%tele_period%", "none");
                            html.replace("%change_tele%", tele);
                        }
                        if (this.getClanHall().getFunction(6) != null) {
                            html.replace("%support%", "Stage " + this.getClanHall().getFunction(6).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(6).getLease() + "</font>Adena /" + Configuration.clanhall().getSupportFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%support_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(6).getEndTime()));
                            int grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">Deactivate</a>]" + support_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">Deactivate</a>]" + support_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">Deactivate</a>]" + support_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">Deactivate</a>]" + support_grade3);
                                }
                            }
                        } else {
                            html.replace("%support%", "none");
                            html.replace("%support_period%", "none");
                            int grade = this.getClanHall().getGrade();
                            switch (grade) {
                                case 0: {
                                    html.replace("%change_support%", support_grade0);
                                    break;
                                }
                                case 1: {
                                    html.replace("%change_support%", support_grade1);
                                    break;
                                }
                                case 2: {
                                    html.replace("%change_support%", support_grade2);
                                    break;
                                }
                                case 3: {
                                    html.replace("%change_support%", support_grade3);
                                }
                            }
                        }
                        if (this.getClanHall().getFunction(2) != null) {
                            html.replace("%item%", "Stage " + this.getClanHall().getFunction(2).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(2).getLease() + "</font>Adena /" + Configuration.clanhall().getItemCreationFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%item_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(2).getEndTime()));
                            html.replace("%change_item%", "[<a action=\"bypass -h npc_%objectId%_manage other item_cancel\">Deactivate</a>]" + item);
                        } else {
                            html.replace("%item%", "none");
                            html.replace("%item_period%", "none");
                            html.replace("%change_item%", item);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("deco") && !this.getClanHall().isSiegableHall()) {
                        if (st.countTokens() >= 1) {
                            if (this.getClanHall().getOwnerId() == 0) {
                                player.sendMessage("This clan hall has no owner, you cannot change the configuration.");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("curtains_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "deco curtains 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("fixtures_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel.htm");
                                html.replace("%apply%", "deco fixtures 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_curtains")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Curtains (Decoration)");
                                int stage = Integer.parseInt(val);
                                int cost = stage == 1 ? Configuration.clanhall().getCurtainFunctionFeeLvl1() : Configuration.clanhall().getCurtainFunctionFeeLvl2();
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getCurtainFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "These curtains can be used to decorate the clan hall.");
                                html.replace("%apply%", "deco curtains " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_fixtures")) {
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply.htm");
                                html.replace("%name%", "Front Platform (Decoration)");
                                int stage = Integer.parseInt(val);
                                int cost = stage == 1 ? Configuration.clanhall().getFrontPlatformFunctionFeeLvl1() : Configuration.clanhall().getFrontPlatformFunctionFeeLvl2();
                                html.replace("%cost%", cost + "</font>Adena /" + Configuration.clanhall().getFrontPlatformFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace("%use%", "Used to decorate the clan hall.");
                                html.replace("%apply%", "deco fixtures " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("curtains")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Deco curtains editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(8) != null && this.getClanHall().getFunction(8).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Configuration.clanhall().getCurtainFunctionFeeLvl1();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getCurtainFunctionFeeLvl2();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 8, lvl, fee, Configuration.clanhall().getCurtainFunctionFeeRatio(), this.getClanHall().getFunction(8) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("fixtures")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Configuration.general().debug()) {
                                        LOG.debug("Deco fixtures editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-apply_confirmed.htm");
                                    if (this.getClanHall().getFunction(7) != null && this.getClanHall().getFunction(7).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-used.htm");
                                        html.replace("%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Configuration.clanhall().getFrontPlatformFunctionFeeLvl1();
                                            break;
                                        }
                                        default: {
                                            fee = Configuration.clanhall().getFrontPlatformFunctionFeeLvl2();
                                        }
                                    }
                                    if (!this.getClanHall().updateFunctions(player, 7, lvl, fee, Configuration.clanhall().getFrontPlatformFunctionFeeRatio(), this.getClanHall().getFunction(7) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.revalidateDeco(player);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/deco.htm");
                        String curtains = "[<a action=\"bypass -h npc_%objectId%_manage deco edit_curtains 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage deco edit_curtains 2\">Level 2</a>]";
                        String fixtures = "[<a action=\"bypass -h npc_%objectId%_manage deco edit_fixtures 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage deco edit_fixtures 2\">Level 2</a>]";
                        if (this.getClanHall().getFunction(8) != null) {
                            html.replace("%curtain%", "Stage " + this.getClanHall().getFunction(8).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(8).getLease() + "</font>Adena /" + Configuration.clanhall().getCurtainFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%curtain_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(8).getEndTime()));
                            html.replace("%change_curtain%", "[<a action=\"bypass -h npc_%objectId%_manage deco curtains_cancel\">Deactivate</a>]" + curtains);
                        } else {
                            html.replace("%curtain%", "none");
                            html.replace("%curtain_period%", "none");
                            html.replace("%change_curtain%", curtains);
                        }
                        if (this.getClanHall().getFunction(7) != null) {
                            html.replace("%fixture%", "Stage " + this.getClanHall().getFunction(7).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getClanHall().getFunction(7).getLease() + "</font>Adena /" + Configuration.clanhall().getFrontPlatformFunctionFeeRatio() / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace("%fixture_period%", "Withdraw the fee for the next time at " + format.format(this.getClanHall().getFunction(7).getEndTime()));
                            html.replace("%change_fixture%", "[<a action=\"bypass -h npc_%objectId%_manage deco fixtures_cancel\">Deactivate</a>]" + fixtures);
                        } else {
                            html.replace("%fixture%", "none");
                            html.replace("%fixture_period%", "none");
                            html.replace("%change_fixture%", fixtures);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("back")) {
                        this.showChatWindow(player);
                    } else {
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), this.getClanHall().isSiegableHall() ? "data/html/clanHallManager/manage_siegable.htm" : "data/html/clanHallManager/manage.htm");
                        this.sendHtmlMessage(player, html);
                    }
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/not_authorized.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("support")) {
                if (player.isCursedWeaponEquipped()) {
                    player.sendMessage("The wielder of a cursed weapon cannot receive outside heals or buffs");
                    return;
                }
                this.setTarget(player);
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int skill_id = Integer.parseInt(val);
                    try {
                        Skill skill;
                        int skill_lvl = 0;
                        if (st.countTokens() >= 1) {
                            skill_lvl = Integer.parseInt(st.nextToken());
                        }
                        if ((skill = SkillData.getInstance().getSkill(skill_id, skill_lvl)).hasEffectType(L2EffectType.SUMMON, new L2EffectType[0])) {
                            player.doSimultaneousCast(skill);
                        } else {
                            int mpCost = skill.getMpConsume1() + skill.getMpConsume2();
                            if (this.getCurrentMp() >= (double)mpCost || Configuration.clanhall().mpBuffFree()) {
                                this.doCast(skill);
                            } else {
                                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support-no_mana.htm");
                                html.replace("%mp%", String.valueOf((int)this.getCurrentMp()));
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                        }
                        if (this.getClanHall().getFunction(6) == null) {
                            return;
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        if (this.getClanHall().getFunction(6).getLvl() == 0) {
                            return;
                        }
                        html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support-done.htm");
                        html.replace("%mp%", String.valueOf((int)this.getCurrentMp()));
                        this.sendHtmlMessage(player, html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid skill level, contact your admin!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid skill level, contact your admin!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("list_back")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                Object file = "data/html/clanHallManager/chamberlain-" + this.getId() + ".htm";
                if (!HtmCache.getInstance().isLoadable((String)file)) {
                    file = "data/html/clanHallManager/chamberlain.htm";
                }
                html.setFile(player.getHtmlPrefix(), (String)file);
                html.replace("%objectId%", String.valueOf(this.getObjectId()));
                html.replace("%npcname%", this.getName());
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("support_back")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if (this.getClanHall().getFunction(6).getLvl() == 0) {
                    return;
                }
                html.setFile(player.getHtmlPrefix(), "data/html/clanHallManager/support" + this.getClanHall().getFunction(6).getLvl() + ".htm");
                html.replace("%mp%", String.valueOf((int)this.getStatus().getCurrentMp()));
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("goto")) {
                int whereTo = Integer.parseInt(val);
                this.doTeleport(player, whereTo);
                return;
            }
        }
        super.onBypassFeedback(player, command);
    }

    private void sendHtmlMessage(L2PcInstance player, NpcHtmlMessage html) {
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcId%", String.valueOf(this.getId()));
        player.sendPacket(html);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        Object filename = "data/html/clanHallManager/chamberlain-no.htm";
        int condition = this.validateCondition(player);
        if (condition == 3) {
            filename = "data/html/clanHallManager/chamberlain-" + this.getId() + ".htm";
            if (!HtmCache.getInstance().isLoadable((String)filename)) {
                filename = "data/html/clanHallManager/chamberlain.htm";
            }
        } else if (condition == 0) {
            filename = "data/html/clanHallManager/chamberlain-of.htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), (String)filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcId%", String.valueOf(this.getId()));
        player.sendPacket(html);
    }

    protected int validateCondition(L2PcInstance player) {
        if (this.getClanHall() == null) {
            return 1;
        }
        if (player.canOverrideCond(PcCondOverride.CLANHALL_CONDITIONS)) {
            return 3;
        }
        if (player.getClan() != null) {
            if (this.getClanHall().getOwnerId() == player.getClanId()) {
                return 3;
            }
            return 0;
        }
        return 1;
    }

    public final ClanHall getClanHall() {
        if (this._clanHallId < 0) {
            ClanHall temp = ClanHallManager.getInstance().getNearbyClanHall(this.getX(), this.getY(), 500);
            if (temp == null) {
                temp = ClanHallSiegeManager.getInstance().getNearbyClanHall(this);
            }
            if (temp != null) {
                this._clanHallId = temp.getId();
            }
            if (this._clanHallId < 0) {
                return null;
            }
        }
        return ClanHallManager.getInstance().getClanHallById(this._clanHallId);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list;
        if (Configuration.general().debug()) {
            LOG.debug("doTeleport(L2PcInstance player, int val) is called");
        }
        if ((list = TeleportLocationTable.getInstance().getTemplate(val)) != null) {
            if (player.isCombatFlagEquipped()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_TELEPORT_WHILE_IN_POSSESSION_OF_A_WARD);
                return;
            }
            if (player.destroyItemByItemId("Teleport", list.getItemId(), list.getPrice(), this, true)) {
                if (Configuration.general().debug()) {
                    LOG.debug("Teleporting player {} for CH to new location: {}, {}, {}" + list.getLocZ(), player, list.getLocX(), list.getLocY(), list.getLocZ());
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ());
            }
        } else {
            LOG.warn("No teleport destination with id: {}", (Object)val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private void revalidateDeco(L2PcInstance player) {
        AuctionableHall ch = ClanHallManager.getInstance().getClanHallByOwner(player.getClan());
        if (ch == null) {
            return;
        }
        AgitDecoInfo bl = new AgitDecoInfo(ch);
        player.sendPacket(bl);
    }
}

