/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExColosseumFenceInfo;
import java.awt.Rectangle;

public final class L2ColosseumFence
extends L2Object {
    private final int _minZ;
    private final int _maxZ;
    private final FenceState _state;
    private final Rectangle _bounds;

    private L2ColosseumFence(int objectId, int instanceId, int x, int y, int z, int minZ, int maxZ, int width, int height, FenceState state) {
        super(objectId);
        this.setInstanceId(instanceId);
        this.setXYZ(x, y, z);
        this._minZ = minZ;
        this._maxZ = maxZ;
        this._state = state;
        this._bounds = new Rectangle(x - width / 2, y - height / 2, width, height);
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new ExColosseumFenceInfo(this));
    }

    public int getFenceX() {
        return this._bounds.x;
    }

    public int getFenceY() {
        return this._bounds.y;
    }

    public int getFenceMinZ() {
        return this._minZ;
    }

    public int getFenceMaxZ() {
        return this._maxZ;
    }

    public int getFenceWidth() {
        return this._bounds.width;
    }

    public int getFenceHeight() {
        return this._bounds.height;
    }

    public FenceState getFenceState() {
        return this._state;
    }

    @Override
    public int getId() {
        return this.getObjectId();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public boolean isInsideFence(int x, int y, int z) {
        return x >= this._bounds.x && y >= this._bounds.y && z >= this._minZ && z <= this._maxZ && x <= this._bounds.x + this._bounds.width && y <= this._bounds.y + this._bounds.height;
    }

    public static enum FenceState {
        HIDDEN,
        OPEN,
        CLOSED;

    }
}

