/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Evolve;

public class L2PetManagerInstance
extends L2MerchantInstance {
    public L2PetManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2PetManagerInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        String pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/petmanager/" + pom + ".htm";
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        Object filename = "data/html/petmanager/" + this.getId() + ".htm";
        if (this.getId() == 36478 && player.hasSummon()) {
            filename = "data/html/petmanager/restore-unsummonpet.htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), (String)filename);
        if (Configuration.general().allowRentPet() && Configuration.npc().getPetRentNPCs().contains(this.getId())) {
            html.replace("_Quest", "_RentPet\">Rent Pet</a><br><a action=\"bypass -h npc_%objectId%_Quest");
        }
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcname%", this.getName());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("exchange")) {
            String[] params = command.split(" ");
            int val = Integer.parseInt(params[1]);
            switch (val) {
                case 1: {
                    this.exchange(player, 7585, 6650);
                    break;
                }
                case 2: {
                    this.exchange(player, 7583, 6648);
                    break;
                }
                case 3: {
                    this.exchange(player, 7584, 6649);
                }
            }
        } else if (command.startsWith("evolve")) {
            boolean ok;
            String[] params = command.split(" ");
            int val = Integer.parseInt(params[1]);
            switch (val) {
                case 1: {
                    boolean bl = Evolve.doEvolve(player, this, 2375, 9882, 55);
                    break;
                }
                case 2: {
                    boolean bl = Evolve.doEvolve(player, this, 9882, 10426, 70);
                    break;
                }
                case 3: {
                    boolean bl = Evolve.doEvolve(player, this, 6648, 10311, 55);
                    break;
                }
                case 4: {
                    boolean bl = Evolve.doEvolve(player, this, 6650, 10313, 55);
                    break;
                }
                case 5: {
                    boolean bl = Evolve.doEvolve(player, this, 6649, 10312, 55);
                    break;
                }
                default: {
                    boolean bl = ok = false;
                }
            }
            if (!ok) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/petmanager/evolve_no.htm");
                player.sendPacket(html);
            }
        } else if (command.startsWith("restore")) {
            boolean ok;
            String[] params = command.split(" ");
            int val = Integer.parseInt(params[1]);
            switch (val) {
                case 1: {
                    boolean bl = Evolve.doRestore(player, this, 10307, 9882, 55);
                    break;
                }
                case 2: {
                    boolean bl = Evolve.doRestore(player, this, 10611, 10426, 70);
                    break;
                }
                case 3: {
                    boolean bl = Evolve.doRestore(player, this, 10308, 4422, 55);
                    break;
                }
                case 4: {
                    boolean bl = Evolve.doRestore(player, this, 10309, 4423, 55);
                    break;
                }
                case 5: {
                    boolean bl = Evolve.doRestore(player, this, 10310, 4424, 55);
                    break;
                }
                default: {
                    boolean bl = ok = false;
                }
            }
            if (!ok) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/petmanager/restore_no.htm");
                player.sendPacket(html);
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public final void exchange(L2PcInstance player, int itemIdtake, int itemIdgive) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (player.destroyItemByItemId("Consume", itemIdtake, 1L, this, true)) {
            player.addItem("", itemIdgive, 1L, this, true);
            html.setFile(player.getHtmlPrefix(), "data/html/petmanager/" + this.getId() + ".htm");
            player.sendPacket(html);
        } else {
            html.setFile(player.getHtmlPrefix(), "data/html/petmanager/exchange_no.htm");
            player.sendPacket(html);
        }
    }
}

