/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.util.Util;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectKnownList {
    private final L2Object _activeObject;
    private volatile Map<Integer, L2Object> _knownObjects;

    public ObjectKnownList(L2Object activeObject) {
        this._activeObject = activeObject;
    }

    public boolean addKnownObject(L2Object object) {
        if (object == null) {
            return false;
        }
        if (this.getActiveObject().getInstanceId() != -1 && object.getInstanceId() != this.getActiveObject().getInstanceId()) {
            return false;
        }
        if (object.isPlayer() && object.getActingPlayer().getAppearance().isGhost()) {
            return false;
        }
        if (this.knowsObject(object)) {
            return false;
        }
        if (!Util.checkIfInShortRadius(this.getDistanceToWatchObject(object), this.getActiveObject(), object, true)) {
            return false;
        }
        return this.getKnownObjects().put(object.getObjectId(), object) == null;
    }

    public final boolean knowsObject(L2Object object) {
        if (object == null) {
            return false;
        }
        return this.getActiveObject() == object || this.getKnownObjects().containsKey(object.getObjectId());
    }

    public void removeAllKnownObjects() {
        this.getKnownObjects().clear();
    }

    public final boolean removeKnownObject(L2Object object) {
        return this.removeKnownObject(object, false);
    }

    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (object == null) {
            return false;
        }
        if (forget) {
            return true;
        }
        return this.getKnownObjects().remove(object.getObjectId()) != null;
    }

    public final void findObjects() {
        block6: {
            L2WorldRegion worldRegion;
            block5: {
                worldRegion = this.getActiveObject().getWorldRegion();
                if (worldRegion == null) {
                    return;
                }
                if (!this.getActiveObject().isPlayable()) break block5;
                for (L2WorldRegion surroundingRegion : worldRegion.getSurroundingRegions()) {
                    for (L2Object l2Object : surroundingRegion.getVisibleObjects().values()) {
                        if (l2Object == this.getActiveObject()) continue;
                        this.addKnownObject(l2Object);
                        if (!(l2Object instanceof L2Character)) continue;
                        l2Object.getKnownList().addKnownObject(this.getActiveObject());
                    }
                }
                break block6;
            }
            if (!(this.getActiveObject() instanceof L2Character)) break block6;
            for (L2WorldRegion surroundingRegion : worldRegion.getSurroundingRegions()) {
                if (!surroundingRegion.isActive()) continue;
                for (L2Object l2Object : surroundingRegion.getVisiblePlayable().values()) {
                    if (l2Object == this.getActiveObject()) continue;
                    this.addKnownObject(l2Object);
                }
            }
        }
    }

    public void forgetObjects(boolean fullCheck) {
        Iterator<L2Object> oIter = this.getKnownObjects().values().iterator();
        while (oIter.hasNext()) {
            L2Object object = oIter.next();
            if (!fullCheck && !object.isPlayable() || object.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(object), this.getActiveObject(), object, true)) continue;
            oIter.remove();
            this.removeKnownObject(object, true);
        }
    }

    public L2Object getActiveObject() {
        return this._activeObject;
    }

    public int getDistanceToForgetObject(L2Object object) {
        return 0;
    }

    public int getDistanceToWatchObject(L2Object object) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Integer, L2Object> getKnownObjects() {
        if (this._knownObjects == null) {
            ObjectKnownList objectKnownList = this;
            synchronized (objectKnownList) {
                if (this._knownObjects == null) {
                    this._knownObjects = new ConcurrentHashMap<Integer, L2Object>();
                }
            }
        }
        return this._knownObjects;
    }
}

