/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.status;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.stats.Formulas;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharStatus {
    protected static final Logger LOG = LoggerFactory.getLogger(CharStatus.class);
    private final L2Character _activeChar;
    private double _currentHp = 0.0;
    private double _currentMp = 0.0;
    private Set<L2Character> _statusListener;
    private Future<?> _regTask;
    protected byte _flagsRegenActive = 0;
    protected static final byte REGEN_FLAG_CP = 4;
    private static final byte REGEN_FLAG_HP = 1;
    private static final byte REGEN_FLAG_MP = 2;

    public CharStatus(L2Character activeChar) {
        this._activeChar = activeChar;
    }

    public final void addStatusListener(L2Character object) {
        if (object == this.getActiveChar()) {
            return;
        }
        this.getStatusListener().add(object);
    }

    public final void removeStatusListener(L2Character object) {
        this.getStatusListener().remove(object);
    }

    public final Set<L2Character> getStatusListener() {
        if (this._statusListener == null) {
            this._statusListener = ConcurrentHashMap.newKeySet();
        }
        return this._statusListener;
    }

    public void reduceCp(int value) {
    }

    public void reduceHp(double value, L2Character attacker) {
        this.reduceHp(value, attacker, true, false, false);
    }

    public void reduceHp(double value, L2Character attacker, boolean isHpConsumption) {
        this.reduceHp(value, attacker, true, false, isHpConsumption);
    }

    public void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHPConsumption) {
        L2PcInstance attackerPlayer;
        if (this.getActiveChar().isDead()) {
            return;
        }
        if ((this.getActiveChar().isInvul() || this.getActiveChar().isHpBlocked()) && !isDOT && !isHPConsumption) {
            return;
        }
        if (attacker != null && (attackerPlayer = attacker.getActingPlayer()) != null && attackerPlayer.isGM() && !attackerPlayer.getAccessLevel().canGiveDamage()) {
            return;
        }
        if (!isDOT && !isHPConsumption) {
            this.getActiveChar().stopEffectsOnDamage(awake);
            if (this.getActiveChar().isStunned() && Rnd.get((int)10) == 0) {
                this.getActiveChar().stopStunning(true);
            }
        }
        if (value > 0.0) {
            this.setCurrentHp(Math.max(this.getCurrentHp() - value, 0.0));
        }
        if (this.getActiveChar().getCurrentHp() < 0.5 && this.getActiveChar().isMortal()) {
            this.getActiveChar().abortAttack();
            this.getActiveChar().abortCast();
            if (Configuration.general().debug()) {
                LOG.debug("char is dead.");
            }
            this.getActiveChar().doDie(attacker);
        }
    }

    public void reduceMp(double value) {
        this.setCurrentMp(Math.max(this.getCurrentMp() - value, 0.0));
    }

    public final synchronized void startHpMpRegeneration() {
        if (this._regTask == null && !this.getActiveChar().isDead()) {
            if (Configuration.general().debug()) {
                LOG.debug("HP/MP regen started");
            }
            int period = Formulas.getRegeneratePeriod(this.getActiveChar());
            this._regTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new RegenTask(), period, period);
        }
    }

    public final synchronized void stopHpMpRegeneration() {
        if (this._regTask != null) {
            if (Configuration.general().debug()) {
                LOG.debug("HP/MP regen stop");
            }
            this._regTask.cancel(false);
            this._regTask = null;
            this._flagsRegenActive = 0;
        }
    }

    public double getCurrentCp() {
        return 0.0;
    }

    public void setCurrentCp(double newCp) {
    }

    public final double getCurrentHp() {
        return this._currentHp;
    }

    public final void setCurrentHp(double newHp) {
        this.setCurrentHp(newHp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentHp(double newHp, boolean broadcastPacket) {
        boolean hpWasChanged;
        int currentHp = (int)this.getCurrentHp();
        double maxHp = this.getActiveChar().getMaxHp();
        CharStatus charStatus = this;
        synchronized (charStatus) {
            if (this.getActiveChar().isDead()) {
                return false;
            }
            if (newHp >= maxHp) {
                this._currentHp = maxHp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive & 0xFFFFFFFE);
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentHp = newHp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive | 1);
                this.startHpMpRegeneration();
            }
        }
        boolean bl = hpWasChanged = (double)currentHp != this._currentHp;
        if (hpWasChanged && broadcastPacket) {
            this.getActiveChar().broadcastStatusUpdate();
        }
        return hpWasChanged;
    }

    public final void setCurrentHpMp(double newHp, double newMp) {
        boolean hpOrMpWasChanged = this.setCurrentHp(newHp, false);
        if (hpOrMpWasChanged |= this.setCurrentMp(newMp, false)) {
            this.getActiveChar().broadcastStatusUpdate();
        }
    }

    public final double getCurrentMp() {
        return this._currentMp;
    }

    public final void setCurrentMp(double newMp) {
        this.setCurrentMp(newMp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setCurrentMp(double newMp, boolean broadcastPacket) {
        boolean mpWasChanged;
        int currentMp = (int)this.getCurrentMp();
        int maxMp = this.getActiveChar().getMaxMp();
        CharStatus charStatus = this;
        synchronized (charStatus) {
            if (this.getActiveChar().isDead()) {
                return false;
            }
            if (newMp >= (double)maxMp) {
                this._currentMp = maxMp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive & 0xFFFFFFFD);
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentMp = newMp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive | 2);
                this.startHpMpRegeneration();
            }
        }
        boolean bl = mpWasChanged = (double)currentMp != this._currentMp;
        if (mpWasChanged && broadcastPacket) {
            this.getActiveChar().broadcastStatusUpdate();
        }
        return mpWasChanged;
    }

    protected void doRegeneration() {
        if (this.getCurrentHp() < (double)this.getActiveChar().getMaxRecoverableHp()) {
            this.setCurrentHp(this.getCurrentHp() + Formulas.calcHpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentMp() < (double)this.getActiveChar().getMaxRecoverableMp()) {
            this.setCurrentMp(this.getCurrentMp() + Formulas.calcMpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentHp() >= (double)this.getActiveChar().getMaxRecoverableHp() && this.getCurrentMp() >= (double)this.getActiveChar().getMaxMp()) {
            this.stopHpMpRegeneration();
        }
        if (this.getActiveChar().isInActiveRegion()) {
            this.getActiveChar().broadcastStatusUpdate();
        }
    }

    public L2Character getActiveChar() {
        return this._activeChar;
    }

    class RegenTask
    implements Runnable {
        RegenTask() {
        }

        @Override
        public void run() {
            try {
                CharStatus.this.doRegeneration();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }
}

