/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.player;

import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetFeedTask
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(PetFeedTask.class);
    private final L2PcInstance _player;

    public PetFeedTask(L2PcInstance player) {
        this._player = player;
    }

    @Override
    public void run() {
        try {
            IItemHandler handler;
            if (!this._player.isMounted() || this._player.getMountNpcId() == 0 || PetDataTable.getInstance().getPetData(this._player.getMountNpcId()) == null) {
                this._player.stopFeed();
                return;
            }
            if (this._player.getCurrentFeed() <= this._player.getFeedConsume()) {
                this._player.setCurrentFeed(0);
                this._player.stopFeed();
                this._player.dismount();
                this._player.sendPacket(SystemMessageId.OUT_OF_FEED_MOUNT_CANCELED);
                return;
            }
            this._player.setCurrentFeed(this._player.getCurrentFeed() - this._player.getFeedConsume());
            List<Integer> foodIds = PetDataTable.getInstance().getPetData(this._player.getMountNpcId()).getFood();
            if (foodIds.isEmpty()) {
                return;
            }
            L2ItemInstance food = null;
            for (int id : foodIds) {
                food = this._player.getInventory().getItemByItemId(id);
                if (food == null) continue;
                break;
            }
            if (food != null && this._player.isHungry() && (handler = ItemHandler.getInstance().getHandler(food.getEtcItem())) != null) {
                handler.useItem(this._player, food, false);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY);
                sm.addItemName(food.getId());
                this._player.sendPacket(sm);
            }
        }
        catch (Exception e) {
            _log.error("Could not feed mounted Pet NPC ID {}, a feed task error has occurred", (Object)this._player.getMountNpcId(), (Object)e);
        }
    }
}

