/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.templates;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.enums.AIType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.enums.Sex;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class L2NpcTemplate
extends L2CharTemplate
implements IIdentifiable {
    private int _id;
    private int _displayId;
    private byte _level;
    private String _type;
    private String _name;
    private boolean _usingServerSideName;
    private String _title;
    private boolean _usingServerSideTitle;
    private StatsSet _parameters;
    private Sex _sex;
    private int _chestId;
    private int _rhandId;
    private int _lhandId;
    private int _weaponEnchant;
    private double _expRate;
    private double _sp;
    private double _raidPoints;
    private boolean _unique;
    private boolean _attackable;
    private boolean _targetable;
    private boolean _undying;
    private boolean _showName;
    private boolean _flying;
    private boolean _canMove;
    private boolean _noSleepMode;
    private boolean _passableDoor;
    private boolean _hasSummoner;
    private boolean _canBeSown;
    private int _corpseTime;
    private AIType _aiType;
    private int _aggroRange;
    private int _clanHelpRange;
    private boolean _isChaos;
    private boolean _isAggressive;
    private int _soulShot;
    private int _spiritShot;
    private int _soulShotChance;
    private int _spiritShotChance;
    private int _minSkillChance;
    private int _maxSkillChance;
    private Map<Integer, Skill> _skills;
    private Map<AISkillScope, List<Skill>> _aiSkillLists;
    private Set<Integer> _clans;
    private Set<Integer> _ignoreClanNpcIds;
    private Map<DropListScope, List<IDropItem>> _dropLists;
    private double _collisionRadiusGrown;
    private double _collisionHeightGrown;

    public L2NpcTemplate(StatsSet set) {
        super(set);
    }

    @Override
    public void set(StatsSet set) {
        super.set(set);
        this._id = set.getInt("id");
        this._displayId = set.getInt("displayId", this._id);
        this._level = set.getByte("level", (byte)70);
        this._type = set.getString("type", "L2Npc");
        this._name = set.getString("name", "");
        this._usingServerSideName = set.getBoolean("usingServerSideName", false);
        this._title = set.getString("title", "");
        this._usingServerSideTitle = set.getBoolean("usingServerSideTitle", false);
        this.setRace(set.getEnum("race", Race.class, Race.NONE));
        this._sex = set.getEnum("sex", Sex.class, Sex.ETC);
        this._chestId = set.getInt("chestId", 0);
        this._rhandId = set.getInt("rhandId", 0);
        this._lhandId = set.getInt("lhandId", 0);
        this._weaponEnchant = set.getInt("weaponEnchant", 0);
        this._expRate = set.getDouble("expRate", 0.0);
        this._sp = set.getDouble("sp", 0.0);
        this._raidPoints = set.getDouble("raidPoints", 0.0);
        this._unique = set.getBoolean("unique", false);
        this._attackable = set.getBoolean("attackable", true);
        this._targetable = set.getBoolean("targetable", true);
        this._undying = set.getBoolean("undying", true);
        this._showName = set.getBoolean("showName", true);
        this._flying = set.getBoolean("flying", false);
        this._canMove = set.getBoolean("canMove", true);
        this._noSleepMode = set.getBoolean("noSleepMode", false);
        this._passableDoor = set.getBoolean("passableDoor", false);
        this._hasSummoner = set.getBoolean("hasSummoner", false);
        this._canBeSown = set.getBoolean("canBeSown", false);
        this._corpseTime = set.getInt("corpseTime", Configuration.npc().getDefaultCorpseTime());
        this._aiType = set.getEnum("aiType", AIType.class, AIType.FIGHTER);
        this._aggroRange = set.getInt("aggroRange", 0);
        this._clanHelpRange = set.getInt("clanHelpRange", 0);
        this._isChaos = set.getBoolean("isChaos", false);
        this._isAggressive = set.getBoolean("isAggressive", true);
        this._soulShot = set.getInt("soulShot", 0);
        this._spiritShot = set.getInt("spiritShot", 0);
        this._soulShotChance = set.getInt("shotShotChance", 0);
        this._spiritShotChance = set.getInt("spiritShotChance", 0);
        this._minSkillChance = set.getInt("minSkillChance", 7);
        this._maxSkillChance = set.getInt("maxSkillChance", 15);
        this._collisionRadiusGrown = set.getDouble("collisionRadiusGrown", 0.0);
        this._collisionHeightGrown = set.getDouble("collisionHeightGrown", 0.0);
    }

    @Override
    public int getId() {
        return this._id;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public byte getLevel() {
        return this._level;
    }

    public String getType() {
        return this._type;
    }

    public boolean isType(String type) {
        return this.getType().equalsIgnoreCase(type);
    }

    public String getName() {
        return this._name;
    }

    public boolean isUsingServerSideName() {
        return this._usingServerSideName;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isUsingServerSideTitle() {
        return this._usingServerSideTitle;
    }

    public StatsSet getParameters() {
        return this._parameters;
    }

    public void setParameters(StatsSet set) {
        this._parameters = set;
    }

    public Sex getSex() {
        return this._sex;
    }

    public int getChestId() {
        return this._chestId;
    }

    public int getRHandId() {
        return this._rhandId;
    }

    public int getLHandId() {
        return this._lhandId;
    }

    public int getWeaponEnchant() {
        return this._weaponEnchant;
    }

    public double getExpRate() {
        return this._expRate;
    }

    public double getSP() {
        return this._sp;
    }

    public double getRaidPoints() {
        return this._raidPoints;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public boolean isAttackable() {
        return this._attackable;
    }

    public boolean isTargetable() {
        return this._targetable;
    }

    public boolean isUndying() {
        return this._undying;
    }

    public boolean isShowName() {
        return this._showName;
    }

    public boolean isFlying() {
        return this._flying;
    }

    public boolean canMove() {
        return this._canMove;
    }

    public boolean isNoSleepMode() {
        return this._noSleepMode;
    }

    public boolean isPassableDoor() {
        return this._passableDoor;
    }

    public boolean hasSummoner() {
        return this._hasSummoner;
    }

    public boolean canBeSown() {
        return this._canBeSown;
    }

    public int getCorpseTime() {
        return this._corpseTime;
    }

    public AIType getAIType() {
        return this._aiType;
    }

    public int getAggroRange() {
        return this._aggroRange;
    }

    public int getClanHelpRange() {
        return this._clanHelpRange;
    }

    public boolean isChaos() {
        return this._isChaos;
    }

    public boolean isAggressive() {
        return this._isAggressive;
    }

    public int getSoulShot() {
        return this._soulShot;
    }

    public int getSpiritShot() {
        return this._spiritShot;
    }

    public int getSoulShotChance() {
        return this._soulShotChance;
    }

    public int getSpiritShotChance() {
        return this._spiritShotChance;
    }

    public int getMinSkillChance() {
        return this._minSkillChance;
    }

    public int getMaxSkillChance() {
        return this._maxSkillChance;
    }

    @Override
    public Map<Integer, Skill> getSkills() {
        return this._skills;
    }

    public void setSkills(Map<Integer, Skill> skills) {
        this._skills = skills != null ? Collections.unmodifiableMap(skills) : Collections.emptyMap();
    }

    public List<Skill> getAISkills(AISkillScope aiSkillScope) {
        return this._aiSkillLists.getOrDefault((Object)aiSkillScope, Collections.emptyList());
    }

    public void setAISkillLists(Map<AISkillScope, List<Skill>> aiSkillLists) {
        this._aiSkillLists = aiSkillLists != null ? Collections.unmodifiableMap(aiSkillLists) : Collections.emptyMap();
    }

    public Set<Integer> getClans() {
        return this._clans;
    }

    public void setClans(Set<Integer> clans) {
        this._clans = clans != null ? Collections.unmodifiableSet(clans) : null;
    }

    public boolean isClan(String clanName, String ... clanNames) {
        Set<Integer> clans = this._clans;
        if (clans == null) {
            return false;
        }
        int clanId = NpcData.getInstance().getClanId("ALL");
        if (clans.contains(clanId)) {
            return true;
        }
        clanId = NpcData.getInstance().getClanId(clanName);
        if (clans.contains(clanId)) {
            return true;
        }
        for (String name : clanNames) {
            clanId = NpcData.getInstance().getClanId(name);
            if (!clans.contains(clanId)) continue;
            return true;
        }
        return false;
    }

    public boolean isClan(Set<Integer> clans) {
        Set<Integer> clanSet = this._clans;
        if (clanSet == null || clans == null) {
            return false;
        }
        int clanId = NpcData.getInstance().getClanId("ALL");
        if (clanSet.contains(clanId)) {
            return true;
        }
        for (Integer id : clans) {
            if (!clanSet.contains(id)) continue;
            return true;
        }
        return false;
    }

    public Set<Integer> getIgnoreClanNpcIds() {
        return this._ignoreClanNpcIds;
    }

    public void setIgnoreClanNpcIds(Set<Integer> ignoreClanNpcIds) {
        this._ignoreClanNpcIds = ignoreClanNpcIds != null ? Collections.unmodifiableSet(ignoreClanNpcIds) : null;
    }

    public Map<DropListScope, List<IDropItem>> getDropLists() {
        return this._dropLists;
    }

    public void setDropLists(Map<DropListScope, List<IDropItem>> dropLists) {
        this._dropLists = dropLists != null ? Collections.unmodifiableMap(dropLists) : null;
    }

    public List<IDropItem> getDropList(DropListScope dropListScope) {
        Map<DropListScope, List<IDropItem>> dropLists = this._dropLists;
        return dropLists != null ? dropLists.get(dropListScope) : null;
    }

    public Collection<ItemHolder> calculateDrops(DropListScope dropListScope, L2Character victim, L2Character killer) {
        List<IDropItem> dropList = this.getDropList(dropListScope);
        if (dropList == null) {
            return null;
        }
        LinkedList<ItemHolder> calculatedDrops = null;
        for (IDropItem dropItem : dropList) {
            List<ItemHolder> drops = dropItem.calculateDrops(victim, killer);
            if (drops == null || drops.isEmpty()) continue;
            if (calculatedDrops == null) {
                calculatedDrops = new LinkedList<ItemHolder>();
            }
            calculatedDrops.addAll(drops);
        }
        return calculatedDrops;
    }

    public double getCollisionRadiusGrown() {
        return this._collisionRadiusGrown;
    }

    public double getCollisionHeightGrown() {
        return this._collisionHeightGrown;
    }

    public String toString() {
        return this.getName() + " [" + this.getId() + "]";
    }
}

