/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.cleft;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.cleft.CleftTeam;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class CleftParticipant {
    private volatile L2PcInstance _player;
    private volatile CleftTeam _team;
    private final AtomicInteger _kills;
    private final AtomicInteger _deaths;
    private final AtomicInteger _towers;

    public CleftParticipant(L2PcInstance player, CleftTeam team) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(team);
        this._player = player;
        this._team = team;
        this._kills = new AtomicInteger(0);
        this._deaths = new AtomicInteger(0);
        this._towers = new AtomicInteger(0);
    }

    public CleftParticipant(L2PcInstance player, CleftTeam team, int kills, int deaths, int towers) {
        this(player, team);
        this._kills.set(kills);
        this._deaths.set(deaths);
        this._towers.set(towers);
    }

    public void setPlayer(L2PcInstance player) {
        Objects.requireNonNull(player);
        this._player = player;
    }

    public void setTeam(CleftTeam team) {
        Objects.requireNonNull(team);
        this._team = team;
    }

    public int addKill() {
        return this._kills.incrementAndGet();
    }

    public int addDeath() {
        return this._deaths.incrementAndGet();
    }

    public int addTower() {
        return this._towers.incrementAndGet();
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public CleftTeam getTeam() {
        return this._team;
    }

    public int getKills() {
        return this._kills.get();
    }

    public int getDeaths() {
        return this._deaths.get();
    }

    public int getTowers() {
        return this._towers.get();
    }
}

