/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class ConditionPlayerCanCreateBase
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanCreateBase(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effector == null || !effector.isPlayer()) {
            return !this._val;
        }
        L2PcInstance player = effector.getActingPlayer();
        boolean canCreateBase = true;
        if (player.isAlikeDead() || player.isCursedWeaponEquipped() || player.getClan() == null) {
            canCreateBase = false;
        }
        Castle castle = CastleManager.getInstance().getCastle(player);
        Fort fort = FortManager.getInstance().getFort(player);
        if (castle == null && fort == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            canCreateBase = false;
        } else if (castle != null && !castle.getSiege().isInProgress() || fort != null && !fort.getSiege().isInProgress()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            canCreateBase = false;
        } else if (castle != null && castle.getSiege().getAttackerClan(player.getClan()) == null || fort != null && fort.getSiege().getAttackerClan(player.getClan()) == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            canCreateBase = false;
        } else if (!player.isClanLeader()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            canCreateBase = false;
        } else if (castle != null && castle.getSiege().getAttackerClan(player.getClan()).getNumFlags() >= SiegeManager.getInstance().getFlagMaxCount() || fort != null && fort.getSiege().getAttackerClan(player.getClan()).getNumFlags() >= Configuration.fortSiege().getMaxFlags()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            canCreateBase = false;
        } else if (!player.isInsideZone(ZoneId.HQ)) {
            player.sendPacket(SystemMessageId.NOT_SET_UP_BASE_HERE);
            canCreateBase = false;
        }
        return this._val == canCreateBase;
    }
}

