/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import java.util.List;

public class ConditionPlayerCanSweep
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanSweep(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        boolean canSweep = false;
        L2PcInstance sweeper = effector.getActingPlayer();
        if (sweeper != null && skill != null) {
            List<L2Object> targets = skill.getTargets(sweeper);
            for (L2Object object : targets) {
                L2Attackable target;
                if (!object.isAttackable() || !(target = (L2Attackable)object).isDead()) continue;
                if (target.isSpoiled()) {
                    canSweep = target.checkSpoilOwner(sweeper, true);
                    canSweep &= !target.isOldCorpse(sweeper, Configuration.npc().getCorpseConsumeSkillAllowedTimeBeforeDecay(), true);
                    canSweep &= sweeper.getInventory().checkInventorySlotsAndWeight(target.getSpoilLootItems(), true, true);
                    continue;
                }
                sweeper.sendPacket(SystemMessageId.SWEEPER_FAILED_TARGET_NOT_SPOILED);
            }
        }
        return this._val == canSweep;
    }
}

