/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.instancezone.InstanceWorld;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.ArrayList;

public class ConditionPlayerInstanceId
extends Condition {
    private final ArrayList<Integer> _instanceIds;

    public ConditionPlayerInstanceId(ArrayList<Integer> instanceIds) {
        this._instanceIds = instanceIds;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (effector.getActingPlayer() == null) {
            return false;
        }
        int instanceId = effector.getInstanceId();
        if (instanceId <= 0) {
            return false;
        }
        InstanceWorld world = InstanceManager.getInstance().getPlayerWorld(effector.getActingPlayer());
        if (world == null || world.getInstanceId() != instanceId) {
            return false;
        }
        return this._instanceIds.contains(world.getTemplateId());
    }
}

