/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class ConditionTargetMyParty
extends Condition {
    private static final String EXCEPT_ME = "EXCEPT_ME";
    private final String type;

    public ConditionTargetMyParty(String type) {
        this.type = type;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        L2PcInstance player = effector.getActingPlayer();
        if (player == null) {
            return false;
        }
        if (EXCEPT_ME.equals(this.type) && player == effected) {
            effector.sendPacket(SystemMessageId.CANNOT_USE_ON_YOURSELF);
            return false;
        }
        if (player.isInParty()) {
            if (!player.isInPartyWith(effected)) {
                effector.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED).addSkillName(skill)));
                return false;
            }
        } else {
            L2PcInstance effectedPlayer = effected.getActingPlayer();
            if (player != effectedPlayer) {
                effector.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED).addSkillName(skill)));
                return false;
            }
        }
        return true;
    }
}

