/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops.strategy;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import java.util.List;

public interface IDropCalculationStrategy {
    public static final IDropCalculationStrategy DEFAULT_STRATEGY = (item, victim, killer) -> {
        double chance = item.getChance(victim, killer);
        if (chance > Rnd.nextDouble() * 100.0) {
            int amountMultiply = 1;
            if (item.isPreciseCalculated() && chance > 100.0) {
                amountMultiply = (int)chance / 100;
                if (chance % 100.0 > Rnd.nextDouble() * 100.0) {
                    ++amountMultiply;
                }
            }
            return List.of(new ItemHolder(item.getItemId(), Rnd.get((long)item.getMin(victim), (long)item.getMax(victim)) * (long)amountMultiply));
        }
        return null;
    };

    public List<ItemHolder> calculateDrops(GeneralDropItem var1, L2Character var2, L2Character var3);
}

