/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.FortUpdater;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.data.xml.impl.StaticObjectData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.enums.audio.Music;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.entity.AbstractResidence;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.zone.type.L2FortZone;
import com.l2jserver.gameserver.model.zone.type.L2SiegeZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Fort
extends AbstractResidence {
    private static final Logger LOG = LoggerFactory.getLogger(Fort.class);
    private final List<L2DoorInstance> _doors = new ArrayList<L2DoorInstance>();
    private L2StaticObjectInstance _flagPole = null;
    private volatile FortSiege _siege = null;
    private Calendar _siegeDate;
    private Calendar _lastOwnedTime;
    private L2SiegeZone _zone;
    private L2Clan _fortOwner = null;
    private int _fortType = 0;
    private int _state = 0;
    private int _castleId = 0;
    private int _supplyLvL = 0;
    private final Map<Integer, FortFunction> _function;
    private final ScheduledFuture<?>[] _FortUpdater = new ScheduledFuture[2];
    private boolean _isSuspiciousMerchantSpawned = false;
    private final List<L2Spawn> _siegeNpcs = new CopyOnWriteArrayList<L2Spawn>();
    private final List<L2Spawn> _npcCommanders = new CopyOnWriteArrayList<L2Spawn>();
    private final List<L2Spawn> _specialEnvoys = new CopyOnWriteArrayList<L2Spawn>();
    private final Map<Integer, Integer> _envoyCastles = new HashMap<Integer, Integer>(2);
    private final Set<Integer> _availableCastles = new HashSet<Integer>(1);
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_RESTORE_HP = 2;
    public static final int FUNC_RESTORE_MP = 3;
    public static final int FUNC_RESTORE_EXP = 4;
    public static final int FUNC_SUPPORT = 5;

    public Fort(int fortId) {
        super(fortId);
        this.load();
        this.loadFlagPoles();
        this._function = new ConcurrentHashMap<Integer, FortFunction>();
        if (this.getOwnerClan() != null) {
            this.setVisibleFlag(true);
            this.loadFunctions();
        }
        this.initResidenceZone();
        this.initNpcs();
        this.initSiegeNpcs();
        this.initNpcCommanders();
        this.spawnNpcCommanders();
        this.initSpecialEnvoys();
        if (this.getOwnerClan() != null && this.getFortState() == 0) {
            this.spawnSpecialEnvoys();
        }
    }

    public FortFunction getFunction(int type) {
        return this._function.get(type);
    }

    public void endOfSiege(L2Clan clan) {
        ThreadPoolManager.getInstance().executeAi(new EndFortressSiege(this, clan));
    }

    public void banishForeigners() {
        this.getResidenceZone().banishForeigners(this.getOwnerClan().getId());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getZone().isInsideZone(x, y, z);
    }

    public L2SiegeZone getZone() {
        if (this._zone == null) {
            for (L2SiegeZone zone : ZoneManager.getInstance().getAllZones(L2SiegeZone.class)) {
                if (zone.getSiegeObjectId() != this.getResidenceId()) continue;
                this._zone = zone;
                break;
            }
        }
        return this._zone;
    }

    @Override
    public L2FortZone getResidenceZone() {
        return (L2FortZone)super.getResidenceZone();
    }

    public double getDistance(L2Object obj) {
        return this.getZone().getDistanceToZone(obj);
    }

    public void closeDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, false);
    }

    public void openDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, true);
    }

    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar.getClan() != this.getOwnerClan()) {
            return;
        }
        L2DoorInstance door = this.getDoor(doorId);
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    public void removeUpgrade() {
        this.removeDoorUpgrade();
    }

    public boolean setOwner(L2Clan clan, boolean updateClansReputation) {
        if (clan == null) {
            LOG.warn("Updating Fort owner with null clan!!!");
            return false;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED);
        sm.addCastleId(this.getResidenceId());
        this.getSiege().announceToPlayer(sm);
        L2Clan oldowner = this.getOwnerClan();
        if (oldowner != null && clan != oldowner) {
            this.updateClansReputation(oldowner, true);
            try {
                L2PcInstance oldleader = oldowner.getLeader().getPlayerInstance();
                if (oldleader != null && oldleader.getMountType() == MountType.WYVERN) {
                    oldleader.dismount();
                }
            }
            catch (Exception e) {
                LOG.warn("Exception in setOwner: {}", (Object)e.getMessage(), (Object)e);
            }
            this.removeOwner(true);
        }
        this.setFortState(0, 0);
        if (clan.getCastleId() > 0) {
            this.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.NPCS_RECAPTURED_FORTRESS));
            return false;
        }
        if (updateClansReputation) {
            this.updateClansReputation(clan, false);
        }
        this.spawnSpecialEnvoys();
        if (clan.getFortId() > 0) {
            FortManager.getInstance().getFortByOwner(clan).removeOwner(true);
        }
        this.setSupplyLvL(0);
        this.setOwnerClan(clan);
        this.updateOwnerInDB();
        this.saveFortVariables();
        if (this.getSiege().isInProgress()) {
            this.getSiege().endSiege();
        }
        for (L2PcInstance member : clan.getOnlineMembers(0)) {
            this.giveResidentialSkills(member);
            member.sendSkillList();
        }
        return true;
    }

    public void removeOwner(boolean updateDB) {
        L2Clan clan = this.getOwnerClan();
        if (clan != null) {
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                this.removeResidentialSkills(member);
                member.sendSkillList();
            }
            clan.setFortId(0);
            clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
            this.setOwnerClan(null);
            this.setSupplyLvL(0);
            this.saveFortVariables();
            this.removeAllFunctions();
            if (updateDB) {
                this.updateOwnerInDB();
            }
        }
    }

    public void raiseSupplyLvL() {
        ++this._supplyLvL;
        if (this._supplyLvL > Configuration.fortress().getMaxSupplyLevel()) {
            this._supplyLvL = Configuration.fortress().getMaxSupplyLevel();
        }
    }

    public void setSupplyLvL(int val) {
        if (val <= Configuration.fortress().getMaxSupplyLevel()) {
            this._supplyLvL = val;
        }
    }

    public int getSupplyLvL() {
        return this._supplyLvL;
    }

    public void saveFortVariables() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE fort SET supplyLvL=? WHERE id = ?");){
            ps.setInt(1, this._supplyLvL);
            ps.setInt(2, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: saveFortVariables(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void setVisibleFlag(boolean val) {
        L2StaticObjectInstance flagPole = this.getFlagPole();
        if (flagPole != null) {
            flagPole.setMeshIndex(val ? 1 : 0);
        }
    }

    public void resetDoors() {
        for (L2DoorInstance door : this._doors) {
            if (door.getOpen()) {
                door.closeMe();
            }
            if (door.isDead()) {
                door.doRevive();
            }
            if (!(door.getCurrentHp() < (double)door.getMaxHp())) continue;
            door.setCurrentHp(door.getMaxHp());
        }
        this.loadDoorUpgrade();
    }

    public void upgradeDoor(int doorId, int hp, int pDef, int mDef) {
        L2DoorInstance door = this.getDoor(doorId);
        if (door != null) {
            door.setCurrentHp(door.getMaxHp() + hp);
            this.saveDoorUpgrade(doorId, hp, pDef, mDef);
        }
    }

    @Override
    protected void load() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM fort WHERE id = ?");){
            ps.setInt(1, this.getResidenceId());
            int ownerId = 0;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this.setName(rs.getString("name"));
                    this._siegeDate = Calendar.getInstance();
                    this._lastOwnedTime = Calendar.getInstance();
                    this._siegeDate.setTimeInMillis(rs.getLong("siegeDate"));
                    this._lastOwnedTime.setTimeInMillis(rs.getLong("lastOwnedTime"));
                    ownerId = rs.getInt("owner");
                    this._fortType = rs.getInt("fortType");
                    this._state = rs.getInt("state");
                    this._castleId = rs.getInt("castleId");
                    this._supplyLvL = rs.getInt("supplyLvL");
                }
            }
            if (ownerId > 0) {
                long initial;
                L2Clan clan = ClanTable.getInstance().getClan(ownerId);
                clan.setFortId(this.getResidenceId());
                this.setOwnerClan(clan);
                int runCount = this.getOwnedTime() / (int)TimeUnit.MILLISECONDS.toSeconds(Configuration.fortress().getPeriodicUpdateFrequency());
                for (initial = System.currentTimeMillis() - this._lastOwnedTime.getTimeInMillis(); initial > Configuration.fortress().getPeriodicUpdateFrequency(); initial -= Configuration.fortress().getPeriodicUpdateFrequency()) {
                }
                initial = Configuration.fortress().getPeriodicUpdateFrequency() - initial;
                if (Configuration.fortress().getMaxKeepTime() <= 0 || this.getOwnedTime() < Configuration.fortress().getMaxKeepTime() * 3600) {
                    this._FortUpdater[0] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, runCount, FortUpdater.UpdaterType.PERIODIC_UPDATE), initial, Configuration.fortress().getPeriodicUpdateFrequency());
                    if (Configuration.fortress().getMaxKeepTime() > 0) {
                        this._FortUpdater[1] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, runCount, FortUpdater.UpdaterType.MAX_OWN_TIME), 3600000L, 3600000L);
                    }
                } else {
                    this._FortUpdater[1] = ThreadPoolManager.getInstance().scheduleGeneral(new FortUpdater(this, clan, 0, FortUpdater.UpdaterType.MAX_OWN_TIME), 60000L);
                }
            } else {
                this.setOwnerClan(null);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: loadFortData(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void loadFunctions() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM fort_functions WHERE fort_id = ?");){
            ps.setInt(1, this.getResidenceId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._function.put(rs.getInt("type"), new FortFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception: Fort.loadFunctions(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void removeFunction(int functionType) {
        this._function.remove(functionType);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM fort_functions WHERE fort_id=? AND type=?");){
            ps.setInt(1, this.getResidenceId());
            ps.setInt(2, functionType);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: Fort.removeFunctions(int functionType): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void removeAllFunctions() {
        for (int id : this._function.keySet()) {
            this.removeFunction(id);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._function.put(type, new FortFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - this._function.get(type).getLease();
            if (diffLease > 0) {
                this._function.remove(type);
                this._function.put(type, new FortFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                this._function.get(type).setLease(lease);
                this._function.get(type).setLvl(lvl);
                this._function.get(type).dbSave();
            }
        }
        return true;
    }

    public void activateInstance() {
        this.loadDoor();
    }

    private void loadDoor() {
        for (L2DoorInstance door : DoorData.getInstance().getDoors()) {
            if (door.getFort() == null || door.getFort().getResidenceId() != this.getResidenceId()) continue;
            this._doors.add(door);
        }
    }

    private void loadFlagPoles() {
        for (L2StaticObjectInstance obj : StaticObjectData.getInstance().getStaticObjects()) {
            if (obj.getType() != 3 || !obj.getName().startsWith(this.getName())) continue;
            this._flagPole = obj;
            break;
        }
        if (this._flagPole == null) {
            throw new NullPointerException("Can't find flagpole for Fort " + String.valueOf(this));
        }
    }

    private void loadDoorUpgrade() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM fort_doorupgrade WHERE fortId = ?");){
            ps.setInt(1, this.getResidenceId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this.upgradeDoor(rs.getInt("id"), rs.getInt("hp"), rs.getInt("pDef"), rs.getInt("mDef"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: loadFortDoorUpgrade(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void removeDoorUpgrade() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM fort_doorupgrade WHERE fortId = ?");){
            ps.setInt(1, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: removeDoorUpgrade(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void saveDoorUpgrade(int doorId, int hp, int pDef, int mDef) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO fort_doorupgrade (doorId, hp, pDef, mDef) VALUES (?,?,?,?)");){
            ps.setInt(1, doorId);
            ps.setInt(2, hp);
            ps.setInt(3, pDef);
            ps.setInt(4, mDef);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: saveDoorUpgrade(int doorId, int hp, int pDef, int mDef): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void updateOwnerInDB() {
        L2Clan clan = this.getOwnerClan();
        int clanId = 0;
        if (clan != null) {
            clanId = clan.getId();
            this._lastOwnedTime.setTimeInMillis(System.currentTimeMillis());
        } else {
            this._lastOwnedTime.setTimeInMillis(0L);
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE fort SET owner=?,lastOwnedTime=?,state=?,castleId=? WHERE id = ?");){
            ps.setInt(1, clanId);
            ps.setLong(2, this._lastOwnedTime.getTimeInMillis());
            ps.setInt(3, 0);
            ps.setInt(4, 0);
            ps.setInt(5, this.getResidenceId());
            ps.execute();
            if (clan != null) {
                clan.setFortId(this.getResidenceId());
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CLAN_IS_VICTORIOUS_IN_THE_FORTRESS_BATTLE_OF_S2);
                sm.addString(clan.getName());
                sm.addCastleId(this.getResidenceId());
                L2World.getInstance().getPlayers().forEach(p -> p.sendPacket(sm));
                clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
                clan.broadcastToOnlineMembers(Music.SIEGE_VICTORY.getPacket());
                if (this._FortUpdater[0] != null) {
                    this._FortUpdater[0].cancel(false);
                }
                if (this._FortUpdater[1] != null) {
                    this._FortUpdater[1].cancel(false);
                }
                this._FortUpdater[0] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, 0, FortUpdater.UpdaterType.PERIODIC_UPDATE), Configuration.fortress().getPeriodicUpdateFrequency(), Configuration.fortress().getPeriodicUpdateFrequency());
                if (Configuration.fortress().getMaxKeepTime() > 0) {
                    this._FortUpdater[1] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, 0, FortUpdater.UpdaterType.MAX_OWN_TIME), 3600000L, 3600000L);
                }
            } else {
                if (this._FortUpdater[0] != null) {
                    this._FortUpdater[0].cancel(false);
                }
                this._FortUpdater[0] = null;
                if (this._FortUpdater[1] != null) {
                    this._FortUpdater[1].cancel(false);
                }
                this._FortUpdater[1] = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: updateOwnerInDB(L2Clan clan): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public L2Clan getOwnerClan() {
        return this._fortOwner;
    }

    public void setOwnerClan(L2Clan clan) {
        this.setVisibleFlag(clan != null);
        this._fortOwner = clan;
    }

    public L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getId() != doorId) continue;
            return door;
        }
        return null;
    }

    public List<L2DoorInstance> getDoors() {
        return this._doors;
    }

    public L2StaticObjectInstance getFlagPole() {
        return this._flagPole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FortSiege getSiege() {
        if (this._siege == null) {
            Fort fort = this;
            synchronized (fort) {
                if (this._siege == null) {
                    this._siege = new FortSiege(this);
                }
            }
        }
        return this._siege;
    }

    public Calendar getSiegeDate() {
        return this._siegeDate;
    }

    public void setSiegeDate(Calendar siegeDate) {
        this._siegeDate = siegeDate;
    }

    public int getOwnedTime() {
        if (this._lastOwnedTime.getTimeInMillis() == 0L) {
            return 0;
        }
        return (int)((System.currentTimeMillis() - this._lastOwnedTime.getTimeInMillis()) / 1000L);
    }

    public int getTimeTillRebelArmy() {
        if (this._lastOwnedTime.getTimeInMillis() == 0L) {
            return 0;
        }
        return (int)((this._lastOwnedTime.getTimeInMillis() + (long)Configuration.fortress().getMaxKeepTime() * 3600000L - System.currentTimeMillis()) / 1000L);
    }

    public long getTimeTillNextFortUpdate() {
        if (this._FortUpdater[0] == null) {
            return 0L;
        }
        return this._FortUpdater[0].getDelay(TimeUnit.SECONDS);
    }

    public void updateClansReputation(L2Clan owner, boolean removePoints) {
        if (owner != null) {
            if (removePoints) {
                owner.takeReputationScore(Configuration.clan().getLoseFortPoints(), true);
            } else {
                owner.addReputationScore(Configuration.clan().getTakeFortPoints(), true);
            }
        }
    }

    public int getFortState() {
        return this._state;
    }

    public void setFortState(int state, int castleId) {
        this._state = state;
        this._castleId = castleId;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE fort SET state=?,castleId=? WHERE id = ?");){
            ps.setInt(1, this.getFortState());
            ps.setInt(2, this.getContractedCastleId());
            ps.setInt(3, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: setFortState(int state, int castleId): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public int getFortType() {
        return this._fortType;
    }

    public int getCastleIdByAmbassador(int npcId) {
        return this._envoyCastles.get(npcId);
    }

    public Castle getCastleByAmbassador(int npcId) {
        return CastleManager.getInstance().getCastleById(this.getCastleIdByAmbassador(npcId));
    }

    public int getContractedCastleId() {
        return this._castleId;
    }

    public Castle getContractedCastle() {
        return CastleManager.getInstance().getCastleById(this.getContractedCastleId());
    }

    public boolean isBorderFortress() {
        return this._availableCastles.size() > 1;
    }

    public int getFortSize() {
        return this.getFortType() == 0 ? 3 : 5;
    }

    public void spawnSuspiciousMerchant() {
        if (this._isSuspiciousMerchantSpawned) {
            return;
        }
        this._isSuspiciousMerchantSpawned = true;
        for (L2Spawn spawnDat : this._siegeNpcs) {
            spawnDat.doSpawn();
            spawnDat.startRespawn();
        }
    }

    public void despawnSuspiciousMerchant() {
        if (!this._isSuspiciousMerchantSpawned) {
            return;
        }
        this._isSuspiciousMerchantSpawned = false;
        for (L2Spawn spawnDat : this._siegeNpcs) {
            spawnDat.stopRespawn();
            spawnDat.getLastSpawn().deleteMe();
        }
    }

    public void spawnNpcCommanders() {
        for (L2Spawn spawnDat : this._npcCommanders) {
            spawnDat.doSpawn();
            spawnDat.startRespawn();
        }
    }

    public void despawnNpcCommanders() {
        for (L2Spawn spawnDat : this._npcCommanders) {
            spawnDat.stopRespawn();
            spawnDat.getLastSpawn().deleteMe();
        }
    }

    public void spawnSpecialEnvoys() {
        for (L2Spawn spawnDat : this._specialEnvoys) {
            spawnDat.doSpawn();
        }
    }

    private void initNpcs() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM fort_spawnlist WHERE fortId = ? AND spawnType = ?");){
            ps.setInt(1, this.getResidenceId());
            ps.setInt(2, 0);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2Spawn spawnDat = new L2Spawn(rs.getInt("npcId"));
                    spawnDat.setAmount(1);
                    spawnDat.setX(rs.getInt("x"));
                    spawnDat.setY(rs.getInt("y"));
                    spawnDat.setZ(rs.getInt("z"));
                    spawnDat.setHeading(rs.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    spawnDat.doSpawn();
                    spawnDat.startRespawn();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Fort {} initNpcs: Spawn could not be initialized: {}", this.getResidenceId(), e.getMessage(), e);
        }
    }

    private void initSiegeNpcs() {
        this._siegeNpcs.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT id, npcId, x, y, z, heading FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ORDER BY id");){
            ps.setInt(1, this.getResidenceId());
            ps.setInt(2, 2);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2Spawn spawnDat = new L2Spawn(rs.getInt("npcId"));
                    spawnDat.setAmount(1);
                    spawnDat.setX(rs.getInt("x"));
                    spawnDat.setY(rs.getInt("y"));
                    spawnDat.setZ(rs.getInt("z"));
                    spawnDat.setHeading(rs.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    this._siegeNpcs.add(spawnDat);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Fort {} initSiegeNpcs: Spawn could not be initialized: {}", this.getResidenceId(), e.getMessage(), e);
        }
    }

    private void initNpcCommanders() {
        this._npcCommanders.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT id, npcId, x, y, z, heading FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ORDER BY id");){
            ps.setInt(1, this.getResidenceId());
            ps.setInt(2, 1);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2Spawn spawnDat = new L2Spawn(rs.getInt("npcId"));
                    spawnDat.setAmount(1);
                    spawnDat.setX(rs.getInt("x"));
                    spawnDat.setY(rs.getInt("y"));
                    spawnDat.setZ(rs.getInt("z"));
                    spawnDat.setHeading(rs.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    this._npcCommanders.add(spawnDat);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Fort {} initNpcCommanders: Spawn could not be initialized: {}", this.getResidenceId(), e.getMessage(), e);
        }
    }

    private void initSpecialEnvoys() {
        this._specialEnvoys.clear();
        this._envoyCastles.clear();
        this._availableCastles.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT id, npcId, x, y, z, heading, castleId FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ORDER BY id");){
            ps.setInt(1, this.getResidenceId());
            ps.setInt(2, 3);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int castleId = rs.getInt("castleId");
                    L2Spawn spawnDat = new L2Spawn(rs.getInt("npcId"));
                    spawnDat.setAmount(1);
                    spawnDat.setX(rs.getInt("x"));
                    spawnDat.setY(rs.getInt("y"));
                    spawnDat.setZ(rs.getInt("z"));
                    spawnDat.setHeading(rs.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    this._specialEnvoys.add(spawnDat);
                    this._envoyCastles.put(spawnDat.getId(), castleId);
                    this._availableCastles.add(castleId);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Fort {} initSpecialEnvoys: Spawn could not be initialized: {}", this.getResidenceId(), e.getMessage(), e);
        }
    }

    @Override
    protected void initResidenceZone() {
        for (L2FortZone zone : ZoneManager.getInstance().getAllZones(L2FortZone.class)) {
            if (zone.getResidenceId() != this.getResidenceId()) continue;
            this.setResidenceZone(zone);
            break;
        }
    }

    public class FortFunction {
        private final int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private final long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public FortFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (Fort.this.getOwnerClan() == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        public void dbSave() {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement("REPLACE INTO fort_functions (fort_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");){
                ps.setInt(1, Fort.this.getResidenceId());
                ps.setInt(2, this.getType());
                ps.setInt(3, this.getLvl());
                ps.setInt(4, this.getLease());
                ps.setLong(5, this.getRate());
                ps.setLong(6, this.getEndTime());
                ps.execute();
            }
            catch (Exception e) {
                LOG.error("Exception: Fort.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): {}", (Object)e.getMessage(), (Object)e);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                FortFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (Fort.this.getOwnerClan() == null) {
                        return;
                    }
                    if (Fort.this.getOwnerClan().getWarehouse().getAdena() >= (long)FortFunction.this._fee || !FortFunction.this._cwh) {
                        int fee = FortFunction.this._fee;
                        if (FortFunction.this.getEndTime() == -1L) {
                            fee = FortFunction.this._tempFee;
                        }
                        FortFunction.this.setEndTime(System.currentTimeMillis() + FortFunction.this.getRate());
                        FortFunction.this.dbSave();
                        if (FortFunction.this._cwh) {
                            Fort.this.getOwnerClan().getWarehouse().destroyItemByItemId("CS_function_fee", 57, fee, null, null);
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), FortFunction.this.getRate());
                    } else {
                        Fort.this.removeFunction(FortFunction.this.getType());
                    }
                }
                catch (Throwable t) {
                    LOG.warn(t.getMessage(), t);
                }
            }
        }
    }

    private static class EndFortressSiege
    implements Runnable {
        private final Fort _f;
        private final L2Clan _clan;

        public EndFortressSiege(Fort f, L2Clan clan) {
            this._f = f;
            this._clan = clan;
        }

        @Override
        public void run() {
            try {
                this._f.setOwner(this._clan, true);
            }
            catch (Exception e) {
                LOG.warn("Exception in endFortressSiege {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

