/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.xml.impl.ClassListData;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hero {
    private static final Logger LOG = LoggerFactory.getLogger(Hero.class);
    private static final String GET_HEROES = "SELECT heroes.charId, characters.char_name, heroes.class_id, heroes.count, heroes.played, heroes.claimed FROM heroes, characters WHERE characters.charId = heroes.charId AND heroes.played = 1";
    private static final String GET_ALL_HEROES = "SELECT heroes.charId, characters.char_name, heroes.class_id, heroes.count, heroes.played, heroes.claimed FROM heroes, characters WHERE characters.charId = heroes.charId";
    private static final String UPDATE_ALL = "UPDATE heroes SET played = 0";
    private static final String INSERT_HERO = "INSERT INTO heroes (charId, class_id, count, played, claimed) VALUES (?,?,?,?,?)";
    private static final String UPDATE_HERO = "UPDATE heroes SET count = ?, played = ?, claimed = ? WHERE charId = ?";
    private static final String GET_CLAN_ALLY = "SELECT characters.clanid AS clanid, coalesce(clan_data.ally_Id, 0) AS allyId FROM characters LEFT JOIN clan_data ON clan_data.clan_id = characters.clanid WHERE characters.charId = ?";
    private static final String DELETE_ITEMS = "DELETE FROM items WHERE item_id IN (6842, 6611, 6612, 6613, 6614, 6615, 6616, 6617, 6618, 6619, 6620, 6621, 9388, 9389, 9390) AND owner_id NOT IN (SELECT charId FROM characters WHERE accesslevel > 0)";
    private static final Map<Integer, StatsSet> HEROES = new ConcurrentHashMap<Integer, StatsSet>();
    private static final Map<Integer, StatsSet> COMPLETE_HEROES = new ConcurrentHashMap<Integer, StatsSet>();
    private static final Map<Integer, StatsSet> HERO_COUNTS = new ConcurrentHashMap<Integer, StatsSet>();
    private static final Map<Integer, List<StatsSet>> HERO_FIGHTS = new ConcurrentHashMap<Integer, List<StatsSet>>();
    private static final Map<Integer, List<StatsSet>> HERO_DIARY = new ConcurrentHashMap<Integer, List<StatsSet>>();
    private static final Map<Integer, String> HERO_MESSAGE = new ConcurrentHashMap<Integer, String>();
    public static final String COUNT = "count";
    public static final String PLAYED = "played";
    public static final String CLAIMED = "claimed";
    public static final String CLAN_NAME = "clan_name";
    public static final String CLAN_CREST = "clan_crest";
    public static final String ALLY_NAME = "ally_name";
    public static final String ALLY_CREST = "ally_crest";
    public static final int ACTION_RAID_KILLED = 1;
    public static final int ACTION_HERO_GAINED = 2;
    public static final int ACTION_CASTLE_TAKEN = 3;

    protected Hero() {
        this.init();
    }

    private void init() {
        HEROES.clear();
        COMPLETE_HEROES.clear();
        HERO_COUNTS.clear();
        HERO_FIGHTS.clear();
        HERO_DIARY.clear();
        HERO_MESSAGE.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s1 = con.createStatement();
             ResultSet rs1 = s1.executeQuery(GET_HEROES);
             PreparedStatement ps = con.prepareStatement(GET_CLAN_ALLY);
             Statement s2 = con.createStatement();
             ResultSet rs2 = s2.executeQuery(GET_ALL_HEROES);){
            int charId;
            StatsSet hero;
            while (rs1.next()) {
                hero = new StatsSet();
                charId = rs1.getInt("charId");
                hero.set("char_name", rs1.getString("char_name"));
                hero.set("class_id", rs1.getInt("class_id"));
                hero.set(COUNT, rs1.getInt(COUNT));
                hero.set(PLAYED, rs1.getInt(PLAYED));
                hero.set(CLAIMED, rs1.getBoolean(CLAIMED));
                this.loadFights(charId);
                this.loadDiary(charId);
                this.loadMessage(charId);
                this.processHeroes(ps, charId, hero);
                HEROES.put(charId, hero);
            }
            while (rs2.next()) {
                hero = new StatsSet();
                charId = rs2.getInt("charId");
                hero.set("char_name", rs2.getString("char_name"));
                hero.set("class_id", rs2.getInt("class_id"));
                hero.set(COUNT, rs2.getInt(COUNT));
                hero.set(PLAYED, rs2.getInt(PLAYED));
                hero.set(CLAIMED, rs2.getBoolean(CLAIMED));
                this.processHeroes(ps, charId, hero);
                COMPLETE_HEROES.put(charId, hero);
            }
        }
        catch (Exception ex) {
            LOG.warn("Couldn't load Heroes!", ex);
        }
        LOG.info("Loaded {} Heroes.", (Object)HEROES.size());
        LOG.info("Loaded {} all time Heroes.", (Object)COMPLETE_HEROES.size());
    }

    private void processHeroes(PreparedStatement ps, int charId, StatsSet hero) throws Exception {
        ps.setInt(1, charId);
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                int clanId = rs.getInt("clanid");
                int allyId = rs.getInt("allyId");
                String clanName = "";
                String allyName = "";
                int clanCrest = 0;
                int allyCrest = 0;
                if (clanId > 0) {
                    clanName = ClanTable.getInstance().getClan(clanId).getName();
                    clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                    if (allyId > 0) {
                        allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                        allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                    }
                }
                hero.set(CLAN_CREST, clanCrest);
                hero.set(CLAN_NAME, clanName);
                hero.set(ALLY_CREST, allyCrest);
                hero.set(ALLY_NAME, allyName);
            }
            ps.clearParameters();
        }
    }

    private String calcFightTime(long FightTime) {
        String format = String.format("%%0%dd", 2);
        String seconds = String.format(format, (FightTime /= 1000L) % 60L);
        String minutes = String.format(format, FightTime % 3600L / 60L);
        return minutes + ":" + seconds;
    }

    public void loadMessage(int charId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT message FROM heroes WHERE charId=?");){
            ps.setInt(1, charId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    HERO_MESSAGE.put(charId, rs.getString("message"));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not load Hero message for player Id {}!", (Object)charId, (Object)ex);
        }
    }

    public void loadDiary(int charId) {
        ArrayList<StatsSet> diary = new ArrayList<StatsSet>();
        int diaryEntries = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM  heroes_diary WHERE charId=? ORDER BY time");){
            ps.setInt(1, charId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Castle castle;
                    StatsSet _diaryentry = new StatsSet();
                    long time = rs.getLong("time");
                    int action = rs.getInt("action");
                    int param = rs.getInt("param");
                    String date = new SimpleDateFormat("yyyy-MM-dd HH").format(new Date(time));
                    _diaryentry.set("date", date);
                    if (action == 1) {
                        L2NpcTemplate template = NpcData.getInstance().getTemplate(param);
                        if (template != null) {
                            _diaryentry.set("action", template.getName() + " was defeated");
                        }
                    } else if (action == 2) {
                        _diaryentry.set("action", "Gained Hero status");
                    } else if (action == 3 && (castle = CastleManager.getInstance().getCastleById(param)) != null) {
                        _diaryentry.set("action", castle.getName() + " Castle was successfully taken");
                    }
                    diary.add(_diaryentry);
                    ++diaryEntries;
                }
            }
            HERO_DIARY.put(charId, diary);
            LOG.info("Loaded {} diary entries for Hero {}.", (Object)diaryEntries, (Object)CharNameTable.getInstance().getNameById(charId));
        }
        catch (Exception ex) {
            LOG.warn("Could not load Hero Diary for player Id {}!", (Object)charId, (Object)ex);
        }
    }

    public void loadFights(int charId) {
        ArrayList<StatsSet> fights = new ArrayList<StatsSet>();
        StatsSet heroCountData = new StatsSet();
        Calendar data = Calendar.getInstance();
        data.set(5, 1);
        data.set(11, 0);
        data.set(12, 0);
        data.set(14, 0);
        long from = data.getTimeInMillis();
        int numberOfFights = 0;
        int _victorys = 0;
        int _losses = 0;
        int _draws = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM olympiad_fights WHERE (charOneId=? OR charTwoId=?) AND start<? ORDER BY start");){
            ps.setInt(1, charId);
            ps.setInt(2, charId);
            ps.setLong(3, from);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String date;
                    StatsSet fight;
                    String cls;
                    String name;
                    int charOneId = rs.getInt("charOneId");
                    int charOneClass = rs.getInt("charOneClass");
                    int charTwoId = rs.getInt("charTwoId");
                    int charTwoClass = rs.getInt("charTwoClass");
                    int winner = rs.getInt("winner");
                    long start = rs.getLong("start");
                    long time = rs.getLong("time");
                    int classed = rs.getInt("classed");
                    if (charId == charOneId) {
                        name = CharNameTable.getInstance().getNameById(charTwoId);
                        cls = ClassListData.getInstance().getClass(charTwoClass).getClientCode();
                        if (name == null) continue;
                        fight = new StatsSet();
                        fight.set("oponent", name);
                        fight.set("oponentclass", cls);
                        fight.set("time", this.calcFightTime(time));
                        date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(start));
                        fight.set("start", date);
                        fight.set("classed", classed);
                        if (winner == 1) {
                            fight.set("result", "<font color=\"00ff00\">victory</font>");
                            ++_victorys;
                        } else if (winner == 2) {
                            fight.set("result", "<font color=\"ff0000\">loss</font>");
                            ++_losses;
                        } else if (winner == 0) {
                            fight.set("result", "<font color=\"ffff00\">draw</font>");
                            ++_draws;
                        }
                        fights.add(fight);
                        ++numberOfFights;
                        continue;
                    }
                    if (charId != charTwoId) continue;
                    name = CharNameTable.getInstance().getNameById(charOneId);
                    cls = ClassListData.getInstance().getClass(charOneClass).getClientCode();
                    if (name == null) continue;
                    fight = new StatsSet();
                    fight.set("oponent", name);
                    fight.set("oponentclass", cls);
                    fight.set("time", this.calcFightTime(time));
                    date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(start));
                    fight.set("start", date);
                    fight.set("classed", classed);
                    if (winner == 1) {
                        fight.set("result", "<font color=\"ff0000\">loss</font>");
                        ++_losses;
                    } else if (winner == 2) {
                        fight.set("result", "<font color=\"00ff00\">victory</font>");
                        ++_victorys;
                    } else if (winner == 0) {
                        fight.set("result", "<font color=\"ffff00\">draw</font>");
                        ++_draws;
                    }
                    fights.add(fight);
                    ++numberOfFights;
                }
            }
            heroCountData.set("victory", _victorys);
            heroCountData.set("draw", _draws);
            heroCountData.set("loss", _losses);
            HERO_COUNTS.put(charId, heroCountData);
            HERO_FIGHTS.put(charId, fights);
            LOG.info("Loaded {} fights for Hero {}.", (Object)numberOfFights, (Object)CharNameTable.getInstance().getNameById(charId));
        }
        catch (Exception ex) {
            LOG.warn("Could not load Hero fights history for player Id {}!", (Object)charId, (Object)ex);
        }
    }

    public Map<Integer, StatsSet> getHeroes() {
        return HEROES;
    }

    public int getHeroByClass(int classId) {
        for (Map.Entry<Integer, StatsSet> e : HEROES.entrySet()) {
            if (e.getValue().getInt("class_id") != classId) continue;
            return e.getKey();
        }
        return 0;
    }

    public void resetData() {
        HERO_DIARY.clear();
        HERO_FIGHTS.clear();
        HERO_COUNTS.clear();
        HERO_MESSAGE.clear();
    }

    public void showHeroDiary(L2PcInstance activeChar, int heroclass, int charid, int page) {
        int perpage = 10;
        List<StatsSet> mainList = HERO_DIARY.get(charid);
        if (mainList != null) {
            NpcHtmlMessage diaryReply = new NpcHtmlMessage();
            String htmContent = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/olympiad/herodiary.htm");
            String heroMessage = HERO_MESSAGE.get(charid);
            if (htmContent != null && heroMessage != null) {
                diaryReply.setHtml(htmContent);
                diaryReply.replace("%heroname%", CharNameTable.getInstance().getNameById(charid));
                diaryReply.replace("%message%", heroMessage);
                diaryReply.disableValidation();
                if (!mainList.isEmpty()) {
                    ArrayList<StatsSet> list = new ArrayList<StatsSet>(mainList);
                    Collections.reverse(list);
                    boolean color = true;
                    StringBuilder fList = new StringBuilder(500);
                    int counter = 0;
                    int breakat = 0;
                    for (int i = (page - 1) * 10; i < list.size(); ++i) {
                        breakat = i;
                        StatsSet diaryEntry = (StatsSet)list.get(i);
                        StringUtil.append(fList, "<tr><td>");
                        if (color) {
                            StringUtil.append(fList, "<table width=270 bgcolor=\"131210\">");
                        } else {
                            StringUtil.append(fList, "<table width=270>");
                        }
                        StringUtil.append(fList, "<tr><td width=270><font color=\"LEVEL\">" + diaryEntry.getString("date") + ":xx</font></td></tr>");
                        StringUtil.append(fList, "<tr><td width=270>" + diaryEntry.getString("action") + "</td></tr>");
                        StringUtil.append(fList, "<tr><td>&nbsp;</td></tr></table>");
                        StringUtil.append(fList, "</td></tr>");
                        boolean bl = color = !color;
                        if (++counter >= 10) break;
                    }
                    if (breakat < list.size() - 1) {
                        diaryReply.replace("%buttprev%", "<button value=\"Prev\" action=\"bypass _diary?class=" + heroclass + "&page=" + (page + 1) + "\" width=60 height=25 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        diaryReply.replace("%buttprev%", "");
                    }
                    if (page > 1) {
                        diaryReply.replace("%buttnext%", "<button value=\"Next\" action=\"bypass _diary?class=" + heroclass + "&page=" + (page - 1) + "\" width=60 height=25 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        diaryReply.replace("%buttnext%", "");
                    }
                    diaryReply.replace("%list%", fList.toString());
                } else {
                    diaryReply.replace("%list%", "");
                    diaryReply.replace("%buttprev%", "");
                    diaryReply.replace("%buttnext%", "");
                }
                activeChar.sendPacket(diaryReply);
            }
        }
    }

    public void showHeroFights(L2PcInstance activeChar, int heroclass, int charid, int page) {
        int perpage = 20;
        int _win = 0;
        int _loss = 0;
        int _draw = 0;
        List<StatsSet> heroFights = HERO_FIGHTS.get(charid);
        if (heroFights != null) {
            NpcHtmlMessage FightReply = new NpcHtmlMessage();
            String htmContent = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/olympiad/herohistory.htm");
            if (htmContent != null) {
                FightReply.setHtml(htmContent);
                FightReply.replace("%heroname%", CharNameTable.getInstance().getNameById(charid));
                if (!heroFights.isEmpty()) {
                    StatsSet heroCount = HERO_COUNTS.get(charid);
                    if (heroCount != null) {
                        _win = heroCount.getInt("victory");
                        _loss = heroCount.getInt("loss");
                        _draw = heroCount.getInt("draw");
                    }
                    boolean color = true;
                    StringBuilder fList = new StringBuilder(500);
                    int counter = 0;
                    int breakat = 0;
                    for (int i = (page - 1) * 20; i < heroFights.size(); ++i) {
                        breakat = i;
                        StatsSet fight = heroFights.get(i);
                        StringUtil.append(fList, "<tr><td>");
                        if (color) {
                            StringUtil.append(fList, "<table width=270 bgcolor=\"131210\">");
                        } else {
                            StringUtil.append(fList, "<table width=270>");
                        }
                        StringUtil.append(fList, "<tr><td width=220><font color=\"LEVEL\">" + fight.getString("start") + "</font>&nbsp;&nbsp;" + fight.getString("result") + "</td><td width=50 align=right>" + (fight.getInt("classed") > 0 ? "<font color=\"FFFF99\">cls</font>" : "<font color=\"999999\">non-cls<font>") + "</td></tr>");
                        StringUtil.append(fList, "<tr><td width=220>vs " + fight.getString("oponent") + " (" + fight.getString("oponentclass") + ")</td><td width=50 align=right>(" + fight.getString("time") + ")</td></tr>");
                        StringUtil.append(fList, "<tr><td colspan=2>&nbsp;</td></tr></table>");
                        StringUtil.append(fList, "</td></tr>");
                        boolean bl = color = !color;
                        if (++counter >= 20) break;
                    }
                    if (breakat < heroFights.size() - 1) {
                        FightReply.replace("%buttprev%", "<button value=\"Prev\" action=\"bypass _match?class=" + heroclass + "&page=" + (page + 1) + "\" width=60 height=25 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        FightReply.replace("%buttprev%", "");
                    }
                    if (page > 1) {
                        FightReply.replace("%buttnext%", "<button value=\"Next\" action=\"bypass _match?class=" + heroclass + "&page=" + (page - 1) + "\" width=60 height=25 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        FightReply.replace("%buttnext%", "");
                    }
                    FightReply.replace("%list%", fList.toString());
                } else {
                    FightReply.replace("%list%", "");
                    FightReply.replace("%buttprev%", "");
                    FightReply.replace("%buttnext%", "");
                }
                FightReply.replace("%win%", String.valueOf(_win));
                FightReply.replace("%draw%", String.valueOf(_draw));
                FightReply.replace("%loos%", String.valueOf(_loss));
                activeChar.sendPacket(FightReply);
            }
        }
    }

    public synchronized void computeNewHeroes(List<StatsSet> newHeroes) {
        this.updateHeroes(true);
        for (Integer objectId : HEROES.keySet()) {
            L2PcInstance player = L2World.getInstance().getPlayer(objectId);
            if (player == null) continue;
            player.setHero(false);
            for (int i = 0; i < 25; ++i) {
                L2ItemInstance[] equippedItem = player.getInventory().getPaperdollItem(i);
                if (equippedItem == null || !equippedItem.isHeroItem()) continue;
                player.getInventory().unEquipItemInSlot(i);
            }
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance item : player.getInventory().getItems()) {
                if (item == null || !item.isHeroItem()) continue;
                player.destroyItem("Hero", item, null, true);
                iu.addRemovedItem(item);
            }
            if (!iu.getItems().isEmpty()) {
                player.sendPacket(iu);
            }
            player.broadcastUserInfo();
        }
        this.deleteItemsInDb();
        HEROES.clear();
        if (newHeroes.isEmpty()) {
            return;
        }
        for (StatsSet hero : newHeroes) {
            int charId = hero.getInt("charId");
            if (COMPLETE_HEROES.containsKey(charId)) {
                StatsSet oldHero = COMPLETE_HEROES.get(charId);
                int count = oldHero.getInt(COUNT);
                oldHero.set(COUNT, count + 1);
                oldHero.set(PLAYED, 1);
                oldHero.set(CLAIMED, false);
                HEROES.put(charId, oldHero);
                continue;
            }
            StatsSet newHero = new StatsSet();
            newHero.set("char_name", hero.getString("char_name"));
            newHero.set("class_id", hero.getInt("class_id"));
            newHero.set(COUNT, 1);
            newHero.set(PLAYED, 1);
            newHero.set(CLAIMED, false);
            HEROES.put(charId, newHero);
        }
        this.updateHeroes(false);
    }

    public void updateHeroes(boolean setDefault) {
        block43: {
            try (Connection con = ConnectionFactory.getInstance().getConnection();){
                if (setDefault) {
                    try (Statement s = con.createStatement();){
                        s.executeUpdate(UPDATE_ALL);
                        break block43;
                    }
                }
                for (Map.Entry<Integer, StatsSet> entry : HEROES.entrySet()) {
                    PreparedStatement statement;
                    StatsSet hero = entry.getValue();
                    int heroId = entry.getKey();
                    if (!COMPLETE_HEROES.containsKey(heroId)) {
                        try (PreparedStatement insert = con.prepareStatement(INSERT_HERO);){
                            insert.setInt(1, heroId);
                            insert.setInt(2, hero.getInt("class_id"));
                            insert.setInt(3, hero.getInt(COUNT));
                            insert.setInt(4, hero.getInt(PLAYED));
                            insert.setBoolean(5, hero.getBoolean(CLAIMED));
                            insert.execute();
                        }
                        statement = con.prepareStatement(GET_CLAN_ALLY);
                        try {
                            statement.setInt(1, heroId);
                            try (ResultSet rs = statement.executeQuery();){
                                if (rs.next()) {
                                    int clanId = rs.getInt("clanid");
                                    int allyId = rs.getInt("allyId");
                                    String clanName = "";
                                    String allyName = "";
                                    int clanCrest = 0;
                                    int allyCrest = 0;
                                    if (clanId > 0) {
                                        clanName = ClanTable.getInstance().getClan(clanId).getName();
                                        clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                                        if (allyId > 0) {
                                            allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                                            allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                                        }
                                    }
                                    hero.set(CLAN_CREST, clanCrest);
                                    hero.set(CLAN_NAME, clanName);
                                    hero.set(ALLY_CREST, allyCrest);
                                    hero.set(ALLY_NAME, allyName);
                                }
                            }
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                        HEROES.put(heroId, hero);
                        COMPLETE_HEROES.put(heroId, hero);
                        continue;
                    }
                    statement = con.prepareStatement(UPDATE_HERO);
                    try {
                        statement.setInt(1, hero.getInt(COUNT));
                        statement.setInt(2, hero.getInt(PLAYED));
                        statement.setBoolean(3, hero.getBoolean(CLAIMED));
                        statement.setInt(4, heroId);
                        statement.execute();
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("Could not update Heroes!", ex);
            }
        }
    }

    public void setHeroGained(int charId) {
        this.setDiaryData(charId, 2, 0);
    }

    public void setRBkilled(int charId, int npcId) {
        this.setDiaryData(charId, 1, npcId);
        L2NpcTemplate template = NpcData.getInstance().getTemplate(npcId);
        List<StatsSet> list = HERO_DIARY.get(charId);
        if (list != null && template != null) {
            StatsSet diaryEntry = new StatsSet();
            String date = new SimpleDateFormat("yyyy-MM-dd HH").format(new Date(System.currentTimeMillis()));
            diaryEntry.set("date", date);
            diaryEntry.set("action", template.getName() + " was defeated");
            list.add(diaryEntry);
        }
    }

    public void setCastleTaken(int charId, int castleId) {
        this.setDiaryData(charId, 3, castleId);
        Castle castle = CastleManager.getInstance().getCastleById(castleId);
        List<StatsSet> list = HERO_DIARY.get(charId);
        if (list != null && castle != null) {
            StatsSet diaryEntry = new StatsSet();
            String date = new SimpleDateFormat("yyyy-MM-dd HH").format(new Date(System.currentTimeMillis()));
            diaryEntry.set("date", date);
            diaryEntry.set("action", castle.getName() + " Castle was successfully taken");
            list.add(diaryEntry);
        }
    }

    public void setDiaryData(int charId, int action, int param) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO heroes_diary (charId, time, action, param) values(?,?,?,?)");){
            ps.setInt(1, charId);
            ps.setLong(2, System.currentTimeMillis());
            ps.setInt(3, action);
            ps.setInt(4, param);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error saving diary data!", ex);
        }
    }

    public void setHeroMessage(L2PcInstance player, String message) {
        HERO_MESSAGE.put(player.getObjectId(), message);
    }

    public void saveHeroMessage(int charId) {
        if (HERO_MESSAGE.containsKey(charId)) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE heroes SET message=? WHERE charId=?;");){
            ps.setString(1, HERO_MESSAGE.get(charId));
            ps.setInt(2, charId);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error updating Hero message!", ex);
        }
    }

    private void deleteItemsInDb() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();){
            s.executeUpdate(DELETE_ITEMS);
        }
        catch (Exception ex) {
            LOG.warn("There has been an error deleting Hero items!", ex);
        }
    }

    public void shutdown() {
        HERO_MESSAGE.keySet().forEach(this::saveHeroMessage);
    }

    public boolean isHero(int objectId) {
        return HEROES.containsKey(objectId) && HEROES.get(objectId).getBoolean(CLAIMED);
    }

    public boolean isUnclaimedHero(int objectId) {
        return HEROES.containsKey(objectId) && !HEROES.get(objectId).getBoolean(CLAIMED);
    }

    public void claimHero(L2PcInstance player) {
        StatsSet hero = HEROES.get(player.getObjectId());
        if (hero == null) {
            hero = new StatsSet();
            HEROES.put(player.getObjectId(), hero);
        }
        hero.set(CLAIMED, true);
        L2Clan clan = player.getClan();
        if (clan != null && clan.getLevel() >= 5) {
            clan.addReputationScore(Configuration.clan().getHeroPoints(), true);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS);
            sm.addString(CharNameTable.getInstance().getNameById(player.getObjectId()));
            sm.addInt(Configuration.clan().getHeroPoints());
            clan.broadcastToOnlineMembers(sm);
        }
        player.setHero(true);
        player.broadcastPacket(new SocialAction(player.getObjectId(), 20016));
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.broadcastUserInfo();
        this.setHeroGained(player.getObjectId());
        this.loadFights(player.getObjectId());
        this.loadDiary(player.getObjectId());
        HERO_MESSAGE.put(player.getObjectId(), "");
        this.updateHeroes(false);
    }

    public static Hero getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final Hero INSTANCE = new Hero();

        private SingletonHolder() {
        }
    }
}

