/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.RecoBonus;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventEffect;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventPointInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventTimeChange;
import java.util.Calendar;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HuntingSystem {
    private static final int ADDITIONAL_NEVIT_POINTS = 2;
    private static final int HUNTING_BONUS_REFRESH_RATE = 10;
    private final L2PcInstance _activeChar;
    private ScheduledFuture<?> _huntingBonusTask;
    private ScheduledFuture<?> _nevitBlessingTimeTask;
    private boolean _message25;
    private boolean _message50;
    private boolean _message75;

    public HuntingSystem(L2PcInstance player) {
        Objects.requireNonNull(player);
        this._activeChar = player;
    }

    public void onPlayerLogin() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 6);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(14, 0);
        if (this.getActiveChar().getLastAccess() < cal.getTimeInMillis() / 1000L && System.currentTimeMillis() > cal.getTimeInMillis()) {
            this.setHuntingBonusTime(0);
        }
        this.getActiveChar().sendPacket(new ExNevitAdventPointInfoPacket(this.getNevitBlessingPoints()));
        this.getActiveChar().sendPacket(new ExNevitAdventTimeChange(this.getHuntingBonusTime(), true));
        this.checkNevitBlessingEffect(this.getNevitBlessingTime());
        this.checkSystemMessageSend();
    }

    public void onPlayerLogout() {
        this.stopNevitBlessingEffectTask(true);
        this.stopHuntingBonusTask(false);
    }

    public void addPoints(int val) {
        this.setNevitBlessingPoints(this.getNevitBlessingPoints() + val);
        if (this.getNevitBlessingPoints() > Configuration.hunting().getNevitBlessingMaxPoints()) {
            this.setNevitBlessingPoints(0);
            this.checkNevitBlessingEffect(Configuration.hunting().getNevitBlessingEffetcTime());
        }
        this.checkSystemMessageSend();
    }

    public void startHuntingSystemTask() {
        if (!(this._huntingBonusTask != null || this.getHuntingBonusTime() >= Configuration.hunting().getHuntingBonusMaxTime() && Configuration.hunting().getHuntingBonusLimit())) {
            this._huntingBonusTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new HuntingBonusTask(), 1000L, 10000L);
            if (Configuration.hunting().getHuntingBonusLimit()) {
                this.getActiveChar().sendPacket(new ExNevitAdventTimeChange(this.getHuntingBonusTime(), false));
            }
        }
    }

    public void checkNevitBlessingEffect(int value) {
        if (this.getNevitBlessingTime() > 0) {
            this.stopNevitBlessingEffectTask(false);
            value = this.getNevitBlessingTime();
        }
        if (value > 0) {
            int percent = HuntingSystem.calcPercent(this.getNevitBlessingPoints());
            if (percent < 25) {
                this._message25 = false;
                this._message50 = false;
                this._message75 = false;
            }
            this.setNevitBlessingTime(value);
            this.getActiveChar().sendPacket(new ExNevitAdventEffect(value));
            this.getActiveChar().sendPacket(SystemMessageId.THE_ANGEL_NEVIT_HAS_BLESSED_YOU_FROM_ABOVE);
            this.getActiveChar().startAbnormalVisualEffect(true, AbnormalVisualEffect.NEVIT_ADVENT);
            this._nevitBlessingTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new NevitEffectEnd(), (long)value * 1000L);
        }
    }

    public void stopHuntingBonusTask(boolean sendPacket) {
        if (this._huntingBonusTask != null) {
            this._huntingBonusTask.cancel(true);
            this._huntingBonusTask = null;
        }
        if (sendPacket) {
            this.getActiveChar().sendPacket(new ExNevitAdventTimeChange(this.getHuntingBonusTime(), true));
        }
    }

    public void stopNevitBlessingEffectTask(boolean value) {
        if (this._nevitBlessingTimeTask != null) {
            if (value) {
                int time = (int)this._nevitBlessingTimeTask.getDelay(TimeUnit.SECONDS);
                if (time > 0) {
                    this.setNevitBlessingTime(time);
                } else {
                    this.setNevitBlessingTime(0);
                }
            }
            this._nevitBlessingTimeTask.cancel(true);
            this._nevitBlessingTimeTask = null;
        }
    }

    public void checkSystemMessageSend() {
        int percent = HuntingSystem.calcPercent(this.getNevitBlessingPoints());
        if (percent >= 75) {
            if (!this._message75) {
                this._message75 = true;
                this.getActiveChar().sendPacket(SystemMessageId.NEVITS_ADVENT_BLESSING_SHINES_STRONGLY_FROM_ABOVE);
            }
        } else if (percent >= 50) {
            if (!this._message50) {
                this._message50 = true;
                this.getActiveChar().sendPacket(SystemMessageId.YOU_ARE_FURTHER_INFUSED_WITH_THE_BLESSINGS_OF_NEVIT);
            }
        } else if (percent >= 25 && !this._message25) {
            this._message25 = true;
            this.getActiveChar().sendPacket(SystemMessageId.YOU_ARE_STARTING_TO_FEEL_THE_EFFECTS_OF_NEVITS_ADVENT_BLESSING);
        }
    }

    public boolean isNevitBlessingActive() {
        return this._nevitBlessingTimeTask != null && this._nevitBlessingTimeTask.getDelay(TimeUnit.SECONDS) > 0L;
    }

    public boolean isHuntingBonusTaskActive() {
        return this._nevitBlessingTimeTask != null;
    }

    public static int calcPercent(int points) {
        return (int)(100.0 / (double)Configuration.hunting().getNevitBlessingMaxPoints() * (double)points);
    }

    public L2PcInstance getActiveChar() {
        return this._activeChar;
    }

    public int getNevitBlessingPoints() {
        return this.getActiveChar().getStat().getNevitBlessingPoints();
    }

    public void setNevitBlessingPoints(int points) {
        this.getActiveChar().getStat().setNevitBlessingPoints(points);
    }

    public int getHuntingBonusTime() {
        return this.getActiveChar().getStat().getHuntingBonusTime();
    }

    public void setHuntingBonusTime(int time) {
        this.getActiveChar().getStat().setHuntingBonusTime(time);
    }

    public int getNevitBlessingTime() {
        return this.getActiveChar().getStat().getNevitBlessingTime();
    }

    public void setNevitBlessingTime(int time) {
        this.getActiveChar().getStat().setNevitBlessingTime(time);
    }

    public double getNevitHourglassMultiplier() {
        return this.getActiveChar().getRecSystem().getBonusTime() > 0 || this.getActiveChar().hasAbnormalTypeVote() ? RecoBonus.getRecoMultiplier(this.getActiveChar()) : 0.0;
    }

    public class HuntingBonusTask
    implements Runnable {
        @Override
        public void run() {
            HuntingSystem.this.setHuntingBonusTime(HuntingSystem.this.getHuntingBonusTime() + 10);
            if (HuntingSystem.this.getHuntingBonusTime() >= Configuration.hunting().getHuntingBonusMaxTime() && Configuration.hunting().getHuntingBonusLimit()) {
                HuntingSystem.this.setHuntingBonusTime(Configuration.hunting().getHuntingBonusMaxTime());
                HuntingSystem.this.stopHuntingBonusTask(true);
                return;
            }
            if (Configuration.hunting().getHuntingBonusLimit()) {
                HuntingSystem.this.getActiveChar().sendPacket(new ExNevitAdventTimeChange(HuntingSystem.this.getHuntingBonusTime(), false));
            }
            HuntingSystem.this.addPoints(2);
            if (HuntingSystem.this.getNevitBlessingTime() > 0) {
                HuntingSystem.this.addPoints(Configuration.hunting().getNevitRegularPoints());
            } else {
                HuntingSystem.this.addPoints(Configuration.hunting().getNevitRegularPoints2());
            }
        }
    }

    public class NevitEffectEnd
    implements Runnable {
        @Override
        public void run() {
            HuntingSystem.this.setNevitBlessingTime(0);
            HuntingSystem.this.getActiveChar().sendPacket(new ExNevitAdventEffect(0));
            HuntingSystem.this.getActiveChar().sendPacket(new ExNevitAdventPointInfoPacket(HuntingSystem.this.getNevitBlessingPoints()));
            HuntingSystem.this.getActiveChar().sendPacket(SystemMessageId.NEVITS_ADVENT_BLESSING_HAS_ENDED);
            HuntingSystem.this.getActiveChar().stopAbnormalVisualEffect(true, AbnormalVisualEffect.NEVIT_ADVENT);
            HuntingSystem.this.stopNevitBlessingEffectTask(false);
        }
    }
}

