/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity.clanhall;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.ClanHallSiegeEngine;
import com.l2jserver.gameserver.model.entity.clanhall.SiegeStatus;
import com.l2jserver.gameserver.model.zone.type.L2SiegableHallZone;
import com.l2jserver.gameserver.model.zone.type.L2SiegeZone;
import com.l2jserver.gameserver.network.serverpackets.SiegeInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SiegableHall
extends ClanHall {
    private static final Logger LOG = LoggerFactory.getLogger(SiegableHall.class);
    private static final String SQL_SAVE = "UPDATE siegable_clanhall SET ownerId=?, nextSiege=? WHERE clanHallId=?";
    private Calendar _nextSiege;
    private final long _siegeLength;
    private final int[] _scheduleConfig = new int[]{7, 0, 0, 12, 0};
    private SiegeStatus _status = SiegeStatus.REGISTERING;
    private L2SiegeZone _siegeZone;
    private ClanHallSiegeEngine _siege;

    public SiegableHall(StatsSet set) {
        super(set);
        this._siegeLength = set.getLong("siegeLength");
        String[] rawSchConfig = set.getString("scheduleConfig").split(";");
        if (rawSchConfig.length == 5) {
            for (int i = 0; i < 5; ++i) {
                try {
                    this._scheduleConfig[i] = Integer.parseInt(rawSchConfig[i]);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("{}: Wrong schedule_config parameters!", (Object)this.getName());
                }
            }
        } else {
            LOG.warn("{}: Wrong schedule_config value in siegable_halls table, using default (7 days)", (Object)this.getName());
        }
        this._nextSiege = Calendar.getInstance();
        long nextSiege = set.getLong("nextSiege");
        if (nextSiege - System.currentTimeMillis() < 0L) {
            this.updateNextSiege();
        } else {
            this._nextSiege.setTimeInMillis(nextSiege);
        }
        if (this.getOwnerId() != 0) {
            this._isFree = false;
            this.loadFunctions();
        }
    }

    public void spawnDoor() {
        this.spawnDoor(false);
    }

    public void spawnDoor(boolean isDoorWeak) {
        for (L2DoorInstance door : this.getDoors()) {
            if (door.isDead()) {
                door.doRevive();
                if (isDoorWeak) {
                    door.setCurrentHp((double)door.getMaxHp() / 2.0);
                } else {
                    door.setCurrentHp(door.getMaxHp());
                }
            }
            if (!door.getOpen()) continue;
            door.closeMe();
        }
    }

    @Override
    public void updateDb() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SQL_SAVE);){
            ps.setInt(1, this.getOwnerId());
            ps.setLong(2, this.getNextSiegeTime());
            ps.setInt(3, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: SiegableHall.updateDb(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void setSiege(ClanHallSiegeEngine siegable) {
        this._siege = siegable;
        this._siegeZone.setSiegeInstance(siegable);
    }

    public ClanHallSiegeEngine getSiege() {
        return this._siege;
    }

    public Calendar getSiegeDate() {
        return this._nextSiege;
    }

    public long getNextSiegeTime() {
        return this._nextSiege.getTimeInMillis();
    }

    public long getSiegeLength() {
        return this._siegeLength;
    }

    public void setNextSiegeDate(long date) {
        this._nextSiege.setTimeInMillis(date);
    }

    public void setNextSiegeDate(Calendar c) {
        this._nextSiege = c;
    }

    public void updateNextSiege() {
        Calendar c = Calendar.getInstance();
        c.add(6, this._scheduleConfig[0]);
        c.add(2, this._scheduleConfig[1]);
        c.add(1, this._scheduleConfig[2]);
        c.set(11, this._scheduleConfig[3]);
        c.set(12, this._scheduleConfig[4]);
        c.set(13, 0);
        this.setNextSiegeDate(c);
        this.updateDb();
    }

    public void addAttacker(L2Clan clan) {
        if (this.getSiege() != null) {
            this.getSiege().getAttackers().put(clan.getId(), new L2SiegeClan(clan.getId(), L2SiegeClan.SiegeClanType.ATTACKER));
        }
    }

    public void removeAttacker(L2Clan clan) {
        if (this.getSiege() != null) {
            this.getSiege().getAttackers().remove(clan.getId());
        }
    }

    public boolean isRegistered(L2Clan clan) {
        if (this.getSiege() == null) {
            return false;
        }
        return this.getSiege().checkIsAttacker(clan);
    }

    public SiegeStatus getSiegeStatus() {
        return this._status;
    }

    public boolean isRegistering() {
        return this._status == SiegeStatus.REGISTERING;
    }

    public boolean isInSiege() {
        return this._status == SiegeStatus.RUNNING;
    }

    public boolean isWaitingBattle() {
        return this._status == SiegeStatus.WAITING_BATTLE;
    }

    public void updateSiegeStatus(SiegeStatus status) {
        this._status = status;
    }

    public L2SiegeZone getSiegeZone() {
        return this._siegeZone;
    }

    public void setSiegeZone(L2SiegeZone zone) {
        this._siegeZone = zone;
    }

    public void updateSiegeZone(boolean active) {
        this._siegeZone.setIsActive(active);
    }

    public void showSiegeInfo(L2PcInstance player) {
        player.sendPacket(new SiegeInfo(this));
    }

    @Override
    public boolean isSiegableHall() {
        return true;
    }

    @Override
    public L2SiegableHallZone getZone() {
        return (L2SiegableHallZone)super.getZone();
    }
}

