/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.event;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.AnnouncementsTable;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.announce.EventAnnouncement;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.util.Broadcast;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LongTimeEvent
extends Quest {
    private static final Logger LOG = LoggerFactory.getLogger(LongTimeEvent.class);
    private String _eventName;
    private String _onEnterMsg = "Event is in process";
    protected String _endMsg = "Event ends!";
    private DateRange _eventPeriod = null;
    private DateRange _dropPeriod;
    private final List<NpcSpawn> _spawnList = new ArrayList<NpcSpawn>();
    private final List<GeneralDropItem> _dropList = new ArrayList<GeneralDropItem>();

    public LongTimeEvent(String name, String descr) {
        super(-1, name, descr);
        this.loadConfig();
        if (this._eventPeriod != null) {
            if (this._eventPeriod.isWithinRange(new Date())) {
                this.startEvent();
                LOG.info("Event {} active till {}.", (Object)this._eventName, (Object)this._eventPeriod.getEndDate());
            } else if (this._eventPeriod.getStartDate().after(new Date())) {
                long delay = this._eventPeriod.getStartDate().getTime() - System.currentTimeMillis();
                ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStart(), delay);
                LOG.info("Event {} will be started at {}.", (Object)this._eventName, (Object)this._eventPeriod.getStartDate());
            } else {
                LOG.info("Event {} has passed... Ignored.", (Object)this._eventName);
            }
        }
    }

    private void loadConfig() {
        block23: {
            File configFile = new File(Configuration.server().getDatapackRoot(), "data/events/" + this.getName() + ".xml");
            try {
                Node first;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(configFile);
                if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase("event")) {
                    throw new NullPointerException("WARNING!!! " + this.getName() + " event: bad config file!");
                }
                this._eventName = doc.getDocumentElement().getAttributes().getNamedItem("name").getNodeValue();
                String period = doc.getDocumentElement().getAttributes().getNamedItem("active").getNodeValue();
                this._eventPeriod = DateRange.parse(period, new SimpleDateFormat("dd MM yyyy", Locale.US));
                if (doc.getDocumentElement().getAttributes().getNamedItem("dropPeriod") != null) {
                    String dropPeriod = doc.getDocumentElement().getAttributes().getNamedItem("dropPeriod").getNodeValue();
                    this._dropPeriod = DateRange.parse(dropPeriod, new SimpleDateFormat("dd MM yyyy", Locale.US));
                    if (!this._eventPeriod.isWithinRange(this._dropPeriod.getStartDate()) || !this._eventPeriod.isWithinRange(this._dropPeriod.getEndDate())) {
                        this._dropPeriod = this._eventPeriod;
                    }
                } else {
                    this._dropPeriod = this._eventPeriod;
                }
                if (this._eventPeriod == null) {
                    throw new NullPointerException("WARNING!!! " + this.getName() + " event: illegal event period");
                }
                Date today = new Date();
                if (!this._eventPeriod.getStartDate().after(today) && !this._eventPeriod.isWithinRange(today)) break block23;
                for (Node n = first = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                    Node d;
                    if (n.getNodeName().equalsIgnoreCase("droplist")) {
                        for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                            if (!d.getNodeName().equalsIgnoreCase("add")) continue;
                            try {
                                int itemId = Integer.parseInt(d.getAttributes().getNamedItem("item").getNodeValue());
                                int minCount = Integer.parseInt(d.getAttributes().getNamedItem("min").getNodeValue());
                                int maxCount = Integer.parseInt(d.getAttributes().getNamedItem("max").getNodeValue());
                                String chance = d.getAttributes().getNamedItem("chance").getNodeValue();
                                int finalChance = 0;
                                if (!chance.isEmpty() && chance.endsWith("%")) {
                                    finalChance = Integer.parseInt(chance.substring(0, chance.length() - 1)) * 10000;
                                }
                                if (ItemTable.getInstance().getTemplate(itemId) == null) {
                                    LOG.warn("{} event: {} is wrong item id, item was not added in droplist", (Object)this.getName(), (Object)itemId);
                                    continue;
                                }
                                if (minCount > maxCount) {
                                    LOG.warn("{} event: item {} - min greater than max, item was not added in droplist", (Object)this.getName(), (Object)itemId);
                                    continue;
                                }
                                if (finalChance < 10000 || finalChance > 1000000) {
                                    LOG.warn("{} event: item {} - incorrect drop chance, item was not added in droplist", (Object)this.getName(), (Object)itemId);
                                    continue;
                                }
                                this._dropList.add((GeneralDropItem)DropListScope.STATIC.newDropItem(itemId, minCount, maxCount, finalChance));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                LOG.warn("Wrong number format in config.xml droplist block for {} event", (Object)this.getName());
                            }
                        }
                        continue;
                    }
                    if (n.getNodeName().equalsIgnoreCase("spawnlist")) {
                        for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                            if (!d.getNodeName().equalsIgnoreCase("add")) continue;
                            try {
                                int heading;
                                int npcId = Integer.parseInt(d.getAttributes().getNamedItem("npc").getNodeValue());
                                int xPos = Integer.parseInt(d.getAttributes().getNamedItem("x").getNodeValue());
                                int yPos = Integer.parseInt(d.getAttributes().getNamedItem("y").getNodeValue());
                                int zPos = Integer.parseInt(d.getAttributes().getNamedItem("z").getNodeValue());
                                int n2 = heading = d.getAttributes().getNamedItem("heading").getNodeValue() != null ? Integer.parseInt(d.getAttributes().getNamedItem("heading").getNodeValue()) : 0;
                                if (NpcData.getInstance().getTemplate(npcId) == null) {
                                    LOG.warn("{} event: {} is wrong NPC id, NPC was not added in spawnlist.", (Object)this.getName(), (Object)npcId);
                                    continue;
                                }
                                this._spawnList.add(new NpcSpawn(npcId, new Location(xPos, yPos, zPos, heading)));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                LOG.warn("Wrong number format in config.xml spawnlist block for {} event.", (Object)this.getName());
                            }
                        }
                        continue;
                    }
                    if (!n.getNodeName().equalsIgnoreCase("messages")) continue;
                    for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!d.getNodeName().equalsIgnoreCase("add")) continue;
                        String msgType = d.getAttributes().getNamedItem("type").getNodeValue();
                        String msgText = d.getAttributes().getNamedItem("text").getNodeValue();
                        if (msgType == null || msgText == null) continue;
                        if (msgType.equalsIgnoreCase("onEnd")) {
                            this._endMsg = msgText;
                            continue;
                        }
                        if (!msgType.equalsIgnoreCase("onEnter")) continue;
                        this._onEnterMsg = msgText;
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("{} event: error reading {}!", this.getName(), configFile.getAbsolutePath(), ex);
            }
        }
    }

    protected void startEvent() {
        long currentTime = System.currentTimeMillis();
        if (this._dropList != null && currentTime < this._dropPeriod.getEndDate().getTime()) {
            for (GeneralDropItem drop : this._dropList) {
                EventDroplist.getInstance().addGlobalDrop(drop.getItemId(), drop.getMin(), drop.getMax(), (int)drop.getChance(), this._dropPeriod);
            }
        }
        long millisToEventEnd = this._eventPeriod.getEndDate().getTime() - currentTime;
        if (this._spawnList != null) {
            for (NpcSpawn spawn : this._spawnList) {
                LongTimeEvent.addSpawn(spawn.npcId, spawn.loc.getX(), spawn.loc.getY(), spawn.loc.getZ(), spawn.loc.getHeading(), false, millisToEventEnd, false);
            }
        }
        Broadcast.toAllOnlinePlayers(this._onEnterMsg);
        AnnouncementsTable.getInstance().addAnnouncement(new EventAnnouncement(this._eventPeriod, this._onEnterMsg));
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEnd(), millisToEventEnd);
    }

    public DateRange getEventPeriod() {
        return this._eventPeriod;
    }

    public boolean isEventPeriod() {
        return this._eventPeriod.isWithinRange(new Date());
    }

    public boolean isDropPeriod() {
        return this._dropPeriod.isWithinRange(new Date());
    }

    protected class ScheduleStart
    implements Runnable {
        protected ScheduleStart() {
        }

        @Override
        public void run() {
            LongTimeEvent.this.startEvent();
        }
    }

    private static class NpcSpawn {
        protected final Location loc;
        protected final int npcId;

        protected NpcSpawn(int pNpcId, Location spawnLoc) {
            this.loc = spawnLoc;
            this.npcId = pNpcId;
        }
    }

    protected class ScheduleEnd
    implements Runnable {
        protected ScheduleEnd() {
        }

        @Override
        public void run() {
            Broadcast.toAllOnlinePlayers(LongTimeEvent.this._endMsg);
        }
    }
}

