/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.holders;

import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.HashMap;
import java.util.Map;

public class PlayerSkillHolder
implements ISkillsHolder {
    private final Map<Integer, Skill> _skills = new HashMap<Integer, Skill>();

    public PlayerSkillHolder(L2PcInstance player) {
        for (Skill skill : player.getSkills().values()) {
            if (!SkillTreesData.getInstance().isSkillAllowed(player, skill)) continue;
            this.addSkill(skill);
        }
    }

    @Override
    public Map<Integer, Skill> getSkills() {
        return this._skills;
    }

    @Override
    public Skill addSkill(Skill skill) {
        return this._skills.put(skill.getId(), skill);
    }

    @Override
    public int getSkillLevel(int skillId) {
        Skill skill = this.getKnownSkill(skillId);
        return skill == null ? -1 : skill.getLevel();
    }

    @Override
    public Skill getKnownSkill(int skillId) {
        return this._skills.get(skillId);
    }
}

