/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.holders;

import com.l2jserver.gameserver.model.punishment.PunishmentTask;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PunishmentHolder {
    private final Map<String, Map<PunishmentType, PunishmentTask>> _holder = new ConcurrentHashMap<String, Map<PunishmentType, PunishmentTask>>();

    public void addPunishment(PunishmentTask task) {
        if (!task.isExpired()) {
            String key = String.valueOf(task.getKey());
            this._holder.computeIfAbsent(key, k -> new ConcurrentHashMap()).put(task.getType(), task);
        }
    }

    public void stopPunishment(PunishmentTask task) {
        String key = String.valueOf(task.getKey());
        if (this._holder.containsKey(key)) {
            task.stopPunishment();
            Map<PunishmentType, PunishmentTask> punishments = this._holder.get(key);
            punishments.remove((Object)task.getType());
            if (punishments.isEmpty()) {
                this._holder.remove(key);
            }
        }
    }

    public boolean hasPunishment(String key, PunishmentType type) {
        return this.getPunishment(key, type) != null;
    }

    public PunishmentTask getPunishment(String key, PunishmentType type) {
        if (this._holder.containsKey(key)) {
            return this._holder.get(key).get((Object)type);
        }
        return null;
    }
}

