/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemauction;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.ItemInfo;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemauction.AuctionItem;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionBid;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionExtendState;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionState;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemAuction {
    private static final Logger LOG = LoggerFactory.getLogger(ItemAuction.class);
    private static final long ENDING_TIME_EXTEND_5 = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private static final long ENDING_TIME_EXTEND_3 = TimeUnit.MILLISECONDS.convert(3L, TimeUnit.MINUTES);
    private final int _auctionId;
    private final int _instanceId;
    private final long _startingTime;
    private volatile long _endingTime;
    private final AuctionItem _auctionItem;
    private final List<ItemAuctionBid> _auctionBids;
    private final Object _auctionStateLock;
    private volatile ItemAuctionState _auctionState;
    private volatile ItemAuctionExtendState _scheduledAuctionEndingExtendState;
    private volatile ItemAuctionExtendState _auctionEndingExtendState;
    private final ItemInfo _itemInfo;
    private ItemAuctionBid _highestBid;
    private int _lastBidPlayerObjId;
    private static final String DELETE_ITEM_AUCTION_BID = "DELETE FROM item_auction_bid WHERE auctionId = ? AND playerObjId = ?";
    private static final String INSERT_ITEM_AUCTION_BID = "INSERT INTO item_auction_bid (auctionId, playerObjId, playerBid) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE playerBid = ?";

    public ItemAuction(int auctionId, int instanceId, long startingTime, long endingTime, AuctionItem auctionItem) {
        this(auctionId, instanceId, startingTime, endingTime, auctionItem, new ArrayList<ItemAuctionBid>(), ItemAuctionState.CREATED);
    }

    public ItemAuction(int auctionId, int instanceId, long startingTime, long endingTime, AuctionItem auctionItem, List<ItemAuctionBid> auctionBids, ItemAuctionState auctionState) {
        this._auctionId = auctionId;
        this._instanceId = instanceId;
        this._startingTime = startingTime;
        this._endingTime = endingTime;
        this._auctionItem = auctionItem;
        this._auctionBids = auctionBids;
        this._auctionState = auctionState;
        this._auctionStateLock = new Object();
        this._scheduledAuctionEndingExtendState = ItemAuctionExtendState.INITIAL;
        this._auctionEndingExtendState = ItemAuctionExtendState.INITIAL;
        L2ItemInstance item = this._auctionItem.createNewItemInstance();
        this._itemInfo = new ItemInfo(item);
        L2World.getInstance().removeObject(item);
        for (ItemAuctionBid bid : this._auctionBids) {
            if (this._highestBid != null && this._highestBid.getLastBid() >= bid.getLastBid()) continue;
            this._highestBid = bid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemAuctionState getAuctionState() {
        ItemAuctionState auctionState;
        Object object = this._auctionStateLock;
        synchronized (object) {
            auctionState = this._auctionState;
        }
        return auctionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAuctionState(ItemAuctionState expected, ItemAuctionState wanted) {
        Object object = this._auctionStateLock;
        synchronized (object) {
            if (this._auctionState != expected) {
                return false;
            }
            this._auctionState = wanted;
            this.storeMe();
            return true;
        }
    }

    public int getAuctionId() {
        return this._auctionId;
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public ItemInfo getItemInfo() {
        return this._itemInfo;
    }

    public L2ItemInstance createNewItemInstance() {
        return this._auctionItem.createNewItemInstance();
    }

    public long getAuctionInitBid() {
        return this._auctionItem.getAuctionInitBid();
    }

    public ItemAuctionBid getHighestBid() {
        return this._highestBid;
    }

    public ItemAuctionExtendState getAuctionEndingExtendState() {
        return this._auctionEndingExtendState;
    }

    public ItemAuctionExtendState getScheduledAuctionEndingExtendState() {
        return this._scheduledAuctionEndingExtendState;
    }

    public void setScheduledAuctionEndingExtendState(ItemAuctionExtendState state) {
        this._scheduledAuctionEndingExtendState = state;
    }

    public long getStartingTime() {
        return this._startingTime;
    }

    public long getEndingTime() {
        return this._endingTime;
    }

    public long getStartingTimeRemaining() {
        return Math.max(this.getEndingTime() - System.currentTimeMillis(), 0L);
    }

    public long getFinishingTimeRemaining() {
        return Math.max(this.getEndingTime() - System.currentTimeMillis(), 0L);
    }

    public void storeMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO item_auction (auctionId,instanceId,auctionItemId,startingTime,endingTime,auctionStateId) VALUES (?,?,?,?,?,?) ON DUPLICATE KEY UPDATE auctionStateId=?");){
            ps.setInt(1, this._auctionId);
            ps.setInt(2, this._instanceId);
            ps.setInt(3, this._auctionItem.getAuctionItemId());
            ps.setLong(4, this._startingTime);
            ps.setLong(5, this._endingTime);
            ps.setByte(6, this._auctionState.getStateId());
            ps.setByte(7, this._auctionState.getStateId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
    }

    public int getAndSetLastBidPlayerObjectId(int playerObjId) {
        int lastBid = this._lastBidPlayerObjId;
        this._lastBidPlayerObjId = playerObjId;
        return lastBid;
    }

    private void updatePlayerBid(ItemAuctionBid bid, boolean delete) {
        this.updatePlayerBidInternal(bid, delete);
    }

    void updatePlayerBidInternal(ItemAuctionBid bid, boolean delete) {
        String query = delete ? DELETE_ITEM_AUCTION_BID : INSERT_ITEM_AUCTION_BID;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, this._auctionId);
            ps.setInt(2, bid.getPlayerObjId());
            if (!delete) {
                ps.setLong(3, bid.getLastBid());
                ps.setLong(4, bid.getLastBid());
            }
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBid(L2PcInstance player, long newBid) {
        if (player == null) {
            throw new NullPointerException();
        }
        if (newBid < this.getAuctionInitBid()) {
            player.sendPacket(SystemMessageId.BID_PRICE_MUST_BE_HIGHER);
            return;
        }
        if (newBid > 100000000000L) {
            player.sendPacket(SystemMessageId.BID_CANT_EXCEED_100_BILLION);
            return;
        }
        if (this.getAuctionState() != ItemAuctionState.STARTED) {
            return;
        }
        int playerObjId = player.getObjectId();
        List<ItemAuctionBid> list = this._auctionBids;
        synchronized (list) {
            if (this._highestBid != null && newBid < this._highestBid.getLastBid()) {
                player.sendPacket(SystemMessageId.BID_MUST_BE_HIGHER_THAN_CURRENT_BID);
                return;
            }
            ItemAuctionBid bid = this.getBidFor(playerObjId);
            if (bid == null) {
                if (!this.reduceItemCount(player, newBid)) {
                    player.sendPacket(SystemMessageId.NOT_ENOUGH_ADENA_FOR_THIS_BID);
                    return;
                }
                bid = new ItemAuctionBid(playerObjId, newBid);
                this._auctionBids.add(bid);
            } else {
                if (!bid.isCanceled()) {
                    if (newBid < bid.getLastBid()) {
                        player.sendPacket(SystemMessageId.BID_MUST_BE_HIGHER_THAN_CURRENT_BID);
                        return;
                    }
                    if (!this.reduceItemCount(player, newBid - bid.getLastBid())) {
                        player.sendPacket(SystemMessageId.NOT_ENOUGH_ADENA_FOR_THIS_BID);
                        return;
                    }
                } else if (!this.reduceItemCount(player, newBid)) {
                    player.sendPacket(SystemMessageId.NOT_ENOUGH_ADENA_FOR_THIS_BID);
                    return;
                }
                bid.setLastBid(newBid);
            }
            this.onPlayerBid(player, bid);
            this.updatePlayerBid(bid, false);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SUBMITTED_A_BID_OF_S1);
            sm.addLong(newBid);
            player.sendPacket(sm);
        }
    }

    private void onPlayerBid(L2PcInstance player, ItemAuctionBid bid) {
        if (this._highestBid == null) {
            this._highestBid = bid;
        } else if (this._highestBid.getLastBid() < bid.getLastBid()) {
            L2PcInstance old = this._highestBid.getPlayer();
            if (old != null) {
                old.sendPacket(SystemMessageId.YOU_HAVE_BEEN_OUTBID);
            }
            this._highestBid = bid;
        }
        if (this.getEndingTime() - System.currentTimeMillis() <= 600000L) {
            switch (this._auctionEndingExtendState) {
                case INITIAL: {
                    this._auctionEndingExtendState = ItemAuctionExtendState.EXTEND_BY_5_MIN;
                    this._endingTime += ENDING_TIME_EXTEND_5;
                    this.broadcastToAllBidders(SystemMessage.getSystemMessage(SystemMessageId.BIDDER_EXISTS_AUCTION_TIME_EXTENDED_BY_5_MINUTES));
                    break;
                }
                case EXTEND_BY_5_MIN: {
                    if (this.getAndSetLastBidPlayerObjectId(player.getObjectId()) == player.getObjectId()) break;
                    this._auctionEndingExtendState = ItemAuctionExtendState.EXTEND_BY_3_MIN;
                    this._endingTime += ENDING_TIME_EXTEND_3;
                    this.broadcastToAllBidders(SystemMessage.getSystemMessage(SystemMessageId.BIDDER_EXISTS_AUCTION_TIME_EXTENDED_BY_3_MINUTES));
                    break;
                }
                case EXTEND_BY_3_MIN: {
                    if (Configuration.general().getItemAuctionTimeExtendsOnBid() <= 0L || this.getAndSetLastBidPlayerObjectId(player.getObjectId()) == player.getObjectId()) break;
                    this._auctionEndingExtendState = ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A;
                    this._endingTime += Configuration.general().getItemAuctionTimeExtendsOnBid();
                    break;
                }
                case EXTEND_BY_CONFIG_PHASE_A: {
                    if (this.getAndSetLastBidPlayerObjectId(player.getObjectId()) == player.getObjectId() || this._scheduledAuctionEndingExtendState != ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_B) break;
                    this._auctionEndingExtendState = ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_B;
                    this._endingTime += Configuration.general().getItemAuctionTimeExtendsOnBid();
                    break;
                }
                case EXTEND_BY_CONFIG_PHASE_B: {
                    if (this.getAndSetLastBidPlayerObjectId(player.getObjectId()) == player.getObjectId() || this._scheduledAuctionEndingExtendState != ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A) break;
                    this._endingTime += Configuration.general().getItemAuctionTimeExtendsOnBid();
                    this._auctionEndingExtendState = ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A;
                }
            }
        }
    }

    public void broadcastToAllBidders(L2GameServerPacket packet) {
        ThreadPoolManager.getInstance().executeGeneral(() -> this.broadcastToAllBiddersInternal(packet));
    }

    public void broadcastToAllBiddersInternal(L2GameServerPacket packet) {
        int i = this._auctionBids.size();
        while (i-- > 0) {
            L2PcInstance player;
            ItemAuctionBid bid = this._auctionBids.get(i);
            if (bid == null || (player = bid.getPlayer()) == null) continue;
            player.sendPacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelBid(L2PcInstance player) {
        if (player == null) {
            throw new NullPointerException();
        }
        switch (this.getAuctionState()) {
            case CREATED: {
                return false;
            }
            case FINISHED: {
                if (this._startingTime >= System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(Configuration.general().getItemAuctionExpiredAfter(), TimeUnit.DAYS)) break;
                return false;
            }
        }
        int playerObjId = player.getObjectId();
        List<ItemAuctionBid> list = this._auctionBids;
        synchronized (list) {
            if (this._highestBid == null) {
                return false;
            }
            int bidIndex = this.getBidIndexFor(playerObjId);
            if (bidIndex == -1) {
                return false;
            }
            ItemAuctionBid bid = this._auctionBids.get(bidIndex);
            if (bid.getPlayerObjId() == this._highestBid.getPlayerObjId()) {
                if (this.getAuctionState() == ItemAuctionState.FINISHED) {
                    return false;
                }
                player.sendPacket(SystemMessageId.HIGHEST_BID_BUT_RESERVE_NOT_MET);
                return true;
            }
            if (bid.isCanceled()) {
                return false;
            }
            this.increaseItemCount(player, bid.getLastBid());
            bid.cancelBid();
            this.updatePlayerBid(bid, this.getAuctionState() == ItemAuctionState.FINISHED);
            player.sendPacket(SystemMessageId.CANCELED_BID);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCanceledBids() {
        if (this.getAuctionState() != ItemAuctionState.FINISHED) {
            throw new IllegalStateException("Attempt to clear canceled bids for non-finished auction");
        }
        List<ItemAuctionBid> list = this._auctionBids;
        synchronized (list) {
            for (ItemAuctionBid bid : this._auctionBids) {
                if (bid == null || !bid.isCanceled()) continue;
                this.updatePlayerBid(bid, true);
            }
        }
    }

    private boolean reduceItemCount(L2PcInstance player, long count) {
        if (!player.reduceAdena("ItemAuction", count, player, true)) {
            player.sendPacket(SystemMessageId.NOT_ENOUGH_ADENA_FOR_THIS_BID);
            return false;
        }
        return true;
    }

    private void increaseItemCount(L2PcInstance player, long count) {
        player.addAdena("ItemAuction", count, player, true);
    }

    public long getLastBid(L2PcInstance player) {
        ItemAuctionBid bid = this.getBidFor(player.getObjectId());
        return bid != null ? bid.getLastBid() : -1L;
    }

    public ItemAuctionBid getBidFor(int playerObjId) {
        int index = this.getBidIndexFor(playerObjId);
        return index != -1 ? this._auctionBids.get(index) : null;
    }

    private int getBidIndexFor(int playerObjId) {
        int i = this._auctionBids.size();
        while (i-- > 0) {
            ItemAuctionBid bid = this._auctionBids.get(i);
            if (bid == null || bid.getPlayerObjId() != playerObjId) continue;
            return i;
        }
        return -1;
    }
}

