/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemauction;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.instancemanager.ItemAuctionManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemauction.AuctionDateGenerator;
import com.l2jserver.gameserver.model.itemauction.AuctionItem;
import com.l2jserver.gameserver.model.itemauction.ItemAuction;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionBid;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionExtendState;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionState;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ItemAuctionInstance {
    private static final Logger LOG = LoggerFactory.getLogger(ItemAuctionInstance.class);
    private final SimpleDateFormat DATE_FORMAT;
    private static final long START_TIME_SPACE = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    private static final long FINISH_TIME_SPACE = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
    private static final String SELECT_AUCTION_ID_BY_INSTANCE_ID = "SELECT auctionId FROM item_auction WHERE instanceId = ?";
    private static final String SELECT_AUCTION_INFO = "SELECT auctionItemId, startingTime, endingTime, auctionStateId FROM item_auction WHERE auctionId = ? ";
    private static final String DELETE_AUCTION_INFO_BY_AUCTION_ID = "DELETE FROM item_auction WHERE auctionId = ?";
    private static final String DELETE_AUCTION_BID_INFO_BY_AUCTION_ID = "DELETE FROM item_auction_bid WHERE auctionId = ?";
    private static final String SELECT_PLAYERS_ID_BY_AUCTION_ID = "SELECT playerObjId, playerBid FROM item_auction_bid WHERE auctionId = ?";
    private final int _instanceId;
    private final AtomicInteger _auctionIds;
    private final Map<Integer, ItemAuction> _auctions;
    private final ArrayList<AuctionItem> _items;
    private final AuctionDateGenerator _dateGenerator;
    private ItemAuction _currentAuction;
    private ItemAuction _nextAuction;
    private ScheduledFuture<?> _stateTask;

    public ItemAuctionInstance(int instanceId, AtomicInteger auctionIds, Node node) {
        block35: {
            this.DATE_FORMAT = new SimpleDateFormat("HH:mm:ss dd.MM.yy");
            this._instanceId = instanceId;
            this._auctionIds = auctionIds;
            this._auctions = new HashMap<Integer, ItemAuction>();
            this._items = new ArrayList();
            NamedNodeMap nanode = node.getAttributes();
            StatsSet generatorConfig = new StatsSet();
            int i = nanode.getLength();
            while (i-- > 0) {
                Node n = nanode.item(i);
                if (n == null) continue;
                generatorConfig.set(n.getNodeName(), n.getNodeValue());
            }
            this._dateGenerator = new AuctionDateGenerator(generatorConfig);
            for (Node na = node.getFirstChild(); na != null; na = na.getNextSibling()) {
                try {
                    if (!"item".equalsIgnoreCase(na.getNodeName())) continue;
                    NamedNodeMap naa = na.getAttributes();
                    int auctionItemId = Integer.parseInt(naa.getNamedItem("auctionItemId").getNodeValue());
                    int auctionLength = Integer.parseInt(naa.getNamedItem("auctionLength").getNodeValue());
                    long auctionInitBid = Integer.parseInt(naa.getNamedItem("auctionInitBid").getNodeValue());
                    int itemId = Integer.parseInt(naa.getNamedItem("itemId").getNodeValue());
                    int itemCount = Integer.parseInt(naa.getNamedItem("itemCount").getNodeValue());
                    if (auctionLength < 1) {
                        throw new IllegalArgumentException("auctionLength < 1 for instanceId: " + this._instanceId + ", itemId " + itemId);
                    }
                    StatsSet itemExtra = new StatsSet();
                    AuctionItem item = new AuctionItem(auctionItemId, auctionLength, auctionInitBid, itemId, itemCount, itemExtra);
                    if (!item.checkItemExists()) {
                        throw new IllegalArgumentException("Item with id " + itemId + " not found");
                    }
                    for (AuctionItem tmp : this._items) {
                        if (tmp.getAuctionItemId() != auctionItemId) continue;
                        throw new IllegalArgumentException("Duplicated auction item id " + auctionItemId);
                    }
                    this._items.add(item);
                    for (Node nb = na.getFirstChild(); nb != null; nb = nb.getNextSibling()) {
                        if (!"extra".equalsIgnoreCase(nb.getNodeName())) continue;
                        NamedNodeMap nab = nb.getAttributes();
                        int i2 = nab.getLength();
                        while (i2-- > 0) {
                            Node n = nab.item(i2);
                            if (n == null) continue;
                            itemExtra.set(n.getNodeName(), n.getNodeValue());
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Failed loading auction item!", e);
                }
            }
            if (this._items.isEmpty()) {
                throw new IllegalArgumentException("No items defined");
            }
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(SELECT_AUCTION_ID_BY_INSTANCE_ID);){
                ps.setInt(1, this._instanceId);
                ResultSet rs = ps.executeQuery();
                block26: while (true) {
                    while (rs.next()) {
                        int auctionId = rs.getInt(1);
                        try {
                            ItemAuction auction = this.loadAuction(auctionId);
                            if (auction != null) {
                                this._auctions.put(auctionId, auction);
                                continue block26;
                            }
                            ItemAuctionManager.deleteAuction(auctionId);
                            continue block26;
                        }
                        catch (Exception e) {
                            LOG.warn("Failed loading auction ID {}!", (Object)auctionId, (Object)e);
                        }
                    }
                    break block35;
                    {
                        continue block26;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error loading auctions.", e);
                return;
            }
        }
        LOG.info("Loaded {} item(s) and registered {} auction(s) for NPC ID {}.", this._items.size(), this._auctions.size(), this._instanceId);
        this.checkAndSetCurrentAndNextAuction();
    }

    public ItemAuction getCurrentAuction() {
        return this._currentAuction;
    }

    public ItemAuction getNextAuction() {
        return this._nextAuction;
    }

    public void shutdown() {
        ScheduledFuture<?> stateTask = this._stateTask;
        if (stateTask != null) {
            stateTask.cancel(false);
        }
    }

    private AuctionItem getAuctionItem(int auctionItemId) {
        int i = this._items.size();
        while (i-- > 0) {
            AuctionItem item = this._items.get(i);
            if (item.getAuctionItemId() != auctionItemId) continue;
            return item;
        }
        return null;
    }

    void checkAndSetCurrentAndNextAuction() {
        ItemAuction[] auctions = this._auctions.values().toArray(new ItemAuction[this._auctions.size()]);
        ItemAuction currentAuction = null;
        ItemAuction nextAuction = null;
        int n = auctions.length;
        block0 : switch (n) {
            case 0: {
                nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                break;
            }
            case 1: {
                switch (auctions[0].getAuctionState()) {
                    case CREATED: {
                        if (auctions[0].getStartingTime() < System.currentTimeMillis() + START_TIME_SPACE) {
                            currentAuction = auctions[0];
                            nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                            break block0;
                        }
                        nextAuction = auctions[0];
                        break block0;
                    }
                    case STARTED: {
                        currentAuction = auctions[0];
                        nextAuction = this.createAuction(Math.max(currentAuction.getEndingTime() + FINISH_TIME_SPACE, System.currentTimeMillis() + START_TIME_SPACE));
                        break block0;
                    }
                    case FINISHED: {
                        currentAuction = auctions[0];
                        nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                Arrays.sort(auctions, Comparator.comparingLong(ItemAuction::getStartingTime).reversed());
                long currentTime = System.currentTimeMillis();
                for (ItemAuction auction : auctions) {
                    if (auction.getAuctionState() == ItemAuctionState.STARTED) {
                        currentAuction = auction;
                        break;
                    }
                    if (auction.getStartingTime() > currentTime) continue;
                    currentAuction = auction;
                    break;
                }
                for (ItemAuction auction : auctions) {
                    if (auction.getStartingTime() <= currentTime || currentAuction == auction) continue;
                    nextAuction = auction;
                    break;
                }
                if (nextAuction != null) break;
                nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
            }
        }
        this._auctions.put(nextAuction.getAuctionId(), nextAuction);
        this._currentAuction = currentAuction;
        this._nextAuction = nextAuction;
        if (currentAuction != null && currentAuction.getAuctionState() != ItemAuctionState.FINISHED) {
            if (currentAuction.getAuctionState() == ItemAuctionState.STARTED) {
                this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleAuctionTask(currentAuction), Math.max(currentAuction.getEndingTime() - System.currentTimeMillis(), 0L)));
            } else {
                this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleAuctionTask(currentAuction), Math.max(currentAuction.getStartingTime() - System.currentTimeMillis(), 0L)));
            }
            LOG.info("Schedule current auction ID {} for NPC ID {}.", (Object)currentAuction.getAuctionId(), (Object)this._instanceId);
        } else {
            this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleAuctionTask(nextAuction), Math.max(nextAuction.getStartingTime() - System.currentTimeMillis(), 0L)));
            LOG.info("Schedule next auction ID {} on {} for NPC ID {}.", nextAuction.getAuctionId(), this.DATE_FORMAT.format(new Date(nextAuction.getStartingTime())), this._instanceId);
        }
    }

    public ItemAuction getAuction(int auctionId) {
        return this._auctions.get(auctionId);
    }

    public ItemAuction[] getAuctionsByBidder(int bidderObjId) {
        Collection<ItemAuction> auctions = this.getAuctions();
        ArrayList<ItemAuction> stack = new ArrayList<ItemAuction>(auctions.size());
        for (ItemAuction auction : this.getAuctions()) {
            ItemAuctionBid bid;
            if (auction.getAuctionState() == ItemAuctionState.CREATED || (bid = auction.getBidFor(bidderObjId)) == null) continue;
            stack.add(auction);
        }
        return stack.toArray(new ItemAuction[stack.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ItemAuction> getAuctions() {
        Collection<ItemAuction> auctions;
        Map<Integer, ItemAuction> map = this._auctions;
        synchronized (map) {
            auctions = this._auctions.values();
        }
        return auctions;
    }

    void onAuctionFinished(ItemAuction auction) {
        auction.broadcastToAllBiddersInternal((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.S1_AUCTION_ENDED).addInt(auction.getAuctionId())));
        ItemAuctionBid bid = auction.getHighestBid();
        if (bid != null) {
            L2ItemInstance item = auction.createNewItemInstance();
            L2PcInstance player = bid.getPlayer();
            if (player != null) {
                player.getWarehouse().addItem("ItemAuction", item, null, null);
                player.sendPacket(SystemMessageId.WON_BID_ITEM_CAN_BE_FOUND_IN_WAREHOUSE);
                LOG.info("Auction ID {} has finished. Highest bid by {} for instance ID {}.", auction.getAuctionId(), player.getName(), this._instanceId);
            } else {
                item.setOwnerId(bid.getPlayerObjId());
                item.setItemLocation(ItemLocation.WAREHOUSE);
                item.updateDatabase();
                L2World.getInstance().removeObject(item);
                String playerName = CharNameTable.getInstance().getNameById(bid.getPlayerObjId());
                LOG.info("Auction ID {} has finished. Highest bid by {} for instance ID {}.", auction.getAuctionId(), playerName, this._instanceId);
            }
            auction.clearCanceledBids();
        } else {
            LOG.info("Auction ID {} has finished. There have not been any bid for instance ID {}.", (Object)auction.getAuctionId(), (Object)this._instanceId);
        }
    }

    void setStateTask(ScheduledFuture<?> future) {
        ScheduledFuture<?> stateTask = this._stateTask;
        if (stateTask != null) {
            stateTask.cancel(false);
        }
        this._stateTask = future;
    }

    private ItemAuction createAuction(long after) {
        AuctionItem auctionItem = this._items.get(Rnd.get((int)this._items.size()));
        long startingTime = this._dateGenerator.nextDate(after);
        long endingTime = startingTime + TimeUnit.MILLISECONDS.convert(auctionItem.getAuctionLength(), TimeUnit.MINUTES);
        ItemAuction auction = new ItemAuction(this._auctionIds.getAndIncrement(), this._instanceId, startingTime, endingTime, auctionItem);
        auction.storeMe();
        return auction;
    }

    private ItemAuction loadAuction(int auctionId) throws Exception {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            byte auctionStateId;
            long endingTime;
            long startingTime;
            int auctionItemId;
            ResultSet rs;
            try (PreparedStatement ps = con.prepareStatement(SELECT_AUCTION_INFO);){
                ps.setInt(1, auctionId);
                rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        LOG.warn("Auction data not found for auction ID {}!", (Object)auctionId);
                        ItemAuction itemAuction = null;
                        return itemAuction;
                    }
                    auctionItemId = rs.getInt(1);
                    startingTime = rs.getLong(2);
                    endingTime = rs.getLong(3);
                    auctionStateId = rs.getByte(4);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (startingTime >= endingTime) {
                LOG.warn("Invalid starting/ending parameters for auction ID {}!", (Object)auctionId);
                ps = null;
                return ps;
            }
            AuctionItem auctionItem = this.getAuctionItem(auctionItemId);
            if (auctionItem == null) {
                LOG.warn("Auction item ID {} not found for auction ID {}!", (Object)auctionItemId, (Object)auctionId);
                rs = null;
                return rs;
            }
            ItemAuctionState auctionState = ItemAuctionState.stateForStateId(auctionStateId);
            if (auctionState == null) {
                LOG.warn("Invalid auctionStateId {} for auction ID {}!", (Object)auctionStateId, (Object)auctionId);
                ItemAuction itemAuction = null;
                return itemAuction;
            }
            if (auctionState == ItemAuctionState.FINISHED && startingTime < System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(Configuration.general().getItemAuctionExpiredAfter(), TimeUnit.DAYS)) {
                LOG.info("Clearing expired auction ID {}.", (Object)auctionId);
                try (PreparedStatement ps = con.prepareStatement(DELETE_AUCTION_INFO_BY_AUCTION_ID);){
                    ps.setInt(1, auctionId);
                    ps.execute();
                }
                ps = con.prepareStatement(DELETE_AUCTION_BID_INFO_BY_AUCTION_ID);
                try {
                    ps.setInt(1, auctionId);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = null;
                return ps;
            }
            ArrayList<ItemAuctionBid> auctionBids = new ArrayList<ItemAuctionBid>();
            try (PreparedStatement ps = con.prepareStatement(SELECT_PLAYERS_ID_BY_AUCTION_ID);){
                ps.setInt(1, auctionId);
                try (ResultSet rs2 = ps.executeQuery();){
                    while (rs2.next()) {
                        int playerObjId = rs2.getInt(1);
                        long playerBid = rs2.getLong(2);
                        ItemAuctionBid bid = new ItemAuctionBid(playerObjId, playerBid);
                        auctionBids.add(bid);
                    }
                }
            }
            ItemAuction itemAuction = new ItemAuction(auctionId, this._instanceId, startingTime, endingTime, auctionItem, auctionBids, auctionState);
            return itemAuction;
        }
    }

    private class ScheduleAuctionTask
    implements Runnable {
        private final Logger LOG = LoggerFactory.getLogger(ScheduleAuctionTask.class);
        private final ItemAuction _auction;

        public ScheduleAuctionTask(ItemAuction auction) {
            this._auction = auction;
        }

        @Override
        public final void run() {
            try {
                this.runImpl();
            }
            catch (Exception e) {
                this.LOG.error("Failed scheduling auction ID {}!", (Object)this._auction.getAuctionId(), (Object)e);
            }
        }

        private void runImpl() {
            ItemAuctionState state = this._auction.getAuctionState();
            switch (state) {
                case CREATED: {
                    if (!this._auction.setAuctionState(state, ItemAuctionState.STARTED)) {
                        throw new IllegalStateException("Could not set auction state: " + ItemAuctionState.STARTED.toString() + ", expected: " + state.toString());
                    }
                    this.LOG.info("Auction ID {} has started for NPC ID {}.", (Object)this._auction.getAuctionId(), (Object)this._auction.getInstanceId());
                    ItemAuctionInstance.this.checkAndSetCurrentAndNextAuction();
                    break;
                }
                case STARTED: {
                    switch (this._auction.getAuctionEndingExtendState()) {
                        case EXTEND_BY_5_MIN: {
                            if (this._auction.getScheduledAuctionEndingExtendState() != ItemAuctionExtendState.INITIAL) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_5_MIN);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                        case EXTEND_BY_3_MIN: {
                            if (this._auction.getScheduledAuctionEndingExtendState() == ItemAuctionExtendState.EXTEND_BY_3_MIN) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_3_MIN);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                        case EXTEND_BY_CONFIG_PHASE_A: {
                            if (this._auction.getScheduledAuctionEndingExtendState() == ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_B) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_B);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                        case EXTEND_BY_CONFIG_PHASE_B: {
                            if (this._auction.getScheduledAuctionEndingExtendState() == ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                    }
                    if (!this._auction.setAuctionState(state, ItemAuctionState.FINISHED)) {
                        throw new IllegalStateException("Could not set auction state: " + ItemAuctionState.FINISHED.toString() + ", expected: " + state.toString());
                    }
                    ItemAuctionInstance.this.onAuctionFinished(this._auction);
                    ItemAuctionInstance.this.checkAndSetCurrentAndNextAuction();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid state: " + String.valueOf((Object)state));
                }
            }
        }
    }
}

