/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.ItemType1;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.skills.Skill;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2Armor
extends L2Item {
    private static final Logger LOG = LoggerFactory.getLogger(L2Armor.class);
    private SkillHolder _enchant4Skill = null;
    private ArmorType _type;

    public L2Armor(StatsSet set) {
        super(set);
        String[] info;
        this._type = set.getEnum("armor_type", ArmorType.class, ArmorType.NONE);
        int _bodyPart = this.getBodyPart();
        if (_bodyPart == 8 || (_bodyPart & 4) != 0 || (_bodyPart & 0x20) != 0 || (_bodyPart & 0x100000) != 0 || (_bodyPart & 0x200000) != 0) {
            this._type1 = ItemType1.WEAPON_RING_EARRING_NECKLACE;
            this._type2 = ItemType2.ACCESSORY;
        } else {
            if (this._type == ArmorType.NONE && this.getBodyPart() == 256) {
                this._type = ArmorType.SHIELD;
            }
            this._type1 = ItemType1.SHIELD_ARMOR;
            this._type2 = ItemType2.SHIELD_ARMOR;
        }
        String skill = set.getString("enchant4_skill", null);
        if (skill != null && (info = skill.split("-")).length == 2) {
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                LOG.warn("Couldn't parse {} in armor enchant skills! item {}!", (Object)skill, (Object)this);
            }
            if (id > 0 && level > 0) {
                this._enchant4Skill = new SkillHolder(id, level);
            }
        }
    }

    @Override
    public ArmorType getItemType() {
        return this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    @Override
    public Skill getEnchant4Skill() {
        if (this._enchant4Skill == null) {
            return null;
        }
        return this._enchant4Skill.getSkill();
    }
}

