/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlympiadGameTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(OlympiadGameTask.class);
    private static final int[] TELEPORT_TO_ARENA_TIMES = new int[]{120, 60, 30, 15, 10, 5, 4, 3, 2, 1, 0};
    private static final int[] BATTLE_START_TIME_FIRST = new int[]{60, 50, 40, 30, 20, 10, 0};
    private static final int[] BATTLE_START_TIME_SECOND = new int[]{10, 5, 4, 3, 2, 1, 0};
    private static final int[] TELEPORT_TO_TOWN_TIMES = new int[]{40, 30, 20, 10, 5, 4, 3, 2, 1, 0};
    private final L2OlympiadStadiumZone _zone;
    private AbstractOlympiadGame _game;
    private GameState _state = GameState.IDLE;
    private boolean _needAnnounce = false;
    private int _countDown = 0;

    public OlympiadGameTask(L2OlympiadStadiumZone zone) {
        this._zone = zone;
        zone.registerTask(this);
    }

    public boolean isRunning() {
        return this._state != GameState.IDLE;
    }

    public boolean isGameStarted() {
        return this._state.ordinal() >= GameState.GAME_STARTED.ordinal() && this._state.ordinal() <= GameState.CLEANUP.ordinal();
    }

    public boolean isBattleStarted() {
        return this._state == GameState.BATTLE_IN_PROGRESS;
    }

    public boolean isBattleFinished() {
        return this._state == GameState.TELEPORT_TO_TOWN;
    }

    public boolean needAnnounce() {
        if (this._needAnnounce) {
            this._needAnnounce = false;
            return true;
        }
        return false;
    }

    public L2OlympiadStadiumZone getZone() {
        return this._zone;
    }

    public AbstractOlympiadGame getGame() {
        return this._game;
    }

    public void attachGame(AbstractOlympiadGame game) {
        if (game != null && this._state != GameState.IDLE) {
            LOG.warn("Attempt to overwrite non-finished game in state {}", (Object)this._state);
            return;
        }
        this._game = game;
        this._state = GameState.BEGIN;
        this._needAnnounce = false;
        ThreadPoolManager.getInstance().executeGeneral(this);
    }

    @Override
    public void run() {
        try {
            int delay = 1;
            switch (this._state.ordinal()) {
                case 0: {
                    this._state = GameState.TELEPORT_TO_ARENA;
                    this._countDown = Configuration.olympiad().getWaitTime();
                    break;
                }
                case 1: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_WILL_ENTER_THE_OLYMPIAD_STADIUM_IN_S1_SECOND_S);
                        sm.addInt(this._countDown);
                        this._game.broadcastPacket(sm);
                    }
                    delay = this.getDelay(TELEPORT_TO_ARENA_TIMES);
                    if (this._countDown > 0) break;
                    this._state = GameState.GAME_STARTED;
                    break;
                }
                case 2: {
                    if (!this.startGame()) {
                        this._state = GameState.GAME_CANCELLED;
                        break;
                    }
                    this._state = GameState.BATTLE_COUNTDOWN_FIRST;
                    this._countDown = BATTLE_START_TIME_FIRST[0];
                    delay = 5;
                    break;
                }
                case 3: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_WILL_START_IN_S1_SECOND_S);
                        sm.addInt(this._countDown);
                        this._zone.broadcastPacket(sm);
                    }
                    delay = this.getDelay(BATTLE_START_TIME_FIRST);
                    if (this._countDown > 0) break;
                    this.openDoors();
                    this._state = GameState.BATTLE_COUNTDOWN_SECOND;
                    this._countDown = BATTLE_START_TIME_SECOND[0];
                    delay = this.getDelay(BATTLE_START_TIME_SECOND);
                    break;
                }
                case 4: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_WILL_START_IN_S1_SECOND_S);
                        sm.addInt(this._countDown);
                        this._zone.broadcastPacket(sm);
                    }
                    delay = this.getDelay(BATTLE_START_TIME_SECOND);
                    if (this._countDown > 0) break;
                    this._state = GameState.BATTLE_STARTED;
                    break;
                }
                case 5: {
                    this._countDown = 0;
                    this._state = GameState.BATTLE_IN_PROGRESS;
                    if (this.startBattle()) break;
                    this._state = GameState.GAME_STOPPED;
                    break;
                }
                case 6: {
                    this._countDown += 1000;
                    if (!this.checkBattle() && this._countDown <= Configuration.olympiad().getBattlePeriod()) break;
                    this._state = GameState.GAME_STOPPED;
                    break;
                }
                case 7: {
                    this.stopGame();
                    this._state = GameState.CLEANUP;
                    break;
                }
                case 8: {
                    this._state = GameState.TELEPORT_TO_TOWN;
                    this._countDown = TELEPORT_TO_TOWN_TIMES[0];
                    this.stopGame();
                    delay = this.getDelay(TELEPORT_TO_TOWN_TIMES);
                    break;
                }
                case 9: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_WILL_BE_MOVED_TO_TOWN_IN_S1_SECONDS);
                        sm.addInt(this._countDown);
                        this._game.broadcastPacket(sm);
                    }
                    delay = this.getDelay(TELEPORT_TO_TOWN_TIMES);
                    if (this._countDown > 0) break;
                    this._state = GameState.CLEANUP;
                    break;
                }
                case 10: {
                    this.cleanupGame();
                    this._state = GameState.IDLE;
                    this._game = null;
                    return;
                }
            }
            ThreadPoolManager.getInstance().scheduleGeneral(this, (long)delay * 1000L);
        }
        catch (Exception e) {
            switch (this._state.ordinal()) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    LOG.warn("Unable to return players back in town, exception: {}", (Object)e.getMessage());
                    this._state = GameState.IDLE;
                    this._game = null;
                    return;
                }
            }
            LOG.warn("Exception in {}, trying to port players back: {}", new Object[]{this._state, e.getMessage(), e});
            this._state = GameState.GAME_STOPPED;
            ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
        }
    }

    private int getDelay(int[] times) {
        for (int i = 0; i < times.length - 1; ++i) {
            int time = times[i];
            if (time >= this._countDown) continue;
            int delay = this._countDown - time;
            this._countDown = time;
            return delay;
        }
        this._countDown = -1;
        return 1;
    }

    private boolean startGame() {
        try {
            if (this._game.checkDefaulted()) {
                return false;
            }
            this._zone.closeDoors();
            if (this._game.needBuffers()) {
                this._zone.spawnBuffers();
            }
            if (!this._game.portPlayersToArena(this._zone.getSpawns())) {
                return false;
            }
            this._game.removals();
            this._needAnnounce = true;
            OlympiadGameManager.getInstance().startBattle();
            return true;
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return false;
        }
    }

    private void openDoors() {
        try {
            this._game.resetDamage();
            this._zone.openDoors();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
    }

    private boolean startBattle() {
        try {
            if (this._game.needBuffers()) {
                this._zone.deleteBuffers();
            }
            if (this._game.checkBattleStatus() && this._game.makeCompetitionStart()) {
                this._game.broadcastOlympiadInfo(this._zone);
                this._zone.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.STARTS_THE_GAME));
                this._zone.updateZoneStatusForCharactersInside();
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        return false;
    }

    private boolean checkBattle() {
        try {
            return this._game.haveWinner();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return true;
        }
    }

    private void stopGame() {
        try {
            this._game.validateWinner(this._zone);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        try {
            this._zone.updateZoneStatusForCharactersInside();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        try {
            this._game.cleanEffects();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
    }

    private void cleanupGame() {
        try {
            this._game.playersStatusBack();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        try {
            this._game.portPlayersBack();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        try {
            this._game.clearPlayers();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        try {
            this._zone.closeDoors();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
    }

    private static enum GameState {
        BEGIN,
        TELEPORT_TO_ARENA,
        GAME_STARTED,
        BATTLE_COUNTDOWN_FIRST,
        BATTLE_COUNTDOWN_SECOND,
        BATTLE_STARTED,
        BATTLE_IN_PROGRESS,
        GAME_CANCELLED,
        GAME_STOPPED,
        TELEPORT_TO_TOWN,
        CLEANUP,
        IDLE;

    }
}

