/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.OlympiadInfo;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchResult;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlympiadGameTeams
extends AbstractOlympiadGame {
    private static final Logger LOG = LoggerFactory.getLogger(OlympiadGameTeams.class);
    private static final int MAX_TEAM_SIZE = 3;
    private boolean _teamOneDefaulted;
    private boolean _teamTwoDefaulted;
    private int _damageT1 = 0;
    private int _damageT2 = 0;
    private final int _teamOneSize;
    private final int _teamTwoSize;
    private final Participant[] _teamOne;
    private final Participant[] _teamTwo;

    private OlympiadGameTeams(int id, Participant[] teamOne, Participant[] teamTwo) {
        super(id);
        this._teamOneSize = Math.min(teamOne.length, 3);
        this._teamTwoSize = Math.min(teamTwo.length, 3);
        this._teamOne = new Participant[3];
        this._teamTwo = new Participant[3];
        for (int i = 0; i < 3; ++i) {
            int objectId;
            Participant par;
            if (i < this._teamOneSize) {
                this._teamOne[i] = par = teamOne[i];
                if (par.getPlayer() != null) {
                    par.getPlayer().setOlympiadGameId(id);
                }
            } else {
                objectId = IdFactory.getInstance().getNextId();
                this._teamOne[i] = new Participant(objectId, 1);
            }
            if (i < this._teamTwoSize) {
                this._teamTwo[i] = par = teamTwo[i];
                if (par.getPlayer() == null) continue;
                par.getPlayer().setOlympiadGameId(id);
                continue;
            }
            objectId = IdFactory.getInstance().getNextId();
            this._teamTwo[i] = new Participant(objectId, 2);
        }
    }

    private static Participant[][] createListOfParticipants(List<List<Integer>> list) {
        if (list == null || list.isEmpty() || list.size() < 2) {
            return null;
        }
        ArrayList<L2PcInstance> teamOnePlayers = new ArrayList<L2PcInstance>(3);
        ArrayList<L2PcInstance> teamTwoPlayers = new ArrayList<L2PcInstance>(3);
        while (list.size() > 1) {
            int i;
            L2PcInstance player;
            List<Integer> teamOne = list.remove(Rnd.nextInt((int)list.size()));
            if (teamOne == null || teamOne.isEmpty()) continue;
            for (int objectId : teamOne) {
                player = L2World.getInstance().getPlayer(objectId);
                if (player == null || !player.isOnline()) {
                    teamOnePlayers.clear();
                    break;
                }
                teamOnePlayers.add(player);
            }
            if (teamOnePlayers.isEmpty()) continue;
            List<Integer> teamTwo = list.remove(Rnd.nextInt((int)list.size()));
            if (teamTwo == null || teamTwo.isEmpty()) {
                list.add(teamOne);
                teamOnePlayers.clear();
                continue;
            }
            for (int objectId : teamTwo) {
                player = L2World.getInstance().getPlayer(objectId);
                if (player == null || !player.isOnline()) {
                    teamTwoPlayers.clear();
                    break;
                }
                teamTwoPlayers.add(player);
            }
            if (teamTwoPlayers.isEmpty()) {
                list.add(teamOne);
                teamOnePlayers.clear();
                continue;
            }
            Participant[] t1 = new Participant[teamOnePlayers.size()];
            Participant[] t2 = new Participant[teamTwoPlayers.size()];
            Participant[][] result = new Participant[2][];
            for (i = 0; i < t1.length; ++i) {
                t1[i] = new Participant((L2PcInstance)teamOnePlayers.get(i), 1);
            }
            for (i = 0; i < t2.length; ++i) {
                t2[i] = new Participant((L2PcInstance)teamTwoPlayers.get(i), 2);
            }
            result[0] = t1;
            result[1] = t2;
            return result;
        }
        return null;
    }

    protected static OlympiadGameTeams createGame(int id, List<List<Integer>> list) {
        Participant[][] teams = OlympiadGameTeams.createListOfParticipants(list);
        if (teams == null) {
            return null;
        }
        return new OlympiadGameTeams(id, teams[0], teams[1]);
    }

    @Override
    public CompetitionType getType() {
        return CompetitionType.TEAMS;
    }

    @Override
    protected int getDivider() {
        return 5;
    }

    @Override
    protected List<ItemHolder> getReward() {
        return Configuration.olympiad().getTeamReward();
    }

    @Override
    protected final String getWeeklyMatchType() {
        return "competitions_done_week_team";
    }

    @Override
    public final boolean containsParticipant(int playerId) {
        int i = this._teamOneSize;
        while (--i >= 0) {
            if (this._teamOne[i].getObjectId() != playerId) continue;
            return true;
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            if (this._teamTwo[i].getObjectId() != playerId) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void sendOlympiadInfo(L2Character player) {
        int i;
        for (i = 0; i < 3; ++i) {
            player.sendPacket(new ExOlympiadUserInfo(this._teamOne[i]));
        }
        for (i = 0; i < 3; ++i) {
            player.sendPacket(new ExOlympiadUserInfo(this._teamTwo[i]));
        }
    }

    @Override
    public final void broadcastOlympiadInfo(L2OlympiadStadiumZone stadium) {
        int i;
        for (i = 0; i < 3; ++i) {
            stadium.broadcastPacket(new ExOlympiadUserInfo(this._teamOne[i]));
        }
        for (i = 0; i < 3; ++i) {
            stadium.broadcastPacket(new ExOlympiadUserInfo(this._teamTwo[i]));
        }
    }

    @Override
    protected final void broadcastPacket(L2GameServerPacket packet) {
        Participant par;
        int i;
        for (i = 0; i < this._teamOneSize; ++i) {
            par = this._teamOne[i];
            if (!par.updatePlayer()) continue;
            par.getPlayer().sendPacket(packet);
        }
        for (i = 0; i < this._teamTwoSize; ++i) {
            par = this._teamTwo[i];
            par.updatePlayer();
            if (par.getPlayer() == null) continue;
            par.getPlayer().sendPacket(packet);
        }
    }

    @Override
    protected boolean needBuffers() {
        return false;
    }

    @Override
    protected final boolean portPlayersToArena(List<Location> spawns) {
        boolean result = true;
        try {
            for (int i = 0; i < this._teamOneSize; ++i) {
                result &= OlympiadGameTeams.portPlayerToArena(this._teamOne[i], spawns.get(i), this._stadiumID);
            }
            int offset = spawns.size() / 2;
            for (int i = 0; i < this._teamTwoSize; ++i) {
                result &= OlympiadGameTeams.portPlayerToArena(this._teamTwo[i], spawns.get(i + offset), this._stadiumID);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return false;
        }
        return result;
    }

    @Override
    protected final void removals() {
        int i = this._teamOneSize;
        while (--i >= 0) {
            OlympiadGameTeams.removals(this._teamOne[i].getPlayer(), false);
            this._teamOne[i].getPlayer().setTeam(Team.BLUE);
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            OlympiadGameTeams.removals(this._teamTwo[i].getPlayer(), false);
            this._teamTwo[i].getPlayer().setTeam(Team.RED);
        }
    }

    @Override
    protected final boolean makeCompetitionStart() {
        Participant par;
        int i;
        if (!super.makeCompetitionStart()) {
            return false;
        }
        for (i = 0; i < this._teamOneSize; ++i) {
            par = this._teamOne[i];
            if (par.getPlayer() == null) {
                return false;
            }
            par.getPlayer().setIsOlympiadStart(true);
            par.getPlayer().updateEffectIcons();
        }
        for (i = 0; i < this._teamTwoSize; ++i) {
            par = this._teamTwo[i];
            if (par.getPlayer() == null) {
                return false;
            }
            par.getPlayer().setIsOlympiadStart(true);
            par.getPlayer().updateEffectIcons();
        }
        return true;
    }

    @Override
    protected final void cleanEffects() {
        Participant par;
        int i = this._teamOneSize;
        while (--i >= 0) {
            par = this._teamOne[i];
            if (par.getPlayer() == null || par.isDefaulted() || par.isDisconnected() || par.getPlayer().getOlympiadGameId() != this._stadiumID) continue;
            OlympiadGameTeams.cleanEffects(par.getPlayer());
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            par = this._teamTwo[i];
            if (par.getPlayer() == null || par.isDefaulted() || par.isDisconnected() || par.getPlayer().getOlympiadGameId() != this._stadiumID) continue;
            OlympiadGameTeams.cleanEffects(par.getPlayer());
        }
    }

    @Override
    protected final void portPlayersBack() {
        Participant par;
        int i = this._teamOneSize;
        while (--i >= 0) {
            par = this._teamOne[i];
            if (par.getPlayer() == null || par.isDefaulted() || par.isDisconnected()) continue;
            OlympiadGameTeams.portPlayerBack(par.getPlayer());
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            par = this._teamTwo[i];
            if (par.getPlayer() == null || par.isDefaulted() || par.isDisconnected()) continue;
            OlympiadGameTeams.portPlayerBack(par.getPlayer());
        }
    }

    @Override
    protected final void playersStatusBack() {
        Participant par;
        int i = this._teamOneSize;
        while (--i >= 0) {
            par = this._teamOne[i];
            if (par.getPlayer() == null || par.isDefaulted() || par.isDisconnected() || par.getPlayer().getOlympiadGameId() != this._stadiumID) continue;
            OlympiadGameTeams.playerStatusBack(par.getPlayer());
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            par = this._teamTwo[i];
            if (par.getPlayer() == null || par.isDefaulted() || par.isDisconnected() || par.getPlayer().getOlympiadGameId() != this._stadiumID) continue;
            OlympiadGameTeams.playerStatusBack(par.getPlayer());
        }
    }

    @Override
    protected final void clearPlayers() {
        for (int i = 0; i < 3; ++i) {
            if (i < this._teamOneSize) {
                this._teamOne[i].setPlayer(null);
            } else {
                IdFactory.getInstance().releaseId(this._teamOne[i].getObjectId());
            }
            if (i < this._teamTwoSize) {
                this._teamTwo[i].setPlayer(null);
            } else {
                IdFactory.getInstance().releaseId(this._teamTwo[i].getObjectId());
            }
            this._teamOne[i] = null;
            this._teamTwo[i] = null;
        }
    }

    @Override
    protected final void handleDisconnect(L2PcInstance player) {
        Participant par;
        int i = this._teamOneSize;
        while (--i >= 0) {
            par = this._teamOne[i];
            if (par.getObjectId() != player.getObjectId()) continue;
            par.setDisconnected(true);
            return;
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            par = this._teamTwo[i];
            if (par.getObjectId() != player.getObjectId()) continue;
            par.setDisconnected(true);
            return;
        }
    }

    @Override
    protected final boolean haveWinner() {
        Participant par;
        if (!this.checkBattleStatus()) {
            return true;
        }
        boolean teamOneLost = true;
        boolean teamTwoLost = true;
        int i = this._teamOneSize;
        while (--i >= 0) {
            par = this._teamOne[i];
            if (par.isDisconnected() || par.getPlayer() == null || par.getPlayer().getOlympiadGameId() != this._stadiumID) continue;
            teamOneLost &= par.getPlayer().isDead();
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            par = this._teamTwo[i];
            if (par.isDisconnected() || par.getPlayer() == null || par.getPlayer().getOlympiadGameId() != this._stadiumID) continue;
            teamTwoLost &= par.getPlayer().isDead();
        }
        return teamOneLost || teamTwoLost;
    }

    @Override
    protected final boolean checkBattleStatus() {
        if (this._aborted) {
            return false;
        }
        if (this.teamOneAllDisconnected()) {
            return false;
        }
        return !this.teamTwoAllDisconnected();
    }

    @Override
    protected void validateWinner(L2OlympiadStadiumZone stadium) {
        int i;
        int points;
        int i2;
        if (this._aborted) {
            return;
        }
        ExOlympiadMatchResult result = null;
        boolean tie = false;
        int winside = 0;
        ArrayList<OlympiadInfo> list1 = new ArrayList<OlympiadInfo>(3);
        ArrayList<OlympiadInfo> list2 = new ArrayList<OlympiadInfo>(3);
        boolean tOneCrash = this.teamOneAllDisconnected();
        boolean tTwoCrash = this.teamTwoAllDisconnected();
        if (this._teamOneDefaulted || this._teamTwoDefaulted) {
            try {
                int val;
                int points2;
                Participant par;
                int i3;
                if (this._teamOneDefaulted) {
                    i3 = this._teamOneSize;
                    while (--i3 >= 0) {
                        par = this._teamOne[i3];
                        points2 = par.getStats().getInt("olympiad_points") / this.getDivider();
                        val = Math.min(par.getStats().getInt("olympiad_points") / 3, Configuration.olympiad().getMaxPoints());
                        this.removePointsFromParticipant(par, val);
                        list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, points2 - val, -val));
                    }
                    winside = 2;
                }
                if (this._teamTwoDefaulted) {
                    i3 = this._teamTwoSize;
                    while (--i3 >= 0) {
                        par = this._teamTwo[i3];
                        points2 = par.getStats().getInt("olympiad_points") / this.getDivider();
                        val = Math.min(par.getStats().getInt("olympiad_points") / 3, Configuration.olympiad().getMaxPoints());
                        this.removePointsFromParticipant(par, val);
                        list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, points2 - val, -val));
                    }
                    if (winside == 2) {
                        tie = true;
                    } else {
                        winside = 1;
                    }
                }
                result = winside == 1 ? new ExOlympiadMatchResult(tie, winside, list1, list2) : new ExOlympiadMatchResult(tie, winside, list2, list1);
                stadium.broadcastPacket(result);
            }
            catch (Exception e) {
                LOG.warn("Exception on validateWinner(): {}", (Object)e.getMessage(), (Object)e);
            }
            return;
        }
        int[] pointsTeamOne = new int[this._teamOneSize];
        int[] pointsTeamTwo = new int[this._teamTwoSize];
        int[] maxPointsTeamOne = new int[this._teamOneSize];
        int[] maxPointsTeamTwo = new int[this._teamTwoSize];
        int totalPointsTeamOne = 0;
        int totalPointsTeamTwo = 0;
        for (i2 = 0; i2 < this._teamOneSize; ++i2) {
            points = this._teamOne[i2].getStats().getInt("olympiad_points") / this.getDivider();
            if (points <= 0) {
                points = 1;
            } else if (points > Configuration.olympiad().getMaxPoints()) {
                points = Configuration.olympiad().getMaxPoints();
            }
            totalPointsTeamOne += points;
            pointsTeamOne[i2] = points;
            maxPointsTeamOne[i2] = points;
        }
        i2 = this._teamTwoSize;
        while (--i2 >= 0) {
            points = this._teamTwo[i2].getStats().getInt("olympiad_points") / this.getDivider();
            if (points <= 0) {
                points = 1;
            } else if (points > Configuration.olympiad().getMaxPoints()) {
                points = Configuration.olympiad().getMaxPoints();
            }
            totalPointsTeamTwo += points;
            pointsTeamTwo[i2] = points;
            maxPointsTeamTwo[i2] = points;
        }
        int min = Math.min(totalPointsTeamOne, totalPointsTeamTwo);
        min = min / 3 * 3;
        double dividerOne = (double)totalPointsTeamOne / (double)min;
        double dividerTwo = (double)totalPointsTeamTwo / (double)min;
        totalPointsTeamOne = min;
        totalPointsTeamTwo = min;
        for (i = 0; i < this._teamOneSize; ++i) {
            pointsTeamOne[i] = points = Math.max((int)((double)pointsTeamOne[i] / dividerOne), 1);
            totalPointsTeamOne -= points;
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            pointsTeamTwo[i] = points = Math.max((int)((double)pointsTeamTwo[i] / dividerTwo), 1);
            totalPointsTeamTwo -= points;
        }
        for (i = 0; totalPointsTeamOne > 0 && i < this._teamOneSize; ++i) {
            if (pointsTeamOne[i] >= maxPointsTeamOne[i]) continue;
            int n = i;
            pointsTeamOne[n] = pointsTeamOne[n] + 1;
            --totalPointsTeamOne;
        }
        i = this._teamTwoSize;
        while (totalPointsTeamTwo > 0 && --i >= 0) {
            if (pointsTeamTwo[i] >= maxPointsTeamTwo[i]) continue;
            int n = i;
            pointsTeamTwo[n] = pointsTeamTwo[n] + 1;
            --totalPointsTeamTwo;
        }
        if (tOneCrash || tTwoCrash) {
            try {
                Participant par;
                if (tTwoCrash && !tOneCrash) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    sm.addString(this._teamOne[0].getName());
                    stadium.broadcastPacket(sm);
                    for (i = 0; i < this._teamTwoSize; ++i) {
                        par = this._teamTwo[i];
                        par.updateStat("competitions_lost", 1);
                        points = pointsTeamTwo[i];
                        this.removePointsFromParticipant(par, points);
                        list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, par.getStats().getInt("olympiad_points") - points, -points));
                    }
                    points = min / 3;
                    for (i = 0; i < this._teamOneSize; ++i) {
                        par = this._teamOne[i];
                        par.updateStat("competitions_won", 1);
                        this.addPointsToParticipant(par, points);
                        list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, par.getStats().getInt("olympiad_points") + points, points));
                    }
                    for (i = 0; i < this._teamOneSize; ++i) {
                        OlympiadGameTeams.rewardParticipant(this._teamOne[i].getPlayer(), this.getReward());
                    }
                    winside = 1;
                } else if (tOneCrash && !tTwoCrash) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    sm.addString(this._teamTwo[0].getName());
                    stadium.broadcastPacket(sm);
                    for (i = 0; i < this._teamOneSize; ++i) {
                        par = this._teamOne[i];
                        par.updateStat("competitions_lost", 1);
                        points = pointsTeamOne[i];
                        this.removePointsFromParticipant(par, points);
                        list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, par.getStats().getInt("olympiad_points") - points, -points));
                    }
                    points = min / 3;
                    for (i = 0; i < this._teamTwoSize; ++i) {
                        par = this._teamTwo[i];
                        par.updateStat("competitions_won", 1);
                        this.addPointsToParticipant(par, points);
                        list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, par.getStats().getInt("olympiad_points") + points, points));
                    }
                    winside = 2;
                    for (i = 0; i < this._teamTwoSize; ++i) {
                        OlympiadGameTeams.rewardParticipant(this._teamTwo[i].getPlayer(), this.getReward());
                    }
                } else if (tOneCrash && tTwoCrash) {
                    stadium.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE));
                    i = this._teamOneSize;
                    while (--i >= 0) {
                        par = this._teamOne[i];
                        par.updateStat("competitions_lost", 1);
                        this.removePointsFromParticipant(par, pointsTeamOne[i]);
                        list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, par.getStats().getInt("olympiad_points") - pointsTeamOne[i], -pointsTeamOne[i]));
                    }
                    i = this._teamTwoSize;
                    while (--i >= 0) {
                        par = this._teamTwo[i];
                        par.updateStat("competitions_lost", 1);
                        this.removePointsFromParticipant(par, pointsTeamTwo[i]);
                        list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, par.getStats().getInt("olympiad_points") - pointsTeamOne[i], -pointsTeamOne[i]));
                    }
                    tie = true;
                }
                i = this._teamOneSize;
                while (--i >= 0) {
                    par = this._teamOne[i];
                    par.updateStat("competitions_done", 1);
                    par.updateStat("competitions_done_week", 1);
                    par.updateStat(this.getWeeklyMatchType(), 1);
                }
                i = this._teamTwoSize;
                while (--i >= 0) {
                    par = this._teamTwo[i];
                    par.updateStat("competitions_done", 1);
                    par.updateStat("competitions_done_week", 1);
                    par.updateStat(this.getWeeklyMatchType(), 1);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception on validateWinner(): {}", (Object)e.getMessage(), (Object)e);
            }
            result = winside == 1 ? new ExOlympiadMatchResult(tie, winside, list1, list2) : new ExOlympiadMatchResult(tie, winside, list2, list1);
            stadium.broadcastPacket(result);
            return;
        }
        try {
            Participant par;
            double teamOneHp = 0.0;
            double teamTwoHp = 0.0;
            int i4 = this._teamOneSize;
            while (--i4 >= 0) {
                double hp;
                par = this._teamOne[i4];
                if (!par.isDisconnected() && par.getPlayer() != null && !par.getPlayer().isDead() && (hp = par.getPlayer().getCurrentHp() + par.getPlayer().getCurrentCp()) >= 0.5) {
                    teamOneHp += hp;
                }
                par.updatePlayer();
            }
            i4 = this._teamTwoSize;
            while (--i4 >= 0) {
                double hp;
                par = this._teamTwo[i4];
                if (!par.isDisconnected() && par.getPlayer() != null && !par.getPlayer().isDead() && (hp = par.getPlayer().getCurrentHp() + par.getPlayer().getCurrentCp()) >= 0.5) {
                    teamTwoHp += hp;
                }
                par.updatePlayer();
            }
            if (teamTwoHp == 0.0 && teamOneHp != 0.0 || this._damageT1 > this._damageT2 && teamTwoHp != 0.0 && teamOneHp != 0.0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                sm.addString(this._teamOne[0].getName());
                stadium.broadcastPacket(sm);
                for (i4 = 0; i4 < this._teamTwoSize; ++i4) {
                    par = this._teamTwo[i4];
                    par.updateStat("competitions_lost", 1);
                    points = pointsTeamTwo[i4];
                    this.removePointsFromParticipant(par, points);
                    list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, par.getStats().getInt("olympiad_points") - points, -points));
                }
                points = min / 3;
                for (i4 = 0; i4 < this._teamOneSize; ++i4) {
                    par = this._teamOne[i4];
                    par.updateStat("competitions_won", 1);
                    this.addPointsToParticipant(par, points);
                    list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, par.getStats().getInt("olympiad_points") + points, points));
                }
                winside = 1;
                for (i4 = 0; i4 < this._teamOneSize; ++i4) {
                    OlympiadGameTeams.rewardParticipant(this._teamOne[i4].getPlayer(), this.getReward());
                }
            } else if (teamOneHp == 0.0 && teamTwoHp != 0.0 || this._damageT2 > this._damageT1 && teamOneHp != 0.0 && teamTwoHp != 0.0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                sm.addString(this._teamTwo[0].getName());
                stadium.broadcastPacket(sm);
                for (i4 = 0; i4 < this._teamOneSize; ++i4) {
                    par = this._teamOne[i4];
                    par.updateStat("competitions_lost", 1);
                    points = pointsTeamOne[i4];
                    this.removePointsFromParticipant(par, points);
                    list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, par.getStats().getInt("olympiad_points") - points, -points));
                }
                points = min / 3;
                for (i4 = 0; i4 < this._teamTwoSize; ++i4) {
                    par = this._teamTwo[i4];
                    par.updateStat("competitions_won", 1);
                    this.addPointsToParticipant(par, points);
                    list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, par.getStats().getInt("olympiad_points") + points, points));
                }
                winside = 2;
                for (i4 = 0; i4 < this._teamTwoSize; ++i4) {
                    OlympiadGameTeams.rewardParticipant(this._teamTwo[i4].getPlayer(), this.getReward());
                }
            } else {
                stadium.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE));
                for (i4 = 0; i4 < this._teamOneSize; ++i4) {
                    par = this._teamOne[i4];
                    par.updateStat("competitions_drawn", 1);
                    points = Math.min(par.getStats().getInt("olympiad_points") / this.getDivider(), Configuration.olympiad().getMaxPoints());
                    this.removePointsFromParticipant(par, points);
                    list1.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT1, par.getStats().getInt("olympiad_points") - points, -points));
                }
                for (i4 = 0; i4 < this._teamTwoSize; ++i4) {
                    par = this._teamTwo[i4];
                    par.updateStat("competitions_drawn", 1);
                    points = Math.min(par.getStats().getInt("olympiad_points") / this.getDivider(), Configuration.olympiad().getMaxPoints());
                    this.removePointsFromParticipant(par, points);
                    list2.add(new OlympiadInfo(par.getName(), par.getClanName(), par.getClanId(), par.getBaseClass(), this._damageT2, par.getStats().getInt("olympiad_points") - points, -points));
                }
                tie = true;
            }
            i4 = this._teamOneSize;
            while (--i4 >= 0) {
                par = this._teamOne[i4];
                par.updateStat("competitions_done", 1);
                par.updateStat("competitions_done_week", 1);
                par.updateStat(this.getWeeklyMatchType(), 1);
            }
            i4 = this._teamTwoSize;
            while (--i4 >= 0) {
                par = this._teamTwo[i4];
                par.updateStat("competitions_done", 1);
                par.updateStat("competitions_done_week", 1);
                par.updateStat(this.getWeeklyMatchType(), 1);
            }
            result = winside == 1 ? new ExOlympiadMatchResult(tie, winside, list1, list2) : new ExOlympiadMatchResult(tie, winside, list2, list1);
            stadium.broadcastPacket(result);
        }
        catch (Exception e) {
            LOG.warn("Exception on validateWinner(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    protected final void addDamage(L2PcInstance player, int damage) {
        Participant par;
        int i = this._teamOneSize;
        while (--i >= 0) {
            par = this._teamOne[i];
            if (par.getObjectId() != player.getObjectId()) continue;
            if (!par.isDisconnected()) {
                this._damageT1 += damage;
            }
            return;
        }
        i = this._teamTwoSize;
        while (--i >= 0) {
            par = this._teamTwo[i];
            if (par.getObjectId() != player.getObjectId()) continue;
            if (!par.isDisconnected()) {
                this._damageT2 += damage;
            }
            return;
        }
    }

    @Override
    public final String[] getPlayerNames() {
        return new String[]{this._teamOne[0].getName(), this._teamTwo[0].getName()};
    }

    @Override
    public final boolean checkDefaulted() {
        try {
            Participant par;
            SystemMessage reason = null;
            int i = this._teamOneSize;
            while (--i >= 0) {
                par = this._teamOne[i];
                par.updatePlayer();
                reason = OlympiadGameTeams.checkDefaulted(par.getPlayer());
                if (reason == null) continue;
                par.setDefaulted(true);
                if (this._teamOneDefaulted) continue;
                this._teamOneDefaulted = true;
                for (Participant t : this._teamTwo) {
                    if (t.getPlayer() == null) continue;
                    t.getPlayer().sendPacket(reason);
                }
            }
            i = this._teamTwoSize;
            while (--i >= 0) {
                par = this._teamTwo[i];
                par.updatePlayer();
                reason = OlympiadGameTeams.checkDefaulted(par.getPlayer());
                if (reason == null) continue;
                par.setDefaulted(true);
                if (this._teamTwoDefaulted) continue;
                this._teamTwoDefaulted = true;
                for (Participant t : this._teamOne) {
                    if (t.getPlayer() == null) continue;
                    t.getPlayer().sendPacket(reason);
                }
            }
            return this._teamOneDefaulted || this._teamTwoDefaulted;
        }
        catch (Exception e) {
            LOG.warn("Exception on checkDefaulted(): {}", (Object)e.getMessage(), (Object)e);
            return true;
        }
    }

    @Override
    public final void resetDamage() {
        this._damageT1 = 0;
        this._damageT2 = 0;
    }

    private boolean teamOneAllDisconnected() {
        int i = this._teamOneSize;
        while (--i >= 0) {
            if (this._teamOne[i].isDisconnected()) continue;
            return false;
        }
        return true;
    }

    private boolean teamTwoAllDisconnected() {
        int i = this._teamTwoSize;
        while (--i >= 0) {
            if (this._teamTwo[i].isDisconnected()) continue;
            return false;
        }
        return true;
    }
}

