/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.EffectTaskInfo;
import com.l2jserver.gameserver.model.effects.EffectTickTask;
import com.l2jserver.gameserver.model.skills.BuffTimeTask;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;

public final class BuffInfo {
    private final L2Character _effector;
    private final L2Character _effected;
    private final Skill _skill;
    private final int index;
    private final List<AbstractEffect> _effects = new ArrayList<AbstractEffect>(1);
    private volatile Map<AbstractEffect, EffectTaskInfo> _tasks;
    private ScheduledFuture<?> _scheduledFutureTimeTask;
    private int _abnormalTime;
    private final int _periodStartTicks;
    private boolean _isRemoved = false;
    private boolean _isInUse = true;
    private int _charges = 0;

    public BuffInfo(L2Character effector, L2Character effected, int index, Skill skill) {
        this._effector = effector;
        this._effected = effected;
        this.index = index;
        this._skill = skill;
        this._abnormalTime = Formulas.calcEffectAbnormalTime(effector, effected, skill);
        this._periodStartTicks = GameTimeController.getInstance().getGameTicks();
    }

    public BuffInfo(L2Character effector, L2Character effected, Skill skill) {
        this(effector, effected, -1, skill);
    }

    public List<AbstractEffect> getEffects() {
        return this._effects;
    }

    public void addEffect(AbstractEffect effect) {
        this._effects.add(effect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(AbstractEffect effect, EffectTaskInfo effectTaskInfo) {
        if (this._tasks == null) {
            BuffInfo buffInfo = this;
            synchronized (buffInfo) {
                if (this._tasks == null) {
                    this._tasks = new ConcurrentHashMap<AbstractEffect, EffectTaskInfo>();
                }
            }
        }
        this._tasks.put(effect, effectTaskInfo);
    }

    private EffectTaskInfo getEffectTask(AbstractEffect effect) {
        return this._tasks == null ? null : this._tasks.get(effect);
    }

    public Skill getSkill() {
        return this._skill;
    }

    public int getAbnormalTime() {
        return this._abnormalTime;
    }

    public void setAbnormalTime(int abnormalTime) {
        this._abnormalTime = abnormalTime;
    }

    public int getPeriodStartTicks() {
        return this._periodStartTicks;
    }

    public int getTime() {
        return this._abnormalTime - (GameTimeController.getInstance().getGameTicks() - this._periodStartTicks) / 10;
    }

    public boolean isRemoved() {
        return this._isRemoved;
    }

    public void setRemoved(boolean val) {
        this._isRemoved = val;
    }

    public boolean isInUse() {
        return this._isInUse;
    }

    public void setInUse(boolean val) {
        this._isInUse = val;
    }

    public L2Character getEffector() {
        return this._effector;
    }

    public L2Character getEffected() {
        return this._effected;
    }

    public int getIndex() {
        return this.index;
    }

    public void stopAllEffects(boolean removed) {
        this.setRemoved(removed);
        if (this._scheduledFutureTimeTask != null && !this._scheduledFutureTimeTask.isCancelled()) {
            this._scheduledFutureTimeTask.cancel(true);
        }
        this.finishEffects();
    }

    public void initializeEffects() {
        if (this._effected == null || this._skill == null) {
            return;
        }
        if (this._effected.isPlayer() && !this._skill.isPassive()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
            sm.addSkillName(this._skill);
            this._effected.sendPacket(sm);
        }
        for (AbstractEffect effect : this._effects) {
            if (effect.isInstant() || this._effected.isDead() && !this._skill.isPassive()) continue;
            effect.onStart(this);
            if (effect.getTicks() > 0) {
                EffectTickTask effectTask = new EffectTickTask(this, effect);
                ScheduledFuture<?> scheduledFuture = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(effectTask, effect.getTicks() * Configuration.character().getEffectTickRatio(), effect.getTicks() * Configuration.character().getEffectTickRatio());
                this.addTask(effect, new EffectTaskInfo(effectTask, scheduledFuture));
            }
            this._effected.addStatFuncs(effect.getStatFuncs(this._effector, this._effected, this._skill));
        }
        this.addAbnormalVisualEffects();
        if (this._abnormalTime > 0) {
            this._scheduledFutureTimeTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new BuffTimeTask(this), 0L, 1000L);
        }
    }

    public void onTick(AbstractEffect effect, int tickCount) {
        EffectTaskInfo task;
        boolean continueForever = false;
        if (this._isInUse) {
            continueForever = effect.onActionTime(this);
        }
        if (!continueForever && this._skill.isToggle() && (task = this.getEffectTask(effect)) != null) {
            task.getScheduledFuture().cancel(true);
            this._effected.getEffectList().stopSkillEffects(true, this.getSkill());
        }
    }

    public void finishEffects() {
        if (this._tasks != null) {
            for (EffectTaskInfo effectTask : this._tasks.values()) {
                effectTask.getScheduledFuture().cancel(true);
            }
        }
        this.removeStats();
        for (AbstractEffect effect : this._effects) {
            if (effect == null || effect.isInstant()) continue;
            effect.onExit(this);
        }
        this.removeAbnormalVisualEffects();
        if (!this._effected.isSummon() || ((L2Summon)this._effected).getOwner().hasSummon()) {
            SystemMessageId smId = null;
            if (this._skill.isToggle()) {
                smId = SystemMessageId.S1_HAS_BEEN_ABORTED;
            } else if (this.isRemoved()) {
                smId = SystemMessageId.EFFECT_S1_HAS_BEEN_REMOVED;
            } else if (!this._skill.isPassive()) {
                smId = SystemMessageId.S1_HAS_WORN_OFF;
            }
            if (smId != null) {
                SystemMessage sm = SystemMessage.getSystemMessage(smId);
                sm.addSkillName(this._skill);
                this._effected.sendPacket(sm);
            }
        }
        if (this == this._effected.getEffectList().getShortBuff()) {
            this._effected.getEffectList().shortBuffStatusUpdate(null);
        }
    }

    private void addAbnormalVisualEffects() {
        boolean updated = false;
        if (this._skill.hasAbnormalVisualEffects()) {
            this._effected.startAbnormalVisualEffect(false, this._skill.getAbnormalVisualEffects());
            updated = true;
        }
        if (this._effected.isPlayer() && this._skill.hasAbnormalVisualEffectsEvent()) {
            this._effected.startAbnormalVisualEffect(false, this._skill.getAbnormalVisualEffectsEvent());
            updated = true;
        }
        if (this._skill.hasAbnormalVisualEffectsSpecial()) {
            this._effected.startAbnormalVisualEffect(false, this._skill.getAbnormalVisualEffectsSpecial());
            updated = true;
        }
        if (updated) {
            this._effected.updateAbnormalEffect();
        }
    }

    private void removeAbnormalVisualEffects() {
        if (this._effected == null || this._skill == null) {
            return;
        }
        boolean updated = false;
        if (this._skill.hasAbnormalVisualEffects()) {
            this._effected.stopAbnormalVisualEffect(false, this._skill.getAbnormalVisualEffects());
            updated = true;
        }
        if (this._effected.isPlayer() && this._skill.hasAbnormalVisualEffectsEvent()) {
            this._effected.stopAbnormalVisualEffect(false, this._skill.getAbnormalVisualEffectsEvent());
            updated = true;
        }
        if (this._skill.hasAbnormalVisualEffectsSpecial()) {
            this._effected.stopAbnormalVisualEffect(false, this._skill.getAbnormalVisualEffectsSpecial());
            updated = true;
        }
        if (updated) {
            this._effected.updateAbnormalEffect();
        }
    }

    public void addStats() {
        this._effects.forEach(effect -> this._effected.addStatFuncs(effect.getStatFuncs(this._effector, this._effected, this._skill)));
    }

    public void removeStats() {
        this._effects.forEach(this._effected::removeStatsOwner);
        this._effected.removeStatsOwner(this._skill);
    }

    public int getTickCount(AbstractEffect effect) {
        EffectTaskInfo effectTaskInfo;
        if (this._tasks != null && (effectTaskInfo = this._tasks.get(effect)) != null) {
            return effectTaskInfo.getEffectTask().getTickCount();
        }
        return 0;
    }

    public int getCharges() {
        return this._charges;
    }

    public void setCharges(int charges) {
        this._charges = charges;
    }

    public String toString() {
        return "BuffInfo [effector=" + String.valueOf(this._effector) + ", effected=" + String.valueOf(this._effected) + ", skill=" + String.valueOf(this._skill) + ", effects=" + String.valueOf(this._effects) + ", tasks=" + String.valueOf(this._tasks) + ", scheduledFutureTimeTask=" + String.valueOf(this._scheduledFutureTimeTask) + ", abnormalTime=" + this._abnormalTime + ", periodStartTicks=" + this._periodStartTicks + ", isRemoved=" + this._isRemoved + ", isInUse=" + this._isInUse + "]";
    }
}

