/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.targets;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.AffectObject;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.util.Util;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum AffectScope {
    BALAKAS_SCOPE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    }
    ,
    DEAD_PLEDGE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            if (!target.isPlayable()) {
                return List.of();
            }
            L2PcInstance player = target.getActingPlayer();
            int clanId = player.getClanId();
            if (clanId == 0) {
                return List.of();
            }
            int affectLimit = skill.getAffectLimit();
            AffectObject affectObject = skill.getAffectObject();
            LinkedList<L2Object> targets = new LinkedList<L2Object>();
            boolean inDuel = player.isInDuel();
            for (L2Object object : L2World.getInstance().getVisibleObjects(target, skill.getAffectRange())) {
                L2PcInstance targetPlayer;
                if (affectLimit > 0 && targets.size() >= affectLimit) break;
                if (!object.isPlayable() || (targetPlayer = object.getActingPlayer()) == null || clanId != targetPlayer.getClanId() || inDuel && (player.getDuelId() != targetPlayer.getDuelId() || player.isInParty() && targetPlayer.isInParty() && player.getParty().getLeaderObjectId() != targetPlayer.getParty().getLeaderObjectId()) || !player.checkPvpSkill(targetPlayer, skill) || !TvTEvent.checkForTvTSkill(player, targetPlayer, skill) || player.isInOlympiadMode() && (player.getOlympiadGameId() != targetPlayer.getOlympiadGameId() || player.getOlympiadSide() != targetPlayer.getOlympiadGameId()) || targetPlayer.isInsideZone(ZoneId.SIEGE) && !targetPlayer.isInSiege() || !affectObject.affectObject(player, targetPlayer)) continue;
                targets.add(targetPlayer);
            }
            return targets;
        }
    }
    ,
    DEAD_UNION{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            if (!target.isPlayable()) {
                return List.of();
            }
            L2PcInstance player = target.getActingPlayer();
            int affectLimit = skill.getAffectLimit();
            AffectObject affectObject = skill.getAffectObject();
            LinkedList<L2Object> targets = new LinkedList<L2Object>();
            for (L2Object object : L2World.getInstance().getVisibleObjects(target, skill.getAffectRange())) {
                L2Character creature;
                if (affectLimit > 0 && targets.size() >= affectLimit) break;
                if (!object.isCharacter() || !player.isInCommandChannelWith(creature = (L2Character)object) || !creature.isDead() || !affectObject.affectObject(player, creature)) continue;
                targets.add(creature);
            }
            return targets;
        }
    }
    ,
    FAN{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            double headingAngle = Util.calculateAngleFrom(caster, target);
            int affectLimit = skill.getAffectLimit();
            int[] fanRange = skill.getFanRange();
            int fanStartingAngle = fanRange[1];
            int fanRadius = fanRange[2];
            int fanAngle = fanRange[3];
            AffectObject affectObject = skill.getAffectObject();
            LinkedList<L2Object> targets = new LinkedList<L2Object>();
            for (L2Object object : L2World.getInstance().getVisibleObjects(caster, fanRadius)) {
                L2Character creature;
                if (affectLimit > 0 && targets.size() >= affectLimit) break;
                if (!object.isCharacter() || (creature = (L2Character)object).isDead() || Math.abs(Util.calculateAngleFrom(caster, creature) - (headingAngle + (double)fanStartingAngle)) > (double)(fanAngle / 2) || !affectObject.affectObject(caster, creature) || !GeoData.getInstance().canSeeTarget((L2Object)caster, creature)) continue;
                targets.add(creature);
            }
            return targets;
        }
    }
    ,
    NONE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    }
    ,
    PARTY{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            if (!target.isCharacter()) {
                return List.of();
            }
            int affectLimit = skill.getAffectLimit();
            int affectRange = skill.getAffectRange();
            LinkedList<L2Object> targets = new LinkedList<L2Object>();
            L2Character creature = (L2Character)target;
            if (creature.isInParty()) {
                for (L2PcInstance partyMember : creature.getParty().getMembers()) {
                    if (affectLimit <= 0 || targets.size() < affectLimit) {
                        L2Summon summon;
                        if (!Util.checkIfInRange(affectRange, creature, partyMember, true)) continue;
                        targets.add(partyMember);
                        if (!partyMember.hasSummon() || !Util.checkIfInRange(affectRange, creature, summon = partyMember.getSummon(), true)) continue;
                        targets.add(summon);
                        continue;
                    }
                    break;
                }
            } else {
                L2Summon summon;
                L2PcInstance player = target.getActingPlayer();
                targets.add(player);
                if (player.hasSummon() && Util.checkIfInRange(affectRange, creature, summon = player.getSummon(), true)) {
                    targets.add(summon);
                }
            }
            return targets;
        }
    }
    ,
    PARTY_PLEDGE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            HashSet<L2Object> targets = new HashSet<L2Object>();
            targets.addAll(PARTY.affectTargets(caster, target, skill));
            targets.addAll(PLEDGE.affectTargets(caster, target, skill));
            return new LinkedList<L2Object>(targets);
        }
    }
    ,
    PLEDGE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            LinkedList<L2Object> targets;
            block8: {
                int affectLimit;
                int affectRange;
                block9: {
                    L2Summon summon;
                    L2PcInstance targetPlayer;
                    block10: {
                        affectRange = skill.getAffectRange();
                        affectLimit = skill.getAffectLimit();
                        targets = new LinkedList<L2Object>();
                        if (!target.isPlayer()) break block9;
                        targetPlayer = target.getActingPlayer();
                        L2Clan clan = targetPlayer.getClan();
                        if (clan == null) break block10;
                        for (L2ClanMember clanMember : clan.getMembers()) {
                            if (affectLimit <= 0 || targets.size() < affectLimit) {
                                L2Summon summon2;
                                L2PcInstance clanMemberPlayer = clanMember.getPlayerInstance();
                                if (clanMemberPlayer == null || targetPlayer.isInDuel() && (targetPlayer.getDuelId() != clanMemberPlayer.getDuelId() || targetPlayer.isInParty() && clanMemberPlayer.isInParty() && targetPlayer.getParty().getLeaderObjectId() != clanMemberPlayer.getParty().getLeaderObjectId()) || !targetPlayer.checkPvpSkill(clanMemberPlayer, skill) || !TvTEvent.checkForTvTSkill(targetPlayer, clanMemberPlayer, skill) || targetPlayer.isInOlympiadMode() && (targetPlayer.getOlympiadGameId() != clanMemberPlayer.getOlympiadGameId() || targetPlayer.getOlympiadSide() != clanMemberPlayer.getOlympiadSide())) continue;
                                if (Util.checkIfInRange(affectRange, targetPlayer, clanMemberPlayer, true)) {
                                    targets.add(clanMemberPlayer);
                                }
                                if (!clanMemberPlayer.hasSummon() || !Util.checkIfInRange(affectRange, targetPlayer, summon2 = clanMemberPlayer.getSummon(), true)) continue;
                                targets.add(summon2);
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                    if (Util.checkIfInRange(affectRange, targetPlayer, targetPlayer, true)) {
                        targets.add(targetPlayer);
                    }
                    if (!targetPlayer.hasSummon() || !Util.checkIfInRange(affectRange, targetPlayer, summon = targetPlayer.getSummon(), true)) break block8;
                    targets.add(summon);
                    break block8;
                }
                if (target.isNpc()) {
                    L2Npc npc = (L2Npc)target;
                    targets.add(target);
                    Set<Integer> clans = npc.getTemplate().getClans();
                    if (clans == null || clans.isEmpty()) {
                        return targets;
                    }
                    for (L2Character creature : npc.getKnownList().getKnownCharactersInRadius(affectRange)) {
                        if (affectLimit <= 0 || targets.size() < affectLimit) {
                            if (!creature.isNpc() || !npc.isInMyClan((L2Npc)creature)) continue;
                            targets.add(creature);
                            continue;
                        }
                        break;
                    }
                }
            }
            return targets;
        }
    }
    ,
    POINT_BLANK{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            if (!target.isCharacter()) {
                return List.of();
            }
            int affectLimit = skill.getAffectLimit();
            return L2World.getInstance().getVisibleObjectsStream(target, skill.getAffectRange(), true).filter(c -> skill.getAffectObject().affectObject(caster, (L2Object)c)).limit(affectLimit > 0 ? (long)affectLimit : Integer.MAX_VALUE).toList();
        }
    }
    ,
    RANGE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            int affectLimit = skill.getAffectLimit();
            return L2World.getInstance().getVisibleObjectsStream(target, skill.getAffectRange(), true).filter(L2Object::isCharacter).map(o -> (L2Character)o).filter(c -> !c.isDead()).filter(c -> skill.getAffectObject().affectObject(caster, (L2Object)c)).limit(affectLimit > 0 ? (long)affectLimit : Integer.MAX_VALUE).collect(Collectors.toList());
        }
    }
    ,
    RANGE_SORT_BY_HP{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            int affectLimit = skill.getAffectLimit();
            return L2World.getInstance().getVisibleObjectsStream(target, skill.getAffectRange(), false).filter(L2Object::isCharacter).map(o -> (L2Character)o).filter(creature -> !creature.isDead()).filter(creature -> skill.getAffectObject().affectObject(caster, (L2Object)creature)).sorted(Comparator.comparingDouble(creature -> creature.getCurrentHp() / (double)creature.getMaxHp())).limit(affectLimit > 0 ? (long)affectLimit : Integer.MAX_VALUE).collect(Collectors.toList());
        }
    }
    ,
    RING_RANGE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    }
    ,
    SINGLE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            if (!skill.getAffectObject().affectObject(caster, target)) {
                return List.of();
            }
            return List.of(target);
        }
    }
    ,
    SQUARE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    }
    ,
    SQUARE_PB{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    }
    ,
    STATIC_OBJECT_SCOPE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    }
    ,
    WYVERN_SCOPE{

        @Override
        public List<L2Object> affectTargets(L2Character caster, L2Object target, Skill skill) {
            return List.of();
        }
    };


    public abstract List<L2Object> affectTargets(L2Character var1, L2Object var2, Skill var3);
}

