/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network;

import com.l2jserver.gameserver.config.Configuration;

public class ClientStats {
    public int processedPackets = 0;
    public int droppedPackets = 0;
    public int unknownPackets = 0;
    public int totalQueueSize = 0;
    public int maxQueueSize = 0;
    public int totalBursts = 0;
    public int maxBurstSize = 0;
    public int shortFloods = 0;
    public int longFloods = 0;
    public int totalQueueOverflows = 0;
    public int totalUnderflowExceptions = 0;
    private final int[] _packetsInSecond;
    private long _packetCountStartTick = 0L;
    private int _head;
    private int _totalCount = 0;
    private int _floodsInMin = 0;
    private long _floodStartTick = 0L;
    private int _unknownPacketsInMin = 0;
    private long _unknownPacketStartTick = 0L;
    private int _overflowsInMin = 0;
    private long _overflowStartTick = 0L;
    private int _underflowReadsInMin = 0;
    private long _underflowReadStartTick = 0L;
    private volatile boolean _floodDetected = false;
    private volatile boolean _queueOverflowDetected = false;
    private final int BUFFER_SIZE = Configuration.general().getClientPacketQueueMeasureInterval();

    public ClientStats() {
        this._packetsInSecond = new int[this.BUFFER_SIZE];
        this._head = this.BUFFER_SIZE - 1;
    }

    protected final boolean dropPacket() {
        boolean result;
        boolean bl = result = this._floodDetected || this._queueOverflowDetected;
        if (result) {
            ++this.droppedPackets;
        }
        return result;
    }

    protected final boolean countPacket(int queueSize) {
        ++this.processedPackets;
        this.totalQueueSize += queueSize;
        if (this.maxQueueSize < queueSize) {
            this.maxQueueSize = queueSize;
        }
        if (this._queueOverflowDetected && queueSize < 2) {
            this._queueOverflowDetected = false;
        }
        return this.countPacket();
    }

    protected final boolean countUnknownPacket() {
        ++this.unknownPackets;
        long tick = System.currentTimeMillis();
        if (tick - this._unknownPacketStartTick > 60000L) {
            this._unknownPacketStartTick = tick;
            this._unknownPacketsInMin = 1;
            return false;
        }
        ++this._unknownPacketsInMin;
        return this._unknownPacketsInMin > Configuration.general().getClientPacketQueueMaxUnknownPerMin();
    }

    protected final boolean countBurst(int count) {
        int maxBurstSize;
        if (count > this.maxBurstSize) {
            this.maxBurstSize = count;
        }
        if (count < (maxBurstSize = Math.max(Configuration.general().getClientPacketQueueMaxBurstSize(), Configuration.mmo().getMaxReadPerPass() + 1))) {
            return false;
        }
        ++this.totalBursts;
        return true;
    }

    protected final boolean countQueueOverflow() {
        this._queueOverflowDetected = true;
        ++this.totalQueueOverflows;
        long tick = System.currentTimeMillis();
        if (tick - this._overflowStartTick > 60000L) {
            this._overflowStartTick = tick;
            this._overflowsInMin = 1;
            return false;
        }
        ++this._overflowsInMin;
        return this._overflowsInMin > Configuration.general().getClientPacketQueueMaxOverflowsPerMin();
    }

    protected final boolean countUnderflowException() {
        ++this.totalUnderflowExceptions;
        long tick = System.currentTimeMillis();
        if (tick - this._underflowReadStartTick > 60000L) {
            this._underflowReadStartTick = tick;
            this._underflowReadsInMin = 1;
            return false;
        }
        ++this._underflowReadsInMin;
        return this._underflowReadsInMin > Configuration.general().getClientPacketQueueMaxUnderflowsPerMin();
    }

    protected final boolean countFloods() {
        return this._floodsInMin > Configuration.general().getClientPacketQueueMaxFloodsPerMin();
    }

    private boolean longFloodDetected() {
        return this._totalCount / this.BUFFER_SIZE > Configuration.general().getClientPacketQueueMaxAveragePacketsPerSecond();
    }

    private synchronized boolean countPacket() {
        ++this._totalCount;
        long tick = System.currentTimeMillis();
        if (tick - this._packetCountStartTick > 1000L) {
            this._packetCountStartTick = tick;
            if (this._floodDetected && !this.longFloodDetected() && this._packetsInSecond[this._head] < Configuration.general().getClientPacketQueueMaxPacketsPerSecond() / 2) {
                this._floodDetected = false;
            }
            if (this._head <= 0) {
                this._head = this.BUFFER_SIZE;
            }
            --this._head;
            this._totalCount -= this._packetsInSecond[this._head];
            this._packetsInSecond[this._head] = 1;
            return this._floodDetected;
        }
        int n = this._head;
        int n2 = this._packetsInSecond[n] + 1;
        this._packetsInSecond[n] = n2;
        int count = n2;
        if (!this._floodDetected) {
            if (count > Configuration.general().getClientPacketQueueMaxPacketsPerSecond()) {
                ++this.shortFloods;
            } else if (this.longFloodDetected()) {
                ++this.longFloods;
            } else {
                return false;
            }
            this._floodDetected = true;
            if (tick - this._floodStartTick > 60000L) {
                this._floodStartTick = tick;
                this._floodsInMin = 1;
            } else {
                ++this._floodsInMin;
            }
            return true;
        }
        return false;
    }
}

