/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.TradeOtherAdd;
import com.l2jserver.gameserver.network.serverpackets.TradeOwnAdd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddTradeItem
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(AddTradeItem.class);
    private static final String _C__1B_ADDTRADEITEM = "[C] 1B AddTradeItem";
    private int _tradeId;
    private int _objectId;
    private long _count;

    @Override
    protected void readImpl() {
        this._tradeId = this.readD();
        this._objectId = this.readD();
        this._count = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        TradeList trade = player.getActiveTradeList();
        if (trade == null) {
            LOG.warn("Character: {} requested item: {} add without active tradelist: {}", player.getName(), this._objectId, this._tradeId);
            return;
        }
        L2PcInstance partner = trade.getPartner();
        if (partner == null || L2World.getInstance().getPlayer(partner.getObjectId()) == null || partner.getActiveTradeList() == null) {
            if (partner != null) {
                LOG.warn("Character: {} requested invalid trade object: {}", (Object)player.getName(), (Object)this._objectId);
            }
            player.sendPacket(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
            player.cancelActiveTrade();
            return;
        }
        if (trade.isConfirmed() || partner.getActiveTradeList().isConfirmed()) {
            player.sendPacket(SystemMessageId.CANNOT_ADJUST_ITEMS_AFTER_TRADE_CONFIRMED);
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disabled for your Access Level.");
            player.cancelActiveTrade();
            return;
        }
        if (!player.validateItemManipulation(this._objectId, "trade")) {
            player.sendPacket(SystemMessageId.NOTHING_HAPPENED);
            return;
        }
        TradeItem item = trade.addItem(this._objectId, this._count);
        if (item != null) {
            player.sendPacket(new TradeOwnAdd(item));
            trade.getPartner().sendPacket(new TradeOtherAdd(item));
        }
    }

    @Override
    public String getType() {
        return _C__1B_ADDTRADEITEM;
    }
}

