/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthLogin
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(AuthLogin.class);
    private static final String _C__2B_AUTHLOGIN = "[C] 2B AuthLogin";
    private String _loginName;
    private int _playKey1;
    private int _playKey2;
    private int _loginKey1;
    private int _loginKey2;

    @Override
    protected void readImpl() {
        this._loginName = this.readS().toLowerCase();
        this._playKey2 = this.readD();
        this._playKey1 = this.readD();
        this._loginKey1 = this.readD();
        this._loginKey2 = this.readD();
    }

    @Override
    protected void runImpl() {
        L2GameClient client = (L2GameClient)this.getClient();
        if (this._loginName.isEmpty() || !client.isProtocolOk()) {
            client.close((L2GameServerPacket)null);
            return;
        }
        LoginServerThread.SessionKey key = new LoginServerThread.SessionKey(this._loginKey1, this._loginKey2, this._playKey1, this._playKey2);
        if (Configuration.general().debug()) {
            LOG.info("User: {}", (Object)this._loginName);
            LOG.info("Key: {}", (Object)key);
        }
        if (client.getAccountName() == null) {
            if (LoginServerThread.getInstance().addGameServerLogin(this._loginName, client)) {
                client.setAccountName(this._loginName);
                LoginServerThread.getInstance().addWaitingClientAndSendRequest(this._loginName, client, key);
            } else {
                client.close((L2GameServerPacket)null);
            }
        }
    }

    @Override
    public String getType() {
        return _C__2B_AUTHLOGIN;
    }
}

