/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.ai.NextAction;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.SummonSkillsTable;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.datatables.BotReportTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ChairSit;
import com.l2jserver.gameserver.network.serverpackets.ExAskCoupleAction;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopManageList;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestActionUse
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestActionUse.class);
    private static final String _C__56_REQUESTACTIONUSE = "[C] 56 RequestActionUse";
    private static final int SIN_EATER_ID = 12564;
    private static final int SWITCH_STANCE_ID = 6054;
    private static final NpcStringId[] NPC_STRINGS = new NpcStringId[]{NpcStringId.USING_A_SPECIAL_SKILL_HERE_COULD_TRIGGER_A_BLOODBATH, NpcStringId.HEY_WHAT_DO_YOU_EXPECT_OF_ME, NpcStringId.UGGGGGH_PUSH_ITS_NOT_COMING_OUT, NpcStringId.AH_I_MISSED_THE_MARK};
    private int _actionId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._actionId = this.readD();
        this._ctrlPressed = this.readD() == 1;
        this._shiftPressed = this.readC() == 1;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (Configuration.general().debug()) {
            LOG.info("{}: {} requested action use ID: {} Ctrl pressed:{} Shift pressed:{}", this.getType(), activeChar, this._actionId, this._ctrlPressed, this._shiftPressed);
        }
        if (activeChar.isFakeDeath() && this._actionId != 0 || activeChar.isDead() || activeChar.isOutOfControl()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        BuffInfo info = activeChar.getEffectList().getBuffInfoByAbnormalType(AbnormalType.BOT_PENALTY);
        if (info != null) {
            for (AbstractEffect effect : info.getEffects()) {
                if (effect.checkCondition(this._actionId)) continue;
                activeChar.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_SO_ACTIONS_NOT_ALLOWED);
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if (activeChar.isTransformed()) {
            int[] allowedActions;
            int[] nArray = allowedActions = activeChar.isTransformed() ? ExBasicActionList.ACTIONS_ON_TRANSFORM : ExBasicActionList.DEFAULT_ACTION_LIST;
            if (Arrays.binarySearch(allowedActions, this._actionId) < 0) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                LOG.warn("Player {} used action which he does not have! Id = {} transform: {}", activeChar, this._actionId, activeChar.getTransformation());
                return;
            }
        }
        L2Summon summon = activeChar.getSummon();
        L2Object target = activeChar.getTarget();
        switch (this._actionId) {
            case 0: {
                if (activeChar.isSitting() || !activeChar.isMoving() || activeChar.isFakeDeath()) {
                    this.useSit(activeChar, target);
                    break;
                }
                NextAction nextAction = new NextAction(CtrlEvent.EVT_ARRIVED, CtrlIntention.AI_INTENTION_MOVE_TO, () -> this.useSit(activeChar, target));
                activeChar.getAI().setNextAction(nextAction);
                break;
            }
            case 1: {
                if (activeChar.isRunning()) {
                    activeChar.setWalking();
                    break;
                }
                activeChar.setRunning();
                break;
            }
            case 10: {
                activeChar.tryOpenPrivateSellStore(false);
                break;
            }
            case 15: {
                if (!this.validateSummon(summon, true)) break;
                ((L2SummonAI)summon.getAI()).notifyFollowStatusChange();
                break;
            }
            case 16: {
                if (!this.validateSummon(summon, true) || !summon.canAttack(this._ctrlPressed)) break;
                summon.doAttack();
                break;
            }
            case 17: {
                if (!this.validateSummon(summon, true)) break;
                summon.cancelAction();
                break;
            }
            case 19: {
                if (!this.validateSummon(summon, true)) break;
                if (summon.isDead()) {
                    this.sendPacket(SystemMessageId.DEAD_PET_CANNOT_BE_RETURNED);
                    break;
                }
                if (summon.isAttackingNow() || summon.isInCombat() || summon.isMovementDisabled()) {
                    this.sendPacket(SystemMessageId.PET_CANNOT_SENT_BACK_DURING_BATTLE);
                    break;
                }
                if (summon.isHungry()) {
                    if (summon.isPet() && !((L2PetInstance)summon).getPetData().getFood().isEmpty()) {
                        this.sendPacket(SystemMessageId.YOU_CANNOT_RESTORE_HUNGRY_PETS);
                        break;
                    }
                    this.sendPacket(SystemMessageId.THE_HELPER_PET_CANNOT_BE_RETURNED);
                    break;
                }
                summon.unSummon(activeChar);
                break;
            }
            case 21: {
                if (!this.validateSummon(summon, false)) break;
                ((L2SummonAI)summon.getAI()).notifyFollowStatusChange();
                break;
            }
            case 22: {
                if (!this.validateSummon(summon, false) || !summon.canAttack(this._ctrlPressed)) break;
                summon.doAttack();
                break;
            }
            case 23: {
                if (!this.validateSummon(summon, false)) break;
                summon.cancelAction();
                break;
            }
            case 28: {
                activeChar.tryOpenPrivateBuyStore();
                break;
            }
            case 32: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 36: {
                this.useSkill("RangeDebuff", false);
                break;
            }
            case 37: {
                if (activeChar.isAlikeDead()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (activeChar.getPrivateStoreType() != PrivateStoreType.NONE) {
                    activeChar.setPrivateStoreType(PrivateStoreType.NONE);
                    activeChar.broadcastUserInfo();
                }
                if (activeChar.isSitting()) {
                    activeChar.standUp();
                }
                this.sendPacket(new RecipeShopManageList(activeChar, true));
                break;
            }
            case 38: {
                activeChar.mountPlayer(summon);
                break;
            }
            case 39: {
                this.useSkill("RangeDD", false);
                break;
            }
            case 41: {
                if (!this.validateSummon(summon, false)) break;
                if (target != null && (target.isDoor() || target instanceof L2SiegeFlagInstance)) {
                    this.useSkill(4230, false);
                    break;
                }
                this.sendPacket(SystemMessageId.INCORRECT_TARGET);
                break;
            }
            case 42: {
                this.useSkill("HealMagic", false);
                break;
            }
            case 43: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 44: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 45: {
                this.useSkill("HealMagic", (L2Object)activeChar, false);
                break;
            }
            case 46: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 47: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 48: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 51: {
                if (activeChar.isAlikeDead()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (activeChar.getPrivateStoreType() != PrivateStoreType.NONE) {
                    activeChar.setPrivateStoreType(PrivateStoreType.NONE);
                    activeChar.broadcastUserInfo();
                }
                if (activeChar.isSitting()) {
                    activeChar.standUp();
                }
                this.sendPacket(new RecipeShopManageList(activeChar, false));
                break;
            }
            case 52: {
                if (!this.validateSummon(summon, false)) break;
                if (summon.isAttackingNow() || summon.isInCombat()) {
                    this.sendPacket(SystemMessageId.SERVITOR_NOT_RETURN_IN_BATTLE);
                    break;
                }
                summon.unSummon(activeChar);
                break;
            }
            case 53: {
                if (!this.validateSummon(summon, false) || target == null || summon == target || summon.isMovementDisabled()) break;
                summon.setFollowStatus(false);
                summon.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, target.getLocation());
                break;
            }
            case 54: {
                if (!this.validateSummon(summon, true) || target == null || summon == target || summon.isMovementDisabled()) break;
                summon.setFollowStatus(false);
                summon.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, target.getLocation());
                break;
            }
            case 61: {
                activeChar.tryOpenPrivateSellStore(true);
                break;
            }
            case 65: {
                if (Configuration.general().enableBotReportButton()) {
                    BotReportTable.getInstance().reportBot(activeChar);
                    break;
                }
                activeChar.sendMessage("This feature is disabled.");
                break;
            }
            case 67: {
                if (!activeChar.isInAirShip() || !activeChar.getAirShip().setCaptain(activeChar)) break;
                activeChar.broadcastUserInfo();
                break;
            }
            case 68: {
                if (!activeChar.isInAirShip() || !activeChar.getAirShip().isCaptain(activeChar) || !activeChar.getAirShip().setCaptain(null)) break;
                activeChar.broadcastUserInfo();
                break;
            }
            case 69: {
                AirShipManager.getInstance().sendAirShipTeleportList(activeChar);
                break;
            }
            case 70: {
                if (!activeChar.isInAirShip()) break;
                if (activeChar.getAirShip().isCaptain(activeChar)) {
                    if (!activeChar.getAirShip().setCaptain(null)) break;
                    activeChar.broadcastUserInfo();
                    break;
                }
                if (!activeChar.getAirShip().isInDock()) break;
                activeChar.getAirShip().oustPlayer(activeChar);
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                this.useCoupleSocial(this._actionId - 55);
                break;
            }
            case 1000: {
                if (target == null || !target.isDoor()) break;
                this.useSkill(4079, false);
                break;
            }
            case 1001: {
                if (!this.validateSummon(summon, true) || summon.getId() != 12564) break;
                summon.broadcastPacket(new NpcSay(summon.getObjectId(), 22, summon.getId(), NPC_STRINGS[Rnd.get((int)NPC_STRINGS.length)]));
                break;
            }
            case 1003: {
                this.useSkill("PhysicalSpecial", true);
                break;
            }
            case 1004: {
                this.useSkill("Buff", (L2Object)activeChar, true);
                break;
            }
            case 1005: {
                this.useSkill("DDMagic", true);
                break;
            }
            case 1006: {
                this.useSkill("Heal", (L2Object)activeChar, true);
                break;
            }
            case 1007: {
                this.useSkill("Buff1", (L2Object)activeChar, false);
                break;
            }
            case 1008: {
                this.useSkill("Buff2", (L2Object)activeChar, false);
                break;
            }
            case 1009: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 1010: {
                this.useSkill("Buff1", (L2Object)activeChar, false);
                break;
            }
            case 1011: {
                this.useSkill("Buff2", (L2Object)activeChar, false);
                break;
            }
            case 1012: {
                this.useSkill("DDMagic", false);
                break;
            }
            case 1013: {
                this.useSkill("DeBuff1", false);
                break;
            }
            case 1014: {
                this.useSkill("DeBuff2", false);
                break;
            }
            case 1015: {
                this.useSkill("Heal", false);
                break;
            }
            case 1016: {
                this.useSkill("PhysicalSpecial1", false);
                break;
            }
            case 1017: {
                this.useSkill("PhysicalSpecial2", false);
                break;
            }
            case 1031: {
                this.useSkill("PhysicalSpecial1", false);
                break;
            }
            case 1032: {
                this.useSkill("PhysicalSpecial2", false);
                break;
            }
            case 1033: {
                this.useSkill("PhysicalSpecial3", false);
                break;
            }
            case 1034: {
                this.useSkill("PhysicalSpecial1", false);
                break;
            }
            case 1035: {
                this.useSkill("PhysicalSpecial2", false);
                break;
            }
            case 1036: {
                this.useSkill("PhysicalSpecial1", false);
                break;
            }
            case 1037: {
                this.useSkill("PhysicalSpecial2", false);
                break;
            }
            case 1038: {
                this.useSkill("PhysicalSpecial3", false);
                break;
            }
            case 1039: {
                this.useSkill(5110, false);
                break;
            }
            case 1040: {
                this.useSkill(5111, false);
                break;
            }
            case 1041: {
                this.useSkill("Skill01", true);
                break;
            }
            case 1042: {
                this.useSkill("Skill03", true);
                break;
            }
            case 1043: {
                this.useSkill("Skill02", true);
                break;
            }
            case 1044: {
                this.useSkill("Skill04", true);
                break;
            }
            case 1045: {
                this.useSkill(5584, true);
                break;
            }
            case 1046: {
                this.useSkill(5585, true);
                break;
            }
            case 1047: {
                this.useSkill(5580, false);
                break;
            }
            case 1048: {
                this.useSkill(5581, false);
                break;
            }
            case 1049: {
                this.useSkill(5582, false);
                break;
            }
            case 1050: {
                this.useSkill(5583, false);
                break;
            }
            case 1051: {
                this.useSkill("buff3", false);
                break;
            }
            case 1052: {
                this.useSkill("buff4", false);
                break;
            }
            case 1053: {
                this.useSkill("buff5", false);
                break;
            }
            case 1054: {
                this.useSkill("buff3", false);
                break;
            }
            case 1055: {
                this.useSkill("buff4", false);
                break;
            }
            case 1056: {
                this.useSkill("buff5", false);
                break;
            }
            case 1057: {
                this.useSkill("buff6", false);
                break;
            }
            case 1058: {
                this.useSkill("buff3", false);
                break;
            }
            case 1059: {
                this.useSkill("buff4", false);
                break;
            }
            case 1060: {
                this.useSkill("buff5", false);
                break;
            }
            case 1061: {
                this.useSkill(5745, true);
                break;
            }
            case 1062: {
                this.useSkill(5746, true);
                break;
            }
            case 1063: {
                this.useSkill(5747, true);
                break;
            }
            case 1064: {
                this.useSkill(5748, true);
                break;
            }
            case 1065: {
                this.useSkill(5753, true);
                break;
            }
            case 1066: {
                this.useSkill(5749, true);
                break;
            }
            case 1067: {
                this.useSkill(5750, true);
                break;
            }
            case 1068: {
                this.useSkill(5751, true);
                break;
            }
            case 1069: {
                this.useSkill(5752, true);
                break;
            }
            case 1070: {
                this.useSkill(5771, true);
                break;
            }
            case 1071: {
                this.useSkill("DDMagic", true);
                break;
            }
            case 1072: {
                this.useSkill(6046, true);
                break;
            }
            case 1073: {
                this.useSkill(6047, true);
                break;
            }
            case 1074: {
                this.useSkill(6048, true);
                break;
            }
            case 1075: {
                this.useSkill(6049, true);
                break;
            }
            case 1076: {
                this.useSkill(6050, true);
                break;
            }
            case 1077: {
                this.useSkill(6051, true);
                break;
            }
            case 1078: {
                this.useSkill(6052, true);
                break;
            }
            case 1079: {
                this.useSkill(6053, true);
                break;
            }
            case 1080: {
                this.useSkill(6041, false);
                break;
            }
            case 1081: {
                this.useSkill(6042, false);
                break;
            }
            case 1082: {
                this.useSkill(6043, false);
                break;
            }
            case 1083: {
                this.useSkill(6044, false);
                break;
            }
            case 1084: {
                this.useSkill(6054, true);
                break;
            }
            case 1086: {
                this.useSkill(6094, false);
                break;
            }
            case 1087: {
                this.useSkill(6095, false);
                break;
            }
            case 1088: {
                this.useSkill(6096, false);
                break;
            }
            case 1089: {
                this.useSkill(6199, true);
                break;
            }
            case 1090: {
                this.useSkill(6205, true);
                break;
            }
            case 1091: {
                this.useSkill(6206, true);
                break;
            }
            case 1092: {
                this.useSkill(6207, true);
                break;
            }
            case 1093: {
                this.useSkill(6618, true);
                break;
            }
            case 1094: {
                this.useSkill(6681, true);
                break;
            }
            case 1095: {
                this.useSkill(6619, true);
                break;
            }
            case 1096: {
                this.useSkill(6682, true);
                break;
            }
            case 1097: {
                this.useSkill(6683, true);
                break;
            }
            case 1098: {
                this.useSkill(6684, true);
                break;
            }
            case 5000: {
                this.useSkill(23155, true);
                break;
            }
            case 5001: {
                this.useSkill(23167, true);
                break;
            }
            case 5002: {
                this.useSkill(23168, true);
                break;
            }
            case 5003: {
                this.useSkill(5749, true);
                break;
            }
            case 5004: {
                this.useSkill(5750, true);
                break;
            }
            case 5005: {
                this.useSkill(5751, true);
                break;
            }
            case 5006: {
                this.useSkill(5771, true);
                break;
            }
            case 5007: {
                this.useSkill(6046, true);
                break;
            }
            case 5008: {
                this.useSkill(6047, true);
                break;
            }
            case 5009: {
                this.useSkill(6048, true);
                break;
            }
            case 5010: {
                this.useSkill(6049, true);
                break;
            }
            case 5011: {
                this.useSkill(6050, true);
                break;
            }
            case 5012: {
                this.useSkill(6051, true);
                break;
            }
            case 5013: {
                this.useSkill(6052, true);
                break;
            }
            case 5014: {
                this.useSkill(6053, true);
                break;
            }
            case 5015: {
                this.useSkill(6054, true);
                break;
            }
            case 12: {
                this.tryBroadcastSocial(2);
                break;
            }
            case 13: {
                this.tryBroadcastSocial(3);
                break;
            }
            case 14: {
                this.tryBroadcastSocial(4);
                break;
            }
            case 24: {
                this.tryBroadcastSocial(6);
                break;
            }
            case 25: {
                this.tryBroadcastSocial(5);
                break;
            }
            case 26: {
                this.tryBroadcastSocial(7);
                break;
            }
            case 29: {
                this.tryBroadcastSocial(8);
                break;
            }
            case 30: {
                this.tryBroadcastSocial(9);
                break;
            }
            case 31: {
                this.tryBroadcastSocial(10);
                break;
            }
            case 33: {
                this.tryBroadcastSocial(11);
                break;
            }
            case 34: {
                this.tryBroadcastSocial(12);
                break;
            }
            case 35: {
                this.tryBroadcastSocial(13);
                break;
            }
            case 62: {
                this.tryBroadcastSocial(14);
                break;
            }
            case 66: {
                this.tryBroadcastSocial(15);
                break;
            }
            default: {
                LOG.warn("{}: unhandled action type {}", (Object)activeChar.getName(), (Object)this._actionId);
            }
        }
    }

    protected boolean useSit(L2PcInstance activeChar, L2Object target) {
        if (activeChar.getMountType() != MountType.NONE) {
            return false;
        }
        if (!activeChar.isSitting() && target instanceof L2StaticObjectInstance && ((L2StaticObjectInstance)target).getType() == 1 && activeChar.isInsideRadius(target, 150, false, false)) {
            ChairSit cs = new ChairSit(activeChar, target.getId());
            this.sendPacket(cs);
            activeChar.sitDown();
            activeChar.broadcastPacket(cs);
            return true;
        }
        if (activeChar.isFakeDeath()) {
            activeChar.stopEffects(L2EffectType.FAKE_DEATH);
        } else if (activeChar.isSitting()) {
            activeChar.standUp();
        } else {
            activeChar.sitDown();
        }
        return true;
    }

    private void useSkill(int skillId, L2Object target, boolean pet) {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Summon summon = activeChar.getSummon();
        if (!this.validateSummon(summon, pet)) {
            return;
        }
        if (!this.canControl(summon)) {
            return;
        }
        int lvl = summon.isPet() ? PetDataTable.getInstance().getPetData(summon.getId()).getAvailableLevel(summon, skillId) : SummonSkillsTable.getInstance().getAvailableLevel(summon, skillId);
        if (lvl > 0) {
            summon.setTarget(target);
            summon.useMagic(SkillData.getInstance().getSkill(skillId, lvl), this._ctrlPressed, this._shiftPressed);
        }
        if (skillId == 6054) {
            summon.switchMode();
        }
    }

    private void useSkill(String skillName, L2Object target, boolean pet) {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Summon summon = activeChar.getSummon();
        if (!this.validateSummon(summon, pet)) {
            return;
        }
        if (!this.canControl(summon)) {
            return;
        }
        if (summon instanceof L2PetInstance && !((L2PetInstance)summon).isInSupportMode()) {
            this.sendPacket(SystemMessageId.PET_AUXILIARY_MODE_CANNOT_USE_SKILLS);
            return;
        }
        SkillHolder skillHolder = summon.getTemplate().getParameters().getSkillHolder(skillName);
        if (skillHolder == null) {
            LOG.warn("{} requested missing skill {}!", (Object)summon, (Object)skillName);
            return;
        }
        Skill skill = skillHolder.getSkill();
        if (skill == null) {
            LOG.warn("{} requested missing skill {}!", (Object)summon, (Object)skillHolder);
            return;
        }
        summon.setTarget(target);
        summon.useMagic(skill, this._ctrlPressed, this._shiftPressed);
        if (skill.getId() == 6054) {
            summon.switchMode();
        }
    }

    private boolean canControl(L2Summon summon) {
        if (summon instanceof L2PetInstance && !((L2PetInstance)summon).isInSupportMode()) {
            this.sendPacket(SystemMessageId.PET_AUXILIARY_MODE_CANNOT_USE_SKILLS);
            return false;
        }
        if (summon.isPet() && summon.getLevel() - this.getActiveChar().getLevel() > 20) {
            this.sendPacket(SystemMessageId.PET_TOO_HIGH_TO_CONTROL);
            return false;
        }
        return true;
    }

    private void useSkill(int skillId, boolean pet) {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.useSkill(skillId, activeChar.getTarget(), pet);
    }

    private void useSkill(String skillName, boolean pet) {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.useSkill(skillName, activeChar.getTarget(), pet);
    }

    private boolean validateSummon(L2Summon summon, boolean checkPet) {
        if (summon != null && (checkPet && summon.isPet() || summon.isServitor())) {
            if (summon.isPet() && ((L2PetInstance)summon).isUncontrollable()) {
                this.sendPacket(SystemMessageId.WHEN_YOUR_PETS_HUNGER_GAUGE_IS_AT_0_YOU_CANNOT_USE_YOUR_PET);
                return false;
            }
            if (summon.isBetrayed()) {
                this.sendPacket(SystemMessageId.PET_REFUSING_ORDER);
                return false;
            }
            return true;
        }
        if (checkPet) {
            this.sendPacket(SystemMessageId.DONT_HAVE_PET);
        } else {
            this.sendPacket(SystemMessageId.DONT_HAVE_SERVITOR);
        }
        return false;
    }

    private void tryBroadcastSocial(int id) {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isFishing()) {
            this.sendPacket(SystemMessageId.CANNOT_DO_WHILE_FISHING_3);
            return;
        }
        if (activeChar.canMakeSocialAction()) {
            activeChar.broadcastPacket(new SocialAction(activeChar.getObjectId(), id));
        }
    }

    private void useCoupleSocial(int id) {
        SystemMessage sm;
        L2PcInstance requester = this.getActiveChar();
        if (requester == null) {
            return;
        }
        L2Object target = requester.getTarget();
        if (target == null || !target.isPlayer()) {
            this.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return;
        }
        int distance = (int)requester.calculateDistance(target, false, false);
        if (distance > 125 || distance < 15 || requester.getObjectId() == target.getObjectId()) {
            this.sendPacket(SystemMessageId.TARGET_DO_NOT_MEET_LOC_REQUIREMENTS);
            return;
        }
        if (requester.isInStoreMode() || requester.isInCraftMode()) {
            SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_PRIVATE_SHOP_MODE_OR_IN_A_BATTLE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm2.addPcName(requester);
            this.sendPacket(sm2);
            return;
        }
        if (requester.isInCombat() || requester.isInDuel() || AttackStanceTaskManager.getInstance().hasAttackStanceTask(requester)) {
            SystemMessage sm3 = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_A_BATTLE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm3.addPcName(requester);
            this.sendPacket(sm3);
            return;
        }
        if (requester.isFishing()) {
            this.sendPacket(SystemMessageId.CANNOT_DO_WHILE_FISHING_3);
            return;
        }
        if (requester.getKarma() > 0) {
            SystemMessage sm4 = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_A_CHAOTIC_STATE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm4.addPcName(requester);
            this.sendPacket(sm4);
            return;
        }
        if (requester.isInOlympiadMode()) {
            SystemMessage sm5 = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_PARTICIPATING_IN_THE_OLYMPIAD_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm5.addPcName(requester);
            this.sendPacket(sm5);
            return;
        }
        if (requester.isInSiege()) {
            SystemMessage sm6 = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_A_CASTLE_SIEGE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm6.addPcName(requester);
            this.sendPacket(sm6);
            return;
        }
        if (requester.isInHideoutSiege()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_PARTICIPATING_IN_A_HIDEOUT_SIEGE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(requester);
            this.sendPacket(sm);
        }
        if (requester.isMounted() || requester.isFlyingMounted() || requester.isInBoat() || requester.isInAirShip()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_RIDING_A_SHIP_STEED_OR_STRIDER_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(requester);
            this.sendPacket(sm);
            return;
        }
        if (requester.isTransformed()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_CURRENTLY_TRANSFORMING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(requester);
            this.sendPacket(sm);
            return;
        }
        if (requester.isAlikeDead()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_CURRENTLY_DEAD_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(requester);
            this.sendPacket(sm);
            return;
        }
        L2PcInstance partner = target.getActingPlayer();
        if (partner.isInStoreMode() || partner.isInCraftMode()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_PRIVATE_SHOP_MODE_OR_IN_A_BATTLE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isInCombat() || partner.isInDuel() || AttackStanceTaskManager.getInstance().hasAttackStanceTask(partner)) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_A_BATTLE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.getMultiSociaAction() > 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_PARTICIPATING_IN_A_COUPLE_ACTION_AND_CANNOT_BE_REQUESTED_FOR_ANOTHER_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isFishing()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_FISHING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.getKarma() > 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_A_CHAOTIC_STATE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isInOlympiadMode()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_PARTICIPATING_IN_THE_OLYMPIAD_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isInHideoutSiege()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_PARTICIPATING_IN_A_HIDEOUT_SIEGE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isInSiege()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_IN_A_CASTLE_SIEGE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isMounted() || partner.isFlyingMounted() || partner.isInBoat() || partner.isInAirShip()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_RIDING_A_SHIP_STEED_OR_STRIDER_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isTeleporting()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_CURRENTLY_TELEPORTING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isTransformed()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_CURRENTLY_TRANSFORMING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (partner.isAlikeDead()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_CURRENTLY_DEAD_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION);
            sm.addPcName(partner);
            this.sendPacket(sm);
            return;
        }
        if (requester.isAllSkillsDisabled() || partner.isAllSkillsDisabled()) {
            this.sendPacket(SystemMessageId.COUPLE_ACTION_CANCELED);
            return;
        }
        requester.setMultiSocialAction(id, partner.getObjectId());
        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_REQUESTED_COUPLE_ACTION_C1);
        sm.addPcName(partner);
        this.sendPacket(sm);
        if (requester.getAI().getIntention() != CtrlIntention.AI_INTENTION_IDLE || partner.getAI().getIntention() != CtrlIntention.AI_INTENTION_IDLE) {
            NextAction nextAction = new NextAction(CtrlEvent.EVT_ARRIVED, CtrlIntention.AI_INTENTION_MOVE_TO, () -> partner.sendPacket(new ExAskCoupleAction(requester.getObjectId(), id)));
            requester.getAI().setNextAction(nextAction);
            return;
        }
        if (requester.isCastingNow() || requester.isCastingSimultaneouslyNow()) {
            NextAction nextAction = new NextAction(CtrlEvent.EVT_FINISH_CASTING, CtrlIntention.AI_INTENTION_CAST, () -> partner.sendPacket(new ExAskCoupleAction(requester.getObjectId(), id)));
            requester.getAI().setNextAction(nextAction);
            return;
        }
        partner.sendPacket(new ExAskCoupleAction(requester.getObjectId(), id));
    }

    @Override
    public String getType() {
        return _C__56_REQUESTACTIONUSE;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return this._actionId != 10 && this._actionId != 28;
    }
}

