/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RequestBuySeed
extends L2GameClientPacket {
    private static final int BATCH_LENGTH = 12;
    private int _manorId;
    private List<ItemHolder> _items = null;

    @Override
    protected final void readImpl() {
        this._manorId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<ItemHolder>(count);
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long cnt = this.readQ();
            if (cnt < 1L || itemId < 1) {
                this._items = null;
                return;
            }
            this._items.add(new ItemHolder(itemId, cnt));
        }
    }

    @Override
    protected final void runImpl() {
        SeedProduction sp;
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getManor().tryPerformAction("BuySeed")) {
            player.sendMessage("You are buying seeds too fast!");
            return;
        }
        if (this._items == null) {
            this.sendActionFailed();
            return;
        }
        CastleManorManager manor = CastleManorManager.getInstance();
        if (manor.isUnderMaintenance()) {
            this.sendActionFailed();
            return;
        }
        Castle castle = CastleManager.getInstance().getCastleById(this._manorId);
        if (castle == null) {
            this.sendActionFailed();
            return;
        }
        L2Npc manager = player.getLastFolkNPC();
        if (!(manager instanceof L2MerchantInstance) || !manager.canInteract(player) || manager.getTemplate().getParameters().getInt("manor_id", -1) != this._manorId) {
            this.sendActionFailed();
            return;
        }
        long totalPrice = 0L;
        int slots = 0;
        int totalWeight = 0;
        HashMap<Integer, SeedProduction> _productInfo = new HashMap<Integer, SeedProduction>();
        for (ItemHolder ih : this._items) {
            sp = manor.getSeedProduct(this._manorId, ih.getId(), false);
            if (sp == null || sp.getPrice() <= 0L || sp.getAmount() < ih.getCount() || Configuration.character().getMaxAdena() / ih.getCount() < sp.getPrice()) {
                this.sendActionFailed();
                return;
            }
            if ((totalPrice += sp.getPrice() * ih.getCount()) > Configuration.character().getMaxAdena()) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + Configuration.character().getMaxAdena() + " adena worth of goods.");
                this.sendActionFailed();
                return;
            }
            L2Item template = ItemTable.getInstance().getTemplate(ih.getId());
            totalWeight = (int)((long)totalWeight + ih.getCount() * (long)template.getWeight());
            if (!template.isStackable()) {
                slots = (int)((long)slots + ih.getCount());
            } else if (player.getInventory().getItemByItemId(ih.getId()) == null) {
                ++slots;
            }
            _productInfo.put(ih.getId(), sp);
        }
        if (!player.getInventory().validateWeight(totalWeight)) {
            player.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
            return;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            player.sendPacket(SystemMessageId.SLOTS_FULL);
            return;
        }
        if (totalPrice < 0L || player.getAdena() < totalPrice) {
            player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            return;
        }
        for (ItemHolder i : this._items) {
            sp = (SeedProduction)_productInfo.get(i.getId());
            long price = sp.getPrice() * i.getCount();
            if (!sp.decreaseAmount(i.getCount()) || !player.reduceAdena("Buy", price, player, false)) {
                totalPrice -= price;
                continue;
            }
            player.addItem("Buy", i.getId(), i.getCount(), manager, true);
        }
        if (totalPrice > 0L) {
            castle.addToTreasuryNoTax(totalPrice);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED_ADENA);
            sm.addLong(totalPrice);
            player.sendPacket(sm);
            if (Configuration.general().manorSaveAllActions()) {
                manor.updateCurrentProduction(this._manorId, _productInfo.values());
            }
        }
    }

    @Override
    public String getType() {
        return "[C] C5 RequestBuySeed";
    }
}

